unit Parstst;
{	This program is a simple demo that shows how to use the TFParse control }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, ExtCtrls, FParse, Gauges, StrPChar;

type
  TForm1 = class(TForm)
    WordList: TListBox;
    Panel1: TPanel;
    OpenDlg: TOpenDialog;
    Button1: TButton;
    NumWordsLabel: TLabel;
    Gauge1: TGauge;
    Parser: TFParse;
    Label1: TLabel;
    Button2: TButton;
    procedure FileBtnClick(Sender: TObject);
    procedure StrPCharBtnClick(Sender: TObject);
  private
	  { Private declarations }
	  procedure DoParse;
  public
    { Public declarations }
	end;

var
	Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FileBtnClick(Sender: TObject);
begin
	If OpenDlg.Execute then
	 begin
   	Caption := 'Parsing ' + OpenDlg.Filename;
		WordList.Clear;
		Parser.FileToParse := OpenDlg.Filename;
		DoParse;
	 end;
end;

procedure TForm1.DoParse;
var
	NextWord: Str20;
	i: Integer;
begin
		WordList.Clear;
		With Parser do
		 begin
			NextWord := GetNext;
			WordList.Items.BeginUpdate;
			While (NextWord <> '') {and (WordSort.Count < 1000)} do
			 begin
				WordList.Items.Add( NextWord );
				Gauge1.Progress := PercentDone;
				Application.ProcessMessages;
				NextWord := GetNext;
			 end;
			WordList.Items.EndUpdate;
			NumWordsLabel.Caption := IntToStr(WordList.Items.Count);
			Gauge1.Progress := PercentDone;
		end;
end;

procedure TForm1.StrPCharBtnClick(Sender: TObject);
var
	tmpPChar: PChar;
begin
	With StrPCharForm do
	 begin
		ShowModal;
		If ModalResult <> mrOK then exit;
		If StringRBtn.Checked then
			Parser.StringToParse := ParseString.Text
		Else
		 begin
			tmpPChar := StrAlloc( Length( ParseString.Text ) );
        StrPCopy( tmpPChar, ParseString.Text );
			Parser.PCharToParse := tmpPChar;
			StrDispose( tmpPChar );
		 end;
		DoParse;
	 end;
end;

end.
