unit IncReg;
{******************************************************************************}
{                                                                              }
{                           IMPORTANT NOTICE                                   }
{                                                                              }
{          (c) Copyright 1996 by Softouch Development Incorporated             }
{                                                                              }
{                         ALL RIGHTS RESERVED                                  }
{                                                                              }
{       Software and documentation are the confidential property and           }
{       contain trade secrets of Softouch Development Incorporated.            }
{       Any copying, use, disclosure, modification, or transfer by rental,     }
{       sale, or otherwise without the written consent of Softouch             }
{       Development Incorporated is strictly prohibited.                       }
{                                                                              }
{       Portions may be Copyright (c) 1995 Borland International.              }
{       All restriction apply.                                                 }
{******************************************************************************}
{  IncBase    - Main base class of all Incremental Combos.                     }
{  IncCombo   - Your basic incremental combo with a list box of items.         }
{  IncDBCombo - Your basic DataAware incremental combo with list box of items. }
{  IncDBSrc   - Incremental Combo that is used to navigate a DataSet.          }
{  IncDBLup   - DataAware Incremental Lookup Combo.                            }
{******************************************************************************}
{                                                                              }
{  Problem Log                                                                 }
{  03/14/96  Started problem log                                               }
{  Version 2.5                                                                 }
{  08/19/96  Fix the problem with GridParent not finding any grids when in a   }
{            another child window. For example in a TPanel or TTabbedNoteBook  }
{  Version 2.6                                                                 }
{  08/23/96  Fixed it so the Grid property in GridParent would show all        }
{            applicable grids in the form.                                     }
{  Version 3.1                                                                 }
{  12/12/96  Added property editors for LinkField and LinkIndex.               }
{  Version 3.3                                                                 }
{  02/16/97  Modified to work with new GridSource component.                   }
{  03/04/97  Start registering components on 'Softouch' palette.               }
{******************************************************************************}
interface

uses
	{$IFDEF Win32}
	Windows, Forms,
	{$ELSE}
	Forms,
	{$ENDIF}
	Classes, DsgnIntf, Dialogs, Controls, DB, DBTables, Typinfo,
	Grids, DBGrids, GridSrc;

type
	TIncComboAboutBox = class(TComponentEditor)
	procedure ExecuteVerb(Index: Integer); override;
	function GetVerb(Index: Integer): string; override;
	function GetVerbCount: Integer; override;
	end;

	TDBStringProperty = class(TStringProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		procedure GetValueList(List: TStrings); virtual; abstract;
		procedure GetValues(Proc: TGetStrProc); override;
	end;

{ TLookupFieldProperty }

	TLinkFieldProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
	end;

	TIndexProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
	end;


procedure Register;

implementation
{$IFDEF WIN32}
{$R IncReg32.res}
{$ELSE}
{$R IncReg16.res}
{$ENDIF}

uses IncAbout, IncBase, IncCombo, IncDBCmb, IncDBSrc, IncDBLup, IncGrids;

procedure TIncComboAboutBox.ExecuteVerb(Index: Integer);
var IncAboutBox: TIncAboutBox;
begin
	IncAboutBox := TIncAboutBox.Create(Application);
	IncAboutBox.ShowModal;
	IncAboutBox.Destroy;
end;

function TIncComboAboutBox.GetVerb(Index: Integer): string;
begin
  Result := 'About...';
end;

function TIncComboAboutBox.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
I: Integer;
Values: TStringList;
begin
	Values := TStringList.Create;
	try
		GetValueList(Values);
		for I := 0 to Values.Count - 1 do Proc(Values[I]);
	finally
		Values.Free;
	end;
end;

procedure TLinkFieldProperty.GetValueList(List: TStrings);
var Instance: TPersistent;
PropInfo: PPropInfo;
LookupSource: TDataSource;
begin
	Instance := GetComponent(0);
	PropInfo := TypInfo.GetPropInfo(Instance.ClassInfo,'LookupSource');
	if (PropInfo <> nil) and (PropInfo^.PropType^.Kind = tkClass) then
		begin
		LookupSource := TObject(GetOrdProp(Instance,PropInfo)) as TDataSource;
		if (LookupSource <> Nil) and (LookupSource.DataSet <> Nil)
		and LookupSource.DataSet.InheritsFrom(TTable) then
			TTable(LookupSource.DataSet).GetFieldNames(List);
		end;
end;

procedure TIndexProperty.GetValueList(List: TStrings);
var Instance: TPersistent;
PropInfo: PPropInfo;
LookupSource: TDataSource;
begin
	Instance := GetComponent(0);
	PropInfo := TypInfo.GetPropInfo(Instance.ClassInfo,'LookupSource');
	if (PropInfo <> nil) and (PropInfo^.PropType^.Kind = tkClass) then
		begin
		LookupSource := TObject(GetOrdProp(Instance,PropInfo)) as TDataSource;
		if (LookupSource <> Nil) and (LookupSource.DataSet <> Nil)
		and LookupSource.DataSet.InheritsFrom(TTable) then
			TTable(LookupSource.DataSet).GetIndexNames(List);
		end;
end;

procedure Register;
begin
	RegisterComponentEditor(TIncCombo        ,TIncComboAboutBox);
	RegisterComponentEditor(TDBIncCombo      ,TIncComboAboutBox);
	RegisterComponentEditor(TDBIncLookupCombo,TIncComboAboutBox);
	RegisterComponentEditor(TDBIncSearchCombo,TIncComboAboutBox);
	RegisterComponents('Softouch',[TIncCombo]);
	RegisterComponents('Softouch',[TDBIncCombo]);
	RegisterComponents('Softouch',[TDBIncLookupCombo]);
	RegisterComponents('Softouch',[TDBIncSearchCombo]);
	RegisterPropertyEditor(TypeInfo(string),TDBIncSearchCombo,'LookupIndex',TIndexProperty);
	RegisterPropertyEditor(TypeInfo(string),TDBIncLookupCombo,'LookupIndex',TIndexProperty);
	RegisterPropertyEditor(TypeInfo(string),TDBIncLookupCombo,'LinkField'  ,TLinkFieldProperty);
	RegisterPropertyEditor(TypeInfo(string),TDBIncLookupCombo,'LinkIndex'  ,TIndexProperty);
	RegisterGridParentEditors;
end;

end.
