unit Incdmfrm;
{******************************************************************************}
{                                                                              }
{                           IMPORTANT NOTICE                                   }
{                                                                              }
{          (c) Copyright 1996 by Softouch Development Incorporated             }
{                                                                              }
{                         ALL RIGHTS RESERVED                                  }
{                                                                              }
{       Software and documentation are the confidential property and           }
{       contain trade secrets of Softouch Development Incorporated.            }
{       Any copying, use, disclosure, modification, or transfer by rental,     }
{       sale, or otherwise without the written consent of Softouch             }
{       Development Incorporated is strictly prohibited.                       }
{                                                                              }
{       Portions may be Copyright (c) 1995 Borland International.              }
{       All restriction apply.                                                 }
{******************************************************************************}
{                                                                              }
{  Problem Log                                                                 }
{  Version 2.6                                                                 }
{  08/23/96  Changed some records to be sorted and changed some descriptions.  }
{******************************************************************************}
interface

uses
  {$IFDEF WIN32}
  Windows, ComCtrls, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, IncBase, IncDBLup, Tabnotbk, IncCombo,
  Buttons, DBTables, DB, Grids, DBGrids, IncDBCmb, Mask, DBCtrls, IncDBSrc;
  {$ELSE}
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, IncBase, IncDBLup, Tabnotbk, IncCombo,
  Buttons, DBTables, DB, Grids, DBGrids, IncDBCmb, Mask, DBCtrls, IncDBSrc;
  {$ENDIF}

type
  TForm_Main = class(TForm)
    TabbedNotebook_Main: TTabbedNotebook;
    Panel1: TPanel;
    DataSource_Orders: TDataSource;
    Table_Customer: TTable;
    DataSource_Customer: TDataSource;
    Query_Parts: TQuery;
    DataSource_Parts: TDataSource;
    Query_Vendor: TQuery;
    DataSource_Vendor: TDataSource;
    Query_PartsPartNo: TFloatField;
    Query_PartsVendorNo: TFloatField;
    Query_PartsDescription: TStringField;
    Query_PartsOnHand: TFloatField;
    Query_PartsOnOrder: TFloatField;
    Query_PartsCost: TCurrencyField;
    Query_PartsListPrice: TCurrencyField;
    DataSource_BioLife: TDataSource;
    Panel_NavigationUpper: TPanel;
    Label16: TLabel;
    DBIncSearchCombo2: TDBIncSearchCombo;
    DBImage1: TDBImage;
    DBMemo1: TDBMemo;
    DBNavigator_Navigation: TDBNavigator;
    Query_BioLife: TQuery;
    Panel_LookupUpper: TPanel;
    DBIncLookupCombo_General: TDBIncLookupCombo;
    GroupBox_ComboOptions: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    IncCombo_AutoDropDown: TIncCombo;
    IncCombo_BorderStyle: TIncCombo;
    IncCombo_ShowComboButton: TIncCombo;
    IncCombo_Style: TIncCombo;
    CheckBox_CanBeBlank: TCheckBox;
    CheckBox_Ctl3D: TCheckBox;
    GroupBox_DropDownOptions: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    CheckBox_Titles: TCheckBox;
    CheckBox_RowLines: TCheckBox;
    CheckBox_ColLines: TCheckBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    IncCombo_AlignHorizontally: TIncCombo;
    IncCombo_AlignVertically: TIncCombo;
    IncCombo_Color: TIncCombo;
    IncCombo_TitleColor: TIncCombo;
    Panel_GridUpper: TPanel;
    DBGrid_Main: TDBGrid;
    DBIncLookupCombo_CustomerName: TDBIncLookupCombo;
    DBIncCombo1: TDBIncCombo;
    Panel_SQLUpper: TPanel;
    Label5: TLabel;
    DBIncSearchCombo_PartNo: TDBIncSearchCombo;
    Label6: TLabel;
    DBEdit_Description: TDBEdit;
    DBIncLookupCombo_Vendor: TDBIncLookupCombo;
    Label7: TLabel;
    Label8: TLabel;
    DBEdit_OnHand: TDBEdit;
    DBEdit_OnOrder: TDBEdit;
    Label9: TLabel;
    Label10: TLabel;
    DBEdit_Cost: TDBEdit;
    DBEdit_ListPrice: TDBEdit;
    Label11: TLabel;
    DBNavigator_SQL: TDBNavigator;
    Panel_GeneralUpper: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Label17: TLabel;
    ScrollBox2: TScrollBox;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    BitBtn3: TBitBtn;
    FontDialog1: TFontDialog;
    IncCombo_ButtonCursor: TIncCombo;
    Label34: TLabel;
    Memo_Lookups: TMemo;
    Memo_Navigation: TMemo;
    Memo_Grid: TMemo;
    Memo_SQL: TMemo;
    Table_Orders: TTable;
    Table_OrdersOrderNo: TFloatField;
    Table_OrdersCustNo: TFloatField;
    Table_OrdersPaymentMethod: TStringField;
    Table_OrdersCustomerName: TStringField;
    Table_CustomerLookups: TTable;
    DataSource_CustomerLookups: TDataSource;
    ScrollBox1: TScrollBox;
    Price: TLabel;
    OnCompuserveTitle: TLabel;
    OnCompuserve: TLabel;
    NorthStarTitle: TLabel;
    NorthStar800: TLabel;
    NorthStarVoice: TLabel;
    NorthStar803: TLabel;
    NorthStarFax: TLabel;
    NorthStarFax800: TLabel;
    NorthStarEMail: TLabel;
    NorthStarAOL: TLabel;
    NorthStarCompuserve: TLabel;
    NorthStarInternet: TLabel;
    NorthStarImportantNotes: TLabel;
    Mail: TLabel;
    MailName: TLabel;
    MailAddress: TLabel;
    MailCityStateZip: TLabel;
    MailInfo: TLabel;
    Table_CustomerNameGridCalc: TTable;
    label35: TLabel;
    Memo1: TMemo;
    Label19: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    Memo2: TMemo;
    Label41: TLabel;
    Memo3: TMemo;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label46: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label18: TLabel;
    procedure DBIncLookupCombo_GeneralNewRecord(Sender: TObject;
      DataSet: TDataSet; NewValue: string);
    procedure FormCreate(Sender: TObject);
	 procedure IncCombo_AutoDropDownClick(Sender: TObject);
    procedure IncCombo_BorderStyleClick(Sender: TObject);
    procedure IncCombo_ShowComboButtonClick(Sender: TObject);
    procedure IncCombo_StyleClick(Sender: TObject);
    procedure IncCombo_AlignHorizontallyChange(Sender: TObject);
    procedure IncCombo_AlignVerticallyChange(Sender: TObject);
    procedure CheckBox_ColLinesClick(Sender: TObject);
    procedure CheckBox_RowLinesClick(Sender: TObject);
    procedure CheckBox_TitlesClick(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure IncCombo_ColorChange(Sender: TObject);
    procedure IncCombo_TitleColorChange(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure CheckBox_CanBeBlankClick(Sender: TObject);
    procedure CheckBox_Ctl3DClick(Sender: TObject);
    procedure IncCombo_ButtonCursorChange(Sender: TObject);
    procedure Table_OrdersCalcFields(DataSet: TDataset);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
		procedure SetFields;
		procedure LoadColors(const S: string);
		procedure LoadCursors(const S: string);
	 { Private declarations }
  public
    { Public declarations }
  end;

  TExposedCustomEdit = class(TCustomEdit)
  end;

var
  Form_Main: TForm_Main;

implementation

{$R *.DFM}

procedure TForm_Main.DBIncLookupCombo_GeneralNewRecord(Sender: TObject;
  DataSet: TDataSet; NewValue: string);
begin
	MessageDlg('You have entered a new item that would typically be added at this point using the OnNewRecord event',
	mtInformation,[mbOK],0);
	Abort;
end;

procedure TForm_Main.FormCreate(Sender: TObject);
var i: Integer;
begin
	{ This fixes the autosize problem }
	for i := 0 to ComponentCount-1 do
		begin
		if Components[i] is TLabel then
			begin
			TLabel(Components[i]).AutoSize := not TLabel(Components[i]).AutoSize;
			TLabel(Components[i]).AutoSize := not TLabel(Components[i]).AutoSize;
			end;
		if Components[i] is TImage then
			begin
			TImage(Components[i]).AutoSize := not TImage(Components[i]).AutoSize;
			TImage(Components[i]).AutoSize := not TImage(Components[i]).AutoSize;
			end;
		if (Components[i] is TCustomEdit)
		and not (Components[i] is TCustomMemo) then
			begin
			TExposedCustomEdit(Components[i]).AutoSize := not TExposedCustomEdit(Components[i]).AutoSize;
			TExposedCustomEdit(Components[i]).AutoSize := not TExposedCustomEdit(Components[i]).AutoSize;
			end;
		end;

	GetColorValues(LoadColors);
	GetCursorValues(LoadCursors);
	SetFields;
end;

procedure TForm_Main.SetFields;
var Temp: String;
begin
	with DBIncLookupCombo_General do
		begin
		IncCombo_AutoDropDown.ItemIndex    := Ord(AutoDropDown);
		IncCombo_BorderStyle.ItemIndex     := Ord(BorderStyle);
		IncCombo_ShowComboButton.ItemIndex := Ord(ShowComboButton);
		IncCombo_Style.ItemIndex           := Ord(Style);
		CheckBox_CanBeBlank.Checked        := CanBeBlank;
		CheckBox_Ctl3D.Checked             := Ctl3D;
		IncCombo_AlignHorizontally.ItemIndex := Ord(DropDownOptions.AlignHorizontally);
		IncCombo_AlignVertically.ItemIndex   := Ord(DropDownOptions.AlignVertically);
		CheckBox_ColLines.Checked := DropDownOptions.ColLines;
		CheckBox_RowLines.Checked := DropDownOptions.RowLines;
		CheckBox_Titles.Checked   := DropDownOptions.Titles;
		Temp := ColorToString(DropDownOptions.Color);
		Delete(Temp,1,2);
		IncCombo_Color.ItemIndex := IncCombo_Color.Items.IndexOf(Temp);
		Temp := ColorToString(DropDownOptions.TitleColor);
		Delete(Temp,1,2);
		IncCombo_TitleColor.ItemIndex := IncCombo_TitleColor.Items.IndexOf(Temp);
		Temp := CursorToString(ButtonCursor);
		Delete(Temp,1,2);
		IncCombo_ButtonCursor.ItemIndex := IncCombo_ButtonCursor.Items.IndexOf(Temp);
		end;
end;


procedure TForm_Main.IncCombo_AutoDropDownClick(Sender: TObject);
begin
	DBIncLookupCombo_General.AutoDropDown := TAutoDropDown(IncCombo_AutoDropDown.ItemIndex);
end;

procedure TForm_Main.IncCombo_BorderStyleClick(Sender: TObject);
begin
	DBIncLookupCombo_General.BorderStyle := TBorderStyle(IncCombo_BorderStyle.ItemIndex);
end;

procedure TForm_Main.IncCombo_ShowComboButtonClick(Sender: TObject);
begin
	DBIncLookupCombo_General.ShowComboButton := TShowComboButton(IncCombo_ShowComboButton.ItemIndex);
end;

procedure TForm_Main.IncCombo_StyleClick(Sender: TObject);
begin
	DBIncLookupCombo_General.Style := TComboStyle(IncCombo_Style.ItemIndex);
end;

procedure TForm_Main.IncCombo_AlignHorizontallyChange(Sender: TObject);
begin
	DBIncLookupCombo_General.DropDownOptions.AlignHorizontally :=
	TDropDownAlignHorizontally(IncCombo_AlignHorizontally.ItemIndex);
end;

procedure TForm_Main.IncCombo_AlignVerticallyChange(Sender: TObject);
begin
	DBIncLookupCombo_General.DropDownOptions.AlignVertically :=
	TDropDownAlignVertically(IncCombo_AlignVertically.ItemIndex);
end;

procedure TForm_Main.CheckBox_ColLinesClick(Sender: TObject);
begin
	DBIncLookupCombo_General.DropDownOptions.ColLines := CheckBox_ColLines.Checked;
end;

procedure TForm_Main.CheckBox_RowLinesClick(Sender: TObject);
begin
	DBIncLookupCombo_General.DropDownOptions.RowLines := CheckBox_RowLines.Checked;
end;

procedure TForm_Main.CheckBox_TitlesClick(Sender: TObject);
begin
	DBIncLookupCombo_General.DropDownOptions.Titles := CheckBox_Titles.Checked;
end;

procedure TForm_Main.BitBtn3Click(Sender: TObject);
begin
	Close;
end;

procedure TForm_Main.LoadColors(const S: string);
var DisplayColor: String;
begin
	DisplayColor := S;
	Delete(DisplayColor,1,2);
	IncCombo_Color.Items.Add(DisplayColor);
	IncCombo_TitleColor.Items.Add(DisplayColor);
end;


procedure TForm_Main.IncCombo_ColorChange(Sender: TObject);
var AColor: LongInt;
begin
	IdentToColor('cl'+IncCombo_Color.Text,LongInt(AColor));
	DBIncLookupCombo_General.DropDownOptions.Color := TColor(AColor);
end;

procedure TForm_Main.IncCombo_TitleColorChange(Sender: TObject);
var AColor: LongInt;
begin
	IdentToColor('cl'+IncCombo_TitleColor.Text,LongInt(AColor));
	DBIncLookupCombo_General.DropDownOptions.TitleColor := TColor(AColor);
end;

procedure TForm_Main.BitBtn1Click(Sender: TObject);
begin
	FontDialog1.Font.Assign(DBIncLookupCombo_General.DropDownOptions.Font);
	if FontDialog1.Execute then
		DBIncLookupCombo_General.DropDownOptions.Font.Assign(FontDialog1.Font);
end;

procedure TForm_Main.BitBtn2Click(Sender: TObject);
begin
	FontDialog1.Font.Assign(DBIncLookupCombo_General.DropDownOptions.TitleFont);
	if FontDialog1.Execute then
		DBIncLookupCombo_General.DropDownOptions.TitleFont.Assign(FontDialog1.Font);
end;

procedure TForm_Main.CheckBox_CanBeBlankClick(Sender: TObject);
begin
	DBIncLookupCombo_General.CanBeBlank := CheckBox_CanBeBlank.Checked;
end;

procedure TForm_Main.CheckBox_Ctl3DClick(Sender: TObject);
begin
	DBIncLookupCombo_General.Ctl3D := CheckBox_Ctl3D.Checked;
end;

procedure TForm_Main.LoadCursors(const S: string);
var DisplayCursor: String;
begin
	DisplayCursor := S;
	Delete(DisplayCursor,1,2);
	IncCombo_ButtonCursor.Items.Add(DisplayCursor);
end;

procedure TForm_Main.IncCombo_ButtonCursorChange(Sender: TObject);
var ACursor: LongInt;
begin
	IdentToCursor('cr'+IncCombo_ButtonCursor.Text,LongInt(ACursor));
	DBIncLookupCombo_General.ButtonCursor := TCursor(ACursor);
end;

procedure TForm_Main.Table_OrdersCalcFields(DataSet: TDataset);
begin
	with Table_CustomerNameGridCalc do
		begin
		if Active and FindKey([DataSet.FieldByName('CustNo').AsString]) then
			DataSet.FieldByName('CustomerName').AsString := FieldByName('Company').AsString;
		end;
end;

procedure TForm_Main.FormActivate(Sender: TObject);
begin
   TabbedNotebook_Main.ActivePage := 'General';
	Application.ProcessMessages;
	Screen.Cursor := crHourGlass;
	try
		Table_Orders.Active := True;
		Table_Customer.Active := True;
		Table_CustomerLookups.Active := True;
		Table_CustomerNameGridCalc.Active := True;
		Query_Parts.Active := True;
		Query_Vendor.Active := True;
		Query_BioLife.Active := True;
		Table_Orders.Refresh;
	finally
		Screen.Cursor := crDefault;
		end;
	Repaint;
end;

procedure TForm_Main.FormDestroy(Sender: TObject);
begin
	Table_Orders.Active := False;
	Table_Customer.Active := False;
	Table_CustomerLookups.Active := False;
	Table_CustomerNameGridCalc.Active := False;
	Query_Parts.Active := False;
	Query_Vendor.Active := False;
	Query_BioLife.Active := False;
end;

end.
