
{
Compress.pas

Small test program for my compression component "TLzrw1".

Author : Danny Heijl, may 10 1996.
         Danny.Heijl@cevi.be


 Feel free to use or give away this software as you see fit.
 Just leave the credits in place if you alter the source.

 This software is delivered to you "as is",
 no guarantees, it may blow up or trigger World War Three
 for all I know.

 If you find any bugs and let me know, I will try to fix them.

 I believe in programmers around the world helping each other
 out by distributing free source code.

}

unit Compress;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Lzrw1, StdCtrls, ExtCtrls;


type
  TForm1 = class(TForm)
    Compressor: Tlzrw1;
    Button1: TButton;
    InputFile: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    OutputFile: TEdit;
    Button2: TButton;
    RgrpComprMode: TRadioGroup;
    RBtnFast: TRadioButton;
    RBtnGood: TRadioButton;
    RBtnAuto: TRadioButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RBtnFastClick(Sender: TObject);
    procedure RBtnGoodClick(Sender: TObject);
    procedure RBtnAutoClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    CompressionMode : TcompressMode;
    procedure Loaded; override;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;


implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   Compressor.CompressMode := CompressionMode;
   Compressor.InputFile := InputFile.Text;
   Compressor.OutputFile := OutputFile.Text;
   Compressor.Compress;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   Compressor.CompressMode := CompressionMode;  { does autodetect, really }
   Compressor.InputFile := InputFile.Text;
   Compressor.OutputFile := OutputFile.Text;
   Compressor.DeCompress;
end;

procedure TForm1.RBtnFastClick(Sender: TObject);
begin
  CompressionMode := Fast;
end;

procedure TForm1.RBtnGoodClick(Sender: TObject);
begin
  CompressionMode := Good;
end;

procedure Tform1.Loaded;
begin
  inherited Loaded;
  CompressionMode := Auto;
  RbtnAuto.Checked := True;     {    Fast }
end;

procedure TForm1.RBtnAutoClick(Sender: TObject);
begin
  CompressionMode := Auto;
end;

procedure TForm1.Button3Click(Sender: TObject);
var

  Cmode : TcompressMode;

begin
  Compressor.InputFile := InputFile.Text;
  if (Compressor.Inputfile <> '') then begin
    Cmode := Compressor.Advise;
    if (Cmode = Good) then begin
      RBtnGoodClick(Self);
      RBtnGood.Checked := True;
    end
    else begin
      RBtnFastClick(Self);
      RBtnFast.Checked := True;
    end;
  end
  else  begin
    ActiveControl := InputFile;
  end;
end;

end.
