{*******************************************************}
{                   Demo of                             }
{       Ole Automation Controller for Delphi 1.0        }
{       by Roger Headrick (Compserv 76114,1430)         }
{       contributed to public domain 12/23/95           }
{                                                       }
{*******************************************************}

unit Ctlrdemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, OleCtlr;

type
  TForm1 = class(TForm)
    btnCreate: TButton;
    btnFileNewDef: TButton;
    btnInsert: TButton;
    editInsert: TEdit;
    btnFileSaveAs: TButton;
    editFileName: TEdit;
    btnWordCount: TButton;
    lblWordCount: TLabel;
    Label1: TLabel;
    procedure btnCreateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnFileNewDefClick(Sender: TObject);
    procedure btnInsertClick(Sender: TObject);
    procedure btnFileSaveAsClick(Sender: TObject);
    procedure btnWordCountClick(Sender: TObject);
  private
    { Private declarations }
    WordCtlr: TWordCtlr;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  WordCtlr := TWordCtlr.Create( self);
end;

procedure TForm1.btnCreateClick(Sender: TObject);
begin
  try
    Screen.Cursor := crHourglass;
    WordCtlr.CreateOleObject;
    btnFileNewDef.Enabled := True;
    btnInsert.Enabled := True;
    btnFileSaveAs.Enabled := True;
    btnWordCount.Enabled := True;
    btnFileNewDef.SetFocus;
    btnCreate.Enabled := False;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TForm1.btnFileNewDefClick(Sender: TObject);
begin
  WordCtlr.FileNewDefault;
end;

procedure TForm1.btnInsertClick(Sender: TObject);
begin
  WordCtlr.Insert( editInsert.Text);
end;

procedure TForm1.btnFileSaveAsClick(Sender: TObject);
begin
  WordCtlr.FileSaveAs( editFileName.Text);
end;

procedure TForm1.btnWordCountClick(Sender: TObject);
var
   lResult: Longint;
begin
  WordCtlr.GetDocumentProperty('Words', PAS_LONGINT, lResult);
  lblWordCount.Caption := IntToStr(lResult);
end;

end.
