unit Example2;

interface

uses
  Windows, SysUtils, Classes, Graphics, Forms, Controls, Buttons, StdCtrls,
  MainClss, PopupBox, Menus, ComCtrls, ExtCtrls;

type
  TForm2 = class(TForm)
    TPageControl1: TPageControl;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PopupBox1: TPopupBox;
    PopupMenu1: TPopupMenu;
    MenuAdd: TMenuItem;
    MenuInsert: TMenuItem;
    MenuEdit: TMenuItem;
    MenuDelete: TMenuItem;
    MenuBreak: TMenuItem;
    MenuDeleteAll: TMenuItem;
    Bevel1: TBevel;
    Label4: TLabel;
    Bevel2: TBevel;
    PopupBox2: TPopupBox;
    Label5: TLabel;
    Label6: TLabel;
    PopupBoxDates1: TPopupBoxDates;
    Bevel3: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    BitBtn1: TBitBtn;
    Page1: TTabSheet;
    Page2: TTabSheet;
    Page3: TTabSheet;
    procedure PopupMenu1Popup(Sender: TObject);
    procedure MenuAddClick(Sender: TObject);
    procedure MenuInsertClick(Sender: TObject);
    procedure MenuEditClick(Sender: TObject);
    procedure MenuDeleteClick(Sender: TObject);
    procedure MenuDeleteAllClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PopupBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PopupBox2DrawListItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure PopupBoxDates1Popup(Sender: TObject);
    procedure PopupBox2SetFieldValue(Sender: TObject; Index: Integer;
      var Value: string; var Allowed: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

uses
  Dialogs;

// Form create
procedure TForm2.FormCreate(Sender: TObject);
begin
  PopupBoxDates1.Text:= FormatDateTime('c', Date);
end;

// Menu opens up
procedure TForm2.PopupMenu1Popup(Sender: TObject);
begin
  with PopupBox1 do begin
    MenuInsert.Enabled:= ListBox.ValidSelection;
    MenuEdit.Enabled:= ListBox.ValidSelection;
    MenuDelete.Enabled:= ListBox.ValidSelection;
    MenuDeleteAll.Enabled:= Items.Count > 0;
  end;
end;

// add country
procedure TForm2.MenuAddClick(Sender: TObject);
VAR
  NewValue: String;
begin
  NewValue:= '';
  if InputQuery('Give in the new country', 'country name:', NewValue) then
    PopupBox1.ItemIndex:= PopupBox1.Items.Add(NewValue);
end;

// insert country
procedure TForm2.MenuInsertClick(Sender: TObject);
VAR
  NewValue: String;
begin
  if not PopupBox1.ListBox.ValidSelection then exit;
  NewValue:= '';
  if InputQuery('Give in the new value', 'country to insert:', NewValue) then begin
    PopupBox1.Items.Insert(PopupBox1.ItemIndex, NewValue);
    PopupBox1.ItemIndex:= PopupBox1.Items.IndexOf(NewValue);
  end;
end;

// edit country name
procedure TForm2.MenuEditClick(Sender: TObject);
VAR
  ChangedValue: String;
  CurrentItemIndex: Integer;
begin
  with PopupBox1 do begin
    if not ListBox.ValidSelection then exit;
    ChangedValue:= Items[ItemIndex];
    if ListBox.Sorted then begin
      if InputQuery('Edit value', 'Change country:', ChangedValue) then begin
        ListBox.Sorted:= False;
        Items[ItemIndex]:= ChangedValue;
        ListBox.Sorted:= True;
        if Items.Find(ChangedValue, CurrentItemIndex) then
          ItemIndex:= CurrentItemIndex;
      end;
    end else
      if InputQuery('Edit value', 'value:', ChangedValue) then begin
        Items[ItemIndex]:= ChangedValue;
        ItemIndex:= Items.IndexOf(ChangedValue);
      end;
  end;
end;

// delete country
procedure TForm2.MenuDeleteClick(Sender: TObject);
VAR
  CurrSelection: LongInt;
begin
  with PopupBox1 do begin
    if not ListBox.ValidSelection then exit;
    CurrSelection:= ItemIndex;
    Items.Delete(CurrSelection);
    if Items.Count-1 < CurrSelection then
      // we select the last list item
      ItemIndex:= Items.Count-1
    else
      ItemIndex:= CurrSelection;
  end;
end;

// Delete all countries
procedure TForm2.MenuDeleteAllClick(Sender: TObject);
begin
  PopupBox1.Items.Clear;
end;

// Keyboard-Key pressed while at PopupBox
procedure TForm2.PopupBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ssCtrl in Shift then
    Case Key of
      ord('A'): MenuAddClick(Sender);
      ord('E'): MenuEditClick(Sender);
      ord('L'): MenuDeleteAllClick(Sender);
    End
  else
    Case Key of
      VK_DELETE: MenuDeleteClick(Sender);
      VK_INSERT: MenuInsertClick(Sender);
    End;
end;

procedure TForm2.PopupBox2DrawListItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
VAR
  TempStr1, TempStr2: String;
  Rect1, Rect2: TRect;
begin
  TempStr1:= PopupBox2.Items[Index];
  SetLength(TempStr1, 3);
  TempStr2:= PopupBox2.Items[Index];
  Delete(TempStr2, 1, 3);
  with TPopupBoxLB(Control).Canvas do begin
    SetRect(Rect1, Rect.Left, Rect.Top, Rect.Left + TextWidth('WWWW'), Rect.Bottom);
    SetRect(Rect2, Rect1.Right, Rect.Top, Rect.Right, Rect.Bottom);

    TextRect(Rect1, Rect1.Left, Rect1.Top, TempStr1);
    TextRect(Rect2, Rect2.Left, Rect2.Top, TempStr2);
  end;
end;

procedure TForm2.PopupBoxDates1Popup(Sender: TObject);
begin
  with PopupBoxDates1 do
    if ItemIndex >= 4 then ListBox.TopIndex:= ItemIndex - 4;
end;

procedure TForm2.PopupBox2SetFieldValue(Sender: TObject; Index: Integer;
  var Value: string; var Allowed: Boolean);
begin
  if Value = 'C   Cuba' then begin
    MessageDlg('You can not select Cuba!!', mtInformation, [mbYes], 0);
    Allowed:= False;
  end else
    SetLength(Value, 3);
end;

end.
