unit dpfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, powerprn, Mask;

type
  TPowerPrinterForm = class(TForm)
    Button1: TButton;
    PageControl1: TPageControl;
    btnAbout: TButton;
    Label1: TLabel;
    DefaultPrinter: TEdit;
    Label2: TLabel;
    DefaultDriver: TEdit;
    Label3: TLabel;
    DefaultPort: TEdit;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label4: TLabel;
    st_orientation: TLabel;
    Button3: TButton;
    Button4: TButton;
    lbPrnList: TListBox;
    Button5: TButton;
    Label5: TLabel;
    btnUnlock: TButton;
    Label6: TLabel;
    Label7: TLabel;
    eUserName: TEdit;
    eKey: TMaskEdit;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    lb_bins: TListBox;
    btnGetBinList: TButton;
    btnSetBin: TButton;
    btnGetBin: TButton;
    lb_papersize: TListBox;
    btnGetPaperSizeList: TButton;
    btnGetPaperSize: TButton;
    bntSetPaperSize: TButton;
    rbDefault: TRadioButton;
    rbNamed: TRadioButton;
    TabSheet5: TTabSheet;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure lbPrnListDblClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure btnUnlockClick(Sender: TObject);
    procedure btnGetPaperSizeListClick(Sender: TObject);
    procedure btnGetBinListClick(Sender: TObject);
    procedure btnGetBinClick(Sender: TObject);
    procedure rbDefaultClick(Sender: TObject);
    procedure rbNamedClick(Sender: TObject);
    procedure btnSetBinClick(Sender: TObject);
    procedure btnGetPaperSizeClick(Sender: TObject);
    procedure bntSetPaperSizeClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PowerPrinterForm: TPowerPrinterForm;

implementation

{$R *.DFM}

procedure TPowerPrinterForm.Button1Click(Sender: TObject);
begin
     Close;
end;

procedure TPowerPrinterForm.FormCreate(Sender: TObject);
begin
      CreatePowerPrinter;
      DefaultPrinter.Text := GetDefPrinterName;
      DefaultPort.Text    := GetDefPrinterPort;
      DefaultDriver.Text  := GetDefPrinterDriver;
      st_Orientation.Caption := GetPrinterOrientationString;

      Application.HelpFile := 'powerprn.hlp';
end;

procedure TPowerPrinterForm.Button3Click(Sender: TObject);
begin
     SetPrinterOrientation (DMORIENT_LANDSCAPE);
     st_Orientation.Caption := GetPrinterOrientationString;
end;

procedure TPowerPrinterForm.Button4Click(Sender: TObject);
begin
     SetPrinterOrientation (DMORIENT_PORTRAIT);
     st_Orientation.Caption := GetPrinterOrientationString;
end;

procedure TPowerPrinterForm.Button5Click(Sender: TObject);
var
   pPrnList, pName:string;
   i, iPos:smallint;
begin
     pPrnList := GetPrinterList;
     iPos := Pos(';', pPrnList);
     while (iPos > 0 ) do
     begin
          pName := copy(pPrnList, 1, iPos -1);
          lbPrnList.Items.AddObject(pName, nil);
          pPrnLIst := copy(pPrnList, iPos +1, Length(pPrnList) - iPos);
          iPos := Pos(';', pPrnList);
     end;
end;

procedure TPowerPrinterForm.lbPrnListDblClick(Sender: TObject);
var
   PrnName:string;
begin
     PrnName := lbPrnList.Items[lbPrnList.ItemIndex];

     SetDefaultPrinter (PrnName);

      DefaultPrinter.Text := GetDefPrinterName;
      DefaultPort.Text    := GetDefPrinterPort;
      DefaultDriver.Text  := GetDefPrinterDriver;
      st_Orientation.Caption := GetPrinterOrientationString;

end;

procedure TPowerPrinterForm.btnAboutClick(Sender: TObject);
begin
     About;
end;

procedure TPowerPrinterForm.btnUnlockClick(Sender: TObject);
var
   lKey, lCode :longint;
   button:integer;
begin
     Val(trim(eKey.text), lKey, lCode);
     if Unlock (eUserName.text, lKey) = 1 then
        button := application.MessageBox('Valid KEY. The registration reminder will not be shown when PowerPrinter gets unloaded.', 'PowerPrinter', MB_OK);

end;

procedure TPowerPrinterForm.btnGetPaperSizeListClick(Sender: TObject);
var
   sPaperSizeList, sPaperSizeName:string;
   iPos:integer;
begin

     sPaperSizeList := GetPaperSizeList();
     iPos := pos(';', sPaperSizeList);
     lb_papersize.Clear();
     while (iPos > 0) do
     begin
          sPaperSizeName := copy(sPaperSizeList, 1, iPos -1);
          lb_PaperSize.Items.AddObject(sPaperSizeName, nil);
          sPaperSizeList := copy(sPaperSizeList, iPos +1, Length(sPaperSizeList) - iPos);
          iPos := Pos(';', sPaperSizeList);
     end;
end;


procedure TPowerPrinterForm.btnGetBinListClick(Sender: TObject);
var
   sBinList, sBinName:string;
   iPos:integer;
begin

     if rbDefault.checked = TRUE then
        sBinList := GetPaperBinList()
     else
         sBinList := GetNamedPaperBinList();

     lb_Bins.Clear();

     iPos := pos(';', sBinList);
     while (iPos > 0) do
     begin
          sBinName := copy(sBinList, 1, iPos -1);
          lb_Bins.Items.AddObject(sBinName, nil);
          sBinLIst := copy(sBinList, iPos +1, Length(sBinList) - iPos);
          iPos := Pos(';', sBinList);
     end;
end;

procedure TPowerPrinterForm.btnGetBinClick(Sender: TObject);
var
   iBin:SmallInt;
   lRet :LongInt;
   Button:integer;
   pMsg : array [0..200] of Char;
   sMsg : string;
begin
     lRet := GetDefaultSource(iBin);

     if lRet > 0 then
     begin
        sMsg := 'Default Paper Source :' + IntToStr(iBin);
        strPCopy(pMsg, sMsg);
     end
     else
        strPCopy(pMsg, 'Could not fetch default paper source');

     Button := Application.MessageBox(pMsg, 'PowerPrinter', mb_OK);
end;

procedure TPowerPrinterForm.rbDefaultClick(Sender: TObject);
begin
     btnSetBin.enabled := TRUE;
     btnGetBinListClick(rbDefault);
end;

procedure TPowerPrinterForm.rbNamedClick(Sender: TObject);
begin
     btnSetBin.enabled := FALSE;
     btnGetBinListClick(rbNamed);
end;

procedure TPowerPrinterForm.btnSetBinClick(Sender: TObject);
var
   BinName : string;
   BinIndex : SmallInt;
   button :integer;
begin
     if lb_Bins.ItemIndex >= 0 then
     begin
          BinName := lb_Bins.Items[lb_Bins.ItemIndex];
          BinIndex := StrToInt(copy(BinName, 1, pos(' ', BinName) -1));
          if SetDefaultSource (BinIndex) > 0 then
             button := application.MessageBox('Set default Source succeeded', 'PowerPrinter', MB_OK)
          else
             button := application.MessageBox('Set default Source failed', 'PowerPrinter', MB_OK);
     end
     else
         button := application.MessageBox('No Paper Bin to choose from !', 'PowerPrinter', MB_OK);
end;

procedure TPowerPrinterForm.btnGetPaperSizeClick(Sender: TObject);
var
   iSize:SmallInt;
   lRet :LongInt;
   Button:integer;
   pMsg : array [0..200] of Char;
   sMsg : string;
begin
     lRet := GetPaperSize(iSize);

     if lRet > 0 then
     begin
        sMsg := 'Default Paper Size :' + IntToStr(iSize);
        strPCopy(pMsg, sMsg);
     end
     else
        strPCopy(pMsg, 'Could not fetch default paper size. Is your printer online ?');

     Button := Application.MessageBox(pMsg, 'PowerPrinter', mb_OK);
end;


procedure TPowerPrinterForm.bntSetPaperSizeClick(Sender: TObject);
var
   SizeName : string;
   SizeIndex : SmallInt;
   button :integer;
begin
     if lb_papersize.ItemIndex >= 0 then
     begin
          SizeName := lb_papersize.Items[lb_papersize.ItemIndex];
          SizeIndex := StrToInt(copy(SizeName, 1, pos(' ', SizeName) -1));
          if SetPaperSize (SizeIndex) > 0 then
             button := application.MessageBox('Set Paper Size succeeded', 'PowerPrinter', MB_OK)
          else
             button := application.MessageBox('Set Paper Size failed', 'PowerPrinter', MB_OK);
     end
     else
         button := application.MessageBox('No Paper Size to choose from !', 'PowerPrinter', MB_OK);
end;


procedure TPowerPrinterForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     DestroyPowerPrinter;
end;

procedure TPowerPrinterForm.Button2Click(Sender: TObject);
begin
     application.HelpContext(1); 
end;

end.
