VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "PowerPrn"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

' class handle
Dim hdl As Long

'function declarations

Private Sub Class_Initialize()
    hdl = CWin32Prn_CPP_CONSTRUCTOR()
End Sub


Private Sub Class_Terminate()
    CWin32Prn_CPP_DESTRUCTOR (hdl)
End Sub



Public Function GetDefaultPrinterName() As String

    Dim PrnName As String
    Dim ret As Long
    
    ' make sure that the buffer is large enough
    PrnName = String(200, 0)

    ' call API
    ret = dwGetDefaultPrinterName(hdl, PrnName)

    If ret < 0 Then
        PrnName = "Unable to fecth printer name"
    End If
    
    GetDefaultPrinterName = PrnName
End Function



Public Function GetDefaultPrinterDriver() As String

    Dim DrvName As String
    Dim ret As Long
    
    ' make sure that the buffer is large enough
    DrvName = String(200, 0)

    ' call API
    ret = dwGetDefaultPrinterDriver(hdl, DrvName)

    If ret < 0 Then
        DrvName = "Unable to fecth Driver name"
    End If
    
    GetDefaultPrinterDriver = DrvName


End Function

Public Function GetDefaultPrinterPort() As String

    Dim PortName As String
    Dim ret As Long
    
    ' make sure that the buffer is large enough
    PortName = String(200, 0)

    ' call API
    ret = dwGetDefaultPrinterPort(hdl, PortName)

    If ret < 0 Then
        PortName = "Unable to fecth Port name"
    End If
    
    GetDefaultPrinterPort = PortName
End Function

Public Function SetPrinterOrientation(iOrient As Integer)
    
    ' check value
    If ((iOrient = DMORIENT_PORTRAIT) Or (iOrient = DMORIENT_LANDSCAPE)) Then
        SetPrinterOrientation = dwSetPrinterOrientation(hdl, iOrient)
    Else
        SetPrinterOrientation = -2  ' bad param
    End If
    
End Function

Public Function GetPrinterOrientation(ByRef iOrient As Integer) As Long

    GetPrinterOrientation = dwGetPrinterOrientation(hdl, iOrient)
    
End Function

Public Function GetPrinterOrientationString(ByRef PrnOrient As String) As Long

    Dim iOrient As Integer
    Dim iRet As Long
    
    ' get it
    iRet = dwGetPrinterOrientation(hdl, iOrient)
    
    
    If iRet > 0 Then
        Select Case iOrient
        
            Case DMORIENT_PORTRAIT
                PrnOrient = "Portrait"
                
            Case DMORIENT_LANDSCAPE
                PrnOrient = "Landscape"
                
            Case Else
                PrnOrient = "Unknown Orientation"
                
        End Select
    Else
        PrnOrient = "Unknown Orientation"
    End If
    
    ' return error code
    GetPrinterOrientationString = iRet
    
End Function

Public Function GetPrinterList(ByRef PrnList As String) As Long

    PrnList = String(2000, 0)
    GetPrinterList = dwGetPrinterList(hdl, PrnList)
    
End Function

Public Function SetDefaultPrinter(DefaultPrinter As String) As Long
       
    Dim x As String
    Dim y As Long
    
    x = String(200, 0)
    
    x = DefaultPrinter
    
    y = dwSetDefaultPrinter(hdl, x)
    SetDefaultPrinter = y

End Function

Public Sub About()
    dwAbout
End Sub

Public Function UnlockDLL(RegUser As String, lKey As Long) As Long

    Dim ret As Long
    
    ret = dwUnlock(RegUser, lKey)
    
    If ret > 0 Then
        MsgBox ("Valid KEY. The registration reminder will not be shown when PowerPrinter gets unloaded.")
    End If
    
    UnlockDLL = ret
    
End Function

Public Function GetPaperBinList() As String

    Dim lsBinList As String
    Dim ret As Long
    
    lsBinList = String(500, 0)
    
    ret = dwGetPaperBinList(hdl, lsBinList)
    
    If ret < 0 Then
        lsBinList = "Could NOt Fetch Paper Bin List"
    End If
    
    GetPaperBinList = lsBinList
End Function

Public Function GetNamedPaperBinList() As String

    Dim lsBinList As String
    Dim ret As Long
    
    lsBinList = String(500, 0)
    
    ret = dwGetNamedPaperBinList(hdl, lsBinList)
    
    If ret < 0 Then
        lsBinList = "Could Not Fetch Named Paper Bin List"
    End If
    
    GetNamedPaperBinList = lsBinList

End Function

Public Function GetPaperSize(ByRef iSize As Integer) As Long
    
    GetPaperSize = dwGetPaperSize(hdl, iSize)
    
End Function

Public Function GetPaperSource(ByRef iSource As Integer) As Long

    GetPaperSource = dwGetDefaultSource(hdl, iSource)
    
End Function

Public Function SetDefaultSource(iSource As Integer)
    SetDefaultSource = dwSetDefaultSource(hdl, iSource)
End Function

Public Function GetPaperSizeList() As String
    
    Dim lsPaperSizeList As String
    Dim ret As Long
    
    lsPaperSizeList = String(3000, 0)
    
    ret = dwGetSupportedPaperSizeList(hdl, lsPaperSizeList)
    
    If ret < 0 Then
        lsPaperSizeList = "Could Not Fetch Paper Size List List"
    End If
    
    GetPaperSizeList = lsPaperSizeList

End Function

Public Function SetPaperSize(iSize As Integer)
       SetPaperSize = dwSetPaperSize(hdl, iSize)
End Function
