unit powerprn;

interface
function CWin32Prn_CPP_CONSTRUCTOR : longint; stdcall; external 'powerprn.dll';
Procedure CWin32Prn_CPP_DESTRUCTOR (hdl:Longint) ; stdcall; external 'powerprn.dll';

function dwGetDefaultPrinterName (hdl:LongInt; pPrnName:pChar):longint; stdcall; external 'powerprn.dll';
function dwGetDefaultPrinterPort (hdl:LongInt; pPrnPort:pChar):longint; stdcall; external 'powerprn.dll';
function dwGetDefaultPrinterDriver (hdl:LongInt; pPrnDriver:pChar):longint; stdcall; external 'powerprn.dll';
function dwGetPrinterList (hdl:LongInt; szPrtr:pChar):longint; stdcall; external 'powerprn.dll'
function dwSetDefaultPrinter (hdl:LongInt; szPrinterName:pChar):longint; stdcall; external 'powerprn.dll'
function dwGetDefaultPrinterEx (hdl:LongInt; szPrinterName, szPrinterDriver, szPrinterPort:pChar):longint; stdcall; external 'powerprn.dll'
function dwSetDefaultPrinterEx (hdl:LongInt; const szPrinterName, szPrinterDriver, szPrinterPort:pChar):longint; stdcall; external 'powerprn.dll'

// short orientation
function dwGetPrinterOrientation(hdl:LongInt; var iOrient:SmallInt):longint; stdcall; external 'powerprn.dll';
function dwSetPrinterOrientation(hdl:LongInt; iOrient:SmallInt):longint; stdcall; external 'powerprn.dll';

// short paper size
function dwGetPaperSize(hdl:longint; var iPaperSize:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPaperSize(hdl:longint; iPaperSize:smallint) :longint; stdcall; external 'powerprn.dll'

// short paper Length
function dwGetPaperLength(hdl:longint; var iPaperLength:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPaperLength(hdl:longint; iPaperLength:smallint) :longint; stdcall; external 'powerprn.dll'

// short paper Width
function dwGetPaperWidth(hdl:longint; var iPaperWidth:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPaperWidth(hdl:longint; iPaperWidth:smallint) :longint; stdcall; external 'powerprn.dll'

// Scale
function dwGetScale(hdl:longint; var iScale:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetScale(hdl:longint; iScale:smallint) :longint; stdcall; external 'powerprn.dll'

// Copies
function dwGetCopies(hdl:longint; var iCopies:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetCopies(hdl:longint; iCopies:smallint) :longint; stdcall; external 'powerprn.dll'

// Default Source
function dwGetDefaultSource(hdl:longint; var iSource:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetDefaultSource(hdl:longint; iSource:smallint) :longint; stdcall; external 'powerprn.dll'

// short  dmPrintQuality
function dwGetPrintQuality(hdl:longint; var iPrintQuality:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPrintQuality(hdl:longint; iPrintQuality:smallint) :longint; stdcall; external 'powerprn.dll'

// Color
function dwGetColor(hdl:longint; var iColor:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetColor(hdl:longint; iColor:smallint) :longint; stdcall; external 'powerprn.dll'

// Duplex
function dwGetDuplex(hdl:longint; var iDuplex:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetDuplex(hdl:longint; iDuplex:smallint) :longint; stdcall; external 'powerprn.dll'

// YResolution
function dwGetYResolution(hdl:longint; var iYResolution:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetYResolution(hdl:longint; iYResolution:smallint) :longint; stdcall; external 'powerprn.dll'

// TTOption
function dwGetTTOption(hdl:longint; var iTTOption:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetTTOption(hdl:longint; iTTOption:smallint) :longint; stdcall; external 'powerprn.dll'

// Collate
function dwGetCollate(hdl:longint; var iCollate:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetCollate(hdl:longint; iCollate:smallint) :longint; stdcall; external 'powerprn.dll'

Procedure dwAbout ; stdcall; external 'powerprn.dll';
function dwUnlock (sregUser:pChar; lKey:LOngInt): longint; stdcall; external 'powerprn.dll'

Function dwGetPaperBinList (hdl:LongInt; szPaperList:pChar): longint; stdcall; external 'powerprn.dll'
Function dwGetNamedPaperBinList (hdl:LongInt; szPaperList:pChar) : longint; stdcall; external 'powerprn.dll'
Function dwGetSupportedPaperSizeList (hdl:LongInt; szPaperSizeList:pChar) : longint; stdcall; external 'powerprn.dll'



procedure CreatePowerPrinter;
procedure DestroyPowerPrinter;
procedure About;
function Unlock (RegUser:string; lKey:LongInt): longint;
function GetDefPrinterName : string;
function GetDefPrinterPort : string;
function GetDefPrinterDriver : string;
function GetPrinterOrientationString : string;
function SetPrinterOrientation (iOrient : SmallInt) : LongInt;
function SetPaperSize (iSize : SmallInt) : LongInt;
function GetPaperSize (var iSize : SmallInt) : longint;
function SetDefaultSource (iSource : SmallInt) : LongInt;
function GetDefaultSource (var iSource : SmallInt) : longint;

function GetPrinterList : string;
procedure SetDefaultPrinter (pName:string);

function GetPaperBinList: string;
function GetNamedPaperBinList: string;
function GetPaperSizeList: string ;

// paper Length
function GetPaperLength(var iPaperLength:smallint) :longint;
function SetPaperLength(iPaperLength:smallint) :longint;

// paper Width
function GetPaperWidth(var iPaperWidth:smallint) :longint;
function SetPaperWidth(iPaperWidth:smallint) :longint;

// Scale
function GetScale(var iScale:smallint) :longint;
function SetScale(iScale:smallint) :longint;

// Copies
function GetCopies(var iCopies:smallint) :longint;
function SetCopies(iCopies:smallint) :longint;

// dmPrintQuality
function GetPrintQuality(var iPrintQuality:smallint) :longint;
function SetPrintQuality(iPrintQuality:smallint) :longint;

// Color
function GetColor(var iColor:smallint) :longint;
function SetColor(iColor:smallint) :longint;

// Duplex
function GetDuplex(var iDuplex:smallint) :longint;
function SetDuplex(iDuplex:smallint) :longint;

// YResolution
function GetYResolution(var iYResolution:smallint) :longint;
function SetYResolution(iYResolution:smallint) :longint;

// TTOption
function GetTTOption(var iTTOption:smallint) :longint;
function SetTTOption(iTTOption:smallint) :longint;

// Collate
function GetCollate(var iCollate:smallint) :longint;
function SetCollate(iCollate:smallint) :longint;




Var
   hdl:longint;         { Class instance handle }
   Ret:LOngInt;         {return value}
implementation

uses
  SysUtils;

procedure CreatePowerPrinter;
begin
     // create PowerPrinter class
     hdl := CWin32Prn_CPP_CONSTRUCTOR ();
end;

procedure DestroyPowerPrinter;
begin
     // free memory
     CWin32Prn_CPP_DESTRUCTOR (hdl);
end;

function GetDefPrinterName : string;
var
   pDefaultPrinterName:pChar;
   pBuffer:array [0..256] of char;
begin
     pDefaultPrinterName := pBuffer;
     Ret := dwGetDefaultPrinterName(hdl, pDefaultPrinterName);

     { TODO: test Ret }

     GetDefPrinterName := StrPas(pDefaultPrinterName);
end;

function GetDefPrinterPort : string;
var
   pDefaultPrinterPort:pChar;
   pBuffer:array [0..256] of char;
begin
     pDefaultPrinterPort := pBuffer;
     Ret := dwGetDefaultPrinterPort(hdl, pDefaultPrinterPort);

     { TODO: test Ret }

     GetDefPrinterPort := StrPas(pDefaultPrinterPort);
end;

function GetDefPrinterDriver : string;
var
   pDefaultPrinterDriver:pChar;
   pBuffer:array [0..256] of char;
begin
     pDefaultPrinterDriver := pBuffer;
     Ret := dwGetDefaultPrinterDriver(hdl, pDefaultPrinterDriver);

     { TODO: test Ret }

     GetDefPrinterDriver := StrPas(pDefaultPrinterDriver);
end;

function GetPrinterOrientationString : string;
var
   iOrient : SmallInt;
   lError : LongInt;
   sOrient : string;
begin

        lError := dwGetPrinterOrientation(hdl, iOrient);

        if lError > 0 then
        begin
             case iOrient of
                  1: sOrient := 'Portrait';
                  2: sOrient := 'Landscape';
                  3: sOrient := 'Unknown';
             end;

        end
           else
               sOrient := 'Unable to Fetch Orientation';

        GetPrinterOrientationString := sOrient;
end;

function SetPrinterOrientation (iOrient : smallint) : LongInt;
begin
     SetPrinterOrientation := dwSetPrinterOrientation(hdl, iOrient)
end;

function GetPrinterList : string;
var
   iRet :LOngInt;
   pPrnList:pChar;
   pBuffer:array [0..2000] of char;

begin
     pPrnList := pBuffer;
     Ret := dwGetPrinterList (hdl, pPrnList);

     GetPrinterList := StrPas(pPrnList);
end;

procedure SetDefaultPrinter (pName:string);
var
   szPrinterName:pChar;
   tmpBuf: array [0..256] of char;
begin
     StrPCopy(tmpBuf, pName);
     szPrinterName := tmpBuf;
     dwSetDefaultPrinter (hdl, szPrinterName)
end;

procedure About;
begin
     dwAbout();
end;

function Unlock (RegUser:String; lKey:LOngInt):longint;
var
   szRegUser:pChar;
   tmpBuf: array [0..256] of char;
begin
     StrPCopy(tmpBuf, RegUser);
     szRegUser := tmpBuf;
     Unlock := dwUnlock (szRegUser, lKey);
end;

function GetPaperBinList: string;
var
   iRet :LongInt;
   pBinList:pChar;
   pBuffer:array [0..2000] of char;
begin
     pBinList := pBuffer;
     Ret := dwGetPaperBinList (hdl, pBinList);

     if Ret > 0 then
        GetPaperBinList := StrPas(pBinList)
     else
         GetPaperBinList := 'Could not fetch Paper Bin List';
end;

function GetNamedPaperBinList: string;
var
   iRet :LongInt;
   pBinList:pChar;
   pBuffer:array [0..4000] of char;
begin
     pBinList := pBuffer;
     Ret := dwGetNamedPaperBinList (hdl, pBinList);

     if Ret > 0 then
        GetNamedPaperBinList := StrPas(pBinList)
     else
         GetNamedPaperBinList := 'Could not fetch Named Paper Bin List';

end;

function GetPaperSizeList: string ;
var
   iRet :LongInt;
   pPaperSizeList:pChar;
   pBuffer:array [0..2000] of char;
begin
     pPaperSizeList := pBuffer;
     Ret := dwGetSupportedPaperSizeList (hdl, pPaperSizeList);

     if Ret > 0 then
         GetPaperSizeList := StrPas(pPaperSizeList)
     else
         GetPaperSizeList := 'Could not fetch Paper Size List';

end;

function SetPaperSize (iSize : SmallInt) : LongInt;
begin
     SetPaperSize := dwSetPaperSize (hdl, iSize);
end;

function GetPaperSize (var iSize:SmallInt) : longint;
begin
     GetPaperSize := dwGetPaperSize(hdl, iSize);
end;

function SetDefaultSource (iSource : SmallInt) : LongInt;
begin
     SetDefaultSource := dwSetDefaultSource(hdl, iSource);
end;

function GetDefaultSource (var iSource : SmallInt) : longint;
begin
     GetDefaultSource := dwGetDefaultSource(hdl, iSource);
end;

// paper Length
function GetPaperLength(var iPaperLength:smallint) :longint;
begin
     GetPaperLength := dwGetPaperLength(hdl, iPaperlength);
end;

function SetPaperLength(iPaperLength:smallint) :longint;
begin
     SetPaperLength := dwSetPaperLength(hdl, iPaperLength);
end;

// paper Width
function GetPaperWidth(var iPaperWidth:smallint) :longint;
begin
     GetPaperWidth := dwGetPaperWidth(hdl, iPaperWidth);
end;

function SetPaperWidth(iPaperWidth:smallint) :longint;
begin
     SetPaperWidth := dwSetPaperWidth(hdl, iPaperWidth);
end;

// Scale
function GetScale(var iScale:smallint) :longint;
begin
     getScale := dwgetScale(hdl, iScale);
end;

function SetScale(iScale:smallint) :longint;
begin
     SetScale := dwSetScale(hdl, iScale);
end;


// Copies
function GetCopies(var iCopies:smallint) :longint;
begin
     GetCopies := dwGetCopies(hdl, iCopies);
end;

function SetCopies(iCopies:smallint) :longint;
begin
     SetCopies := dwSetCopies(hdl, iCopies);
end;

// dmPrintQuality
function GetPrintQuality(var iPrintQuality:smallint) :longint;
begin
     GetPrintQuality := dwGetPrintQuality(hdl, iPrintQuality);
end;

function SetPrintQuality(iPrintQuality:smallint) :longint;
begin
     SetPrintQuality := dwSetPrintQuality(hdl, iPrintQuality);
end;

// Color
function GetColor(var iColor:smallint) :longint;
begin
     GetColor := dwGetColor(hdl, iColor);
end;

function SetColor(iColor:smallint) :longint;
begin
     SetColor := dwSetColor(hdl, iColor);
end;

// Duplex
function GetDuplex(var iDuplex:smallint) :longint;
begin
     GetDuplex := dwGetDuplex(hdl, iDuplex);
end;

function SetDuplex(iDuplex:smallint) :longint;
begin
     SetDuplex := dwSetDuplex(hdl, iDuplex);
end;

// YResolution
function GetYResolution(var iYResolution:smallint) :longint;
begin
     GetYResolution := dwGetYResolution(hdl,iYResolution);
end;

function SetYResolution(iYResolution:smallint) :longint;
begin
     SetYResolution := dwSetYResolution(hdl,iYResolution);
end;

// TTOption
function GetTTOption(var iTTOption:smallint) :longint;
begin
     GetTTOption := dwSetTTOption(hdl, iTTOption);
end;

function SetTTOption(iTTOption:smallint) :longint;
begin
     SetTTOption := dwSetTTOption(hdl, iTTOption);
end;

// Collate
function GetCollate(var iCollate:smallint) :longint;
begin
     GetCollate := dwGetCollate(hdl, iCollate);
end;

function SetCollate(iCollate:smallint) :longint;
begin
     SetCollate := dwSetCollate(hdl, iCollate);
end;

end.
