VERSION 4.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Form1"
   ClientHeight    =   5760
   ClientLeft      =   1095
   ClientTop       =   1680
   ClientWidth     =   7965
   Height          =   6165
   Left            =   1035
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5760
   ScaleWidth      =   7965
   ShowInTaskbar   =   0   'False
   Top             =   1335
   Width           =   8085
   Begin VB.TextBox eKey 
      Height          =   285
      Left            =   4320
      TabIndex        =   24
      Top             =   5280
      Width           =   1935
   End
   Begin VB.TextBox eUserName 
      Height          =   285
      Left            =   4320
      TabIndex        =   23
      Top             =   4920
      Width           =   1935
   End
   Begin VB.CommandButton cmdUnlock 
      Caption         =   "Unlock"
      Height          =   495
      Left            =   1800
      TabIndex        =   20
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdAbout 
      Caption         =   "About"
      Height          =   495
      Left            =   360
      TabIndex        =   19
      Top             =   4920
      Width           =   1215
   End
   Begin VB.TextBox tb_port 
      Enabled         =   0   'False
      Height          =   285
      Left            =   5760
      TabIndex        =   7
      Text            =   "Text1"
      Top             =   360
      Width           =   1935
   End
   Begin VB.TextBox tb_driver 
      Enabled         =   0   'False
      Height          =   285
      Left            =   3600
      TabIndex        =   5
      Text            =   "Text1"
      Top             =   360
      Width           =   1815
   End
   Begin VB.TextBox tb_prnname 
      Enabled         =   0   'False
      Height          =   285
      Left            =   240
      TabIndex        =   3
      Text            =   "Text1"
      Top             =   360
      Width           =   2295
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Bye"
      Height          =   495
      Left            =   6480
      TabIndex        =   0
      Top             =   4920
      Width           =   1215
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   3975
      Left            =   240
      TabIndex        =   1
      Top             =   840
      Width           =   7455
      _Version        =   65536
      _ExtentX        =   13150
      _ExtentY        =   7011
      _StockProps     =   15
      Caption         =   "Printer List"
      TabsPerRow      =   4
      Tab             =   1
      TabOrientation  =   0
      Tabs            =   4
      Style           =   0
      TabMaxWidth     =   0
      TabHeight       =   529
      TabCaption(0)   =   "Orientation"
      Tab(0).ControlCount=   4
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "btn_setportrait"
      Tab(0).Control(1)=   "btn_setlandscape"
      Tab(0).Control(2)=   "lbl_orientation"
      Tab(0).Control(3)=   "Label4"
      TabCaption(1)   =   "Printer List"
      Tab(1).ControlCount=   4
      Tab(1).ControlEnabled=   -1  'True
      Tab(1).Control(0)=   "Label5"
      Tab(1).Control(1)=   "Label6"
      Tab(1).Control(2)=   "lb_printerlist"
      Tab(1).Control(3)=   "btn_getprnlist"
      TabCaption(2)   =   "PaperBin"
      Tab(2).ControlCount=   6
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "cmdGetList"
      Tab(2).Control(1)=   "cmdGetBin"
      Tab(2).Control(2)=   "cmdSetBin"
      Tab(2).Control(3)=   "lb_Bins"
      Tab(2).Control(4)=   "optDefault"
      Tab(2).Control(5)=   "optNamed"
      TabCaption(3)   =   "Paper Size"
      Tab(3).ControlCount=   4
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "lb_papersize"
      Tab(3).Control(1)=   "cmdGetPaperSizeList"
      Tab(3).Control(2)=   "cmdGetPaperSize"
      Tab(3).Control(3)=   "cmdSetPaperSize"
      Begin VB.CommandButton cmdSetPaperSize 
         Caption         =   "Set Paper Size"
         Height          =   495
         Left            =   -69840
         TabIndex        =   31
         Top             =   2280
         Width           =   1575
      End
      Begin VB.CommandButton cmdGetPaperSize 
         Caption         =   "Get Paper Size"
         Height          =   495
         Left            =   -69840
         TabIndex        =   30
         Top             =   1560
         Width           =   1575
      End
      Begin VB.CommandButton cmdGetPaperSizeList 
         Caption         =   "Get List"
         Height          =   495
         Left            =   -69840
         TabIndex        =   29
         Top             =   840
         Width           =   1575
      End
      Begin VB.ListBox lb_papersize 
         Height          =   2565
         Left            =   -74520
         TabIndex        =   28
         Top             =   720
         Width           =   3855
      End
      Begin VB.OptionButton optNamed 
         Caption         =   "Named"
         Height          =   255
         Left            =   -72960
         TabIndex        =   27
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton optDefault 
         Caption         =   "Default"
         Height          =   255
         Left            =   -74520
         TabIndex        =   26
         Top             =   600
         Value           =   -1  'True
         Width           =   1215
      End
      Begin VB.ListBox lb_Bins 
         Height          =   2370
         Left            =   -74760
         TabIndex        =   25
         Top             =   960
         Width           =   5295
      End
      Begin VB.CommandButton cmdSetBin 
         Caption         =   "Set Bin"
         Height          =   495
         Left            =   -69240
         TabIndex        =   18
         Top             =   2160
         Width           =   1335
      End
      Begin VB.CommandButton cmdGetBin 
         Caption         =   "Get Bin"
         Height          =   495
         Left            =   -69240
         TabIndex        =   17
         Top             =   1560
         Width           =   1335
      End
      Begin VB.CommandButton cmdGetList 
         Caption         =   "Get List"
         Height          =   495
         Left            =   -69240
         TabIndex        =   16
         Top             =   960
         Width           =   1335
      End
      Begin VB.CommandButton btn_getprnlist 
         Caption         =   "Get It"
         Height          =   495
         Left            =   3240
         TabIndex        =   13
         Top             =   1080
         Width           =   1215
      End
      Begin VB.ListBox lb_printerlist 
         Height          =   2175
         Left            =   480
         TabIndex        =   12
         Top             =   1080
         Width           =   2535
      End
      Begin VB.CommandButton btn_setportrait 
         Caption         =   "Set as Portrait"
         Height          =   495
         Left            =   -72360
         TabIndex        =   11
         Top             =   3120
         Width           =   1935
      End
      Begin VB.CommandButton btn_setlandscape 
         Caption         =   "Set As Landscape"
         Height          =   495
         Left            =   -74760
         TabIndex        =   10
         Top             =   3120
         Width           =   2175
      End
      Begin VB.Label Label6 
         Caption         =   "Double click on a printer to set it as default"
         Height          =   255
         Left            =   480
         TabIndex        =   15
         Top             =   3360
         Width           =   5295
      End
      Begin VB.Label Label5 
         Caption         =   "Printer List:"
         Height          =   255
         Left            =   480
         TabIndex        =   14
         Top             =   720
         Width           =   2535
      End
      Begin VB.Label lbl_orientation 
         Caption         =   "lbl_orientation"
         Height          =   255
         Left            =   -73440
         TabIndex        =   9
         Top             =   720
         Width           =   3495
      End
      Begin VB.Label Label4 
         Caption         =   "Orientation:"
         Height          =   255
         Left            =   -74640
         TabIndex        =   8
         Top             =   720
         Width           =   975
      End
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "Key:"
      Height          =   255
      Left            =   3240
      TabIndex        =   22
      Top             =   5280
      Width           =   975
   End
   Begin VB.Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "User Name:"
      Height          =   255
      Left            =   3240
      TabIndex        =   21
      Top             =   4920
      Width           =   975
   End
   Begin VB.Label Label3 
      Caption         =   "Port:"
      Height          =   255
      Left            =   5760
      TabIndex        =   6
      Top             =   120
      Width           =   1815
   End
   Begin VB.Label Label2 
      Caption         =   "Printer Driver:"
      Height          =   255
      Left            =   3600
      TabIndex        =   4
      Top             =   120
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "Default Printer Name:"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1815
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim iPowerPrn As New PowerPrn

Private Sub btn_getprnlist_Click()

    Dim PrnList As String
    Dim PrnName As String
    Dim i, iPOs As Integer
    Dim lRet As Long
        
    Screen.MousePointer = 11
    
    lb_printerlist.Clear
     
    lRet = iPowerPrn.GetPrinterList(PrnList)
    
    If lRet > 0 Then
        ' printers are separated by semicolumn
        iPOs = InStr(PrnList, ";")
        While iPOs > 0
            ' get name
            PrnName = Left(PrnList, iPOs - 1)
            ' add it to the list box
            lb_printerlist.AddItem PrnName
            ' get next one
            PrnList = Right(PrnList, Len(PrnList) - iPOs)
            iPOs = InStr(PrnList, ";")
        Wend
    Else
        MsgBox ("Cannot get printer list")
    End If
    
    Screen.MousePointer = 0
End Sub


Private Sub btn_setlandscape_Click()
    Dim PrnOrient As String
    Dim iRet As Long
    
    Screen.MousePointer = 11    ' Change mouse pointer to hourglass.
    
    iRet = iPowerPrn.SetPrinterOrientation(DMORIENT_LANDSCAPE)
   
    If iRet > 0 Then
        iRet = iPowerPrn.GetPrinterOrientationString(PrnOrient)
        lbl_orientation.Caption = PrnOrient
    End If
    
    Screen.MousePointer = 0 ' Return mouse pointer to normal.

End Sub


Private Sub btn_setportrait_Click()
    Dim iRet As Long
    Dim PrnOrient As String
    
    Screen.MousePointer = 11    ' Change mouse pointer to hourglass.
        
    iRet = iPowerPrn.SetPrinterOrientation(DMORIENT_PORTRAIT)

    If iRet > 0 Then    ' update display
        iRet = iPowerPrn.GetPrinterOrientationString(PrnOrient)
        lbl_orientation.Caption = PrnOrient
    End If

    Screen.MousePointer = 0 ' Return mouse pointer to normal.

End Sub

Private Sub cmdAbout_Click()
    iPowerPrn.About
End Sub

Private Sub cmdGetBin_Click()

    Dim iSource As Integer
    Dim ret As Long
    
    Screen.MousePointer = 11
    
    ret = iPowerPrn.GetPaperSource(iSource)
    
    Screen.MousePointer = 0
    
    If ret > 0 Then
    
        MsgBox ("Paper Bin: " + Str(iSource))
    Else
        MsgBox ("Coud not fetch Paper Bin")
    End If

End Sub

Private Sub cmdGetList_Click()

    Dim lsBinList, lsBinName As String
    Dim iPOs As Integer
    
    lb_Bins.Clear
    
    If optDefault.Value = True Then
        lsBinList = iPowerPrn.GetPaperBinList()
    Else
        lsBinList = iPowerPrn.GetNamedPaperBinList()
    End If
    
    iPOs = InStr(lsBinList, ";")
    
    While iPOs > 0
         ' get name
         lsBinName = Left(lsBinList, iPOs - 1)
         
         ' add it to the list box
         lb_Bins.AddItem lsBinName
         
         ' get next one
         lsBinList = Right(lsBinList, Len(lsBinList) - iPOs)
        iPOs = InStr(lsBinList, ";")
        Wend
    
End Sub

Private Sub cmdGetPaperSize_Click()
    Dim iSize As Integer
    Dim ret As Long
    
    Screen.MousePointer = 11
    
    ret = iPowerPrn.GetPaperSize(iSize)
    
    Screen.MousePointer = 0
    
    If ret > 0 Then
    
        MsgBox ("Paper Size: " + Str(iSize))
    Else
        MsgBox ("Coud not fetch Paper Size")
    End If
End Sub

Private Sub cmdGetPaperSizeList_Click()
    Dim lsPaperSizeList, lsPaperName As String
    Dim iPOs As Integer
    
    lb_papersize.Clear
    
    lsPaperSizeList = iPowerPrn.GetPaperSizeList()
    
    iPOs = InStr(lsPaperSizeList, ";")
    
    While iPOs > 0
         ' get name
         lsPaperName = Left(lsPaperSizeList, iPOs - 1)
         
         ' add it to the list box
         lb_papersize.AddItem lsPaperName
         
         ' get next one
         lsPaperSizeList = Right(lsPaperSizeList, Len(lsPaperSizeList) - iPOs)
        iPOs = InStr(lsPaperSizeList, ";")
        Wend
    
End Sub

Private Sub cmdSetBin_Click()

    Dim iSource As Integer
    Dim sBin As String
    
    Screen.MousePointer = 11
    
    If lb_Bins.ListCount() > 0 Then
    
        sBin = lb_Bins.List(lb_Bins.ListIndex)
        
        If sBin <> "" Then
            iSource = CInt(Left(sBin, InStr(sBin, " ")))
            
            
            If iPowerPrn.SetDefaultSource(iSource) > 0 Then
                MsgBox ("Set Paper Bin succeeded")
            Else
                MsgBox ("Set Paper Bin failed")
            End If
        Else
            MsgBox ("No Paper Bin to choose from. Please select one")
        End If
    Else
        MsgBox ("No Paper Bin to choose from")
    End If
    
    Screen.MousePointer = 0
    
End Sub

Private Sub cmdSetPaperSize_Click()
    
    Dim iSize As Integer
    Dim sSize As String
    
    Screen.MousePointer = 11
    
    If lb_papersize.ListCount() > 0 Then
    
        sSize = lb_papersize.List(lb_papersize.ListIndex)
        
        If sSize <> "" Then
            iSize = CInt(Left(sSize, InStr(sSize, " ")))
                        
            If iPowerPrn.SetPaperSize(iSize) > 0 Then
                MsgBox ("Set Paper Size succeeded")
            Else
                MsgBox ("Set Paper Size failed")
            End If
        Else
            MsgBox ("No Paper Size to choose from. Please select one")
        End If
    Else
        MsgBox ("No Paper Size to choose from")
    End If
    
    Screen.MousePointer = 0
End Sub

Private Sub cmdUnlock_Click()

    Dim RegUser As String
    Dim lKey As Long
    Dim ret As Long
    
    RegUser = eUserName.Text

    If eKey.Text <> "" And IsNumeric(eKey.Text) Then
        lKey = CLng(eKey.Text)

        ret = iPowerPrn.UnlockDLL(RegUser, lKey)
    Else
        MsgBox ("Please provide a numeric key")
    End If
End Sub

Private Sub Command1_Click()
    Unload Me
    End
End Sub






Private Sub Form_Load()
  
    Dim iOrient As Integer
    Dim lRet As Long
    
    ' get default printer attributes
    tb_prnname.Text = iPowerPrn.GetDefaultPrinterName()
    tb_driver.Text = iPowerPrn.GetDefaultPrinterDriver()
    tb_port.Text = iPowerPrn.GetDefaultPrinterPort()
    
    ' orientation
    ' get as integer
    lRet = iPowerPrn.GetPrinterOrientation(iOrient)
    If lRet > 0 Then
        lbl_orientation.Caption = CStr(iOrient)
    Else
        lbl_orientation.Caption = "Cannot get Printer Orientation"
    End If

    ' now get it as a string and override previous operation
    ' this not needed: just show both techniques
    Dim PrnOrient As String
    lRet = iPowerPrn.GetPrinterOrientationString(PrnOrient)
    
    lbl_orientation.Caption = PrnOrient
End Sub


Private Sub lb_printerlist_DblClick()
    
    Dim Ind As Integer
    Dim lRet As Long
    Dim DefPrinter As String
    
    Screen.MousePointer = 11    ' Change mouse pointer to hourglass
    

    Ind = lb_printerlist.ListIndex                   ' Get index.
    If Ind >= 0 Then                                ' Make sure a list item is selected.
        DefPrinter = lb_printerlist.List(Ind)
        lRet = iPowerPrn.SetDefaultPrinter(DefPrinter)
        If lRet > 0 Then
            ' update display
            tb_prnname.Text = iPowerPrn.GetDefaultPrinterName()
            tb_driver.Text = iPowerPrn.GetDefaultPrinterDriver()
            tb_port.Text = iPowerPrn.GetDefaultPrinterPort()
        Else
            MsgBox ("Could not set default printer")
        End If
    End If
    
    Screen.MousePointer = 0    ' Change mouse pointer to default
End Sub


Private Sub Option1_Click()

End Sub


Private Sub optDefault_Click()
    cmdGetList_Click
End Sub


Private Sub optNamed_Click()
    cmdGetList_Click
End Sub


