unit Fdemo01;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, PrnWin, CB_Types, Printers, CB_MFunc,
  ExtCtrls, CBPanel;

type
  TForm01 = class(TForm)
    Memo1: TMemo;
    CBPanel1: TCBPanel;
    Memo2: TMemo;
    View: TBitBtn;
    Exit: TBitBtn;
    PrintWin1: TPrintWin;
    procedure ViewClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
  private
    { Private declarations }
  public
		procedure DrawIt( FontName: string; x: Real; y: Real );
  end;

var
  Form01: TForm01;

implementation

{$R *.DFM}

procedure TForm01.ViewClick(Sender: TObject);
begin
	PrintWin1.HeaderStringCenter := Printer.Printers[Printer.PrinterIndex];
	PrintWin1.HeaderStringRight := 'Font Test';
	PrintWin1.BeginPrint;


   DrawIt ('Arial', 0.25, 1.0);
   DrawIt ('Times New Roman', 0.25, 3.0);
   DrawIt ('Courier New', 0.25, 5.0);

   PrintWin1.NewFont ('Courier New',12,True,True,False);

	Memo1.Visible := True;
   PrintWin1.DrawWindow(7,poCenter,Memo1);
   Memo1.Visible := False;
	PrintWin1.EndPrint;
end;

procedure TForm01.DrawIt( FontName: string; x: Real; y: Real );
var
	i: Integer;
	Width: Real;
   Height: Real;
   str: string;
   Name: string;
begin
   PrintWin1.NewFont (FontName,18,True,True,False);

   PrintWin1.DrawText( y ,poCenter, FontName);

   Name := 'Test String';
   Width := PrintWin1.GetTextWidth(Name);
   Height := PrintWin1.GetTextHeight(Name);
   PrintWin1.NewFont (FontName,12,True,True,False);

   for i := 0 to 5 do begin
      str := '('+FloatToStrF(Width,ffFixed,5,2)+','+FloatToStrF(Height,ffFixed,5,2)+')';
      PrintWin1.DrawTextAt( x, y - Height, str);
      PrintWin1.DrawRectAt( x, y, x+Width, y+Height);
      PrintWin1.DrawTextAt( x,y,Name);
      x := x + Width;
      y := y + Height;

      PrintWin1.NewFont (FontName,12+((i+1)*4),True,True,False);
   	Width := PrintWin1.GetTextWidth(Name);
   	Height := PrintWin1.GetTextHeight(Name);

   end;
end;

procedure TForm01.ExitClick(Sender: TObject);
begin
	Close;
end;


end.
