unit Fdemo15;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, PrnWin, ExtCtrls, DBTables, DB, Printers, DBCtrls, CB_Types,
  Grids, DBGrids, DBPrnWin, CB_MFunc;

type
  TForm15 = class(TForm)
    Bevel1: TBevel;
    Memo1: TMemo;
    Table1: TTable;
    Table2: TTable;
    Query1: TQuery;
    Query2: TQuery;
    Query3: TQuery;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DataSource3: TDataSource;
    DataSource4: TDataSource;
    DataSource5: TDataSource;
    Query1SpeciesNo: TFloatField;
    Query1Category: TStringField;
    Query1Common_Name: TStringField;
    Table1NAME: TStringField;
    Table1SIZE: TSmallintField;
    Table1WEIGHT: TSmallintField;
    Table1AREA: TStringField;
    Query2Name: TStringField;
    Query2Capital: TStringField;
    Query2Continent: TStringField;
    Query2Population: TFloatField;
    Query3Company: TStringField;
    Query3Phone: TStringField;
    Query3LastInvoiceDate: TDateTimeField;
    Preview: TBitBtn;
    Exit: TBitBtn;
    Table2IND_CODE: TSmallintField;
    Table2IND_NAME: TStringField;
    Table2LONG_NAME: TStringField;
    Table1BMP: TBlobField;
    DBImage1: TDBImage;
    DBImage2: TDBImage;
    Query1Graphic: TGraphicField;
    DBGrid1: TDBGrid;
    DBPrintWin1: TDBPrintWin;
    procedure PreviewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form15: TForm15;

implementation

{$R *.DFM}

procedure TForm15.PreviewClick(Sender: TObject);
var
	i: Integer;
   Right, Bottom, Top: Real;
begin
   DBPrintWin1.BeginPrint;
   DBGrid1.Visible := True;

   { This will take a bit of programming! }

   { Set a nice big font }
   DBPrintWin1.NewFont ('Arial',20,True,True,True); { The 3 True's are for Bold,
                                                   Italic and Underline }

   { And change the color to Red }
   DBPrintWin1.SetTheTextColor (RGB(255,0,0));

   { Draw the text in the Center of the page }
   DBPrintWin1.DrawText( 1.0,poCenter,'A 3-Page Demo for TPrintWin');

   { Draw the first table }
   DBPrintWin1.NewFont ('Arial',14,False,False,True);
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawText( 2.0,poLeft,'Here is a list of animals from Table1');
   DBPrintWin1.DrawWindow( 2.3, poLeft, DBGrid1);


   { Draw the 2nd table }
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawText( 4.6,poLeft,'Here is another Table');
   DBPrintWin1.DrawWindow( 5.0, poLeft, DBGrid1);

   { Draw the 2nd table again}
   DBPrintWin1.SetTheTextColor (RGB(0,0,0));
   DBPrintWin1.DrawText( 2.0,poRight,'Repeating Table2');
   DBPrintWin1.DrawWindow( 2.3, poRight, DBGrid1);

   { And the 1st Query }
   DBPrintWin1.SetTheTextColor (RGB(0,255,0));
   DBPrintWin1.DrawText( 4.6,poRight,'Here is a Query');
   DBPrintWin1.DrawWindow( 5.0, poRight, DBGrid1);

   { And Draw some lines in different colors, added some Printer info }
   Bottom := DBPrintWin1.PageHeight - 1;
   Top := Bottom - 1.5;
   Right := 1.01;
   for i := 0 to 30 do begin
   	if i mod 3 = 0 then
   		DBPrintWin1.SelectPen(1, RGB(255,0,0));
   	if i mod 3 = 1 then
   		DBPrintWin1.SelectPen(1, RGB(0,255,0));
   	if i mod 3 = 2 then
   		DBPrintWin1.SelectPen(1, RGB(0,0,255));

      DBPrintWin1.DrawLine( 0.5, Top, Right, Bottom);
      Top := Top + 0.03;
      Right := Right + 0.07;
      Bottom := Bottom - 0.03;

      DBPrintWin1.DrawLine( 0.5, Bottom, Right, Top);
   end;

   { And Frame them nicely }
   Bottom := DBPrintWin1.PageHeight - 1;
   Top := Bottom - 1.5;
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawText(Top - 0.3,poLeft,'Draw a few lines');
   DBPrintWin1.DrawLine(0.5,Top,Right,Top);
   DBPrintWin1.DrawLine(0.5,Bottom,Right,Bottom);
   DBPrintWin1.DrawLine(0.5,Top,0.5,Bottom);
   DBPrintWin1.DrawLine(Right,Top,Right,Bottom);

   { Print a Bitmap }
   DBPrintWin1.DrawText(Top - 0.3,poRight,'Draw an Image');
   DBPrintWin1.PrintBitmap(DBPrintWin1.PageWidth -2.5,Top,2,2,DBImage1.Picture.Bitmap);

   { Now we switch the header on again }
   DBPrintWin1.HeaderEnabled := True;
   DBPrintWin1.HeaderFilled := True;
   DBPrintWin1.HeaderOutlined := True;
   DBPrintWin1.HeaderStringCenter := 'Ah, Now we have a header again';

   { And go on to the second page }
   DBPrintWin1.NewPage;

   { Draw the text in the Center of the 2nd page }
   DBPrintWin1.NewFont ('Arial',20,True,True,True);
   DBPrintWin1.DrawText( 1.6,poCenter,'2nd Page of a 3-Page Demo for TPrintWin');

   { Draw the 2nd Query }
   DBPrintWin1.NewFont ('Arial',14,False,False,True);
   DBPrintWin1.SetTheTextColor (RGB(0,0,255));
   DBPrintWin1.DrawText( 2.3,poCenter,'Name some countries in North America');
   DBPrintWin1.DrawText( 2.6,poCenter,'and keep to the Center');
   DBGrid1.Datasource := Datasource2;
   DBPrintWin1.DrawWindow( 3, poCenter, DBGrid1);

{   PrintWin1.DrawQuery( 3, poCenter, Query2, False, False);}

   { Draw the 2nd Query }
   DBPrintWin1.NewFont ('Arial',14,True,False,True);
   DBPrintWin1.SetTheTextColor (RGB(255,0,0));
   DBPrintWin1.DrawText( 5.6,poCenter,'And now I have to make some phone calls');
   DBPrintWin1.DrawText( 6,poCenter,'and keep to the Center');
   DBGrid1.Visible := True;
   DBPrintWin1.SetColumnWidth(DBGrid1, 'NAME', 1.0);
   DBPrintWin1.SetColumnWidth(DBGrid1, 'WEIGHT', 2.0);
   DBPrintWin1.DrawWindow( 6.3, poCenter, DBGrid1);
   Table1.First;


   { and Maybe just add a single Record from the phone calls query }
   DBPrintWin1.NewFont ('Arial',14,True,False,True);
   DBPrintWin1.SetTheTextColor (RGB(0,0,0));
   DBPrintWin1.DrawText( 8,poLeft,'And now for a single record');
   DBPrintWin1.NewFont ('Arial',14,False,True,False);
   DBPrintWin1.DrawQueryRecord( 1, 8.3, Query3);

   { And go on to the 3rd page }
   DBPrintWin1.NewPage;

   { Here we need a heading }
   DBPrintWin1.NewFont ('Arial',20,True,True,True);
   DBPrintWin1.DrawText( 1.6,poCenter,'3rd Page of a 3-Page Demo for TPrintWin');

   { Now we need an image, We might as well use some animals from
     table1
     Note: The DBImage component is used to extract the bitmap and
     TPrintWin Prints it}

   { First draw a grid }
   DBPrintWin1.NewFont ('Arial',14,True,False,False);
   DBPrintWin1.DrawGrid(0.5,2.3,2.3,2.3,3,3);
   for i := 0 to 2 do begin
     DBPrintWin1.DrawTextAt( 0.8,2.4+(2.3*i),Table1Name.AsString);
     DBPrintWin1.PrintBitmap(0.8,2.8+(2.3*i),1.6,1.6,DBImage1.Picture.Bitmap);
     Table1.Next;

     { There are only 7 images in the table, so return }
     if i < 2 then begin
        DBPrintWin1.DrawTextAt( 3.1,2.4+(2.3*i),Table1Name.AsString);
        DBPrintWin1.PrintBitmap(3.1,2.8+(2.3*i),1.6,1.6,DBImage1.Picture.Bitmap);
        Table1.Next;
        DBPrintWin1.DrawTextAt( 5.4,2.4+(2.3*i),Table1Name.AsString);
        DBPrintWin1.PrintBitmap(5.4,2.8+(2.3*i),1.6,1.6,DBImage1.Picture.Bitmap);
        Table1.Next;
     end;
   end;


   DBPrintWin1.EndPrint;
end;

end.
