unit Repdem03;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Buttons, DBTables, Grids,
  ExtCtrls, Printers, PrnGridR,  CB_Types, CB_MFunc, CBPanel;

type
  Tdem03form = class(TForm)
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Query1: TQuery;
    Query1PartNo: TFloatField;
    Query1VendorNo: TFloatField;
    Query1Description: TStringField;
    Query1OnHand: TFloatField;
    Query1OnOrder: TFloatField;
    Query1Cost: TCurrencyField;
    Query1ListPrice: TCurrencyField;
    Query1OnOrderValue: TCurrencyField;
    Query1OnHandValue: TCurrencyField;
    PrintGridReport1: TPrintGridReport;
    CBPanel1: TCBPanel;
    Label2: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    Preview: TBitBtn;
    Exit: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure Query1CalcFields(DataSet: TDataset);
  private
    { private declarations }
  public
  end;

var
  dem03form: Tdem03form;

implementation

{$R *.DFM}

procedure Tdem03form.FormCreate(Sender: TObject);
begin
  Query1.Open;

  { SubTotals will be on field VenderNo}
  PrintGridReport1.SetSubTotalField(1, 'VendorNo','Vendor Number');

  { Do not total next 4 fields, but do all the rest  }
  PrintGridReport1.SetPrintTotal('PartNo', False);
  PrintGridReport1.SetPrintTotal('Cost', False);
  PrintGridReport1.SetPrintTotal('ListPrice', False);
  PrintGridReport1.SetPrintTotal('VenderNo', False);
end;                                                           

procedure Tdem03form.PreviewClick(Sender: TObject);
begin
	Query1.DisableControls;

	{ Force Orientation to Landscape }
	PrintGridReport1.Orientation := poLandscape;

   { and send query for preview }
	PrintGridReport1.Execute;
	Printer.Orientation := poPortrait;
   Query1.EnableControls;
end;


procedure Tdem03form.Query1CalcFields(DataSet: TDataset);
begin
	Query1OnOrderValue.Value := Query1OnOrder.Value*Query1Cost.Value;
  Query1OnHandValue.Value := Query1Cost.Value*Query1OnHand.Value;
 end;



end.