unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Printers, StdCtrls, Buttons, winSpool, iniFiles, Menus, about;

type
  TsetDefaultPrinterDlg = class(TForm)
    GroupBox1: TGroupBox;
    currentPrinter: TEdit;
    Label1: TLabel;
    printersLB: TListBox;
    closeBtn: TBitBtn;
    setDefaultBtn: TBitBtn;
    MainMenu1: TMainMenu;
    AboutMenuItem: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure setDefaultBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure AboutMenuItemClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  setDefaultPrinterDlg: TsetDefaultPrinterDlg;
  winIniFile          : tIniFile;

implementation

{$R *.DFM}

procedure TsetDefaultPrinterDlg.FormShow(Sender: TObject);
begin
  {* Populate the list of printers ListBox ************************************}
  winIniFile.readSection('devices', printersLB.Items);

  {* Show the current Printer! ************************************************}
  currentPrinter.text := winIniFile.readString('windows', 'device', 'None Selected');
end;

procedure TsetDefaultPrinterDlg.setDefaultBtnClick(Sender: TObject);
var
  PrinterName  : array [0..255] of Char;
  phPrinter    : tHandle;  {* Handle to the selected printer ******************}
  lpbPrinter   : PPrinterInfo5;     {* Requires "winSpool" unit ***************}
  port         : string;
  aPort        : array[0..255] of char;
begin
  {* If there is a selected printer, continue *********************************}
  if (printersLB.itemIndex = -1) then exit; {* stop procedure NOW! ************}

  {* Prepare to set the printer ***********************************************}
  strPCopy(PrinterName, printersLB.items[printersLB.itemIndex]);
  {* The "openPrinter" procedure returns a handle to the printer you want to
     set as the default *******************************************************}
  if (openPrinter(PrinterName, phPrinter, nil)) then begin
     {* Set the default printer ***********************************************}
     messageDlg('Printer context opened', mtInformation, [mbOK], 0);
     {* Figure out the current port *******************************************
        Note: You could get this information from the registry, but Windows 95
        keeps the same information up-to-date in the Win.Ini file *************}
     port := winIniFile.readString('devices', printersLB.items[printersLB.itemIndex], 'LPT1:');
     port := copy(port, pos(',', port) + 1, length(port));
     strPCopy(aPort, port);
     {* Set up the printer name, port, and default attributes *****************}
     lpbPrinter.pPrinterName := PrinterName; {* One selected by user **********}
     lpbPrinter.pPortName    := aPort; {* From WIN.INI File *******************}
     lpbPrinter.Attributes   := PRINTER_ATTRIBUTE_DEFAULT; {* Microsoft says so}
     {* This actually sets the printer ****************************************}
     setPrinter(phPrinter, 5, lpbPrinter, 0);
  end else messageDlg('Printer context not opened', mtError, [mbOK], 0);
  {* Update the dialog with the currently selected printer ********************}
  currentPrinter.text := winIniFile.readString('windows', 'device', 'None Selected');
end;

procedure TsetDefaultPrinterDlg.FormCreate(Sender: TObject);
begin
  winIniFile := tIniFile.create('win.ini'); {* Connect to WIN.INI File ********}
end;

procedure TsetDefaultPrinterDlg.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  winIniFile.free; {* Release WIN.INI file ************************************}
end;

procedure TsetDefaultPrinterDlg.AboutMenuItemClick(Sender: TObject);
var
  aDialog : TAboutBox;
begin
  {* Menu Item: Shows the about box *******************************************}
  aDialog := TAboutBox.create(self);
  aDialog.showModal;
  aDialog.free;
end;

end.
