unit Demo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, Buttons, DB, DBTables, Mask, DBCtrls,
  Dialogs, Slrquery, Slrtable;

type
  TForm1 = class(TForm)
    PlotButton: TBitBtn;
    BitBtn2: TBitBtn;
    LoadButton: TBitBtn;
    RunButton: TBitBtn;
    FittedLabel: TLabel;
    TableDataSet: TRadioGroup;
    Panel1: TPanel;
    CountLabel: TLabel;
    xBarLabel: TLabel;
    yBarLabel: TLabel;
    RSquaredLabel: TLabel;
    minYLabel: TLabel;
    maxYLabel: TLabel;
    minXLabel: TLabel;
    maxXLabel: TLabel;
    syxLabel: TLabel;
    tStatistic: TLabel;
    dofLabel: TLabel;
    TStatisticTable: TTable;
    TStatisticDataSource: TDataSource;
    TStatisticTableFloatField90PercentConfidence: TFloatField;
    TStatisticTableFloatField95PercentConfidence: TFloatField;
    TStatisticTableFloatField99PercentConfidence: TFloatField;
    TValueLabel: TLabel;
    ConfidenceLevelGroup: TRadioGroup;
    TStatisticTableDegreesofFreedom: TFloatField;
    Panel2: TPanel;
    xInput: TEdit;
    yOutput: TEdit;
    InputLabel: TLabel;
    OutputLabel: TLabel;
    SLRTable1: TSLRTable;
    SLRTable2: TSLRTable;
    RegSummaryLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    SLRQuery1: TSLRQuery;
    QryDataSet: TRadioGroup;
    SLRQuery2: TSLRQuery;
    procedure PlotButtonClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure RunButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ConfidenceLevelGroupClick(Sender: TObject);
    procedure xInputChange(Sender: TObject);
    procedure QryDataSetClick(Sender: TObject);
    procedure TableDataSetClick(Sender: TObject);
    procedure TableRegression;
    procedure QueryRegression;
  end;

var
  Form1: TForm1;
  SLRTableChosen: TSLRTable;
  SLRQueryChosen: TSLRQuery;

implementation

{$R *.DFM}

procedure TForm1.PlotButtonClick(Sender: TObject);
var i:integer;
begin
 if (RegSummaryLabel.Tag = 0) then
  SLRTableChosen.ShowPlots
 else
  SLRQueryChosen.ShowPlots
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
 close
end;

procedure TForm1.LoadButtonClick(Sender: TObject);
begin
 if (RegSummaryLabel.Tag = 0) then
  with SLRTableChosen do
   begin
    LoadValues;
    CountLabel.Caption := intToStr(n)+' Data Points';
    dofLabel.Caption := intToStr(DegreesOfFreedom)+' Degrees of Freedom';
   end
 else
  with SLRQueryChosen do
   begin
    LoadValues;
    CountLabel.Caption := intToStr(n)+' Data Points';
    dofLabel.Caption := intToStr(DegreesOfFreedom)+' Degrees of Freedom';
   end;
 PlotButton.Enabled := True
end;

procedure TForm1.QueryRegression;
begin
 with SLRQueryChosen do
  begin
   Form1.Caption := 'Regression of '+ResponseVarField+' on '+ControlVarField;
   InputLabel.Caption := ControlVarField;
   OutputLabel.Caption := ResponseVarField;
   xBarLabel.Caption := 'Avg '+ControlVarField+' = '+floatToStrF(xBar,ffFixed,7,4);
   yBarLabel.Caption := 'Avg '+ResponseVarField+' = '+floatToStrF(yBar,ffFixed,7,4);
   RSquaredLabel.Caption := 'R^2 = '+floatToStrF(RSquared,ffFixed,7,4);
   maxYLabel.Caption := 'Max '+ResponseVarField+' = '+floatToStrF(yMax,ffFixed,7,4);
   minYLabel.Caption := 'Min '+ResponseVarField+' = '+floatToStrF(yMin,ffFixed,7,4);
   maxXLabel.Caption := 'Max '+ControlVarField+' = '+floatToStrF(xMax,ffFixed,7,4);
   minXLabel.Caption := 'Min'+ControlVarField+' = '+floatToStrF(xMin,ffFixed,7,4);
   syxLabel.Caption := 's'+ResponseVarField+'|'+ControlVarField+' = '+floatToStrF(syx,ffFixed,7,4);
   FittedLabel.Caption := ResponseVarField+' = '+floatToStrF(b0,ffFixed,7,4)+' + '
                                +floatToStrF(b1,ffFixed,7,4)+ControlVarField;
   yOutput.Text := floatToStr(Predict(strToFloat(xInput.Text)));
   TStatisticTable.FindKey([DegreesOfFreedom]);
   if (ConfidenceLevelGroup.ItemIndex < 1) then
    t := TStatisticTableFloatField90PercentConfidence.Value;
   if (ConfidenceLevelGroup.ItemIndex = 1) then
    t := TStatisticTableFloatField95PercentConfidence.Value;
   if (ConfidenceLevelGroup.ItemIndex > 1) then
    t := TStatisticTableFloatField99PercentConfidence.Value;
   TValueLabel.Caption := floatToStrF(t,ffFixed,7,4)
  end;
end;

procedure TForm1.TableRegression;
begin
 with SLRTableChosen do
  begin
   Form1.Caption := 'Regression of '+ResponseVarField+' on '+ControlVarField;
   InputLabel.Caption := ControlVarField;
   OutputLabel.Caption := ResponseVarField;
   xBarLabel.Caption := 'Avg '+ControlVarField+' = '+floatToStrF(xBar,ffFixed,7,4);
   yBarLabel.Caption := 'Avg '+ResponseVarField+' = '+floatToStrF(yBar,ffFixed,7,4);
   RSquaredLabel.Caption := 'R^2 = '+floatToStrF(RSquared,ffFixed,7,4);
   maxYLabel.Caption := 'Max '+ResponseVarField+' = '+floatToStrF(yMax,ffFixed,7,4);
   minYLabel.Caption := 'Min '+ResponseVarField+' = '+floatToStrF(yMin,ffFixed,7,4);
   maxXLabel.Caption := 'Max '+ControlVarField+' = '+floatToStrF(xMax,ffFixed,7,4);
   minXLabel.Caption := 'Min'+ControlVarField+' = '+floatToStrF(xMin,ffFixed,7,4);
   syxLabel.Caption := 's'+ResponseVarField+'|'+ControlVarField+' = '+floatToStrF(syx,ffFixed,7,4);
   FittedLabel.Caption := ResponseVarField+' = '+floatToStrF(b0,ffFixed,7,4)+' + '
                                +floatToStrF(b1,ffFixed,7,4)+ControlVarField;
   yOutput.Text := floatToStr(Predict(strToFloat(xInput.Text)));
   TStatisticTable.FindKey([DegreesOfFreedom]);
   if (ConfidenceLevelGroup.ItemIndex < 1) then
    t := TStatisticTableFloatField90PercentConfidence.Value;
   if (ConfidenceLevelGroup.ItemIndex = 1) then
    t := TStatisticTableFloatField95PercentConfidence.Value;
   if (ConfidenceLevelGroup.ItemIndex > 1) then
    t := TStatisticTableFloatField99PercentConfidence.Value;
   TValueLabel.Caption := floatToStrF(t,ffFixed,7,4)     
 end
end;

procedure TForm1.RunButtonClick(Sender: TObject);
begin
 LoadButtonClick(Sender);
 if (RegSummaryLabel.Tag = 0) then
  TableRegression
 else
  QueryRegression
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
 TableDataSet.Items[0] := SLRTable1.TableName;
 TableDataSet.Items[1] := SLRTable2.TableName;
 ConfidenceLevelGroup.ItemIndex := 1;
 TStatisticTable.Open;
 SLRTable1.Open;
 SLRTable2.Open;
 SLRQuery1.Open;
 SLRQuery2.Open
end;

procedure TForm1.TableDataSetClick(Sender: TObject);
begin
 if (TableDataSet.ItemIndex=0) then
  SLRTableChosen := SLRTable1
 else
  SLRTableChosen := SLRTable2;
 RegSummaryLabel.Caption := SLRTableChosen.Name+' Regression Summary';
 RegSummaryLabel.Tag := 0;
 TValueLabel.Caption := floatToStr(SLRTableChosen.t);
 if RunButton.Enabled  then
  RunButtonClick(Sender);
 LoadButton.Enabled := True;
 RunButton.Enabled := True
end;

procedure TForm1.ConfidenceLevelGroupClick(Sender: TObject);
begin
 if RunButton.Enabled  then
  RunButtonClick(Sender)
end;

procedure TForm1.xInputChange(Sender: TObject);
var x,y: double;
begin
 x := strToFloat(xInput.Text);
 if (RegSummaryLabel.Tag = 0) then
  y := SLRTableChosen.Predict(x)
 else
  y := SLRQueryChosen.Predict(x);
 yOutput.Text := floatToStr(y)
end;

procedure TForm1.QryDataSetClick(Sender: TObject);
begin
 if (QryDataSet.ItemIndex=0) then
  SLRQueryChosen := SLRQuery1
 else
  SLRQueryChosen := SLRQuery2;
 TValueLabel.Caption := floatToStr(SLRQueryChosen.t);
 RegSummaryLabel.Caption := SLRQueryChosen.Name+' Regression Summary';
 RegSummaryLabel.Tag := 1;
 if RunButton.Enabled  then
  RunButtonClick(Sender);
 LoadButton.Enabled := True;
 RunButton.Enabled := True
end;

end.
