Unit TArray;

{Freeware Version 0.6


Dietmar Reinwald
Email: Dietmar.Reinwald@t-online.de
CompuServe: 101761,335

If you find errors please contact me.


'--------------------------------------------------------------
Matrix (Two/three dimensional arrays):
ReDimPreserve work only with the first dimension
'--------------------------------------------------------------

'--------------------------------------------------------------
Example:

procedure Test;
var
   myArray : TDoubleArray;
   myMatrix : TDoubleMatrix;
   my3Matrix : TExtended3Matrix;
begin
   myArray := TDoubleArray.Create(15000);
       'This creates a Double-array with index 0 to 15000
   myArray[10000]:=10000.0;
   myArray.ReDimPreserve(30000);
       'This creates an Double-array with index 0 to 30000 with preserving the old values
   if myArray[10000]<>10000.0 then
      ShowMessage('An error occurs');
   myArray.Free;

   myMatrix:=TDoubleMatrix.Create(100,200);
        'This creates a Double-matrix with index 0 to 100, 0 to 200
   myMatrix[50,100]:=5000;
   myMatrix.ReDimPreserve(200,200);
        'This creates a Double-matrix with index 0 to 200, 0 to 200 with preserving the old values
   if myMatrix[50,100]<>5000 then
      ShowMessage('An error occurs');
   myMatrix.Free;

   my3Matrix:=TExtended3Matrix.Create(10,20,20);
        'This creates a Extended-matrix with index 0 to 10, 0 to 20, 0 to 20
   my3Matrix[5,10,10]:=5000;
   my3Matrix.ReDimPreserve(20,20,20);
        'This creates a Double-matrix with index 0 to 20, 0 to 20, 0 to 20 with preserving the old values
   if my3Matrix[5,10,10]<>5000 then
      ShowMessage('An error occurs');
   my3Matrix.Free;

end;
'--------------------------------------------------------------

'--------------------------------------------------------------
You can transfer vb-arrays to Delphi
a) What to do in VB

1) Declare Function VarPtr& Lib "vbrun300.dll" (a As Any) (in VB3)
or Declare Function VarPtr& Lib "vb40016.dll" (a As Any) (in VB4)
2) Maximal size of arrays:
     Double: 0 to 8190
     Long (LongInt), Single: 0 to 16382
     Integer: 0 to 32766

b) What to do in Delphi

   procedure DllExample(getPointer,getUBound:LongInt);
   var
      DArray:TDoubleArray;
      a:double;
   begin
      DArray:=TDoubleArray(0);
      DArray.Pointer:=Pointer(getPointer);
      DArray.SetUBound(getUBound);
      a:=DArray[DArray.UBound];
      DArray.Free;
   end;
c) What to do in VB

   Declare sub DllExample Lib "????????.???" (ByVal getPointer&,ByVal getUBound&)

   Dim i&,j&

   j=1000
   ReDim a#(j)
   i=VarPtr(a(0))

   call DllExample(i,j)
'--------------------------------------------------------------

}


interface
uses
    WinTypes, winProcs, Classes, SysUtils;

type


      tDArray = Array[0..0] of Double;
      tDArrayPtr = ^tDArray;
      tRArray = Array[0..0] of Real;
      tRArrayPtr = ^tRArray;
      tEArray = Array[0..0] of Extended;
      tEArrayPtr = ^tEArray;
      tIArray = Array[0..0] of Integer;
      tIArrayPtr = ^tIArray;
      tLArray = Array[0..0] of LongInt;
      tLArrayPtr = ^tLArray;


EArrayException=class(Exception);
EBoundsError=class(EArrayException);
EHandleError=class(EArrayException);
EPointerError=class(EArrayException);


TBaseArray = Class( TObject)
  protected
      myHandle :THandle;
      myPointer :Pointer;
      PosSize :LongInt;
      Itemsize :LongInt;
      DisposeNoHandle:boolean;
      IsPointer:boolean;
      procedure DisposeArray;virtual;
      procedure AllocArray(Wieviel :LongInt);virtual;
  public
      constructor Create(GetItemSize:integer; Wieviel :LongInt);
      destructor Destroy;override;
      function UBound:LongInt;virtual;
      procedure ReDimPreserve(NewSize :LongInt);virtual;
      procedure ReDim(NewSize :LongInt);virtual;
      function GetHandle:LongInt;
      procedure SetHandle(wHandle:LongInt);
      property Handle:LongInt read GetHandle write SetHandle;
      function GetPointer:Pointer;
      procedure SetPointer(wPointer:Pointer);
      property Pointer:Pointer read GetPointer write SetPointer;
      procedure SetUBound(n:LongInt);
      procedure FreeNoHandle;
      procedure SetHandleNoDispose(getHandle:LongInt);
End;


TIntegerArray = Class( TBaseArray)
  protected
      VIArrayPtr : tIArrayPtr;
  public
      constructor Create(Wieviel :LongInt);
      Procedure SetData( index: LongInt; wert: Integer );
      Function GetData(index: LongInt): Integer;
      property Data[ Index:LongInt ]: Integer
         read GetData write SetData; default;
      Procedure Add( wert: Integer );

End;


TLongIntArray = Class( TBaseArray)
  protected
      VLArrayPtr : tLArrayPtr;
  public
      constructor Create(Wieviel :LongInt);
      Procedure SetData( index: LongInt; wert: LongInt);
      Function GetData(index: LongInt): LongInt;
      property Data[ Index:LongInt ]: LongInt
         read GetData write SetData; default;
End;

TRealArray = Class( TBaseArray)
  protected
      VRArrayPtr : tRArrayPtr;
  public
      constructor Create(Wieviel :LongInt);
      Procedure SetData( index: LongInt; wert: Real );
      Function GetData(index: LongInt): Real;
      property Data[ Index:LongInt ]: Real
         read GetData write SetData; default;
End;


TDoubleArray = Class( TBaseArray)
  protected
      VDArrayPtr : tDArrayPtr;
  public
      constructor Create(Wieviel :LongInt);
      Procedure SetData( index: LongInt; wert: Double );
      Function GetData(index: LongInt): Double;
      property Data[ Index:LongInt ]: double
         read GetData write SetData; default;
End;

TExtendedArray = Class( TBaseArray)
  protected
      VEArrayPtr : tEArrayPtr;
  public
      constructor Create(Wieviel :LongInt);
      Procedure SetData( index: LongInt; wert: Extended );
      Function GetData(index: LongInt): Extended;
      property Data[ Index:LongInt ]: Extended
         read GetData write SetData; default;
End;


TBaseMatrix = Class( TObject)
  protected
      myHandle :THandle;
      myPointer :Pointer;
      Huge1 :LongInt;
      Huge2 :LongInt;
      ItemSize1 :LongInt;
      IsPointer:boolean;
      procedure DisposeMatrix;virtual;
      procedure AllocMatrix(GetHuge1, GetHuge2 :LongInt);virtual;
  public
      constructor Create(GetItemSize :integer; GetHuge1, GetHuge2 :LongInt);
      destructor Destroy;override;
      function UBound(WhatDim:byte):LongInt;virtual;
      procedure ReDimPreserve(NewHuge1, NewHuge2 :LongInt);virtual;
      procedure ReDim(NewHuge1, NewHuge2 :LongInt);virtual;
End;

TIntegerMatrix = Class( TBaseMatrix)
  protected
      VIArrayPtr : tIArrayPtr;
  public
      constructor Create(Wieviel1, Wieviel2 :LongInt);
      Procedure SetData( index1, index2 :LongInt; wert: Integer );
      Function GetData(index1, index2 :LongInt): Integer;
      property Data[ Index1, Index2 :LongInt ]: Integer
         read GetData write SetData; default;
End;


TLongIntMatrix = Class( TBaseMatrix)
  protected
      VLArrayPtr : tLArrayPtr;
  public
      constructor Create(Wieviel1, Wieviel2 :LongInt);
      Procedure SetData( index1, index2: LongInt; wert: LongInt);
      Function GetData(index1, index2: LongInt): LongInt;
      property Data[ Index1, Index2:LongInt ]: LongInt
         read GetData write SetData; default;
End;

TDoubleMatrix = Class( TBaseMatrix)
  protected
      VDArrayPtr : tDArrayPtr;
  public
      constructor Create(Wieviel1, Wieviel2 :LongInt);
      Procedure SetData( index1, index2: LongInt; wert: Double);
      Function GetData(index1, index2: LongInt): Double;
      property Data[ Index1, Index2:LongInt ]: Double
         read GetData write SetData; default;
End;


TExtendedMatrix = Class( TBaseMatrix)
  protected
      VEArrayPtr : tEArrayPtr;
  public
      constructor Create(Wieviel1, Wieviel2 :LongInt);
      Procedure SetData( index1, index2: LongInt; wert: Extended);
      Function GetData(index1, index2: LongInt): Extended;
      property Data[ Index1, Index2:LongInt ]: Extended
         read GetData write SetData; default;
End;


TBase3Matrix = Class( TObject)
  protected
      myHandle :THandle;
      myPointer :Pointer;
      Huge1 :LongInt;
      Huge2 :LongInt;
      Huge3 :LongInt;
      ItemSize1 :LongInt;
      IsPointer:boolean;
      procedure DisposeMatrix;virtual;
      procedure AllocMatrix(GetHuge1, GetHuge2, GetHuge3 :LongInt);virtual;
  public
      constructor Create(GetItemSize :integer; GetHuge1, GetHuge2, GetHuge3 :LongInt);
      destructor Destroy;override;
      function UBound(WhatDim:byte):LongInt;virtual;
      procedure ReDimPreserve(NewHuge1, NewHuge2, NewHuge3 :LongInt);virtual;
      procedure ReDim(NewHuge1, NewHuge2, NewHuge3 :LongInt);virtual;
End;

TExtended3Matrix = Class( TBase3Matrix)
  protected
      VEArrayPtr : tEArrayPtr;
  public
      constructor Create(Wieviel1, Wieviel2, Wieviel3 :LongInt);
      Procedure SetData( index1, index2, index3: LongInt; wert: Extended);
      Function GetData(index1, index2, index3: LongInt): Extended;
      property Data[ Index1, Index2, Index3:LongInt ]: Extended
         read GetData write SetData; default;
End;



implementation


{------------ BaseVektor --------------------}


procedure TBaseArray.SetHandleNoDispose(getHandle:LongInt);
begin
     myHandle:=THandle(getHandle);
     IsPointer:=false;
end;

function TBaseArray.GetHandle:LongInt;
begin
     Result:=LongInt(myHandle);
end;

procedure TBaseArray.SetHandle(wHandle:LongInt);
begin
     DisposeArray;
     myHandle:=THandle(wHandle);
     IsPointer:=false;
end;

function TBaseArray.GetPointer:Pointer;
begin
     Result:=myPointer;
end;

procedure TBaseArray.SetPointer(wPointer:Pointer);
begin
     if wPointer=nil then
     begin
          raise EPointerError.Create('Pointer=nil');
          exit;
     end;
     DisposeArray;
     myHandle:=0;
     myPointer:=wPointer;
     IsPointer:=true;
end;


procedure TBaseArray.SetUBound(n:LongInt);
begin
     PosSize:=n+1;
end;


function TBaseArray.UBound:LongInt;
{We always think we have an array 0..PosSize-1}
begin
     UBound:=PosSize-1;
end;

procedure TBaseArray.DisposeArray;
begin
     if not (myHandle=0) then
     begin
       repeat
       until not GlobalUnlock(myHandle);
     end;
     myHandle:=GlobalFree(myHandle);
     myHandle:=0;
     myPointer:=nil;
end;

procedure TBaseArray.FreeNoHandle;
begin
     DisposeNoHandle:=true;
     Free;
end;

destructor TBaseArray.Destroy;
begin
     if not DisposeNoHandle then DisposeArray;
     inherited Destroy;
end;

procedure TBaseArray.AllocArray(Wieviel :LongInt);
var
   mySize:LongInt;
begin
    mySize:=ItemSize*Wieviel;
    myHandle:=GlobalAlloc(GMEM_MOVEABLE+GMEM_ZEROINIT,mySize);
    if myHandle<>0 then
       PosSize:=Wieviel
    else
    begin
       PosSize:=0;
       raise EHandleError.Create('No Handle created');
    end;
end;

constructor TBaseArray.Create(GetItemSize:integer; Wieviel :LongInt);
{We want to have an array 0..Wieviel}
begin
    inherited Create;
    myHandle:=0;
    myPointer:=nil;
    ItemSize:=GetItemSize;
    DisposeNoHandle:=false;
    IsPointer:=false;
    AllocArray(Wieviel+1);
{    myPointer:=GlobalLock(myHandle);}
end;

procedure TBaseArray.ReDimPreserve(NewSize :LongInt);
{We want to have an array 0..NewSize}
var
   mySize:LongInt;
begin
    mySize:=(NewSize+1)*ItemSize;
    if myHandle<>0 then
    begin
        myHandle:=GlobalReAlloc(myHandle, mySize, GMEM_MOVEABLE + GMEM_ZEROINIT);
        if myHandle=0 then
        begin
           PosSize:=0;
           raise EHandleError.Create('No Handle created');
        end;
    end
    else
         ReDim(NewSize);
    if myHandle<>0 then
    begin
         PosSize:=NewSize+1;
{         myPointer:=GlobalLock(myHandle);}
    end;
end;

procedure TBaseArray.ReDim(NewSize :LongInt);
{We want to have an array 0..NewSize}
begin
     DisposeArray;
     AllocArray(NewSize+1);
end;


{--------------------------------- Integer ----------------------------------------------}

procedure TIntegerArray.Add(wert:integer);
{We always think we have an array 0..PosSize-1}
var
   oldSize:LongInt;
begin
     oldSize:=PosSize;
     ReDimPreserve(PosSize);
     Data[PosSize]:=wert;
end;

constructor TIntegerArray.Create(Wieviel :LongInt);
{We want to have an array 0..NewSize}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tIArray);
     inherited Create(mySize, Wieviel);
end;


function TIntegerArray.GetData(index:longint):Integer ;
begin
  Result:=0;
  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VIArrayPtr:=GlobalLock(myHandle)
  else
     VIArrayPtr:=myPointer;
  if VIArrayPtr=nil then
  begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;
  result:=VIArrayPtr^[index];

  if not IsPointer then GlobalUnLock(myHandle);
end;

procedure TIntegerArray.SetData(index:longint; wert:Integer);
begin
  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VIArrayPtr:=GlobalLock(myHandle)
  else
     VIArrayPtr:=myPointer;
  if VIArrayPtr=nil then
  begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;
  VIArrayPtr^[index]:=wert;

  if not IsPointer then GlobalUnLock(myHandle);
end;



{--------------------------------- LongInt ----------------------------------------------}
constructor TLongIntArray.Create(Wieviel :LongInt);
{We want to have an array 0..NewSize}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tLArray);
     inherited Create(mySize, Wieviel);
end;


function TLongIntArray.GetData(index:longint):LongInt ;
begin
  Result:=0;
  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VLArrayPtr:=GlobalLock(myHandle)
  else
     VLArrayPtr:=myPointer;
  if VLArrayPtr=nil then
  begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VLArrayPtr^[index];

  if not IsPointer then GlobalUnLock(myHandle);
end;

procedure TLongIntArray.SetData(index:longint; wert:LongInt);
begin
  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VLArrayPtr:=GlobalLock(myHandle)
  else
     VLArrayPtr:=myPointer;
  if VLArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VLArrayPtr^[index]:=wert;
  if not IsPointer then GlobalUnLock(myHandle);
end;

{--------------------------------- Real ------------------------------------------------}

constructor TRealArray.Create(Wieviel :LongInt);
{We want to have an array 0..Wieviel}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tRArray);
     inherited Create(mySize, Wieviel);
end;


function TRealArray.GetData(index:longint):Real ;
begin
  Result:=0.0;
  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VRArrayPtr:=GlobalLock(myHandle)
  else
     VRArrayPtr:=myPointer;
  if VRArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VRArrayPtr^[index];

  if not IsPointer then GlobalUnLock(myHandle);
end;

procedure TRealArray.SetData(index:longint; wert:REal);
begin
  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VRArrayPtr:=GlobalLock(myHandle)
  else
     VRArrayPtr:=myPointer;
  if VRArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VRArrayPtr^[index]:=wert;

  if not IsPointer then GlobalUnLock(myHandle);
end;


{--------------------------------- Double ----------------------------------------------}
constructor TDoubleArray.Create(Wieviel :LongInt);
{We want to have an array 0..NewSize}
var
   mySize:Integer;
begin
     mySize:= sizeOf(tDArray);      {sizeOf(Double);}
     inherited Create(mySize, Wieviel);
end;


function TDoubleArray.GetData(index:longint):double ;
begin
  Result:=0.0;

  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VDArrayPtr:=GlobalLock(myHandle)
  else
     VDArrayPtr:=myPointer;
  if VDArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VDArrayPtr^[index];

  if not IsPointer then GlobalUnLock(myHandle);
end;

procedure TDoubleArray.SetData(index:longint; wert:double);
begin

  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VDArrayPtr:=GlobalLock(myHandle)
  else
     VDArrayPtr:=myPointer;
  if VDArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VDArrayPtr^[index]:=wert;

  if not IsPointer then GlobalUnLock(myHandle);
end;

{--------------------------------- Extended ----------------------------------------------}
constructor TExtendedArray.Create(Wieviel :LongInt);
{We want to have an array 0..NewSize}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tEArray);
     inherited Create(mySize, Wieviel);
end;


function TExtendedArray.GetData(index:longint):Extended ;
begin
      Result:=0.0;

  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VEArrayPtr:=GlobalLock(myHandle)
  else
     VEArrayPtr:=myPointer;
  if VEArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VEArrayPtr^[index];
  if not IsPointer then GlobalUnLock(myHandle);

end;

procedure TExtendedArray.SetData(index:longint; wert:Extended);
begin

  If (index>Ubound) or (index <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;

  if not IsPointer then
     VEArrayPtr:=GlobalLock(myHandle)
  else
     VEArrayPtr:=myPointer;
  if VEArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VEArrayPtr^[index]:=wert;
  if not IsPointer then GlobalUnLock(myHandle);
end;


{---------------------------------- TBaseMatrix -----------------------------------------}



function TBaseMatrix.UBound(WhatDim:Byte):LongInt;
{We always think we have an array 0..Huge1-1, 0..Huge2-1}
begin
     Result:=0;
     if (WhatDim=1) then
        Result:=Huge1-1;
     if (WhatDim=2) then
        Result:=Huge2-1;
end;

procedure TBaseMatrix.DisposeMatrix;
var
   i:longint;
   good :boolean;
begin
     if not (myHandle=0) then
     begin
         repeat
         until not GlobalUnlock(myHandle);
         myHandle:=GlobalFree(myHandle);
     end;
     myHandle:=0;
     Huge1:=0;
     Huge2:=0;
     myPointer:=nil;
end;


destructor TBaseMatrix.Destroy;
begin
     DisposeMatrix;
     inherited Destroy;
end;

procedure TBaseMatrix.AllocMatrix(GetHuge1, GetHuge2 :LongInt);
{array[0..GetHuge1, 0..GetHuge2]}
var
   mySize:LongInt;
begin
    mySize:=ItemSize1*(GetHuge1+1)*(GetHuge2+1);
    myHandle:=GlobalAlloc(GMEM_MOVEABLE+GMEM_ZEROINIT,mySize);
    Huge1:=0;
    Huge2:=0;
    if myHandle<>0 then
    begin
         Huge1:=GetHuge1+1;
         Huge2:=GetHuge2+1;
    end
    else
       raise EHandleError.Create('No Handle created');

end;

constructor TBaseMatrix.Create(GetItemSize :integer; GetHuge1, GetHuge2 :LongInt);
{We want to have an array 0..GetHuge1, 0..GetHuge2}
begin
    inherited Create;
    myHandle:=0;
    myPointer:=nil;
    ItemSize1:=GetItemSize;
    IsPointer:=false;
    AllocMatrix(GetHuge1,GetHuge2);
end;

procedure TBaseMatrix.ReDimPreserve(NewHuge1, NewHuge2 :LongInt);
{We want to have an array 0..NewHuge1, 0.. NewHuge2}
{Only the first dimension can extended with preserve}
var
   good :boolean;
   mySize :LongInt;
begin
     if NewHuge2+1=Huge2 then
     begin
          Huge1:=0;
          Huge2:=0;
          mySize:= ItemSize1*(NewHuge1+1)*(NewHuge2+1);
          myHandle:=GlobalReAlloc(myHandle, mySize, GMEM_MOVEABLE + GMEM_ZEROINIT);
          if (myHandle<>0) then
          begin
               Huge1:=NewHuge1+1;
               Huge2:=NewHuge2+1;
               good:=GlobalUnLock(myHandle);
          end
          else
              raise EHandleError.Create('No Handle created');
     end
     else
         ReDim(NewHuge1, NewHuge2);

end;

procedure TBaseMatrix.ReDim(NewHuge1, NewHuge2 :LongInt);
{We want to have an array 0..NewHuge, 0..NewHuge2}
begin
     DisposeMatrix;
     AllocMatrix(NewHuge1, NewHuge2);
end;

{--------------------------------- IntegerMatrix ----------------------------------------------}
constructor TIntegerMatrix.Create(Wieviel1, Wieviel2 :LongInt);
{We want to have an array 0..Wieviel1,0..Wieviel2}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tIArray);
     inherited Create(mySize, Wieviel1, Wieviel2);
end;


function TIntegerMatrix.GetData(index1, index2:longint):Integer ;

begin
  Result:=0;
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VIArrayPtr:=GlobalLock(myHandle);
  if VIArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VIArrayPtr^[index1*Huge2+index2];
  GlobalUnLock(myHandle);

end;

procedure TIntegerMatrix.SetData(index1, index2:longint; wert:Integer);
begin

  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VIArrayPtr:=GlobalLock(myHandle);
  if VIArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VIArrayPtr^[index1*Huge2+index2]:=wert;
  GlobalUnLock(myHandle);

end;


{--------------------------------- LongIntMatrix ----------------------------------------------}
constructor TLongIntMatrix.Create(Wieviel1, Wieviel2 :LongInt);
{We want to have an array 0..Wieviel1,0..Wieviel2}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tLArray);
     inherited Create(mySize, Wieviel1, Wieviel2);
end;


function TLongIntMatrix.GetData(index1, index2:longint):LongInt ;
begin
  Result:=0;

  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VLArrayPtr:=GlobalLock(myHandle);
  if VLArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VLArrayPtr^[index1*Huge2+index2];
  GlobalUnLock(myHandle);
end;

procedure TLongIntMatrix.SetData(index1, index2:longint; wert:LongInt);
begin

  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VLArrayPtr:=GlobalLock(myHandle);
  if VLArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VLArrayPtr^[index1*Huge2+index2]:=wert;
  GlobalUnLock(myHandle);

end;

{--------------------------------- DoubleMatrix ----------------------------------------------}
constructor TDoubleMatrix.Create(Wieviel1, Wieviel2 :LongInt);
{We want to have an array 0..Wieviel1,0..Wieviel2}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tDArray);
     inherited Create(mySize, Wieviel1, Wieviel2);
end;


function TDoubleMatrix.GetData(index1, index2:longint):double ;
begin
  Result:=0;
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VDArrayPtr:=GlobalLock(myHandle);
  if VDArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VDArrayPtr^[index1*Huge2+index2];
  GlobalUnLock(myHandle);
end;

procedure TDoubleMatrix.SetData(index1, index2:longint; wert:Double);
begin
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VDArrayPtr:=GlobalLock(myHandle);
  if VDArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VDArrayPtr^[index1*Huge2+index2]:=wert;
  GlobalUnLock(myHandle);
end;


{--------------------------------- ExtendedMatrix ----------------------------------------------}
constructor TExtendedMatrix.Create(Wieviel1, Wieviel2 :LongInt);
{We want to have an array 0..Wieviel1,0..Wieviel2}
var
   mySize:Integer;
begin
     mySize:=sizeOf(Extended);
     inherited Create(mySize, Wieviel1, Wieviel2);
end;


function TExtendedMatrix.GetData(index1, index2:longint):extended ;
begin
  Result:=0;
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VEArrayPtr:=GlobalLock(myHandle);
  if VEArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VEArrayPtr^[index1*Huge2+index2];
  GlobalUnLock(myHandle);
end;

procedure TExtendedMatrix.SetData(index1, index2:longint; wert:extended);
begin
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VEArrayPtr:=GlobalLock(myHandle);
  if VEArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VEArrayPtr^[index1*Huge2+index2]:=wert;
  GlobalUnLock(myHandle);
end;


{---------------------------------- TBaseMatrix -----------------------------------------}


function TBase3Matrix.UBound(WhatDim:Byte):LongInt;
{We think we have an array 0..Huge1-1, 0..Huge2-1, 0..Huge3-1}
begin
     Result:=0;
     if (WhatDim=1) then
        Result:=Huge1-1;
     if (WhatDim=2) then
        Result:=Huge2-1;
     if (WhatDim=3) then
        Result:=Huge3-1;
end;

procedure TBase3Matrix.DisposeMatrix;
begin
     if not (myHandle=0) then
     begin
         repeat
         until not GlobalUnlock(myHandle);
         myHandle:=GlobalFree(myHandle);
     end;
     myHandle:=0;
     Huge1:=0;
     Huge2:=0;
     Huge3:=0;
     myPointer:=nil;
end;


destructor TBase3Matrix.Destroy;
begin
     DisposeMatrix;
     inherited Destroy;
end;

procedure TBase3Matrix.AllocMatrix(GetHuge1, GetHuge2, GetHuge3 :LongInt);
{array[0..GetHuge1, 0..GetHuge2]}
var
   i:longint;
   good :boolean;
   mySize:LongInt;
begin
    mySize:=ItemSize1*(GetHuge1+1)*(GetHuge2+1)*(GetHuge3+1);
    myHandle:=GlobalAlloc(GMEM_MOVEABLE+GMEM_ZEROINIT,mySize);
    Huge1:=0;
    Huge2:=0;
    Huge3:=0;
    if myHandle<>0 then
    begin
         Huge1:=GetHuge1+1;
         Huge2:=GetHuge2+1;
         Huge3:=GetHuge3+1;
    end
    else
        raise EHandleError.Create('No Handle created');

end;

constructor TBase3Matrix.Create(GetItemSize :integer; GetHuge1, GetHuge2, GetHuge3 :LongInt);
{We want to have an array 0..GetHuge1, 0..GetHuge2, 0..GetHuge3}
begin
    inherited Create;
    myHandle:=0;
    myPointer:=nil;
    ItemSize1:=GetItemSize;
    IsPointer:=false;
    AllocMatrix(GetHuge1,GetHuge2,GetHuge3);
end;

procedure TBase3Matrix.ReDimPreserve(NewHuge1, NewHuge2, NewHuge3 :LongInt);
{We want to have an array 0..NewHuge1, 0.. NewHuge2, 0.. NewHuge3}
{Only the first dimension can extended with preserve}
var
   good :boolean;
   mySize :LongInt;
begin
     if (NewHuge2+1=Huge2) and (NewHuge3+1=Huge3) then
     begin
          Huge1:=0;
          Huge2:=0;
          Huge3:=0;
          mySize:= ItemSize1*(NewHuge1+1)*(NewHuge2+1)*(NewHuge3+1);
          myHandle:=GlobalReAlloc(myHandle, mySize, GMEM_MOVEABLE + GMEM_ZEROINIT);
          if (myHandle<>0) then
          begin
               Huge1:=NewHuge1+1;
               Huge2:=NewHuge2+1;
               Huge3:=NewHuge3+1;
               good:=GlobalUnLock(myHandle);
          end
          else
              raise EHandleError.Create('No Handle created');
     end
     else
         ReDim(NewHuge1, NewHuge2, NewHuge3);

end;

procedure TBase3Matrix.ReDim(NewHuge1, NewHuge2, NewHuge3 :LongInt);
{We want to have an array 0..NewHuge, 0..NewHuge2, 0..NewHuge3}
begin
     DisposeMatrix;
     AllocMatrix(NewHuge1, NewHuge2, NewHuge3);
end;

{--------------------------------- Extended3Matrix ----------------------------------------------}

constructor TExtended3Matrix.Create(Wieviel1, Wieviel2, Wieviel3 :LongInt);
{We want to have an array 0..Wieviel1,0..Wieviel2,0..Wieviel3}
var
   mySize:Integer;
begin
     mySize:=sizeOf(tEArray);
     inherited Create(mySize, Wieviel1, Wieviel2, Wieviel3);
end;


function TExtended3Matrix.GetData(index1, index2, index3:longint):extended ;
begin
  Result:=0;
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VEArrayPtr:=GlobalLock(myHandle);
  if VEArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  result:=VEArrayPtr^[(Index1*Huge2+index2)*huge3+index3];
  GlobalUnLock(myHandle);

end;

procedure TExtended3Matrix.SetData(index1, index2, index3:longint; wert:extended);
begin
  If (index1>Ubound(1)) or (index1 <0) or (index2>Ubound(2)) or (index2 <0) or
     (index3>Ubound(3)) or (index3 <0) then
  begin
       raise EBoundsError.Create('Invalid Element');
       exit;
  end;
  VEArrayPtr:=GlobalLock(myHandle);
  if VEArrayPtr=nil then
    begin
       raise EPointerError.Create('Pointer=nil');
       exit;
  end;

  VEArrayPtr^[(Index1*Huge2+index2)*huge3+index3]:=wert;
  GlobalUnLock(myHandle);

end;


end.