unit LEDReg32;

interface

uses Classes, DsgnIntf;

type

  { Override property editor to prevent the Object Inspector from
    sorting the LEDs color property alphabetically }

  TLEDColorProperty = class(TEnumProperty)
    public
      function GetAttributes: TPropertyAttributes; override;

end;

procedure Register;

implementation

uses LED;

function TLEDColorProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes - [paSortList];
end;

procedure Register;
begin
  RegisterComponents('Custom', [TLED]);
  RegisterComponents('Custom', [TLEDLabel]);
  RegisterPropertyEditor(TypeInfo(TLEDColor),TLED,'Color',TLEDColorProperty);
end;

end.
