unit PsVsEval;

interface

uses
  SysUtils, WinTypes, WinProcs, {Messages,} Classes, {Graphics,} Controls,
  Forms,evalvis {Dialogs};

type
  TEvalEventtype = procedure(VarName:string;Var VarVal:Real;Var Accpt:boolean) of object;
  TEvalErrortype = procedure(Errnum :integer;Errtext:string) of object;
  TVisEval = class(TComponent)
  private
    FExpression : string;
    FOnGetVariable : TEvalEventType;
    FOnError : TEvalErrorType;
    FStepMode : boolean;
    FValue : Real;
    FResults : Real;
    FErrorNumber : integer;
    FAbort : boolean;
    FErrorText : string;
    FVisual : boolean;
    Finterval : longint;
    FKeepVisual : boolean;
    FTitle : string;
    function Solveit(var equation:string) : string;
    function solve(equation:string) : string;
(*    function substitute(equation:string):string; *)
    function solvenested(equation:string):string;
    procedure condensesigns(var eq:string);
    function evaluate(eq:string):string;
    function simplify(eq:string):string;
    function isnumber(eq:string):boolean;
    procedure Reportprocess(s:string);
    procedure reporttomemo(s:string);
    procedure ReportError(s:string);
  protected
    { Protected declarations }
    procedure loaded;override;
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    procedure execute;
    procedure closevisual;
    function Rate(per:integer;amount:real;pmt:real):real;
    function Pmt(rate:real;per:integer;amount:real):real;
    function Per(rate:real;pmt:real;amount:real):integer;
    function FV(rate:real;pers:integer;pmt:real):real;
    function PV(rate:real;pers:integer;amount:real):real;
    function nPV(rate:real;pers:integer;pmt:real):real;
    property Results : real read FResults;
    property ErrorNumber : integer read FErrorNumber;

  published
    property Title : string read FTitle write FTitle;
    property interval : longint read Finterval write Finterval;
    property OnGetVariable : TEvalEventtype read FOnGetVariable
      write FOnGetVariable;
    property OnError : TEvalErrortype read FOnError write FOnError;
    property Expression : string read FExpression write FExpression;
    property Visual : boolean read FVisual write FVisual;
    property KeepVisual : boolean read FKeepVisual write FKeepVisual;
    property StepMode : boolean read FStepMode write FStepMode;
  end;

  procedure Register;
  procedure sleep(ticks:longint);
  function replace(mainstr:string;const replstr:string;const target:string):string;
  function IsOperator(op:string) : boolean;
  function OpPrecedence(op:string) : integer;
  function IsEquation(equation:string) :boolean;
  function ParensBalanced(s:string):boolean;
  var
    FAccept : boolean;
    gclosevisual : boolean;
    gstep : boolean;
    greplay : boolean;
    gruntoend : boolean;
    function IsDigit(ch:char):boolean;
    function clearwhitespace(s:string):string;

implementation
procedure Sleep(ticks:longint);
var
   begtick : longint;
   endtick : longint;
begin
   begtick := GetTickCount;
   endtick := begtick;
   while (endtick - begtick) < ticks do
   begin
     endtick := GetTickCount;
   end;

end;
function replace(mainstr:string;const replstr:string;const target:string):string;
var
   temp : string;
   i : integer;
   j : integer;
begin
     temp := '';
     i := Pos(target,mainstr);
     if i = 0 then
     begin
       temp := mainstr;
       exit;
     end;
(*     for j := 1 to i-1 do
       temp := temp + mainstr[j];  *)
     temp := temp + Copy(mainstr,1,i-1);
     temp := temp + replstr;
     for j := i + length(target) to length(mainstr) do
       temp := temp + mainstr[j];
     result := temp;
end;
function IsDigit(ch:char):boolean;
begin
     if ch in ['0'..'9'] then
       IsDigit := true
     else
       IsDigit := false;
end;
procedure Register;
begin
  RegisterComponents('JTaylor', [TVisEval]);
end;
function IsEquation(equation:string) :boolean;
var
   res : boolean;
   sign : string;
   mark : integer;
   len : integer;
   eq : string;
   r : real;
   code : integer;
begin
     val(equation,r,code);  (* if it's just a number return false *)
     if code = 0 then
     begin
       isequation := false;
       exit;
     end;
     mark := 0;
     res := false;
     sign := equation[1];
     len := length(equation);
     if (sign = '+') or (sign = '-') then
       mark := 1;
     eq := Copy(equation,mark+1,length(equation)-mark);
     If (Pos('+',eq) > mark) and (Pos('+',eq) < len) then
      res := true;

     If (Pos('-',eq) > mark) and (Pos('-',eq) < len) then
      res := true;

     If (Pos('/',eq) > mark) and (Pos('/',eq) < len) then
      res := true;
     if (Pos('<',eq) > mark) and (Pos('<',eq) < len) then
      res := true;
     if (Pos('>',eq) > mark) and (Pos('>',eq) < len) then
      res := true;
     if (Pos('=',eq) > mark) and (Pos('=',eq) < len) then
      res := true;

     If (Pos('*',eq) > mark) and (Pos('*',eq) < len) then
      res := true;

     If (Pos('^',eq) > mark) and (Pos('^',eq) < len) then
      res := true;

     If (Pos('%',eq) > mark) and (Pos('%',eq) < len) then
      res := true;

(*     If (Pos('!',eq) > mark) and (Pos('!',eq) < len) then
     begin
      res := false;
     end; jct 3/12/96*)

     If (Pos('!',equation) > mark) and (Pos('!',equation) = len) then
       res := true;
     Result := res;
end;
procedure TVisEval.ReportProcess(s:string);
begin
     If not FVisual or gclosevisual then
       exit;
     EvalVisual.process.caption := s;
     EvalVisual.memo1.lines.add(s);
     if lowercase(s) = 'done.' then
     begin
       evalvisual.btnstep.enabled := false;
       evalvisual.btnreplay.enabled := true;
       evalvisual.btnrun.enabled := false;
     end
     else
       evalvisual.btnstep.enabled := true;
     application.processmessages;
end;
procedure TVisEval.Reporttomemo(s:string);
begin
     If not FVisual or gclosevisual then
       exit;
     evalvisual.process.caption := s;
     EvalVisual.memo1.lines.add(s);
     application.processmessages;
end;

procedure TVisEval.ReportError(s:string);
begin
     If not FVisual or gclosevisual then
       exit;
     EvalVisual.errstat.caption := s;
     evalvisual.memo1.lines.add(s);
     application.processmessages;
end;

procedure TVisEval.Closevisual;
begin
     if (FVisual) and (EvalVisual <> nil) then
     begin
       EvalVisual.free;
       evalvisual := nil;
     end;
end;
destructor TVisEval.Destroy;
begin
(*     if (FVisual) and (EvalVisual <> nil) then
       EvalVisual.free; *)
     inherited Destroy;
end;
procedure TVisEval.loaded;
begin
     inherited loaded;
     If not FVisual then
       FStepmode := false;
end;
constructor TVisEval.Create(AOwner:TComponent);
begin
     inherited Create(AOwner);
     FAbort := false;
     FStepMode := false;
     Finterval := 50;
     gclosevisual := true;
end;

function TVisEval.Per(rate:real;pmt:real;amount:real):integer;
var
   i : real;
   temp : real;
   k : integer;
   target : real;
   pers : integer;
   e : real;
   f : real;
   s : string;
   epsilon : real;
begin
     pers := -1;
     epsilon := 0.01;
     target := strtofloat(floattostrf(amount/pmt,fffixed,18,7));
     for k := 1 to 10000 do
     begin
       e := exp(ln(1+rate)*k);
       f := (1-(1/e))/rate;
       s := floattostrf(f,ffFixed,18,7);
       temp := strtofloat(s);
       if abs(temp - target) < epsilon then
       begin
         pers := k;
         break;
       end;
     end;
     result := pers;
end;
function TVisEval.Isnumber(eq:string):boolean;
var
   r : real;
   code :integer;
begin
     val(eq,r,code);
     result := code = 0;

end;
function TVisEval.Rate(per:integer;amount:real;pmt:real):real;
var
   i : real;
   temp : real;
   k : real;
   target : real;
   e : real;
   f : real;
   irate : real;
   s : string;
   epsilon : real;

begin
     irate := 0;
     epsilon := 0.0001;
     target := strtofloat(floattostrf(amount/pmt,fffixed,18,9));
     k := 0.00001;
     while k < 100.0 do
     begin
       e := exp(ln(1+k)*per);
       f := (1-(1/e))/k;
       s := floattostrf(f,ffFixed,18,9);
       temp := strtofloat(s);
       if (abs(temp - target) < epsilon) or (temp <= target) then
       begin
         irate := k;
         break;
       end;
       k := k + 0.00001
     end;
     result := irate;

end;
function TVisEval.PV(rate:real;pers:integer;amount:real):real;
var
   i : integer;
   res : real;
   factor : real;
   e : real;
begin
     e := exp(ln(1+rate)*pers);
     factor := 1/(e);
     res := amount*factor;
     result := res;
end;
function TVisEval.nPV(rate:real;pers:integer;pmt:real):real;
var
   i : integer;
   res : real;
   factor : real;
   e,f : real;
begin
     e := exp(ln(1+rate)*pers);
     f := 1/e;
     factor := (1-f)/rate;
     res := pmt*factor;
     result := res;
end;

function TVisEval.FV(rate:real;pers:integer;pmt:real):real;
var
   i : integer;
   res : real;
   factor : real;
   e : real;
begin
     e := exp(ln(1+rate)*pers);
     factor := (e-1)/rate;
     res := pmt*factor;
     result := res;
end;
function TVisEval.Pmt(rate:real;per:integer;amount:real):real;
var
   i : real;
   temp : real;
   pmt : real;
   principal : real;

begin
     i := rate;

     principal := amount;
     temp := exp(ln(1+i)*per);
     pmt := principal / ((1-(1/temp))/i);
     result := pmt;

end;

procedure TVisEval.Execute;
var

   i : integer;
   c : string;
   exp : string;
   sum : real;
   xpress : string;
   r : real;
   code : integer;
begin
     If (FVisual) and (gclosevisual) then
     begin
       EvalVisual := TEvalVisual.Create(Self);
       gclosevisual := false;
       gstep := FStepMode;
       greplay := false;
       gruntoend := false;
       evalvisual.caption := FTitle;
       EvalVisual.mainpanel.text := Fexpression;
       ReportProcess('Executing...');
       ReportError('None');
       evalvisual.memo1.clear;
       evalvisual.btnstep.visible := FKeepvisual;
       evalvisual.btnclose.visible := FKeepvisual;
       evalvisual.btnreplay.visible := FKeepvisual;
       evalvisual.btnreplay.enabled := false;
       evalvisual.btnrun.enabled := FKeepvisual and FStepMode;
       EvalVisual.Show;
     end;
     xpress := '';
     exp := clearwhitespace(Fexpression);
     FExpression := exp;
     FAbort := false;
     FResults := 0;
(*     if not isequation(exp) then
     begin
       If isnumber(exp) then
       begin

         val(exp,r,code);
         FResults := r;
         If (FVisual) and (Evalvisual <> nil) and (not FKeepVisual) then
           Evalvisual.free;
         exit;
       end;
     end; *)
     If not ParensBalanced(exp) then
     begin
       If (FVisual) and (Evalvisual <> nil) and (not FKeepVisual) then
         Evalvisual.free;
       FErrorNumber := 2;
       FErrorText := 'Unbalanced parentheses';
       ReportError(FErrorText);
       If Assigned(FOnError) then OnError(FErrorNumber,FErrorText);
       FAbort := true;
       FResults := 0.0;
       exit;
     end;
     if length(exp) > 0 then
     begin
       xpress := evaluate(exp);
       If FAbort then
       begin
         Reportprocess('Aborted - Error');
         exit;
       end;
       val(xpress,r,code);
       if code = 0 then
       begin
         FResults := r;
         ReportProcess('Final Result: '+floattostrf(r,ffgeneral,18,5));
         ReportProcess('Done.');
         evalvisual.respanel.caption := 'Final Result: '+floattostrf(r,ffgeneral,18,18);
       end
       else
       begin
         If (FVisual) and (Evalvisual <> nil) and (not FKeepVisual) then
           Evalvisual.free;
         FResults := 0.0;
         FErrorNumber := 4;
         FErrorText := 'Invalid expression';
         ReportError(FErrorText);
         ReportProcess('Abort - Error');
         If Assigned(FOnError) then OnError(FErrorNumber,FErrorText);
         FResults := 0;
         exit;
       end;
     end;
     If (not greplay) and (FVisual) and (Evalvisual <> nil) and (not FKeepVisual) then
       Closevisual;
     while not gclosevisual do
     begin
       Application.processmessages;
       if greplay then
       begin
         greplay := false;
         execute;
       end;
     end;
     Closevisual;
end;

function TVisEval.Solveit(var equation:string) : string;
var
   test : string;
   temp : string;
   var1 : real;
   var2 : real;
   v1, v2 : string;
   eq : string;
   c : string;
{   d : string;}
   e : string;
   len : integer;
   p : integer;
   op : string;
   haveoperator : boolean;
   i,j : integer;
   final : string;
   done : boolean;
   formula : string;
   sum : real;
{   k : integer;}
   oppos, pos1, pos2 : integer;
   xcode : integer;
   R : real;
   f : real;
   sign : string;
   dSep : char;
   dThou : char;
   toplevel : integer;
   formula1 : string;
begin
     test := '';
     c := '';
     eq := equation;
     var1 := 0;
     var2 := 0;
     v1 := '';
     v2 := '';
     formula := '';
     sum := 0;
     final := '';
     done := false;
(*     ReportProcess('Solving: '+equation); *)
     if (FVisual) and (EvalVisual <> nil) then
     begin
       EvalVisual.solving.caption := equation;
       application.processmessages;
     end;

     if not IsEquation(equation) then
     begin
       Result := equation;
       exit;
     end;
   If Pos('^',eq) > 0 then
     toplevel := 4
   else if (Pos('*',eq) > 0) or (Pos('/',eq) > 0 ) or (Pos('!',eq) > 0)
     or (Pos('%',eq) > 0) then
       toplevel := 3
   else if (Pos('+',eq) > 0) or (Pos('-',eq)>0) then
     toplevel := 2
   else
     toplevel := 1;
   while not done do
   begin
     for p := toplevel downto 1 do { for each precedence level }
     begin
       pos1 := 0;
       pos2 := 0;
       i := 1;
       while i <= length(eq) do
       begin
         If not IsEquation(eq) then
          break;
         {new jct}
         if (i > length(eq)) and (p = 1) then
          break;

         c := eq[i];

         If (IsOperator(c)) and (OpPrecedence(c) = p) and (i > 1) then
         begin
           v1 := '';
           oppos := i;
           j := oppos-1;
           while j >= 0 do
           begin
             e := eq[j];
             If (IsOperator(e)) and (j <> 1) then
               break;
             dec(j);
           end;
           pos1 := j + 1;
           if pos1 = 0 then inc(pos1);
           j := oppos + 1;
          If j < length(eq) then
          begin
           while j <= length(eq) do
           begin
             e := eq[j];
             If (IsOperator(e)) and (j <> (oppos + 1)) then
               break;
             inc(j);
           end;
          end
          else
            j := length(eq) + 1;
           pos2 := j-1;
           v1 := Copy(eq,pos1,oppos-pos1);
           dSep := DecimalSeparator;
           dThou := ThousandSeparator;

           Val(v1,R,xcode);

           DecimalSeparator := dSep;
           ThousandSeparator := dThou;
           if (xcode <> 0) and (length(v1) > 0) then
           begin
             sign := v1[1];
             if (sign <> '+') and (sign <> '-') then
               sign := '';
             FAccept := false;
             If sign <> '' then
               v1 := Copy(v1,2,length(v1)-1);
             If Assigned(FOnGetVariable) then
             begin
               Reportprocess('Getting variable: '+v1);
               OnGetVariable(v1,FValue,FAccept);
             end;
             if FAccept then
             begin
               dSep := DecimalSeparator;
               dThou := ThousandSeparator;
               DecimalSeparator := '.';
               ThousandSeparator := ',';
               v1 := Floattostr(FValue);
               v1 := sign + v1;
               Val(v1,R,xcode);
               DecimalSeparator := dSep;
               ThousandSeparator := dThou;
             end;
             if (xcode > 0) or (FAccept = false) then
             begin
               FErrorNumber := 3;
               FErrorText := 'Unrecognized Variable ' + v1;
               ReportError(FErrorText);
               If Assigned(FOnError) then OnError(FErrorNumber,FErrortext);
               FAbort := true;
               FResults := 0.0;
               exit;
             end;
             if not FAccept then
             begin
               FAbort := true;
               FResults := 0.0;
               exit;
             end;
           end;
           if c <> '!' then
           begin
             v2 := Copy(eq,oppos+1,pos2-oppos);
             dSep := DecimalSeparator;
             dThou := ThousandSeparator;
             Val(v2,R,xcode);
             DecimalSeparator := dSep;
             ThousandSeparator := dThou;
             if (xcode <> 0) and (length(v2) > 0) then
             begin
               sign := v2[1];
               if (sign <> '+') and (sign <> '-') then
                 sign := '';
                FAccept := false;
               If sign <> '' then
                 v2 := Copy(v2,2,length(v2)-1);
               If length(v2) > 0 then
               begin
                If Assigned(FOnGetVariable) then
                begin
                  ReportProcess('Getting variable: '+v2);
                  OnGetVariable(v2,FValue,FAccept);
                end;
                if FAccept then
                begin
                  dSep := DecimalSeparator;
                  dThou := ThousandSeparator;
                  DecimalSeparator := '.';
                  v2 := Floattostr(FValue);
                  v2 := sign + v2;
                  Val(v2,R,xcode);
                  DecimalSeparator := dSep;
                  ThousandSeparator := dThou;
                end;
                if (xcode > 0) or (FAccept = false) then
                begin
                 FErrorNumber := 3;
                 FErrorText := 'Unrecognized Variable ' + v2;
                 ReportError(FErrorText);
                 If Assigned(FOnError) then OnError(FErrorNumber,FErrortext);
                 FAbort := true;
                 FResults := 0.0;
                 exit;
                end {if v2 > 0}
               end;
               if not FAccept then
               begin
                FAbort := true;
                FResults := 0.0;
                exit;
               end;
             end;
             if length(v2) = 0 then
               formula := v1+c+Floattostr(sum)
             else
               formula := v1+c+v2;
           end;{<> '!'}
           if c = '!' then
             formula := v1+c;
           if (FVisual) and (EvalVisual <> nil) and (not gclosevisual) then
           begin
             EvalVisual.solving.caption := formula;
(*             EvalVisual.simplify.caption := test; *)
             application.processmessages;
             if FVisual and FStepMode then
             begin
               gstep := true;
               while gstep and not gruntoend do
                 Application.processmessages;
             end;

           end;

           temp := Solve(formula);
           If FAbort then
           begin
            FResults := 0.0;
            exit;
           end;
           (*jct*)
(*           Delete(test,pos1,(pos2-pos1)+1);
           Insert(temp,test,pos1);  *)
           (*eq := equation; *)
           formula1 := Copy(equation,pos1,pos2-pos1+1);
           eq := replace(eq,temp,formula1);
           equation := eq;
           {replace the results of solve}
           if (FVisual) and (EvalVisual <> nil) and (not gclosevisual) then
           begin
             EvalVisual.simplify.caption := eq;
             application.processmessages;
           end;

           i := 1;
           val(temp,sum,xcode);
           if xcode > 0 then
             sum := 0;
(*           sum := Strtofloat(temp); *)
           temp := '';
           v1 := '';
           v2 := '';
         end
         else
           inc(i);
       end; {while i < length(eq);}

     end; {for p}
     If Isequation(eq) then
      done := false
     else
      done := true;
     Application.Processmessages;
     if (i > length(eq)) and (p = 1) then
       done := true;
   end; {while}
   final := Floattostrf(sum,ffGeneral,20,18);
   Result := final;
end;
function OpPrecedence(op:string) : integer;
begin
     If (op = '*') or (op = '/') or (op = '%') or (op = '!') then
       Result := 3
     else If (op = '^') then
       Result := 4
     else If (op = '+') or (op = '-') then
       Result := 2
     else if (op = '>') or (op = '<') or (op = '=') then
       result := 1
     else
       Result := 0;

end;
function IsOperator(op:string) : boolean;
var
   res : boolean;
begin
     res := false;
     If Pos(op,'+-*/^%!=><') > 0 then
       res := true;
     Result := res;
end;
function TVisEval.solve(equation:string) : string;
var
   i : integer;
   s : string;
   test : string;
   c : string;
   var1 : real;
   var2 : real;
   sum : real;
   len : integer;
   v1 : string;
   v2 : string;
   haveoperator : boolean;
   xcode :integer;
   op : string;
   power : integer;
   dSep : char;
   dThou : char;
begin
   If FAbort then
   begin
     FResults := 0.0;
     exit;
   end;
   Reportprocess('Solving: '+equation);
   var1 := 0;
   var2 := 0;
   v1 := '';
   v2 := '';
   op := '';

   if (FVisual) and (EvalVisual <> nil) then
   begin
     EvalVisual.solving.caption := equation;
     application.processmessages;
(*     if FVisual and FStepMode then
     begin
       gstep := true;
       while gstep do
         Application.processmessages;
     end;  *)
   end;

   len := length(equation);
   haveoperator := false;
   for i := 1 to len do
   begin
     c := equation[i];
     If (Not IsOperator(c)) or (i = 1) or (haveoperator) then
     begin
       If not haveoperator then
         v1 := v1 + c
       else
         v2 := v2 + c;
     end
     else
     begin
       haveoperator := true;
       op := c;
     end;
   end; {for}
   dSep := DecimalSeparator;
   dThou := ThousandSeparator;
   DecimalSeparator := '.';
   ThousandSeparator := ',';

(*   var1 := strtofloat(v1);
   var2 := strtofloat(v2);   *)
   val(v1,var1,xcode);
   val(v2,var2,xcode);
   DecimalSeparator := dSep;
   ThousandSeparator := dThou;
   if op = '+' then
     sum := var1 + var2
   else if op = '-' then
     sum := var1 - var2
   else if op = '*' then
     sum := var1 * var2
   else if op = '=' then
   begin
     if var1 = var2 then
       sum := 1
     else
       sum := 0;
   end
   else if op = '<' then
   begin
     if var1 < var2 then
       sum := 1
     else
       sum := 0;
   end
   else if op = '>' then
   begin
     if var1 > var2 then
       sum := 1
     else
       sum := 0;
   end
   else if op = '/' then
     begin
      If var2 = 0 then
      begin
        FErrorNumber := 1;
        FErrorText := 'Divide by Zero';
        ReportError(FErrorText);
        FAbort := true;
        FResults := 0.0;
        If Assigned(FOnError) then OnError(FErrorNumber,FErrorText);
        exit;
      end;
      sum := var1 / var2
     end
   else if op = '^' then
   begin
    sum := var1;
    power := Round(var2);
    try
    if power = 0 then
    begin
      sum := 1;
      Result := Floattostrf(sum,ffGeneral,20,18);
      exit;
    end;
    i := 1;
    while i < abs(power) do
    begin
      try
        sum := sum * var1;
      except
        on EOverflow do
        begin
          FErrorNumber := 5;
          FErrorText := 'Overflow';
          ReportError(FErrorText);
          If Assigned(FOnError) then OnError(FErrorNumber,FErrortext);
          sum := 0;
          FAbort := true;
(*          break; *)
          exit;
        end;
      end;
      inc(i);
    end;
    If power < 0 then
      sum := 1/sum;

{      sum := Exp(Ln(var1)*round(var2)); }
    except
      on EOverflow do
      begin
        FErrorNumber := 5;
        FErrorText := 'Overflow';
        ReportError(FErrorText);
        If Assigned(FOnError) then OnError(FErrorNumber,FErrortext);
         sum := 0;
      end;
     end;
   end
   else if op = '!' then
   begin
     sum := abs(var1);
     i := Round(abs(var1));
     dec(i);
     while i > 0 do
     begin
       try
         sum := sum * i;
       except (* check for overflow *)
       on EOverflow do
       begin
          FErrorNumber := 5;
          FErrorText := 'Overflow';
          ReportError(FErrorText);
          If Assigned(FOnError) then OnError(FErrorNumber,FErrortext);
          sum := 0;
          FAbort := true;
          exit;
        end;
       end;
       dec(i);
     end;
     if var1 < 0 then
       sum := -sum;
   end
   else if op = '%' then
     sum := Round(var1) mod Round(var2);
   if not haveoperator then
     sum := var1;
   Result := FloattoStrf(sum,ffGeneral,20,18);
   Reportprocess('Result: '+result);

end;
procedure TVisEval.condensesigns(var eq:string);
var
     i : integer;
     k : integer;
     temp : string;
begin
     while (Pos('++',eq) > 0) or (Pos('--',eq) > 0) or
           (Pos('+-',eq) > 0) do
     begin
       i := Pos('++',eq);
       if i > 0 then
       begin
         temp := replace(eq,'+','++');
         eq := temp;
       end;
       i := Pos('+-',eq);
       if i > 0 then
       begin
         temp := replace(eq,'-','+-');
         eq := temp;
       end;
       i := Pos('--',eq);
       if i > 0 then
       begin
         temp := replace(eq,'+','--');
         eq := temp;
       end;
       i := Pos('-+',eq);
       if i > 0 then
       begin
         temp := replace(eq,'-','-+');
         eq := temp;
       end;

     end;
end;
function TVisEval.solvenested(equation:string):string;
var
   BegParen,EndParen : integer;
   eq : string;
   temp : string;
   i : integer;
   formula : string;
   target : string;

begin
     eq := equation;
     temp := '';
     condensesigns(eq);
     if (Pos('(',equation) = 0) and (Pos(')',equation)=0) then
     begin
       result := eq;
       exit;
     end;
     while (Pos('(',eq) > 0) and (Pos(')',eq) > 0) do
     begin
       ReportProcess('Substituting...');
       EndParen := Pos(')',eq);  (* get position of first ending paren *)
       for i := Endparen downto 1 do
       begin
         if eq[i] = '(' then
         begin
           BegParen := i; (* beginning Parentheses position *)
           break;
         end;
       end;
(*       If Begparen > 1 then
         temp := Copy(eq,1,begparen-1)
       else
         temp := '';  *)
       if (endparen - begparen) = 1 then
       begin (*eliminate empty parens*)
         target := '()';
         formula := '0';
         temp := '0';
         eq := replace(eq,temp,target);
       end
       else
       begin
         target := copy(eq,begparen,endparen-begparen+1);
         formula := Copy(eq,Begparen+1,endparen-begparen-1);
         temp := solveit(formula);
         eq := replace(eq,temp,target);
       end;
       Reporttomemo(eq);

     end;
     result := eq;
end;
(* function TVisEval.substitute(equation:string):string;
var

   i : integer;
   c : string;
   BegParen : integer;
   EndParen : integer;
   equate : string;
   eq : string;
   temp : string;
   r : real;
   code : integer;
begin
     If FAbort then exit;
     ReportProcess('Substituting...');
     ReportProcess(equation);
     c := '';

     if length(equation) <= 0 then exit;
     If (Pos('(',equation)=0) or (Pos(')',equation)=0) then
     begin
       result := equation;
       exit;
     end;
     BegParen := 0;
     EndParen := 0;
     eq := equation;
     EndParen := Pos(')',eq);
     for i := EndParen downto 1 do
       if eq[i] = '(' then
       begin
         BegParen := i;
         break;
       end;
     equate := '';
     temp := '';
     If (EndParen > BegParen) and (BegParen > 0) then
     begin
       if begparen > 1 then
         temp := copy(eq,1,begparen-1)
       else
         temp := '';
       equate := Copy(eq,BegParen+1,EndParen-1-BegParen);
       val(equate,r,code);
       if code > 0 then
       begin
         temp := temp + Solveit(equate);
         temp := temp + copy(eq,EndParen+1,length(equation)-EndParen);
       end
       else
         temp := temp+equate+copy(eq,EndParen+1,length(equation)-EndParen);
       if (FVisual) and (EvalVisual <> nil) then
       begin
         EvalVisual.simplify.caption := eq;
         application.processmessages;
       end;

     end;
     if length(temp) > 0 then
       Result := temp
     else
       Result := equation;
     Reportprocess(result);
     If FVisual and not gclosevisual then
     begin
       evalvisual.simplify.caption := result;
       application.processmessages;
     end;
end;  *)
function TVisEval.evaluate(eq:string):string;
var
   s : string;
   i : integer;
   r : real;
   code : integer;
begin

     FAbort := false;
     If FVisual and not gclosevisual then
     begin
       evalvisual.simplify.caption := eq;
       Reportprocess('Evaluating...');
       evalvisual.memo1.lines.add(eq);
       application.processmessages;
     end;
     val(eq,r,code);
     if code = 0 then
     begin
       result := eq;
       exit;
     end;
     (* find any ')(' and insert ')*(' implied multiplier *)
     While Pos(')(',eq) > 0 do
     begin
       eq := replace(eq,')*(',')(');
     end;
(*     s := Substitute(eq); *)
     s := solvenested(eq); (* new jct *)
     s := Simplify(s);
     {for the following code... if the original
     is not an equation, then it may be a variable
     name so just get it and return it}

     if not isequation(s) and (code > 0) then
     begin
       If Assigned(FOnGetVariable) then
       begin
         OnGetVariable(s,FValue,FAccept);
         if FAccept then
         begin
           evaluate := Floattostrf(Fvalue,ffGeneral,20,18);
           exit;
         end
         else
         begin
           FErrorNumber := 3;
           FErrorText := 'Unrecognized Variable ' + s;
           ReportError(FErrorText);
           If Assigned(FOnError) then OnError(FErrorNumber,FErrortext);
           FAbort := true;
           FResults := 0.0;
           evaluate := '';
           exit;
         end;
       end
       else
       begin
         evaluate := '';
         exit;
       end;
     end; {if not is equation}
 {    s := eq; }
     while (Pos('(',s)<>0) and (Pos(')',s)<>0) do
     begin

(*       s := Substitute(s); *)
(*       s := solvenested(s);*) (* jct new *)
       s := Simplify(s);
       If FAbort then
        break;
       application.processmessages;
     end;
     If not FAbort then
     begin
(*       if (FVisual) and (EvalVisual <> nil) then
       begin
         EvalVisual.simplify.caption := eq;
         if FVisual and FStepMode then
         begin
           gstep := true;
           while gstep do
             Application.processmessages;
         end;
       end;   *)

       Result := Solveit(s)
     end
     else
       Result := '';

end;
Function TVisEval.Simplify(eq:string):string;
var
   s : string;
   i : integer;
   r : real;
   code : integer;
   temp,temp1 : string;
begin
     Reportprocess('Simplifying...');
     Reportprocess(eq);
     val(eq,r,code);
     if code = 0 then
     begin
       result := eq;
       exit;
     end;
     s := '';
(*     for i := 1 to length(eq) do  *)
     i := 1;
     while i <= length(eq) do
     begin
       if i < length(eq) then
       begin
         if (IsDigit(eq[i+1])) and (eq[i]=')') then
           s := s + eq[i] + '*'
         else if (IsDigit(eq[i])) and (eq[i+1]='(') then
           s := s + eq[i] + '*'
         else if (eq[i] = '-') and (eq[i+1] = '-') then
         begin
           s := s + '+';
           inc(i);
         end
         else if (eq[i] = '-') and (eq[i+1] = '+') then
         begin
           s := s + '-';
           inc(i);
         end
         else if (eq[i] = '+') and (eq[i+1] = '-') then
         begin
           s := s + '-';
           inc(i);
         end
         else if (eq[i] = '+') and (eq[i+1] = '+') then
         begin
           s := s + '+';
           inc(i);
         end

         else if (eq[i] = ')') and (eq[i+1] = '(') then
           s := s + eq[i] + '*'
         else If (Pos('*)',eq) > 0) or
            (Pos('^)',eq) > 0) or
            (Pos('/)',eq) > 0) or
            (Pos('(*',eq) > 0) or
            (Pos('(^',eq) > 0) or
            (Pos('(/',eq) > 0) or
            (Pos('(!',eq) > 0) or
            (Pos('()',eq) > 0) then
            begin
              Ferrornumber := 4;
              Ferrortext := 'Invalid Expression';
              ReportError(FErrorText);
              If Assigned(FonError) then OnError(Ferrornumber,Ferrortext);
              FAbort := true;
              FResults := 0;
              Simplify := '';
              exit;
            end
         else if IsOperator(eq[i]) and IsOperator(eq[i+1]) then
         begin
           if eq[i] = '!' then
           begin
             temp := copy(eq,1,i);
             temp1 := copy(eq,i+1,length(eq));
             s := solve(temp)+temp1;
             result := s;
             exit;
           end;
           if (eq[i+1] <> '+') and (eq[i+1] <> '-') then
           begin
             FErrorNumber := 6;
             FErrorText := 'Missing Operator';
             ReportError(FErrorText);
             If Assigned(FOnError) then OnError(FErrorNumber,FErrorText);
             Result := '';
             FAbort := true; {handled here}
             FResults := 0;
             Simplify := '';
             exit;
           end
           else
             s := s + eq[i];
         end
         else if eq[i] <> ' ' then
           s := s + eq[i];
       end
       else
        s := s + eq[i];
       inc(i);
     end; {while}
       Simplify := s;

end;
function clearwhitespace(s:string):string;
var
   i : integer;
   c : string;
begin
     c := '';
     for i := 1 to length(s) do
     begin
       if (s[i] <> ' ') and (s[i] <> ThousandSeparator) then
         c := c + s[i];
     end;
     Result := c;
end;
function ParensBalanced(s:string):boolean;
var
   i : integer;
   numbeg,numend : integer;
begin
     Numend := 0;
     numbeg := 0;
     for i := 1 to length(s) do
     begin
       if s[i] = '(' then
         inc(NumBeg);
       if s[i] = ')' then
         inc(NumEnd)
     end;
     if Numend = numbeg then
       ParensBalanced := true
     else
       ParensBalanced := false;
end;


end.
