unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Decode, Encode, StdCtrls, ExtCtrls,Progrss, Menus,
  About;

type
  TForm1 = class(TForm)
    UUEncode1: TUUEncode;
    UUDecode1: TUUDecode;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Encode1: TMenuItem;
    EncodeMany1: TMenuItem;
    N1: TMenuItem;
    Decode1: TMenuItem;
    DecodeMultiple1: TMenuItem;
    DecodeSingleFile1: TMenuItem;
    N2: TMenuItem;
    ListHeaders1: TMenuItem;
    Panel1: TPanel;
    ListBox1: TListBox;
    AddFile: TButton;
    EncAll: TButton;
    DecOne: TButton;
    Help1: TMenuItem;
    About1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure UUEncode1Progress(sourceFileName, currentFileName: String);
    procedure UUEncode1Error(ErrorCode: Integer; ErrorMessage: String);
    procedure Button2Click(Sender: TObject);
    procedure AddFileClick(Sender: TObject);
    procedure EncAllClick(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure UUDecode1Error(ErrorCode: Integer; ErrorMessage: string80);
    procedure UUDecode1Progress(sourceFileName, currentFileName: string80);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure DecOneClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckState;
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

CONST
 oper_none: integer =-1;
 oper_decode: integer =0;
 oper_encode: integer =1;
 oper_multi: integer =2;

var
  Form1: TForm1;
  currentUUEOperation: integer;
  detailUUEOperation: integer;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  OpenDialog1.FilterIndex:=0;
  if OpenDialog1.Execute then
  begin
    currentUUEOperation:=oper_encode;
    detailUUEOperation:=oper_none;
    UUEnCode1.SourceFileName:=OpenDialog1.FileName;
    CheckState;
    SaveDialog1.Title:='Create UUE File';
    if SaveDialog1.Execute then
    begin
 {*
 ** The currentUUEOperation is simply for this example. We will use it
 ** to keep track of what type of UUE operation is going on. This will allow
 ** our Progress screen to tell the correct UUE operation to abort if the button
 ** is pressed
 *}
     currentUUEOperation:=oper_encode;

     UUEnCode1.DestinationFileName:=SaveDialog1.FileName;
     form2.StartProgress;
     UUEncode1.EncodeFile;
     form2.EndProgress;
    end;
  end;
end;

procedure TForm1.UUEncode1Progress(sourceFileName,
  currentFileName: String);
begin
   form2.UpdateProgress(sourceFileName,currentFileName);
end;

procedure TForm1.UUEncode1Error(ErrorCode: Integer; ErrorMessage: String);
begin
  MessageDlg(ErrorMessage,mtError,[mbOK],0);
  MessageDlg('This was the handler for the UUEncode OnError Event',mtError,[mbOK],0);
  form2.EndProgress;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   currentUUEOperation:=oper_encode;
   detailUUEOperation:=oper_multi;
   CheckState;
   ListBox1.Items.Clear;
end;

procedure TForm1.AddFileClick(Sender: TObject);
begin
if currentUUEOperation<>oper_encode then exit;
  OpenDialog1.FilterIndex:=0;
  if OpenDialog1.Execute then
  begin
    EncAll.Enabled:=TRUE;
    ListBox1.Items.Add(OpenDialog1.FileName);
  end;
end;

procedure TForm1.EncAllClick(Sender: TObject);
begin
 if currentUUEOperation<>oper_encode then exit;
    SaveDialog1.Title:='Create UUE File';
    if SaveDialog1.Execute then
    begin
 {*
 ** The currentUUEOperation is simply for this example. We will use it
 ** to keep track of what type of UUE operation is going on. This will allow
 ** our Progress screen to tell the correct UUE operation to abort if the button
 ** is pressed
 *}
     currentUUEOperation:=oper_encode;
     UUEnCode1.DestinationFileName:=SaveDialog1.FileName;
     form2.StartProgress;
     UUEncode1.EncodeFiles(ListBox1.Items);
     form2.EndProgress;
    end;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
 ListBox1.Items.Clear;
 OpenDialog1.Title:='Select a UUE file to list';
 OpenDialog1.FilterIndex:=4;
  if OpenDialog1.Execute then
  begin
    currentUUEOperation:=oper_none;
    detailUUEOperation:=oper_none;
    CheckState;
    UUDecode1.SourceFileName:=OpenDialog1.FileName;
    UUDecode1.ListHeaders(ListBox1.Items);
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  OpenDialog1.Title:='Enter the UUE file to decode';
  OpenDialog1.FilterIndex:=4;
  if OpenDialog1.Execute then
  begin
    currentUUEOperation:=oper_decode;
    detailUUEOperation:=oper_none;
    CheckState;
    UUDecode1.SourceFileName:=OpenDialog1.FileName;
    SaveDialog1.Title:='Select a directory to decode the file(s) to';
    if SaveDialog1.Execute then
    begin
 {*
 ** The currentUUEOperation is simply for this example. We will use it
 ** to keep track of what type of UUE operation is going on. This will allow
 ** our Progress screen to tell the correct UUE operation to abort if the button
 ** is pressed
 *}
     currentUUEOperation:=oper_decode;

     UUDecode1.TargetDirectory:=ExtractFilePath(SaveDialog1.FileName);
     form2.StartProgress;
     UUDecode1.DecodeFile;
     form2.EndProgress;
    end;
  end;

end;

procedure TForm1.UUDecode1Error(ErrorCode: Integer;
  ErrorMessage: string80);
begin
  MessageDlg(ErrorMessage,mtError,[mbOK],0);
  MessageDlg('This was the handler for the UUDecode OnError Event',mtError,[mbOK],0);
  form2.EndProgress;
end;

procedure TForm1.UUDecode1Progress(sourceFileName,
  currentFileName: string80);
begin
   form2.UpdateProgress(sourceFileName,currentFileName);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  ListBox1.Items.Clear;
  OpenDialog1.Title:='Enter the UUE file to decode';
  OpenDialog1.FilterIndex:=4;
  if OpenDialog1.Execute then
  begin
    currentUUEOperation:=oper_decode;
    detailUUEOperation:=oper_multi;
    CheckState;
    UUDecode1.SourceFileName:=OpenDialog1.FileName;
    SaveDialog1.Title:='Select a directory to decode the file(s) to';
    if SaveDialog1.Execute then
    begin
 {*
 ** The currentUUEOperation is simply for this example. We will use it
 ** to keep track of what type of UUE operation is going on. This will allow
 ** our Progress screen to tell the correct UUE operation to abort if the button
 ** is pressed
 *}
     currentUUEOperation:=oper_decode;

     UUDecode1.TargetDirectory:=ExtractFilePath(SaveDialog1.FileName);
     form2.StartProgress;
     UUDecode1.DecodeFiles;
     form2.EndProgress;
    end;
  end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 ListBox1.Items.Clear;
 OpenDialog1.Title:='Select a UUE file';
 OpenDialog1.FilterIndex:=4;
  if OpenDialog1.Execute then
  begin
    currentUUEOperation:=oper_decode;
    detailUUEOperation:=oper_multi;
    CheckState;
    UUDecode1.SourceFileName:=OpenDialog1.FileName;
    UUDecode1.ListHeaders(ListBox1.Items);
  end;
end;

procedure TForm1.DecOneClick(Sender: TObject);
begin
if currentUUEOperation <>oper_decode then exit;
SaveDialog1.Title:='Select a directory to decode the file to';
if SaveDialog1.Execute then
 begin
  UUDecode1.TargetDirectory:=ExtractFilePath(SaveDialog1.FileName);
   with ListBox1 do
   begin
     if ItemIndex>-1 then
     begin
      form2.StartProgress;
      UUDecode1.DecodeSingleFile(items[ItemIndex]);
      form2.EndProgress;
     end;
   end;
 end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  currentUUEOperation:=oper_none;
  detailUUEOperation:=oper_none;
end;

procedure TForm1.CheckState;
begin
  if (currentUUEOperation=oper_decode) and
     (detailUUEOperation=oper_multi) then
      DecOne.Enabled:=TRUE
     else
      DecOne.Enabled:=FALSE;

  if (currentUUEOperation=oper_encode) and
     (detailUUEOperation=oper_multi) then
      AddFile.Enabled:=TRUE
     else
     begin
      AddFile.Enabled:=FALSE;
      EncAll.Enabled:=FALSE;
     end;

end;

procedure TForm1.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

end.
