unit WCSEXAMP;
{ - Example unit for TWCSDIRSEARCH Component}

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes, WinProcs, 
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Dcdirsrc, StdCtrls, FileCtrl, ExtCtrls;

type
  TForm1 = class(TForm)
    DirDialog1: TDirDialog;
    WCSDirSearch1: TWCSDirSearch;
    Label1: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    BtnSearch: TButton;
    Button3: TButton;
    BtnAbort: TButton;
    ListBox1: TListBox;
    Label2: TLabel;
    Label3: TLabel;
    ListBox2: TListBox;
    PnlStatus: TPanel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BtnSearchClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure BtnAbortClick(Sender: TObject);
    procedure WCSDirSearch1Completion(Sender: TObject);
    procedure WCSDirSearch1FindFile(Sender: TObject; FileName: string);
    procedure WCSDirSearch1FindSubDir(Sender: TObject;
      DirectoryPath: string; DirectoryLevel: Word);
    procedure WCSDirSearch1FindFileDetail(Sender: TObject;
      FileBreak: TFileBreak);
  private
    { Private declarations }
    SearchComplete,
    Aborted : Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if DirDialog1.Execute then
    Edit1.Text := DirDialog1.Directory;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.BtnSearchClick(Sender: TObject);
begin
  if DirectoryExists(Edit1.Text) then
{ - This is in Delphi FileCtrl unit}
  begin

{ - Set the start directory for the search}
    WCSDirSearch1.dsStartDir := Edit1.Text;

{ - Set up the variables being used to track the search and collect info}
    BtnSearch.Enabled := False;
    ListBox1.Clear;
    ListBox2.Clear;
    Screen.Cursor := crHourGlass;
    SearchComplete := False;
    Aborted := False;
    PnlStatus.Caption := 'Searching....';
    PnlStatus.Refresh;
    BtnAbort.Enabled := True;
    BtnAbort.Refresh;

{ - Begin the Search}
    WCSDirSearch1.Execute;

{ - Wait for search to finish}
    repeat
      Application.ProcessMessages;
    until SearchComplete or Aborted;


    if SearchComplete then
      PnlStatus.Caption := 'Search Complete'
    else
      PnlStatus.Caption := 'Search Aborted';
    Screen.Cursor := crDefault;
    ShowMessage(PnlStatus.Caption);

    BtnAbort.Enabled := True;
    BtnSearch.Enabled := True;
  end else
    ShowMessage('Start Directory does not exist!');

end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  BtnSearch.Enabled := Edit1.Text > '';
end;

procedure TForm1.BtnAbortClick(Sender: TObject);
begin
  WCSDirSearch1.HaltSearch;
  Aborted := True;
  Screen.Cursor := crDefault;
end;

procedure TForm1.WCSDirSearch1Completion(Sender: TObject);
begin
{ - Search ended}
  if not Aborted then
    SearchComplete := True;
end;

procedure TForm1.WCSDirSearch1FindFile(Sender: TObject; FileName: string);
var
  Pad : String;
  i : integer;
begin
{ - Add the file name to the list padded to 60 chars}
  Pad := '';
  While Length(Pad+FileName) < 60 do
    Pad := Pad + '.';
  ListBox2.Items.Add(FileName + Pad);
end;

procedure TForm1.WCSDirSearch1FindSubDir(Sender: TObject;
  DirectoryPath: string; DirectoryLevel: Word);
var
  Pad : String;
  i : integer;
begin
{ - Add the directory name to the list and pad to show levels}
  Pad := '';
  for i := 0 to DirectoryLevel-1 do
    Pad := '|-- ' + Pad;
  ListBox1.Items.Add(Pad + DirectoryPath);
end;

procedure TForm1.WCSDirSearch1FindFileDetail(Sender: TObject;
  FileBreak: TFileBreak);
begin
{ - Add the file details to the last item in the file list}
{NOTE : If you do not define this event, the search will
        be faster as it does not create the Filebreak structure}
  with FileBreak do
    ListBox2.Items[ListBox2.Items.Count-1] :=
      ListBox2.Items[ListBox2.Items.Count-1] +
        FormatDateTime('dd mmm yyyy hh:mm',FileDateTime) + '  ' +
        FormatFloat('##,###,##0 bytes',FileByteSize);
end;

end.
