unit WRunMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, wexeclib;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ErrorLog: TListBox;
    Splitter1: TSplitter;
    DebugLog: TListBox;
    Splitter2: TSplitter;
    ReDirectLog: TListBox;
    eCommand: TEdit;
    bStart: TButton;
    rbNormal: TRadioButton;
    rbHide: TRadioButton;
    rbRedirect: TRadioButton;
    cbWait: TCheckBox;
    cbDOS: TCheckBox;
    bClear: TButton;
    bAbort: TButton;
    RunProcess1: TRunProcess;
    procedure bStartClick(Sender: TObject);
    procedure RunProcess1Error(Sender: TObject; const Msg: String);
    procedure RunProcess1Debug(Sender: TObject; const msg: String);
    function RunProcess1TaskSwitch(Sender: TObject): Boolean;
    procedure bClearClick(Sender: TObject);
    procedure bAbortClick(Sender: TObject);
    procedure RunProcess1RedirectChar(Sender: TObject; const ch: Char);
  private
    { Private declarations }
    Data : String;
    Procedure ClearLogs;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Procedure TForm1.ClearLogs;
begin
  ErrorLog.Clear;
  DebugLog.Clear;
  RedirectLog.Clear;
end;

procedure TForm1.bClearClick(Sender: TObject);
begin
 ClearLogs;
end;

procedure TForm1.bAbortClick(Sender: TObject);
begin
  RunProcess1.AbortWait := TRUE;
end;

procedure TForm1.bStartClick(Sender: TObject);
begin
  Data := '';
  ClearLogs;
  bStart.Enabled := FALSE;
  bAbort.Enabled := TRUE;
  RunProcess1.UseComSpec := cbDOS.Checked;
  RunProcess1.UseWait    := cbWait.Checked;
  if rbNormal.Checked then
     RunProcess1.UseShow    := EXEC_DEFAULT;
  if rbHide.Checked then
     RunProcess1.UseShow    := EXEC_HIDE;
  if rbRedirect.Checked then
     RunProcess1.UseShow    := EXEC_REDIRECT;
  RunProcess1.Command    := eCommand.Text;
  RunProcess1.Execute;
  bStart.Enabled := TRUE;
  bAbort.Enabled := FALSE;
end;

procedure TForm1.RunProcess1Error(Sender: TObject; const Msg: String);
begin
  ErrorLog.Items.Add(Msg);
end;

procedure TForm1.RunProcess1Debug(Sender: TObject; const msg: String);
begin
  DebugLog.Items.Add(Msg);
end;

function TForm1.RunProcess1TaskSwitch(Sender: TObject): Boolean;
begin
  Result := TRUE;
  Application.ProcessMessages;
end;

procedure TForm1.RunProcess1RedirectChar(Sender: TObject; const ch: Char);
begin
 if Not (ch in [#13,#10]) then data := data + ch;
 if ch = #10 then
    begin
     RedirectLog.Items.Add(Data);
     Data := '';
     Application.ProcessMessages;
    end;
end;

end.
