unit RegForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    btnInsert: TButton;
    Memo2: TMemo;
    btnCleanUp: TButton;
    BitBtn1: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure btnInsertClick(Sender: TObject);
    procedure btnCleanUpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
Uses
  WinReg;

{$R *.DFM}

// define a constant to hold our registry key
const
  APP_REG_KEY = 'software\Dave White\Test Registry';

// a record to test the binary storage format
type
  TTestRecord = record
    Left    : integer;
    Top     : integer;
    Width   : integer;
    Height  : integer;
    State   : TWindowState;
  end;


procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.btnInsertClick(Sender: TObject);
var
  reg       : TWinRegistry;
  aString   : string;
  aInteger  : integer;
  aBoolean  : boolean;
  aCurrency : Currency;
  aFloat    : double;
  aDate     : TDateTime;
  aTime     : TDateTime;
  aDateTime : TDateTime;
  aRecord   : TTestRecord;

begin
  // we'll store some of the test fields in a section called TestSection
  // and the rest in AnotherTestSection - original huh?

  // open the registry using the default root of HKEY_CURRENT_USER
  reg := TWinRegistry.Create(APP_REG_KEY);

  // initialise the variables
  aString := 'This is a test string';
  aInteger := 1234;
  aBoolean := true;
  aCurrency := 456.78;
  aFloat := 123.456;
  aDateTime := Now;
  aDate := StrToDateTime('4/20/96');
  aTime := Time;
  with aRecord do
  begin
    Left := 20;
    Top := 30;
    Width := 200;
    Height := 400;
    State := wsNormal;
  end;

  // write the variables to the registry
  with reg do
  begin
    WriteString('TestSection', 'Description', aString);
    WriteInteger('TestSection', 'IntCount', aInteger);
    WriteBool('TestSection', 'ShowToolTips', aBoolean);
    WriteCurrency('TestSection', 'Total Cost', aCurrency);
    WriteFloat('AnotherTestSection', 'Frequency', aFloat);
    WriteDateTime('AnotherTestSection', 'Date and Time', aDateTime);
    WriteDate('AnotherTestSection', 'Current Date', aDate);
    WriteTime('AnotherTestSection', 'Current Time', aTime);
    WriteBinaryData('AnotherTestSection', 'Form Position', aRecord, SizeOf(aRecord));
  end;
  reg.Free;
  MessageDlg('Fields have been written.  Use REGEDIT to view them.', mtInformation, [mbOK], 0);
end;

procedure TForm1.btnCleanUpClick(Sender: TObject);
var
  reg       : TWinRegistry;
begin
  reg := TWinRegistry.Create('software');
  reg.EraseSection('Dave White');
  reg.Free;
  MessageDlg('Changes have been undone.  Use REGEDIT to confirm.', mtInformation, [mbOK], 0);
end;

end.

