unit Aaqbldr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DsgnIntf;

type

  TAaQBuilder = class(TComponent)
  public
    procedure SetFormAsControl;
  end;

  TAaQBuilderEditor = class(TComponentEditor)
  public
    procedure ExecuteVerb(index: integer);override;
    function GetVerb(index: integer): string;override;
    function GetVerbCount: integer;override;
  end;

procedure Register;


implementation


{==============================================================================}

procedure Register;
begin
  RegisterComponents('Samples', [TAaQBuilder]);
  RegisterComponentEditor(TAaQBuilder, TAaQBuilderEditor);
end;

{==============================================================================}

procedure TAaQBuilder.SetFormAsControl;
begin
  if (Owner as TForm).Designer <> nil then begin
    (Owner as TForm).Designer.IsControl := true;
    Application.MessageBox('You should now remove the builder component, ' +
      'add a reference to AaWiz in the uses clause, change the form''s ' +
      'parent class to TAaQuestionCtl, and save your project.',
      'Success', MB_ICONINFORMATION);
  end;
end;

{------------------------------------------------------------------------------}

procedure TAaQBuilderEditor.ExecuteVerb(index: integer);
begin
  (Component as TAaQBuilder).SetFormAsControl;
end;

{------------------------------------------------------------------------------}

function TAaQBuilderEditor.GetVerb(index: integer): string;
begin
  result := 'Convert form into question control.';
end;

{------------------------------------------------------------------------------}

function TAaQBuilderEditor.GetVerbCount: integer;
begin
  result := 1;
end;

{------------------------------------------------------------------------------}

end.
