unit Bldform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl;

type
  TBuilderForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    NameEdit: TEdit;
    CaptionEdit: TEdit;
    ClassUnitEdit: TEdit;
    ControlUnitEdit: TEdit;
    GroupBox1: TGroupBox;
    DirList: TDirectoryListBox;
    DriveCombo: TDriveComboBox;
    GroupBox2: TGroupBox;
    CancelBtn: TButton;
    GenerateBtn: TButton;
    LinkMemo: TMemo;
    TemplateMemo: TMemo;
    Label5: TLabel;
    ControlNameEdit: TEdit;
    procedure CancelBtnClick(Sender: TObject);
    procedure GenerateBtnClick(Sender: TObject);
  private
    FClassName: string;
    FMenuCaption: string;
    FFileName: string;
    FCtlUnit: string;
    FCtlClassName: string;
    FLinkProps: TStrings;
    FTemplate: TStrings;
    procedure Validate;
    procedure Build;
  public
    { Public declarations }
  end;

var
  BuilderForm: TBuilderForm;

implementation

{$R *.DFM}

const
  idBase           = '{<<';
  idLink           = '{<<Link>>}';
  idClassName      = '{<<ClassName>>}';
  idMenuName       = '{<<MenuName>>}';
  idUnitName       = '{<<UnitName>>}';
  idCtlClassName   = '{<<CtlClassName>>}';
  idCtlUnitName    = '{<<CtlUnitName>>}';
  idDesignPPI      = '{<<DesignPPI>>}';

{------------------------------------------------------------------------------}

function ReplaceString(const search, replace, src: string): string;
var
  idx: integer;
  len: integer;
begin
  idx := Pos(search, src);
  if idx = 0 then
    result := src
  else begin
    len := Length(search);
    result := Copy(src, 1, idx-1) + replace + Copy(src, idx+len, Length(src));
    {recurse for any other tokens in the same line }
    result := ReplaceString(search, replace, result);
  end;
end;

{==============================================================================}

procedure TBuilderForm.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

{------------------------------------------------------------------------------}

procedure TBuilderForm.GenerateBtnClick(Sender: TObject);
begin
  FClassName := NameEdit.Text;
  FMenuCaption := CaptionEdit.Text;
  FFileName := DirList.Directory + '\' + ClassUnitEdit.Text + '.pas';
  FCtlClassName := ControlNameEdit.Text;
  FCtlUnit := ControlUnitEdit.Text;
  FLinkProps := LinkMemo.Lines;
  FTemplate := TemplateMemo.Lines;
  Validate;
  Build;
  Application.MessageBox('The question class code has been generated ' +
      'successfully.', 'Success', MB_ICONINFORMATION);
  Close;
end;

{------------------------------------------------------------------------------}

procedure TBuilderForm.Validate;
var
  i: integer;
begin

  { validate links -- must be 1 or more valid identifiers }
  if FLinkProps.Count = 0 then
    raise Exception.Create('Question must have 1 or more link properties');
  for i := 0 to FLinkProps.Count-1 do
    if not(IsValidIdent(FLinkProps[i])) then
      Exception.Create('One or more link properties have invalid names');

  { menu caption }
  if  FMenuCaption= '' then
    Exception.Create('Question must have a menu caption');

  { class name }
  if not IsValidIdent(FClassName) then
    Exception.Create('Invalid question class name!');

  { control class name }
  if not IsValidIdent(FCtlClassName) then
    Exception.Create('Invalid control class name!');

end;

{------------------------------------------------------------------------------}

procedure TBuilderForm.Build;
var
  templateFile: string;
  src: TStringList;
  lineNo: integer;
  parseComp: TComponent;
  template: string;
  i: integer;
  unitName: string;
begin

  src := TStringList.Create;
  try

    src.Assign(FTemplate);

    unitName := ChangeFileExt(ExtractFileName(FFileName), '');

    { on the first pass expand all link references }
    lineNo := 0;
    while lineNo < src.Count do begin
      if Pos(idLink, src[lineNo]) > 0 then begin
        { delete the template line }
        template := src[lineNo];
        src.Delete(lineNo);
        { add lines corresponding to the template for each link }
        for i := FLinkProps.Count-1 downto 0 do
          src.Insert(lineNo, ReplaceString(idLink, FLinkProps[i], template));
      end;
      Inc(lineNo);
    end;


    { second pass: expand all other tokens }
    for i := 0 to src.Count-1 do
      if Pos(idBase, src[i]) > 0 then begin
        src[i] := ReplaceString(idClassName, FClassName, src[i]);
        src[i] := ReplaceString(idMenuName, FMenuCaption, src[i]);
        src[i] := ReplaceString(idUnitName, unitName, src[i]);
        src[i] := ReplaceString(idCtlClassName, FCtlClassName, src[i]);
        src[i] := ReplaceString(idCtlUnitName, FCtlUnit, src[i]);
        src[i] := ReplaceString(idDesignPPI, IntToStr(Screen.PixelsPerInch),
          src[i]);
      end;

    src.SaveToFile(FFileName);

  finally
    src.Free;
  end;

end;

{------------------------------------------------------------------------------}


end.
