unit UAbout;

{
 Sample Diaog Box, About Dialog Box.

 Author: Alex Wernhardt
         HelpMakers

 Creation Date:    02.04.97
 Last Update:      02.04.97
 Upload to:        http://sunsite.icm.edu.pl/
                   http://carbohyd.siobc.ras.ru/torry/
                   www.delphi32.com

 Credits:          Maga WiseCarver - CIS 102507,3374
                   How to put a Dialog in a DLL
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,

  //-- To Access the Windows Registry
  Registry;

type
  TWAbout = class(TForm)
    Panel1: TPanel;
    CompanyName: TLabel;
    FileDescription: TLabel;
    FileVersion: TLabel;
    InternalName: TLabel;
    LegalCopyright: TLabel;
    OriginalFilename: TLabel;
    ProductName: TLabel;
    ProductVersion: TLabel;
    Image1: TImage;
    Bevel1: TBevel;
    butMore: TButton;
    lblWinVersion: TLabel;
    lblWinPlatForm: TLabel;
    lblUserName: TLabel;
    lblCompanyName: TLabel;
    lblWinSerialNum: TLabel;
    lblCPUType: TLabel;
    lblCPUNum: TLabel;
    Bevel2: TBevel;
    lblTotalPhysMem: TLabel;
    lblAvailPhysMem: TLabel;
    lblTotalVirtMem: TLabel;
    lblAvailVirtMem: TLabel;
    lblMemLoad: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure butMoreClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    wVersion: Word;
  public
    { Public declarations }
  end;

var
  WAbout: TWAbout;
  //-- Copies the Name of the Application
  ApplicationName: String;

  //-- To store the Windows Version from Registery
  CurVerKey : PChar;

  //-- stores the obtained extended information about the version
  //-- of the operating system via GetVersionEx()
  OVI: TOSVersionInfo;

//-- Exported procedure to load the About Box
procedure LoadAboutbox(Handle: THandle; AppName: ShortString); export;

//-- Returns the Windows Version
function WinVerString(I: byte): String;

implementation

{$R *.DFM}

procedure LoadAboutbox(Handle: THandle; AppName: ShortString);        //-- Our procedure
begin
  Application.Handle := Handle;                 //-- Delphi default application calling
  ApplicationName := AppName;
  WAbout := TWAbout.Create(Application);        //-- Create the Aboutbox
  try
    WAbout.ShowModal;                           //-- Try and make the Aboutbox modal
  finally                                       //-- Finally, or "make sure"
         WAbout.Free;                           //-- Unload the instance of our Aboutbox
         end;
end;


function WinVerString(I: byte): String;
begin
     case OVI.dwPlatformID of
          VER_PLATFORM_WIN32_WINDOWS:
             Result := 'Windows 95';
          VER_PLATFORM_WIN32_NT:
             Result := 'Windows NT';
     else
         Result := 'Unknown';
         end;

  //-- Verion Number
  if I = 1 then
     Result := Format('Version %d.%.2d', [OVI.dwMajorVersion, OVI.dwMinorVersion]);

  //-- Platform
  if I = 2 then
     Result := Format('%s', [Result]);
end;


procedure TWAbout.FormCreate(Sender: TObject);
var
   VIHandle : Integer;
   VSize : LongInt;
   VData : Pointer;
   VVers : Pointer;
   Len : Integer;
   FileName :String;

   SysInfo: TSystemInfo;

const
     //-- Prejudiced to U.S. character set
     Prefix = '\StringFileInfo\040904E4\';

     //-- Registry entry
     FPPKey = '\hardware\DESCRIPTION\System\FloatingPointProcessor';

     //-- Returns the Version Informations
     function GetVerValue(Value : String): String;
     var
        ItemName : String;
     begin
          ItemName := Prefix + Value + chr(0);
          Result := '';
          if VerQueryValue(VData,@ItemName[1],VVers,Len) then
             if Len > 0 then begin
                if Len > 255 then
                   //-- "Truncate" any long strings
                   Len := 255;
                Move(VVers, Result, SizeOf(Len));
             end;
     end;

begin
     //-- File Version Information code section --------------------------
     FileName := ApplicationName + Char('0');
     VSize := GetFileVersionInfoSize(@ApplicationName[1], VIHandle);
     if VSize <> 0 then begin
        GetMem(VData, VSize);
        try
           if GetFileVersionInfo(@ApplicationName[1], VIHandle, VSize, VData) then begin
              CompanyName.Caption := GetVerValue('CompanyName');
              CompanyName.Caption := 'Company Name:    ' + CompanyName.Caption;

              FileDescription.Caption := GetVerValue('FileDescription');
              FileDescription.Caption := 'File Description:    ' + FileDescription.Caption;

              FileVersion.Caption := GetVerValue('FileVersion');
              FileVersion.Caption := 'File Version:    ' + FileVersion.Caption;

              InternalName.Caption := GetVerValue('InternalName');
              InternalName.Caption := 'Internal Name:    ' + InternalName.Caption;

              LegalCopyright.Caption := GetVerValue('LegalCopyright');
              LegalCopyright.Caption := 'Legal Copyright:    ' + LegalCopyright.Caption;

              OriginalFilename.Caption := GetVerValue('OriginalFilename');
              OriginalFilename.Caption := 'Original Filename:    ' + OriginalFilename.Caption;

              ProductName.Caption := GetVerValue('ProductName');
              ProductName.Caption := 'Product Name:    ' + ProductName.Caption;

              ProductVersion.Caption := GetVerValue('ProductVersion');
              ProductVersion.Caption := 'Product Version:    ' + ProductVersion.Caption;
              end
           else
              ProductVersion.Caption := 'Screwed up !';
        finally
               FreeMem(VData, VSize);
               end;//-- try...Finally
        end;//-- If

     //-- System Information code section --------------------------
     OVI.dwOSVersionInfoSize := SizeOf(OVI);
     GetVersionEx(OVI);
     case OVI.dwPlatformID of
          VER_PLATFORM_WIN32_WINDOWS :
             CurVerKey := '\SOFTWARE\Microsoft\Windows\CurrentVersion';
          VER_PLATFORM_WIN32_NT      :
             CurVerKey := '\SOFTWARE\Microsoft\Windows NT\CurrentVersion';
     else
         CurVerKey := nil;
         end;//-- Case

     //-- Decieding the Windows Platform ID and Windows Version using
     //-- WinVerString function
     lblWinVersion.Caption := lblWinVersion.Caption + '  ' + WinVerString(1);
     lblWinPlatForm.Caption := lblWinPlatForm.Caption + '  ' + WinVerString(2);

     //~~ Deciding the type of the CPU
     GetSystemInfo(SysInfo);
     case SysInfo.dwProcessorType OF
          386 : lblCPUType.Caption := lblCPUType.Caption + '  ' + '80386';
          486 : lblCPUType.Caption := lblCPUType.Caption + '  ' + '80486';
          586 : lblCPUType.Caption := lblCPUType.Caption + '  ' + 'Pentium';
     else lblCPUType.Caption := lblCPUType.Caption + '  ' + Format('Unknown (%d)',
          [SysInfo.dwProcessorType]);
          end;

     lblCPUNum.Caption := lblCPUNum.Caption + '  ' + IntToStr(SysInfo.dwNumberOfProcessors);

     //~~ Using Registry to get information about FPU, Windows CD Serial Number,
     //~~ User Name and Company Name
     with TRegistry.Create do
          try
             RootKey := HKEY_LOCAL_MACHINE;
             with lblCPUType do
                  if OpenKey(FPPKey, False) then
                     Caption := Caption + ' CPU and FPU'
                  else
                      Caption := Caption + ' CPU, no FPU';

                  if OpenKey(CurVerKey, False) then begin
                     lblUserName.Caption := lblUserName.Caption + '  ' + ReadString('RegisteredOwner');
                     lblCompanyName.Caption := lblCompanyName.Caption + '  ' + ReadString('RegisteredOrganization');
                     if OVI.dwPlatformID = VER_PLATFORM_WIN32_WINDOWS then
                        lblWinSerialNum.Caption := lblWinSerialNum.Caption  + '  ' + 'ID#: ' + ReadString('ProductID');
                        end;
             finally
                    Free;
                    end;
end;

procedure TWAbout.butMoreClick(Sender: TObject);
begin
     Top := Top - (Bevel2.Height div 2);
     ClientHeight := ClientHeight + Bevel2.Height + 20;
     butMore.Top := butMore.Top + Bevel2.Height + 18;
     butMore.Caption := 'Exit';
     butMore.Hint := 'Exit the About Box';
     butMore.ModalResult := mrOk;
     Panel1.SetFocus;
end;

procedure TWAbout.FormActivate(Sender: TObject);
var
   MemStatus: TMemoryStatus;
begin
     //-- Get the Memory Status
     MemStatus.dwLength := SizeOf(MemStatus);
     GlobalMemoryStatus(MemStatus);
     lblTotalPhysMem.Caption := lblTotalPhysMem.Caption + '  ' + FormatFloat('#," KB"', MemStatus.dwTotalPhys DIV 1024);
     lblAvailPhysMem.Caption := lblAvailPhysMem.Caption + '  ' + FormatFloat('#," KB"', MemStatus.dwAvailPhys DIV 1024);
     lblTotalVirtMem.Caption := lblTotalVirtMem.Caption + '  ' + FormatFloat('#," KB"', MemStatus.dwTotalVirtual DIV 1024);
     lblAvailVirtMem.Caption := lblAvailVirtMem.Caption + '  ' + FormatFloat('#," KB"', MemStatus.dwAvailVirtual DIV 1024);
     lblMemLoad.Caption := lblMemLoad.Caption + '  ' + Format('%d%% Load', [MemStatus.dwMemoryLoad]);
end;

end.
