unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus,unit2, Spin, Buttons,unit3;

type
  Tmain = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    NewGame1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Options1: TMenuItem;
    Bevel1: TBevel;
    coaster1: TShape;
    coaster2: TShape;
    coaster3: TShape;
    coaster4: TShape;
    coaster5: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    ListBox1: TListBox;
    Label7: TLabel;
    playerlabel1: TLabel;
    player1: TListBox;
    playerlabel2: TLabel;
    player2: TListBox;
    playerlabel3: TLabel;
    player3: TListBox;
    playerlabel4: TLabel;
    player4: TListBox;
    playerlabel5: TLabel;
    player5: TListBox;
    total: TLabel;
    total1: TLabel;
    total2: TLabel;
    total3: TLabel;
    total4: TLabel;
    total5: TLabel;
    ChangePlayers1: TMenuItem;
    BitBtn1: TBitBtn;
    btnquit: TBitBtn;
    BitBtn3: TBitBtn;
    SpinEdit1: TSpinEdit;
    Label8: TLabel;
    Bevel2: TBevel;
    N2: TMenuItem;
    ComputerPlays1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    N3: TMenuItem;
    RulesoftheGame1: TMenuItem;
    face1: TLabel;
    face2: TLabel;
    face3: TLabel;
    face4: TLabel;
    face5: TLabel;

    procedure implodedisks;
    procedure getcomputerhand;
    procedure playcomputerhand;
    procedure turnemred;
    procedure turnitgray;
    procedure updatetotals(tl:TListbox;l:Tlabel);
    procedure seteligiblecoasters(thisval:integer);
    procedure sleep(ticks:longint);
    procedure getrandomarray;
    procedure Deal;
    function handover : boolean;
    function setupplayers : boolean;
    procedure Exit1Click(Sender: TObject);
    procedure ChangePlayers1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure coaster1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnquitClick(Sender: TObject);
    procedure ComputerPlays1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure RulesoftheGame1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure face1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  main: Tmain;
  gcomputerhanddone : boolean;
  gcurrentplayer : string;
  gcomputerhand : array[1..5] of integer;
  grandom : array[1..5] of integer;
  gtarget : integer;
  gplayertotal : integer;
  gplayername : string;
  gplayernumber : integer;
  ggameover : boolean;
  gnumplayers : integer;
  gfirstpass : boolean;
implementation

{$R *.DFM}

procedure Tmain.Exit1Click(Sender: TObject);
begin
     Application.terminate;
end;

procedure Tmain.ChangePlayers1Click(Sender: TObject);
var
   r : boolean;
begin
     r := setupplayers;
end;

procedure Tmain.BitBtn3Click(Sender: TObject);
begin
     changeplayers1.click;
end;
procedure TMain.Sleep(ticks:longint);
var
   begtick : longint;
   endtick : longint;
begin
   begtick := GetTickCount;
   endtick := begtick;
   while (endtick - begtick) < ticks do
   begin
     endtick := GetTickCount;
   end;

end;
procedure TMain.implodedisks;
var
   h, w : integer;
   increment : integer;
begin
     h := coaster1.height;
     w := coaster1.width;
     increment := 30;
     while coaster1.width > 3 do
     begin
       coaster1.width := coaster1.width - increment;
       coaster1.height := coaster1.height - increment;
       application.processmessages;
       coaster2.width := coaster1.width - increment;
       coaster2.height := coaster1.height - increment;
       application.processmessages;
       coaster3.width := coaster1.width - increment;
       coaster3.height := coaster1.height - increment;
       application.processmessages;
       coaster4.width := coaster1.width - increment;
       coaster4.height := coaster1.height - increment;
        application.processmessages;
       coaster5.width := coaster1.width - increment;
       coaster5.height := coaster1.height - increment;
       application.processmessages;
       sleep(20);
     end;
     coaster1.visible := false;
     coaster2.visible := false;
     coaster3.visible := false;
     coaster4.visible := false;
     coaster5.visible := false;
     coaster1.height := h;
     coaster1.width := w;
     coaster2.height := h;
     coaster2.width := w;
     coaster3.height := h;
     coaster3.width := w;
     coaster4.height := h;
     coaster4.width := w;
     coaster5.height := h;
     coaster5.width := w;

end;
function TMain.handover : boolean;
var
   numyellows : integer;
   numcaps : integer;
   numleft : integer;
begin
     numyellows := 0;
     numleft := 0;
     if coaster1.brush.color = clyellow then
       inc(numyellows);
     if coaster2.brush.color = clyellow then
       inc(numyellows);
     if coaster3.brush.color = clyellow then
       inc(numyellows);
     if coaster4.brush.color = clyellow then
       inc(numyellows);
     if coaster5.brush.color = clyellow then
       inc(numyellows);
     numcaps := 0;
     if numyellows = 1 then
     begin
       if not label1.visible then
         inc(numcaps);
       if not label2.visible then
         inc(numcaps);
       if not label3.visible then
         inc(numcaps);
       if not label4.visible then
         inc(numcaps);
       if not label5.visible then
         inc(numcaps);

     end;
     if (numyellows = 1) and (numcaps = 1) then
     begin
       result := true;
       if gplayernumber = 0 then
        gcomputerhanddone := true;
       gplayertotal := 15;
       turnitgray;
       exit;
     end;
     if (coaster1.brush.color = clgray) and
        (coaster2.brush.color = clgray) and
        (coaster3.brush.color = clgray) and
        (coaster4.brush.color = clgray) and
        (coaster5.brush.color = clgray) then
     begin
        turnemred;
        result := true;
        if gplayernumber = 0 then
        gcomputerhanddone := true;

     end
     else
        result := false;
end;
procedure TMain.turnitgray;
begin
     if not label1.visible then
     begin
       coaster1.brush.color := clgray;
       label1.visible := true;
     end;
     if not label2.visible then
     begin
       coaster2.brush.color := clgray;
       label2.visible := true;
     end;
     if not label3.visible then
     begin
       coaster3.brush.color := clgray;
       label3.visible := true;
     end;
     if not label4.visible then
     begin
       coaster4.brush.color := clgray;
       label4.visible := true;
     end;
     if not label5.visible then
     begin
       coaster5.brush.color := clgray;
       label5.visible := true;
     end;


end;
procedure TMain.turnemred;
begin
     if not label1.visible then
     begin
       coaster1.brush.color := clred;
       label1.visible := true;
       face1.caption := 'L';
     end;
     if not label2.visible then
     begin
       coaster2.brush.color := clred;
       label2.visible := true;
        face2.caption := 'L';
     end;
     if not label3.visible then
     begin
       coaster3.brush.color := clred;
       label3.visible := true;
       face3.caption := 'L';
     end;
     if not label4.visible then
     begin
       coaster4.brush.color := clred;
       label4.visible := true;
       face4.caption := 'L';
     end;
     if not label5.visible then
     begin
       coaster5.brush.color := clred;
       label5.visible := true;
       face5.caption := 'L';
     end;

end;
procedure TMain.updatetotals(Tl:TListbox;l:Tlabel);
var

   sum : integer;
   i : integer;
begin
     case Tl.tag of
     0 : l := total;
     1 : l := total1;
     2 : l := total2;
     3 : l := total3;
     4 : l := total4;
     5 : l := total5;
     end;
     sum := 0;
     for i := 0 to Tl.items.count - 1 do
       sum := sum + strtoint(tl.items[i]);
     l.caption := 'Total : '+inttostr(sum);
     if sum >= gtarget then
       ggameover := true;
end;
procedure TMain.getrandomarray;
var
   range : word;
   i,j : integer;
   done : boolean;
   element : integer;
   num : integer;
   found : boolean;
   sumsofar : integer;
   s : string;
begin
     sumsofar := 0;
     done := false;
     for i := 1 to 5 do
       grandom[i] := 0;
     range := 32767;
     randomize;
     element := 1;
     while element < 5 do
     begin
       s := inttostr(random(range));
       if length(s) < 4 then
         num := 0
       else
         num := strtoint(copy(s,4,1));
       application.processmessages;
       if (num > 0) and (num <= 5) then
       begin
         if element = 1 then
         begin
           grandom[element] := num;
           sumsofar := sumsofar + num;
           inc(element);
         end
         else
         begin
           found := false;
           for j := 1 to element - 1 do
           begin
             if grandom[j] = num then
             begin
               found := true;
               break;
             end;
           end;
           if not found then
           begin
             grandom[element] := num;
             sumsofar := sumsofar + num;
             inc(element);
           end;
         end;
       end;
     end;
     grandom[5] := 15 - sumsofar;
end;
procedure Tmain.playcomputerhand;
var
   pick : integer;
   i : integer;
   first : boolean;
begin
     first := true;
     gcomputerhanddone := false;
     while not gcomputerhanddone do
     begin
       getcomputerhand;

       if first then
       begin
         first := false;
         pick := gcomputerhand[1];
         if gcomputerhanddone then exit;
         case pick of
         1 : coaster1mouseup(coaster1,mbleft,[ssleft],0,0);
         2 : coaster1mouseup(coaster2,mbleft,[ssleft],0,0);
         3 : coaster1mouseup(coaster3,mbleft,[ssleft],0,0);
         4 : coaster1mouseup(coaster4,mbleft,[ssleft],0,0);
         5 : coaster1mouseup(coaster5,mbleft,[ssleft],0,0);
         end;
       end;
       for i := 1 to 5 do
       begin
         if gcomputerhanddone then exit;
         label6.caption := 'Guessing...';
         application.processmessages;
(*         sleep(100); *)
         label6.caption := 'Sleeping...';
         application.processmessages;
(*         sleep(500); *)
         label6.caption := 'Flipping...';
         application.processmessages;
         pick := gcomputerhand[i];
         case pick of
         1 :
         begin
           if (not label1.visible) and (coaster1.brush.color = clyellow) then
           begin
             coaster1mouseup(coaster1,mbleft,[ssleft],0,0);
             if gcomputerhanddone then exit;
           end;
         end;
         2 :
         begin
           if (not label2.visible)  and (coaster2.brush.color = clyellow)  then
           begin
             coaster1mouseup(coaster2,mbleft,[ssleft],0,0);
             if gcomputerhanddone then exit;
           end;
         end;
         3 :
         begin
           if (not label3.visible) and (coaster3.brush.color = clyellow)  then
           begin
             coaster1mouseup(coaster3,mbleft,[ssleft],0,0);
             if gcomputerhanddone then exit;
           end;
         end;
         4 :
         begin
           if (not label4.visible) and (coaster4.brush.color = clyellow)  then
           begin
             coaster1mouseup(coaster4,mbleft,[ssleft],0,0);
             if gcomputerhanddone then exit;
           end;
         end;
         5 :
         begin
           if (not label5.visible) and (coaster5.brush.color = clyellow)  then
           begin
             coaster1mouseup(coaster5,mbleft,[ssleft],0,0);
             if gcomputerhanddone then exit;
           end;
         end;

         end;
       end;
     end;
end;
procedure Tmain.getcomputerhand;
var
   num : integer;
   range : word;
   i, j : integer;
   element : integer;
   sumsofar : integer;
   found : boolean;
begin
     range := 6;
     sumsofar := 0;
     for i := 1 to 5 do
       gcomputerhand[i] := 0;
     element := 1;
     randomize;
     while element < 5 do
     begin
       num := random(range);
       Label6.caption := 'Computing...';
       application.processmessages;
       if num <> 0 then
       begin
         if element = 1 then
         begin
           gcomputerhand[element] := num;
           sumsofar := sumsofar + num;
           inc(element);
         end
         else
         begin
           found := false;
           for j := 1 to element - 1 do
           begin
             if gcomputerhand[j] = num then
             begin
               found := true;
               break;
             end;
           end;
           if not found then
           begin
             gcomputerhand[element] := num;
             sumsofar := sumsofar + num;
             inc(element);
           end;
         end;
       end;
     end;
     gcomputerhand[5] := 15 - sumsofar;
end;
procedure Tmain.deal;
var
   Tl : Tlistbox;
   l : Tlabel;
begin
     ggameover := false;
     inc(gplayernumber);
     if gplayernumber > gnumplayers - 1 then
       gplayernumber := 0;
     if (not computerplays1.checked) and (gplayernumber = 0) then
       gplayernumber := 1;
     if not computerplays1.checked then
     begin
       listbox1.visible := false;
       total.visible := false;
       label7.visible := false;
     end
     else
     begin
       listbox1.visible := true;
       total.visible := true;
       label7.visible := true;

     end;
     gfirstpass := true;
     coaster1.enabled := true;
     coaster2.enabled := true;
     coaster3.enabled := true;
     coaster4.enabled := true;
     coaster5.enabled := true;
     coaster1.visible := false;
     coaster2.visible := false;
     coaster3.visible := false;
     coaster4.visible := false;
     coaster5.visible := false;
     label1.visible := false;
     label2.visible := false;
     label3.visible := false;
     label4.visible := false;
     label5.visible := false;

     coaster1.brush.color := clgreen;
     coaster2.brush.color := clgreen;
     coaster3.brush.color := clgreen;
     coaster4.brush.color := clgreen;
     coaster5.brush.color := clgreen;
     gplayertotal := 0;
     Label6.caption := 'Randomizing';
     getrandomarray;
     Label6.caption := 'Dealing...';
     MessageBeep(0);
     application.processmessages;
(*     sleep(200); *)
     coaster1.visible := true;
     MessageBeep(0);
     application.processmessages;
(*     sleep(200);*)
     coaster2.visible := true;
     MessageBeep(0);
     application.processmessages;
(*     sleep(200); *)
     coaster3.visible := true;
     MessageBeep(0);
     application.processmessages;
(*     sleep(200); *)
     coaster4.visible := true;
     MessageBeep(0);
     application.processmessages;
(*     sleep(200); *)
     coaster5.visible := true;
     MessageBeep(0);
     label1.tag := grandom[1];
     label1.caption := inttostr(label1.tag);
     coaster1.tag := label1.tag;
     label2.tag := grandom[2];
     label2.caption := inttostr(label2.tag);
     coaster2.tag := label2.tag;
     label3.tag := grandom[3];
     label3.caption := inttostr(label3.tag);
     coaster3.tag := label3.tag;
     label4.tag := grandom[4];
     label4.caption := inttostr(label4.tag);
     coaster4.tag := label4.tag;
     label5.tag := grandom[5];
     label5.caption := inttostr(label5.tag);
     coaster5.tag := label5.tag;
     face1.caption := 'J';
     face2.caption := 'J';
     face3.caption := 'J';
     face4.caption := 'J';
     face5.caption := 'J';
     face1.visible := true;
     face2.visible := true;
     face3.visible := true;
     face4.visible := true;
     face5.visible := true;

     case gplayernumber of
     0 :
     begin
       label6.caption := 'It''s '+label7.caption + '''s turn...';
       playcomputerhand;
     end;
     1 : label6.caption := 'It''s '+playerlabel1.caption + '''s turn...';
     2 : label6.caption := 'It''s '+playerlabel2.caption + '''s turn...';
     3 : label6.caption := 'It''s '+playerlabel3.caption + '''s turn...';
     4 : label6.caption := 'It''s '+playerlabel4.caption + '''s turn...';
     5 : label6.caption := 'It''s '+playerlabel5.caption + '''s turn...';
     end;
end;
function Tmain.setupplayers : boolean;
var
   stat : boolean;
begin
     with form2 do
     begin
       showmodal;
       if modalresult = mrcancel then
       begin
         result := false;
         exit;
       end;
       if modalresult = mrok then
       begin
         result := true;
         playerlabel1.caption := edit1.text;
         playerlabel2.caption := edit2.text;
         playerlabel3.caption := edit3.text;
         playerlabel4.caption := edit4.text;
         playerlabel5.caption := edit5.text;
         listbox1.clear;
         player1.clear;
         player2.clear;
         player3.clear;
         player4.clear;
         player5.clear;
         total.caption := 'Total : 0';
         total1.caption := 'Total : 0';
         total2.caption := 'Total : 0';
         total3.caption := 'Total : 0';
         total4.caption := 'Total : 0';
         total5.caption := 'Total : 0';
              stat := form2.edit1.text <> '';
         playerlabel1.visible := stat;
         player1.visible := stat;
         total1.visible := stat;
         stat := form2.edit2.text <> '';
         playerlabel2.visible := stat;
         player2.visible := stat;
         total2.visible := stat;
         stat := form2.edit3.text <> '';
         playerlabel3.visible := stat;
         player3.visible := stat;
         total3.visible := stat;
         stat := form2.edit4.text <> '';
         playerlabel4.visible := stat;
         player4.visible := stat;
         total4.visible := stat;
         stat := form2.edit5.text <> '';
         playerlabel5.visible := stat;
         player5.visible := stat;
         total5.visible := stat;
         gnumplayers := 1;
         if total1.visible then gnumplayers := 2;
         if total2.visible then gnumplayers := 3;
         if total3.visible then gnumplayers := 4;
         if total4.visible then gnumplayers := 5;
         if total5.visible then gnumplayers := 6;
         if gnumplayers = 1 then
         begin
           computerplays1.checked := true;
           Messagedlg('No Takers... Computer plays alone !',mtinformation,[mbok],0);
         end;
       end;
     end;

end;
procedure Tmain.BitBtn1Click(Sender: TObject);
var
   stat : boolean;
begin
     gplayernumber := -1;
     listbox1.clear;
     player1.clear;
     player2.clear;
     player3.clear;
     player4.clear;
     player5.clear;
     if gtarget = 0 then
     begin
       MessageDlg('Specify the play to value first.',mterror,[mbok],0);
       spinedit1.setfocus;
       exit;
     end;
     if (form2.edit1.text = '') and
        (form2.edit2.text = '') and
        (form2.edit3.text = '') and
        (form2.edit4.text = '') and
        (form2.edit5.text = '') then
     begin
        if setupplayers then
         deal;
     end
     else
       deal;
end;

procedure Tmain.coaster1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
   thisval : integer;
   s : string;
   msg : string;
   Tl : TListbox;
   l : TLabel;
   h : integer;
   w : integer;
   diskleft : integer;
begin
     thisval := (Sender As TShape).tag;
     (* if already turned over exit *)
     s := lowercase((Sender As TShape).name);
     if (s = 'coaster1') and (label1.visible) then exit;
     if (s = 'coaster2') and (label2.visible) then exit;
     if (s = 'coaster3') and (label3.visible) then exit;
     if (s = 'coaster4') and (label4.visible) then exit;
     if (s = 'coaster5') and (label5.visible) then exit;
     (* on the first pass all are eligible *)
     if gfirstpass then
     begin
       gfirstpass := false;
       (Sender As TShape).shape := stEllipse;
       application.processmessages;
       sleep(50);
       (Sender As TShape).brush.color := clyellow;
       (Sender As TShape).shape := stCircle;
       if s = 'coaster1' then label1.visible := true;
       if s = 'coaster2' then label2.visible := true;
       if s = 'coaster3' then label3.visible := true;
       if s = 'coaster4' then label4.visible := true;
       if s = 'coaster5' then label5.visible := true;
       gplayertotal := gplayertotal + thisval;
       seteligiblecoasters(thisval);
     end
     else
     begin
       (Sender As TShape).shape := stEllipse;
(*       h := (Sender as Tshape).height;
       w := (Sender as Tshape).width;
       (Sender as Tshape).width := w * 2;
       (Sender as Tshape).height := h div 2;  *)

       application.processmessages;
       (Sender As TShape).visible := false;
(*       (Sender as Tshape).width := w;
       (Sender as Tshape).height := h;  *)
       sleep(50);
       (Sender As TShape).visible := true;
       (Sender As TShape).shape := stCircle;
       if (Sender As TShape).brush.color <> clyellow then exit;

       if s = 'coaster1' then label1.visible := true;
       if s = 'coaster2' then label2.visible := true;
       if s = 'coaster3' then label3.visible := true;
       if s = 'coaster4' then label4.visible := true;
       if s = 'coaster5' then label5.visible := true;
       gplayertotal := gplayertotal + thisval;
       seteligiblecoasters(thisval);
     end;
     If handover then
     begin
       case gplayernumber of
       0 : msg := 'My hand is over. '+#13;
       1 : msg := playerlabel1.caption+' your hand is over. '+#13;
       2 : msg := playerlabel2.caption+' your hand is over. '+#13;
       3 : msg := playerlabel3.caption+' your hand is over. '+#13;
       4 : msg := playerlabel4.caption+' your hand is over. '+#13;
       5 : msg := playerlabel5.caption+' your hand is over. '+#13;
       end;
       if gplayernumber <> 0 then
         msg := msg + 'You get '+inttostr(15-gplayertotal)+' points.'
       else
         msg := msg + 'I got '+inttostr(15-gplayertotal)+' points.';
       Messagedlg(msg,mtinformation,[mbok],0);

       case gplayernumber of
       0 : Tl := Listbox1;
       1 : Tl := Player1;
       2 : Tl := Player2;
       3 : Tl := Player3;
       4 : Tl := Player4;
       5 : Tl := Player5;
       end;
       case gplayernumber of
       0 : l := total;
       1 : l := Total1;
       2 : l := Total2;
       3 : l := Total3;
       4 : l := Total4;
       5 : l := Total5;
       end;

       Tl.items.add(inttostr(15-gplayertotal));
       updatetotals(Tl,l);
       if not ggameover then
         deal
       else
       begin
         Messagebeep(0);
         Messagedlg('Game Over YOU BUY THE BEER !',mtinformation,[mbok],0);
         label6.caption := 'Game Over';
         label1.visible := false;
         label2.visible := false;
         label3.visible := false;
         label4.visible := false;
         label5.visible := false;
         face1.visible := false;
         face2.visible := false;
         face3.visible := false;
         face4.visible := false;
         face5.visible := false;
         gplayernumber := -1;
         diskleft := coaster5.left;
         implodedisks;
       (*  while coaster5.left > coaster1.left do
         begin
           coaster5.visible := false;
           coaster5.left := coaster5.left-10;
           coaster5.visible := true;
           application.processmessages;
         end;
         coaster5.visible := false;
         coaster5.left := diskleft;
         diskleft := coaster4.left;
         while coaster4.left > coaster1.left do
         begin
           coaster4.left := coaster4.left-10;
           application.processmessages;
         end;
         coaster4.visible := false;
         coaster4.left := diskleft;
         diskleft := coaster3.left;
         while coaster3.left > coaster1.left do
         begin
           coaster3.left := coaster3.left-10;
           application.processmessages;
         end;
         coaster3.visible := false;
         coaster3.left := diskleft;
         diskleft := coaster2.left;
         while coaster2.left > coaster1.left do
         begin
           coaster2.left := coaster2.left-10;
           application.processmessages;
         end;
         coaster2.visible := false;
         coaster2.left := diskleft;
         coaster1.visible := false; *)
       end;

     end;

end;
procedure TMain.seteligiblecoasters(thisval:integer);
(*if coasters are eligible set color to clyellow*)
begin
     case thisval of
     1,5 :
     begin
       if not label1.visible then
         coaster1.brush.color := clyellow
       else
         coaster1.brush.color := clgray;
       if not label5.visible then
         coaster5.brush.color := clyellow
       else
         coaster5.brush.color := clgray;
       coaster2.brush.color := clgray;
       coaster3.brush.color := clgray;
       coaster4.brush.color := clgray;
     end;
     2,4 :
     begin
       if not label2.visible then
         coaster2.brush.color := clyellow
       else
         coaster2.brush.color := clgray;
       if not label4.visible then
         coaster4.brush.color := clyellow
       else
         coaster4.brush.color := clgray;

       coaster3.brush.color := clgray;
       coaster1.brush.color := clgray;
       coaster5.brush.color := clgray;
     end;
     3 :
     begin
       if not label3.visible then
         coaster3.brush.color := clyellow
       else
         coaster3.brush.color := clgray;
       coaster1.brush.color := clgray;
       coaster2.brush.color := clgray;
       coaster4.brush.color := clgray;
       coaster5.brush.color := clgray;
     end;
     end;
end;

procedure Tmain.SpinEdit1Change(Sender: TObject);
begin
     gtarget := spinedit1.value;
end;

procedure Tmain.FormCreate(Sender: TObject);
begin
     gtarget := spinedit1.value;
     gplayernumber := -1;
end;

procedure Tmain.btnquitClick(Sender: TObject);
begin
     exit1.click;
end;

procedure Tmain.ComputerPlays1Click(Sender: TObject);
begin
     computerplays1.checked := not computerplays1.checked;
end;

procedure Tmain.About1Click(Sender: TObject);
begin
     Aboutbox.showmodal;
end;

procedure Tmain.RulesoftheGame1Click(Sender: TObject);
begin
     Application.helpcommand(HELP_CONTENTS,0);
end;

procedure Tmain.FormKeyPress(Sender: TObject; var Key: Char);
begin
     case key of
      '1' : coaster1mouseup(coaster1,mbleft,[ssleft],0,0);
      '2' : coaster1mouseup(coaster2,mbleft,[ssleft],0,0);
      '3' : coaster1mouseup(coaster3,mbleft,[ssleft],0,0);
      '4' : coaster1mouseup(coaster4,mbleft,[ssleft],0,0);
      '5' : coaster1mouseup(coaster5,mbleft,[ssleft],0,0);
     end;
end;

procedure Tmain.face1Click(Sender: TObject);
begin
     case (Sender as Tlabel).tag of
     1 : coaster1mouseup(coaster1,mbleft,[ssleft],0,0);
     2 : coaster1mouseup(coaster2,mbleft,[ssleft],0,0);
     3 : coaster1mouseup(coaster3,mbleft,[ssleft],0,0);
     4 : coaster1mouseup(coaster4,mbleft,[ssleft],0,0);
     5 : coaster1mouseup(coaster5,mbleft,[ssleft],0,0);
     end;
end;

end.
