unit Filedlg;
(*-----
    File: FILEDLG.PAS for Project CODEAPP.DPR
-----*)

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, FileCtrl, SysUtils, Grids, Outline, DirOutln, Dialogs,
  PrintDlg, FileFunc;

type
  TSelectFileDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    GroupBox1: TGroupBox;
    FileInfo: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit1: TComboBox;
    FileListBox1: TFileListBox;
    FilterComboBox1: TFilterComboBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    procedure FileListBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure FileListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure HelpBtnClick(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FileListBox1KeyPress(Sender: TObject; var Key: Char);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    function HaveFileName: boolean;
  public
    { Public declarations }
    FileSpec: string;      { the chosen file /w path }
    FilePath: string;
    FileTypes: string;     {file selection filter}
  end;

var
  SelectFileDlg: TSelectFileDlg;

implementation

{$R *.DFM}

function AddBackSlash(const FDir: string): string;
begin
  if (length(FDir) < 255) and (FDir[length(FDir)] <> '\') then
    Result := Fdir+'\'
  else
    Result := FDir;
end;

procedure TSelectFileDlg.FileListBox1Change(Sender: TObject);
{-Show # of files in list}
begin
  Label6.Caption := 'Files: '+
    IntToStr(FileListBox1.Items.Count);
  with FileListBox1 do
    if ItemIndex < 0 then
      FileInfo.Caption := '';
end;

procedure TSelectFileDlg.FormCreate(Sender: TObject);
begin
  FileSpec := '';      { the chosen file /w path }
  FilePath := '';
  FileTypes := '';     {file selection filter}
  Left := Screen.Width - Width;
  Top := 0;
end;

function TSelectFileDlg.HaveFileName: boolean;
var
  F: TSearchRec;
begin
  with FileListBox1 do
    if ItemIndex >= 0 then
    begin
      Result := True;
      FilePath := AddBackSlash(Directory);
      FileSpec := FilePath+Items.Strings[ItemIndex];
      Edit1.Text := Items.Strings[ItemIndex];
      Edit1.Items.Add(Items.Strings[ItemIndex]);
      if GetFileInfo(Items.Strings[ItemIndex], F) then
        FileInfo.Caption := ShowFileStats(F)
      else
        FileInfo.Caption := 'FILE INFO UNAVAILABLE';
    end
    else
    begin
      Result := False;
      MessageBeep(64);
    end
end;

procedure TSelectFileDlg.FileListBox1DblClick(Sender: TObject);
begin
  if HaveFileName then
    Close
end;

procedure TSelectFileDlg.FileListBox1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
{-Select a file from list}
begin
  if HaveFileName then
    FileListBox1.BeginDrag(False);
end;

procedure TSelectFileDlg.OKBtnClick(Sender: TObject);
begin
  if HaveFileName then
    Close;
end;

procedure TSelectFileDlg.FileListBox1KeyPress(Sender: TObject;
  var Key: Char);
begin
  OKBtnClick(Sender);
end;

procedure TSelectFileDlg.CancelBtnClick(Sender: TObject);
begin
  FileSpec := '';
  Close
end;

procedure TSelectFileDlg.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
end;

procedure TSelectFileDlg.Edit1Click(Sender: TObject);
var
  FN: string;
begin
  if Edit1.Text <> '' then
  begin
    FN := UpperCase(FileListBox1.Directory+Edit1.Text);
    FileInfo.Caption := FN;
    FileSpec := FN;
  end;
end;

procedure TSelectFileDlg.DirectoryListBox1Change(Sender: TObject);
{-Make file list match Directory list}
begin
  FileListBox1.Directory := DirectoryListBox1.Directory;
end;

procedure TSelectFileDlg.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = vk_Return) and (Shift = []) then
    if (Pos('*',Edit1.Text) <> 0) or (Pos('?',Edit1.Text) <> 0) then
      FileListBox1.Mask := Edit1.Text
    else
    begin
      FileSpec := Edit1.Text;
      close
    end
end;

procedure TSelectFileDlg.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then Key := #0;
end;

procedure TSelectFileDlg.HelpBtnClick(Sender: TObject);
{-Give user a clue or two}
begin
  MessageDlg('Select a File by highlighting the desired directory and'#13+
  'and file name. Then select it by clicking on OK, or'#13+
  'dragging the name to the main form and dropping it there.',
  mtInformation, [mbCancel], 0);
end;


procedure TSelectFileDlg.FormActivate(Sender: TObject);
begin
  if FileSpec <> '' then
    DirectoryListBox1.Directory := ExtractFilePath(FileSpec);
  FileListBox1.Update;
  DriveComboBox1.Drive := DirectoryListBox1.Drive;
end;

end.
