{++ BUILD Version: 0000    // Increment this if a change has global effects

The  Telephony  API  is jointly copyrighted by Intel and Microsoft.  You are
granted  a royalty free worldwide, unlimited license to make copies, and use
the   API/SPI  for  making  applications/drivers  that  interface  with  the
specification provided that this paragraph and the Intel/Microsoft copyright
statement is maintained as is in the text and source code files.

Copyright 1995-96 Microsoft, all rights reserved.
Portions copyright 1992, 1993 Intel/Microsoft, all rights reserved.

Module Name:

		tapi.h

Notes:

		Additions to the Telephony Application Programming Interface (TAPI) since
		version 1.0 are noted by version number (e.g. "TAPI v1.4").

--}

{ Converted to Delphi by Davide Moretti <dave@rimini.com> }

{
	-- TAPI VERSION INFO -- TAPI VERSION INFO -- TAPI VERSION INFO --
	-- TAPI VERSION INFO -- TAPI VERSION INFO -- TAPI VERSION INFO --
	-- TAPI VERSION INFO -- TAPI VERSION INFO -- TAPI VERSION INFO --

	To build a 32bit TAPI 1.4 application remove the $DEFINE TAPI20 below
}

{$IFDEF WIN32}
{$DEFINE TAPI20}
{$ENDIF}

{$A-}

unit Tapi;

interface

{$IFDEF WIN32}
	uses Windows, Messages;
{$ELSE}
	uses WinTypes, Messages;
type
	WPARAM = Word;
  HInst = THandle;
{$ENDIF}

const
{$IFDEF TAPI20}
	TAPI_CURRENT_VERSION = $00020000;
{$ELSE}
  TAPI_CURRENT_VERSION = $00010004;
{$ENDIF}

{ #pragma pack(1) }

{ Type definitions of the data types used in tapi }

type
  LPHCall = ^THCall;
  THCall = Longint;
  LPHLine = ^THLine;
  THLine = Longint;
  LPHPhone = ^THPhone;
  THPhone = Longint;
  LPHLineApp = ^THLineApp;
  THLineApp = Longint;
	LPHPhoneApp = ^THPhoneApp;
  THPhoneApp = Longint;

  LPHIcon = ^HIcon;


TLineCallback = procedure(hDevice, dwMessage, dwInstance,
		dwParam1, dwParam2, dwParam3: Longint);
{$IFDEF WIN32}
		stdcall;
{$ENDIF}
TPhoneCallback = procedure(hDevice, dwMessage, dwInstance,
		dwParam1, dwParam2, dwParam3: Longint);
{$IFDEF WIN32}
		stdcall;
{$ENDIF}

{ Messages for Phones and Lines }

const
  LINE_ADDRESSSTATE                       = 0;
  LINE_CALLINFO                           = 1;
  LINE_CALLSTATE                          = 2;
  LINE_CLOSE                              = 3;
  LINE_DEVSPECIFIC                        = 4;
  LINE_DEVSPECIFICFEATURE                 = 5;
  LINE_GATHERDIGITS                       = 6;
  LINE_GENERATE                           = 7;
  LINE_LINEDEVSTATE                       = 8;
  LINE_MONITORDIGITS                      = 9;
  LINE_MONITORMEDIA                       = 10;
  LINE_MONITORTONE                        = 11;
  LINE_REPLY                              = 12;
  LINE_REQUEST                            = 13;
  PHONE_BUTTON                            = 14;
  PHONE_CLOSE                             = 15;
  PHONE_DEVSPECIFIC                       = 16;
  PHONE_REPLY                             = 17;
  PHONE_STATE                             = 18;
  LINE_CREATE                             = 19;             { TAPI v1.4 }
  PHONE_CREATE                            = 20;             { TAPI v1.4 }
{$IFDEF TAPI20}
  LINE_AGENTSPECIFIC                      = 21;             { TAPI v2.0 }
  LINE_AGENTSTATUS                        = 22;             { TAPI v2.0 }
  LINE_APPNEWCALL                         = 23;             { TAPI v2.0 }
  LINE_PROXYREQUEST                       = 24;             { TAPI v2.0 }
  LINE_REMOVE                             = 25;             { TAPI v2.0 }
  PHONE_REMOVE                            = 26;             { TAPI v2.0 }
{$ENDIF}



  INITIALIZE_NEGOTIATION                  = $FFFFFFFF;

  LINEADDRCAPFLAGS_FWDNUMRINGS            = $00000001;
  LINEADDRCAPFLAGS_PICKUPGROUPID          = $00000002;
  LINEADDRCAPFLAGS_SECURE                 = $00000004;
  LINEADDRCAPFLAGS_BLOCKIDDEFAULT         = $00000008;
  LINEADDRCAPFLAGS_BLOCKIDOVERRIDE        = $00000010;
  LINEADDRCAPFLAGS_DIALED                 = $00000020;
  LINEADDRCAPFLAGS_ORIGOFFHOOK            = $00000040;
  LINEADDRCAPFLAGS_DESTOFFHOOK            = $00000080;
  LINEADDRCAPFLAGS_FWDCONSULT             = $00000100;
  LINEADDRCAPFLAGS_SETUPCONFNULL          = $00000200;
  LINEADDRCAPFLAGS_AUTORECONNECT          = $00000400;
  LINEADDRCAPFLAGS_COMPLETIONID           = $00000800;
  LINEADDRCAPFLAGS_TRANSFERHELD           = $00001000;
  LINEADDRCAPFLAGS_TRANSFERMAKE           = $00002000;
  LINEADDRCAPFLAGS_CONFERENCEHELD         = $00004000;
  LINEADDRCAPFLAGS_CONFERENCEMAKE         = $00008000;
  LINEADDRCAPFLAGS_PARTIALDIAL            = $00010000;
  LINEADDRCAPFLAGS_FWDSTATUSVALID         = $00020000;
  LINEADDRCAPFLAGS_FWDINTEXTADDR          = $00040000;
  LINEADDRCAPFLAGS_FWDBUSYNAADDR          = $00080000;
  LINEADDRCAPFLAGS_ACCEPTTOALERT          = $00100000;
  LINEADDRCAPFLAGS_CONFDROP               = $00200000;
  LINEADDRCAPFLAGS_PICKUPCALLWAIT         = $00400000;
{$IFDEF TAPI20}
  LINEADDRCAPFLAGS_PREDICTIVEDIALER       = $00800000;      { TAPI v2.0 }
  LINEADDRCAPFLAGS_QUEUE                  = $01000000;      { TAPI v2.0 }
  LINEADDRCAPFLAGS_ROUTEPOINT             = $02000000;      { TAPI v2.0 }
  LINEADDRCAPFLAGS_HOLDMAKESNEW           = $04000000;      { TAPI v2.0 }
  LINEADDRCAPFLAGS_NOINTERNALCALLS        = $08000000;      { TAPI v2.0 }
  LINEADDRCAPFLAGS_NOEXTERNALCALLS        = $10000000;      { TAPI v2.0 }
  LINEADDRCAPFLAGS_SETCALLINGID           = $20000000;      { TAPI v2.0 }
{$ENDIF}

  LINEADDRESSMODE_ADDRESSID               = $00000001;
  LINEADDRESSMODE_DIALABLEADDR            = $00000002;

  LINEADDRESSSHARING_PRIVATE              = $00000001;
  LINEADDRESSSHARING_BRIDGEDEXCL          = $00000002;
  LINEADDRESSSHARING_BRIDGEDNEW           = $00000004;
  LINEADDRESSSHARING_BRIDGEDSHARED        = $00000008;
  LINEADDRESSSHARING_MONITORED            = $00000010;

  LINEADDRESSSTATE_OTHER                  = $00000001;
  LINEADDRESSSTATE_DEVSPECIFIC            = $00000002;
  LINEADDRESSSTATE_INUSEZERO              = $00000004;
  LINEADDRESSSTATE_INUSEONE               = $00000008;
  LINEADDRESSSTATE_INUSEMANY              = $00000010;
  LINEADDRESSSTATE_NUMCALLS               = $00000020;
  LINEADDRESSSTATE_FORWARD                = $00000040;
  LINEADDRESSSTATE_TERMINALS              = $00000080;
  LINEADDRESSSTATE_CAPSCHANGE             = $00000100;      { TAPI v1.4 }

  LINEADDRFEATURE_FORWARD                 = $00000001;
  LINEADDRFEATURE_MAKECALL                = $00000002;
  LINEADDRFEATURE_PICKUP                  = $00000004;
  LINEADDRFEATURE_SETMEDIACONTROL         = $00000008;
  LINEADDRFEATURE_SETTERMINAL             = $00000010;
  LINEADDRFEATURE_SETUPCONF               = $00000020;
  LINEADDRFEATURE_UNCOMPLETECALL          = $00000040;
  LINEADDRFEATURE_UNPARK                  = $00000080;
{$IFDEF TAPI20}
  LINEADDRFEATURE_PICKUPHELD              = $00000100;      { TAPI v2.0 }
  LINEADDRFEATURE_PICKUPGROUP             = $00000200;      { TAPI v2.0 }
  LINEADDRFEATURE_PICKUPDIRECT            = $00000400;      { TAPI v2.0 }
  LINEADDRFEATURE_PICKUPWAITING           = $00000800;      { TAPI v2.0 }
  LINEADDRFEATURE_FORWARDFWD              = $00001000;      { TAPI v2.0 }
  LINEADDRFEATURE_FORWARDDND              = $00002000;      { TAPI v2.0 }
{$ENDIF}

{$IFDEF TAPI20}
  LINEAGENTFEATURE_SETAGENTGROUP          = $00000001;      { TAPI v2.0 }
  LINEAGENTFEATURE_SETAGENTSTATE          = $00000002;      { TAPI v2.0 }
  LINEAGENTFEATURE_SETAGENTACTIVITY       = $00000004;      { TAPI v2.0 }
  LINEAGENTFEATURE_AGENTSPECIFIC          = $00000008;      { TAPI v2.0 }
  LINEAGENTFEATURE_GETAGENTACTIVITYLIST   = $00000010;      { TAPI v2.0 }
  LINEAGENTFEATURE_GETAGENTGROUP          = $00000020;      { TAPI v2.0 }

  LINEAGENTSTATE_LOGGEDOFF                = $00000001;      { TAPI v2.0 }
  LINEAGENTSTATE_NOTREADY                 = $00000002;      { TAPI v2.0 }
  LINEAGENTSTATE_READY                    = $00000004;      { TAPI v2.0 }
  LINEAGENTSTATE_BUSYACD                  = $00000008;      { TAPI v2.0 }
  LINEAGENTSTATE_BUSYINCOMING             = $00000010;      { TAPI v2.0 }
  LINEAGENTSTATE_BUSYOUTBOUND             = $00000020;      { TAPI v2.0 }
  LINEAGENTSTATE_BUSYOTHER                = $00000040;      { TAPI v2.0 }
  LINEAGENTSTATE_WORKINGAFTERCALL         = $00000080;      { TAPI v2.0 }
  LINEAGENTSTATE_UNKNOWN                  = $00000100;      { TAPI v2.0 }
  LINEAGENTSTATE_UNAVAIL                  = $00000200;      { TAPI v2.0 }

  LINEAGENTSTATUS_GROUP                   = $00000001;      { TAPI v2.0 }
  LINEAGENTSTATUS_STATE                   = $00000002;      { TAPI v2.0 }
  LINEAGENTSTATUS_NEXTSTATE               = $00000004;      { TAPI v2.0 }
  LINEAGENTSTATUS_ACTIVITY                = $00000008;      { TAPI v2.0 }
  LINEAGENTSTATUS_ACTIVITYLIST            = $00000010;      { TAPI v2.0 }
  LINEAGENTSTATUS_GROUPLIST               = $00000020;      { TAPI v2.0 }
  LINEAGENTSTATUS_CAPSCHANGE              = $00000040;      { TAPI v2.0 }
  LINEAGENTSTATUS_VALIDSTATES             = $00000080;      { TAPI v2.0 }
  LINEAGENTSTATUS_VALIDNEXTSTATES         = $00000100;      { TAPI v2.0 }
{$ENDIF}


  LINEANSWERMODE_NONE                     = $00000001;
  LINEANSWERMODE_DROP                     = $00000002;
  LINEANSWERMODE_HOLD                     = $00000004;

  LINEBEARERMODE_VOICE                    = $00000001;
  LINEBEARERMODE_SPEECH                   = $00000002;
  LINEBEARERMODE_MULTIUSE                 = $00000004;
  LINEBEARERMODE_DATA                     = $00000008;
  LINEBEARERMODE_ALTSPEECHDATA            = $00000010;
  LINEBEARERMODE_NONCALLSIGNALING         = $00000020;
  LINEBEARERMODE_PASSTHROUGH              = $00000040;      { TAPI v1.4 }
{$IFDEF TAPI20}
  LINEBEARERMODE_RESTRICTEDDATA           = $00000080;      { TAPI v2.0 }
{$ENDIF}

  LINEBUSYMODE_STATION                    = $00000001;
  LINEBUSYMODE_TRUNK                      = $00000002;
  LINEBUSYMODE_UNKNOWN                    = $00000004;
  LINEBUSYMODE_UNAVAIL                    = $00000008;

  LINECALLCOMPLCOND_BUSY                  = $00000001;
  LINECALLCOMPLCOND_NOANSWER              = $00000002;

  LINECALLCOMPLMODE_CAMPON                = $00000001;
  LINECALLCOMPLMODE_CALLBACK              = $00000002;
  LINECALLCOMPLMODE_INTRUDE               = $00000004;
  LINECALLCOMPLMODE_MESSAGE               = $00000008;

  LINECALLFEATURE_ACCEPT                  = $00000001;
  LINECALLFEATURE_ADDTOCONF               = $00000002;
  LINECALLFEATURE_ANSWER                  = $00000004;
  LINECALLFEATURE_BLINDTRANSFER           = $00000008;
  LINECALLFEATURE_COMPLETECALL            = $00000010;
  LINECALLFEATURE_COMPLETETRANSF          = $00000020;
  LINECALLFEATURE_DIAL                    = $00000040;
  LINECALLFEATURE_DROP                    = $00000080;
  LINECALLFEATURE_GATHERDIGITS            = $00000100;
  LINECALLFEATURE_GENERATEDIGITS          = $00000200;
  LINECALLFEATURE_GENERATETONE            = $00000400;
  LINECALLFEATURE_HOLD                    = $00000800;
  LINECALLFEATURE_MONITORDIGITS           = $00001000;
  LINECALLFEATURE_MONITORMEDIA            = $00002000;
  LINECALLFEATURE_MONITORTONES            = $00004000;
  LINECALLFEATURE_PARK                    = $00008000;
  LINECALLFEATURE_PREPAREADDCONF          = $00010000;
  LINECALLFEATURE_REDIRECT                = $00020000;
  LINECALLFEATURE_REMOVEFROMCONF          = $00040000;
  LINECALLFEATURE_SECURECALL              = $00080000;
  LINECALLFEATURE_SENDUSERUSER            = $00100000;
  LINECALLFEATURE_SETCALLPARAMS           = $00200000;
  LINECALLFEATURE_SETMEDIACONTROL         = $00400000;
  LINECALLFEATURE_SETTERMINAL             = $00800000;
  LINECALLFEATURE_SETUPCONF               = $01000000;
  LINECALLFEATURE_SETUPTRANSFER           = $02000000;
  LINECALLFEATURE_SWAPHOLD                = $04000000;
  LINECALLFEATURE_UNHOLD                  = $08000000;
  LINECALLFEATURE_RELEASEUSERUSERINFO     = $10000000;      { TAPI v1.4 }
{$IFDEF TAPI20}
  LINECALLFEATURE_SETTREATMENT            = $20000000;      { TAPI v2.0 }
  LINECALLFEATURE_SETQOS                  = $40000000;      { TAPI v2.0 }
  LINECALLFEATURE_SETCALLDATA             = $80000000;      { TAPI v2.0 }
{$ENDIF}

{$IFDEF TAPI20}
  LINECALLFEATURE2_NOHOLDCONFERENCE       = $00000001;      { TAPI v2.0 }
  LINECALLFEATURE2_ONESTEPTRANSFER        = $00000002;      { TAPI v2.0 }
  LINECALLFEATURE2_COMPLCAMPON            = $00000004;      { TAPI v2.0 }
  LINECALLFEATURE2_COMPLCALLBACK          = $00000008;      { TAPI v2.0 }
  LINECALLFEATURE2_COMPLINTRUDE           = $00000010;      { TAPI v2.0 }
  LINECALLFEATURE2_COMPLMESSAGE           = $00000020;      { TAPI v2.0 }
  LINECALLFEATURE2_TRANSFERNORM           = $00000040;      { TAPI v2.0 }
  LINECALLFEATURE2_TRANSFERCONF           = $00000080;      { TAPI v2.0 }
  LINECALLFEATURE2_PARKDIRECT             = $00000100;      { TAPI v2.0 }
  LINECALLFEATURE2_PARKNONDIRECT          = $00000200;      { TAPI v2.0 }
{$ENDIF}

  LINECALLINFOSTATE_OTHER                 = $00000001;
  LINECALLINFOSTATE_DEVSPECIFIC           = $00000002;
  LINECALLINFOSTATE_BEARERMODE            = $00000004;
  LINECALLINFOSTATE_RATE                  = $00000008;
  LINECALLINFOSTATE_MEDIAMODE             = $00000010;
  LINECALLINFOSTATE_APPSPECIFIC           = $00000020;
  LINECALLINFOSTATE_CALLID                = $00000040;
  LINECALLINFOSTATE_RELATEDCALLID         = $00000080;
  LINECALLINFOSTATE_ORIGIN                = $00000100;
  LINECALLINFOSTATE_REASON                = $00000200;
  LINECALLINFOSTATE_COMPLETIONID          = $00000400;
  LINECALLINFOSTATE_NUMOWNERINCR          = $00000800;
  LINECALLINFOSTATE_NUMOWNERDECR          = $00001000;
  LINECALLINFOSTATE_NUMMONITORS           = $00002000;
  LINECALLINFOSTATE_TRUNK                 = $00004000;
  LINECALLINFOSTATE_CALLERID              = $00008000;
  LINECALLINFOSTATE_CALLEDID              = $00010000;
  LINECALLINFOSTATE_CONNECTEDID           = $00020000;
  LINECALLINFOSTATE_REDIRECTIONID         = $00040000;
  LINECALLINFOSTATE_REDIRECTINGID         = $00080000;
  LINECALLINFOSTATE_DISPLAY               = $00100000;
  LINECALLINFOSTATE_USERUSERINFO          = $00200000;
  LINECALLINFOSTATE_HIGHLEVELCOMP         = $00400000;
  LINECALLINFOSTATE_LOWLEVELCOMP          = $00800000;
  LINECALLINFOSTATE_CHARGINGINFO          = $01000000;
  LINECALLINFOSTATE_TERMINAL              = $02000000;
  LINECALLINFOSTATE_DIALPARAMS            = $04000000;
  LINECALLINFOSTATE_MONITORMODES          = $08000000;
{$IFDEF TAPI20}
  LINECALLINFOSTATE_TREATMENT             = $10000000;      { TAPI v2.0 }
  LINECALLINFOSTATE_QOS                   = $20000000;      { TAPI v2.0 }
  LINECALLINFOSTATE_CALLDATA              = $40000000;      { TAPI v2.0 }
{$ENDIF}

  LINECALLORIGIN_OUTBOUND                 = $00000001;
  LINECALLORIGIN_INTERNAL                 = $00000002;
  LINECALLORIGIN_EXTERNAL                 = $00000004;
  LINECALLORIGIN_UNKNOWN                  = $00000010;
  LINECALLORIGIN_UNAVAIL                  = $00000020;
  LINECALLORIGIN_CONFERENCE               = $00000040;
  LINECALLORIGIN_INBOUND                  = $00000080;      { TAPI v1.4 }

  LINECALLPARAMFLAGS_SECURE               = $00000001;
  LINECALLPARAMFLAGS_IDLE                 = $00000002;
  LINECALLPARAMFLAGS_BLOCKID              = $00000004;
  LINECALLPARAMFLAGS_ORIGOFFHOOK          = $00000008;
  LINECALLPARAMFLAGS_DESTOFFHOOK          = $00000010;
{$IFDEF TAPI20}
  LINECALLPARAMFLAGS_NOHOLDCONFERENCE     = $00000020;      { TAPI v2.0 }
  LINECALLPARAMFLAGS_PREDICTIVEDIAL       = $00000040;      { TAPI v2.0 }
  LINECALLPARAMFLAGS_ONESTEPTRANSFER      = $00000080;      { TAPI v2.0 }
{$ENDIF}

  LINECALLPARTYID_BLOCKED                 = $00000001;
  LINECALLPARTYID_OUTOFAREA               = $00000002;
  LINECALLPARTYID_NAME                    = $00000004;
  LINECALLPARTYID_ADDRESS                 = $00000008;
  LINECALLPARTYID_PARTIAL                 = $00000010;
  LINECALLPARTYID_UNKNOWN                 = $00000020;
  LINECALLPARTYID_UNAVAIL                 = $00000040;

  LINECALLPRIVILEGE_NONE                  = $00000001;
  LINECALLPRIVILEGE_MONITOR               = $00000002;
  LINECALLPRIVILEGE_OWNER                 = $00000004;

  LINECALLREASON_DIRECT                   = $00000001;
  LINECALLREASON_FWDBUSY                  = $00000002;
  LINECALLREASON_FWDNOANSWER              = $00000004;
  LINECALLREASON_FWDUNCOND                = $00000008;
  LINECALLREASON_PICKUP                   = $00000010;
  LINECALLREASON_UNPARK                   = $00000020;
  LINECALLREASON_REDIRECT                 = $00000040;
  LINECALLREASON_CALLCOMPLETION           = $00000080;
  LINECALLREASON_TRANSFER                 = $00000100;
  LINECALLREASON_REMINDER                 = $00000200;
  LINECALLREASON_UNKNOWN                  = $00000400;
  LINECALLREASON_UNAVAIL                  = $00000800;
  LINECALLREASON_INTRUDE                  = $00001000;      { TAPI v1.4 }
  LINECALLREASON_PARKED                   = $00002000;      { TAPI v1.4 }
{$IFDEF TAPI20}
  LINECALLREASON_CAMPEDON                 = $00004000;      { TAPI v2.0 }
  LINECALLREASON_ROUTEREQUEST             = $00008000;      { TAPI v2.0 }
{$ENDIF}

  LINECALLSELECT_LINE                     = $00000001;
  LINECALLSELECT_ADDRESS                  = $00000002;
  LINECALLSELECT_CALL                     = $00000004;

  LINECALLSTATE_IDLE                      = $00000001;
  LINECALLSTATE_OFFERING                  = $00000002;
  LINECALLSTATE_ACCEPTED                  = $00000004;
  LINECALLSTATE_DIALTONE                  = $00000008;
  LINECALLSTATE_DIALING                   = $00000010;
  LINECALLSTATE_RINGBACK                  = $00000020;
  LINECALLSTATE_BUSY                      = $00000040;
  LINECALLSTATE_SPECIALINFO               = $00000080;
  LINECALLSTATE_CONNECTED                 = $00000100;
  LINECALLSTATE_PROCEEDING                = $00000200;
  LINECALLSTATE_ONHOLD                    = $00000400;
  LINECALLSTATE_CONFERENCED               = $00000800;
  LINECALLSTATE_ONHOLDPENDCONF            = $00001000;
  LINECALLSTATE_ONHOLDPENDTRANSFER        = $00002000;
  LINECALLSTATE_DISCONNECTED              = $00004000;
  LINECALLSTATE_UNKNOWN                   = $00008000;

{$IFDEF TAPI20}
  LINECALLTREATMENT_SILENCE               = $00000001;      { TAPI v2.0 }
  LINECALLTREATMENT_RINGBACK              = $00000002;      { TAPI v2.0 }
  LINECALLTREATMENT_BUSY                  = $00000003;      { TAPI v2.0 }
  LINECALLTREATMENT_MUSIC                 = $00000004;      { TAPI v2.0 }
{$ENDIF}

  LINECARDOPTION_PREDEFINED               = $00000001;      { TAPI v1.4 }
  LINECARDOPTION_HIDDEN                   = $00000002;      { TAPI v1.4 }

  LINECONNECTEDMODE_ACTIVE                = $00000001;      { TAPI v1.4 }
  LINECONNECTEDMODE_INACTIVE              = $00000002;      { TAPI v1.4 }
{$IFDEF TAPI20}
  LINECONNECTEDMODE_ACTIVEHELD            = $00000004;      { TAPI v2.0 }
  LINECONNECTEDMODE_INACTIVEHELD          = $00000008;      { TAPI v2.0 }
  LINECONNECTEDMODE_CONFIRMED             = $00000010;      { TAPI v2.0 }
{$ENDIF}

  LINEDEVCAPFLAGS_CROSSADDRCONF           = $00000001;
  LINEDEVCAPFLAGS_HIGHLEVCOMP             = $00000002;
  LINEDEVCAPFLAGS_LOWLEVCOMP              = $00000004;
  LINEDEVCAPFLAGS_MEDIACONTROL            = $00000008;
  LINEDEVCAPFLAGS_MULTIPLEADDR            = $00000010;
  LINEDEVCAPFLAGS_CLOSEDROP               = $00000020;
  LINEDEVCAPFLAGS_DIALBILLING             = $00000040;
  LINEDEVCAPFLAGS_DIALQUIET               = $00000080;
  LINEDEVCAPFLAGS_DIALDIALTONE            = $00000100;

  LINEDEVSTATE_OTHER                      = $00000001;
  LINEDEVSTATE_RINGING                    = $00000002;
  LINEDEVSTATE_CONNECTED                  = $00000004;
  LINEDEVSTATE_DISCONNECTED               = $00000008;
  LINEDEVSTATE_MSGWAITON                  = $00000010;
  LINEDEVSTATE_MSGWAITOFF                 = $00000020;
  LINEDEVSTATE_INSERVICE                  = $00000040;
  LINEDEVSTATE_OUTOFSERVICE               = $00000080;
  LINEDEVSTATE_MAINTENANCE                = $00000100;
  LINEDEVSTATE_OPEN                       = $00000200;
  LINEDEVSTATE_CLOSE                      = $00000400;
  LINEDEVSTATE_NUMCALLS                   = $00000800;
  LINEDEVSTATE_NUMCOMPLETIONS             = $00001000;
  LINEDEVSTATE_TERMINALS                  = $00002000;
  LINEDEVSTATE_ROAMMODE                   = $00004000;
  LINEDEVSTATE_BATTERY                    = $00008000;
  LINEDEVSTATE_SIGNAL                     = $00010000;
  LINEDEVSTATE_DEVSPECIFIC                = $00020000;
  LINEDEVSTATE_REINIT                     = $00040000;
  LINEDEVSTATE_LOCK                       = $00080000;
  LINEDEVSTATE_CAPSCHANGE                 = $00100000;      { TAPI v1.4 }
  LINEDEVSTATE_CONFIGCHANGE               = $00200000;      { TAPI v1.4 }
  LINEDEVSTATE_TRANSLATECHANGE            = $00400000;      { TAPI v1.4 }
  LINEDEVSTATE_COMPLCANCEL                = $00800000;      { TAPI v1.4 }
  LINEDEVSTATE_REMOVED                    = $01000000;      { TAPI v1.4 }

  LINEDEVSTATUSFLAGS_CONNECTED            = $00000001;
  LINEDEVSTATUSFLAGS_MSGWAIT              = $00000002;
  LINEDEVSTATUSFLAGS_INSERVICE            = $00000004;
  LINEDEVSTATUSFLAGS_LOCKED               = $00000008;

  LINEDIALTONEMODE_NORMAL                 = $00000001;
  LINEDIALTONEMODE_SPECIAL                = $00000002;
  LINEDIALTONEMODE_INTERNAL               = $00000004;
  LINEDIALTONEMODE_EXTERNAL               = $00000008;
  LINEDIALTONEMODE_UNKNOWN                = $00000010;
  LINEDIALTONEMODE_UNAVAIL                = $00000020;

  LINEDIGITMODE_PULSE                     = $00000001;
  LINEDIGITMODE_DTMF                      = $00000002;
  LINEDIGITMODE_DTMFEND                   = $00000004;

  LINEDISCONNECTMODE_NORMAL               = $00000001;
  LINEDISCONNECTMODE_UNKNOWN              = $00000002;
  LINEDISCONNECTMODE_REJECT               = $00000004;
  LINEDISCONNECTMODE_PICKUP               = $00000008;
  LINEDISCONNECTMODE_FORWARDED            = $00000010;
  LINEDISCONNECTMODE_BUSY                 = $00000020;
  LINEDISCONNECTMODE_NOANSWER             = $00000040;
  LINEDISCONNECTMODE_BADADDRESS           = $00000080;
  LINEDISCONNECTMODE_UNREACHABLE          = $00000100;
  LINEDISCONNECTMODE_CONGESTION           = $00000200;
  LINEDISCONNECTMODE_INCOMPATIBLE         = $00000400;
  LINEDISCONNECTMODE_UNAVAIL              = $00000800;
  LINEDISCONNECTMODE_NODIALTONE           = $00001000;      { TAPI v1.4 }
{$IFDEF TAPI20}
  LINEDISCONNECTMODE_NUMBERCHANGED        = $00002000;      { TAPI v2.0 }
  LINEDISCONNECTMODE_OUTOFORDER           = $00004000;      { TAPI v2.0 }
  LINEDISCONNECTMODE_TEMPFAILURE          = $00008000;      { TAPI v2.0 }
  LINEDISCONNECTMODE_QOSUNAVAIL           = $00010000;      { TAPI v2.0 }
  LINEDISCONNECTMODE_BLOCKED              = $00020000;      { TAPI v2.0 }
  LINEDISCONNECTMODE_DONOTDISTURB         = $00040000;      { TAPI v2.0 }
  LINEDISCONNECTMODE_CANCELLED            = $00080000;      { TAPI v2.0 }
{$ENDIF}

  LINEERR_ALLOCATED                       = $80000001;
  LINEERR_BADDEVICEID                     = $80000002;
  LINEERR_BEARERMODEUNAVAIL               = $80000003;
  LINEERR_CALLUNAVAIL                     = $80000005;
  LINEERR_COMPLETIONOVERRUN               = $80000006;
  LINEERR_CONFERENCEFULL                  = $80000007;
  LINEERR_DIALBILLING                     = $80000008;
  LINEERR_DIALDIALTONE                    = $80000009;
  LINEERR_DIALPROMPT                      = $8000000A;
  LINEERR_DIALQUIET                       = $8000000B;
  LINEERR_INCOMPATIBLEAPIVERSION          = $8000000C;
  LINEERR_INCOMPATIBLEEXTVERSION          = $8000000D;
  LINEERR_INIFILECORRUPT                  = $8000000E;
  LINEERR_INUSE                           = $8000000F;
  LINEERR_INVALADDRESS                    = $80000010;
  LINEERR_INVALADDRESSID                  = $80000011;
  LINEERR_INVALADDRESSMODE                = $80000012;
  LINEERR_INVALADDRESSSTATE               = $80000013;
  LINEERR_INVALAPPHANDLE                  = $80000014;
  LINEERR_INVALAPPNAME                    = $80000015;
  LINEERR_INVALBEARERMODE                 = $80000016;
  LINEERR_INVALCALLCOMPLMODE              = $80000017;
  LINEERR_INVALCALLHANDLE                 = $80000018;
  LINEERR_INVALCALLPARAMS                 = $80000019;
  LINEERR_INVALCALLPRIVILEGE              = $8000001A;
  LINEERR_INVALCALLSELECT                 = $8000001B;
  LINEERR_INVALCALLSTATE                  = $8000001C;
  LINEERR_INVALCALLSTATELIST              = $8000001D;
  LINEERR_INVALCARD                       = $8000001E;
  LINEERR_INVALCOMPLETIONID               = $8000001F;
  LINEERR_INVALCONFCALLHANDLE             = $80000020;
  LINEERR_INVALCONSULTCALLHANDLE          = $80000021;
  LINEERR_INVALCOUNTRYCODE                = $80000022;
  LINEERR_INVALDEVICECLASS                = $80000023;
  LINEERR_INVALDEVICEHANDLE               = $80000024;
  LINEERR_INVALDIALPARAMS                 = $80000025;
  LINEERR_INVALDIGITLIST                  = $80000026;
  LINEERR_INVALDIGITMODE                  = $80000027;
  LINEERR_INVALDIGITS                     = $80000028;
  LINEERR_INVALEXTVERSION                 = $80000029;
  LINEERR_INVALGROUPID                    = $8000002A;
  LINEERR_INVALLINEHANDLE                 = $8000002B;
  LINEERR_INVALLINESTATE                  = $8000002C;
  LINEERR_INVALLOCATION                   = $8000002D;
  LINEERR_INVALMEDIALIST                  = $8000002E;
  LINEERR_INVALMEDIAMODE                  = $8000002F;
  LINEERR_INVALMESSAGEID                  = $80000030;
  LINEERR_INVALPARAM                      = $80000032;
  LINEERR_INVALPARKID                     = $80000033;
  LINEERR_INVALPARKMODE                   = $80000034;
  LINEERR_INVALPOINTER                    = $80000035;
  LINEERR_INVALPRIVSELECT                 = $80000036;
  LINEERR_INVALRATE                       = $80000037;
  LINEERR_INVALREQUESTMODE                = $80000038;
  LINEERR_INVALTERMINALID                 = $80000039;
  LINEERR_INVALTERMINALMODE               = $8000003A;
  LINEERR_INVALTIMEOUT                    = $8000003B;
  LINEERR_INVALTONE                       = $8000003C;
  LINEERR_INVALTONELIST                   = $8000003D;
  LINEERR_INVALTONEMODE                   = $8000003E;
  LINEERR_INVALTRANSFERMODE               = $8000003F;
  LINEERR_LINEMAPPERFAILED                = $80000040;
  LINEERR_NOCONFERENCE                    = $80000041;
  LINEERR_NODEVICE                        = $80000042;
  LINEERR_NODRIVER                        = $80000043;
  LINEERR_NOMEM                           = $80000044;
  LINEERR_NOREQUEST                       = $80000045;
  LINEERR_NOTOWNER                        = $80000046;
  LINEERR_NOTREGISTERED                   = $80000047;
  LINEERR_OPERATIONFAILED                 = $80000048;
  LINEERR_OPERATIONUNAVAIL                = $80000049;
  LINEERR_RATEUNAVAIL                     = $8000004A;
  LINEERR_RESOURCEUNAVAIL                 = $8000004B;
  LINEERR_REQUESTOVERRUN                  = $8000004C;
  LINEERR_STRUCTURETOOSMALL               = $8000004D;
  LINEERR_TARGETNOTFOUND                  = $8000004E;
  LINEERR_TARGETSELF                      = $8000004F;
  LINEERR_UNINITIALIZED                   = $80000050;
  LINEERR_USERUSERINFOTOOBIG              = $80000051;
  LINEERR_REINIT                          = $80000052;
  LINEERR_ADDRESSBLOCKED                  = $80000053;
  LINEERR_BILLINGREJECTED                 = $80000054;
  LINEERR_INVALFEATURE                    = $80000055;
  LINEERR_NOMULTIPLEINSTANCE              = $80000056;
{$IFDEF TAPI20}
  LINEERR_INVALAGENTID                    = $80000057;      { TAPI v2.0 }
  LINEERR_INVALAGENTGROUP                 = $80000058;      { TAPI v2.0 }
  LINEERR_INVALPASSWORD                   = $80000059;      { TAPI v2.0 }
  LINEERR_INVALAGENTSTATE                 = $8000005A;      { TAPI v2.0 }
  LINEERR_INVALAGENTACTIVITY              = $8000005B;      { TAPI v2.0 }
  LINEERR_DIALVOICEDETECT                 = $8000005C;      { TAPI v2.0 }
{$ENDIF}

  LINEFEATURE_DEVSPECIFIC                 = $00000001;
  LINEFEATURE_DEVSPECIFICFEAT             = $00000002;
  LINEFEATURE_FORWARD                     = $00000004;
  LINEFEATURE_MAKECALL                    = $00000008;
  LINEFEATURE_SETMEDIACONTROL             = $00000010;
  LINEFEATURE_SETTERMINAL                 = $00000020;
{$IFDEF TAPI20}
  LINEFEATURE_SETDEVSTATUS                = $00000040;      { TAPI v2.0 }
  LINEFEATURE_FORWARDFWD                  = $00000080;      { TAPI v2.0 }
  LINEFEATURE_FORWARDDND                  = $00000100;      { TAPI v2.0 }
{$ENDIF}

  LINEFORWARDMODE_UNCOND                  = $00000001;
  LINEFORWARDMODE_UNCONDINTERNAL          = $00000002;
  LINEFORWARDMODE_UNCONDEXTERNAL          = $00000004;
  LINEFORWARDMODE_UNCONDSPECIFIC          = $00000008;
  LINEFORWARDMODE_BUSY                    = $00000010;
  LINEFORWARDMODE_BUSYINTERNAL            = $00000020;
  LINEFORWARDMODE_BUSYEXTERNAL            = $00000040;
  LINEFORWARDMODE_BUSYSPECIFIC            = $00000080;
  LINEFORWARDMODE_NOANSW                  = $00000100;
  LINEFORWARDMODE_NOANSWINTERNAL          = $00000200;
  LINEFORWARDMODE_NOANSWEXTERNAL          = $00000400;
  LINEFORWARDMODE_NOANSWSPECIFIC          = $00000800;
  LINEFORWARDMODE_BUSYNA                  = $00001000;
  LINEFORWARDMODE_BUSYNAINTERNAL          = $00002000;
  LINEFORWARDMODE_BUSYNAEXTERNAL          = $00004000;
  LINEFORWARDMODE_BUSYNASPECIFIC          = $00008000;
  LINEFORWARDMODE_UNKNOWN                 = $00010000;      { TAPI v1.4 }
  LINEFORWARDMODE_UNAVAIL                 = $00020000;      { TAPI v1.4 }

  LINEGATHERTERM_BUFFERFULL               = $00000001;
  LINEGATHERTERM_TERMDIGIT                = $00000002;
  LINEGATHERTERM_FIRSTTIMEOUT             = $00000004;
  LINEGATHERTERM_INTERTIMEOUT             = $00000008;
  LINEGATHERTERM_CANCEL                   = $00000010;

  LINEGENERATETERM_DONE                   = $00000001;
  LINEGENERATETERM_CANCEL                 = $00000002;

{$IFDEF TAPI20}
{
 These constants are mutually exclusive - there's no way to specify more
 than one at a time (and it doesn't make sense, either) so they're
 ordinal rather than bits.
}
  LINEINITIALIZEEXOPTION_USEHIDDENWINDOW      = $00000001; { TAPI v2.0 }
  LINEINITIALIZEEXOPTION_USEEVENT             = $00000002; { TAPI v2.0 }
  LINEINITIALIZEEXOPTION_USECOMPLETIONPORT    = $00000003; { TAPI v2.0 }
{$ENDIF}

  LINELOCATIONOPTION_PULSEDIAL            = $00000001;     { TAPI v1.4 }

  LINEMAPPER                              = $FFFFFFFF;

  LINEMEDIACONTROL_NONE                   = $00000001;
  LINEMEDIACONTROL_START                  = $00000002;
  LINEMEDIACONTROL_RESET                  = $00000004;
  LINEMEDIACONTROL_PAUSE                  = $00000008;
  LINEMEDIACONTROL_RESUME                 = $00000010;
  LINEMEDIACONTROL_RATEUP                 = $00000020;
  LINEMEDIACONTROL_RATEDOWN               = $00000040;
  LINEMEDIACONTROL_RATENORMAL             = $00000080;
  LINEMEDIACONTROL_VOLUMEUP               = $00000100;
  LINEMEDIACONTROL_VOLUMEDOWN             = $00000200;
  LINEMEDIACONTROL_VOLUMENORMAL           = $00000400;

  LINEMEDIAMODE_UNKNOWN                   = $00000002;
  LINEMEDIAMODE_INTERACTIVEVOICE          = $00000004;
  LINEMEDIAMODE_AUTOMATEDVOICE            = $00000008;
  LINEMEDIAMODE_DATAMODEM                 = $00000010;
  LINEMEDIAMODE_G3FAX                     = $00000020;
  LINEMEDIAMODE_TDD                       = $00000040;
  LINEMEDIAMODE_G4FAX                     = $00000080;
  LINEMEDIAMODE_DIGITALDATA               = $00000100;
  LINEMEDIAMODE_TELETEX                   = $00000200;
  LINEMEDIAMODE_VIDEOTEX                  = $00000400;
  LINEMEDIAMODE_TELEX                     = $00000800;
  LINEMEDIAMODE_MIXED                     = $00001000;
  LINEMEDIAMODE_ADSI                      = $00002000;
  LINEMEDIAMODE_VOICEVIEW                 = $00004000;      { TAPI v1.4 }
  LAST_LINEMEDIAMODE                      = $00004000;

  LINEOFFERINGMODE_ACTIVE                 = $00000001;      { TAPI v1.4 }
  LINEOFFERINGMODE_INACTIVE               = $00000002;      { TAPI v1.4 }

{$IFDEF TAPI20}
  LINEOPENOPTION_SINGLEADDRESS            = $80000000;      { TAPI v2.0 }
  LINEOPENOPTION_PROXY                    = $40000000;      { TAPI v2.0 }
{$ENDIF}

  LINEPARKMODE_DIRECTED                   = $00000001;
  LINEPARKMODE_NONDIRECTED                = $00000002;

{$IFDEF TAPI20}
  LINEPROXYREQUEST_SETAGENTGROUP          = $00000001;      { TAPI v2.0 }
  LINEPROXYREQUEST_SETAGENTSTATE          = $00000002;      { TAPI v2.0 }
  LINEPROXYREQUEST_SETAGENTACTIVITY       = $00000003;      { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTCAPS           = $00000004;      { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTSTATUS         = $00000005;      { TAPI v2.0 }
  LINEPROXYREQUEST_AGENTSPECIFIC          = $00000006;      { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTACTIVITYLIST   = $00000007;      { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTGROUPLIST      = $00000008;      { TAPI v2.0 }
{$ENDIF}

  LINEREMOVEFROMCONF_NONE                 = $00000001;
  LINEREMOVEFROMCONF_LAST                 = $00000002;
  LINEREMOVEFROMCONF_ANY                  = $00000003;

  LINEREQUESTMODE_MAKECALL                = $00000001;
  LINEREQUESTMODE_MEDIACALL               = $00000002;
  LINEREQUESTMODE_DROP                    = $00000004;
  LAST_LINEREQUESTMODE                    = LINEREQUESTMODE_MEDIACALL;

  LINEROAMMODE_UNKNOWN                    = $00000001;
  LINEROAMMODE_UNAVAIL                    = $00000002;
  LINEROAMMODE_HOME                       = $00000004;
  LINEROAMMODE_ROAMA                      = $00000008;
  LINEROAMMODE_ROAMB                      = $00000010;

  LINESPECIALINFO_NOCIRCUIT               = $00000001;
  LINESPECIALINFO_CUSTIRREG               = $00000002;
  LINESPECIALINFO_REORDER                 = $00000004;
  LINESPECIALINFO_UNKNOWN                 = $00000008;
  LINESPECIALINFO_UNAVAIL                 = $00000010;

  LINETERMDEV_PHONE                       = $00000001;
  LINETERMDEV_HEADSET                     = $00000002;
  LINETERMDEV_SPEAKER                     = $00000004;

  LINETERMMODE_BUTTONS                    = $00000001;
  LINETERMMODE_LAMPS                      = $00000002;
  LINETERMMODE_DISPLAY                    = $00000004;
  LINETERMMODE_RINGER                     = $00000008;
  LINETERMMODE_HOOKSWITCH                 = $00000010;
  LINETERMMODE_MEDIATOLINE                = $00000020;
  LINETERMMODE_MEDIAFROMLINE              = $00000040;
  LINETERMMODE_MEDIABIDIRECT              = $00000080;

  LINETERMSHARING_PRIVATE                 = $00000001;
  LINETERMSHARING_SHAREDEXCL              = $00000002;
  LINETERMSHARING_SHAREDCONF              = $00000004;

  LINETOLLLISTOPTION_ADD                  = $00000001;
  LINETOLLLISTOPTION_REMOVE               = $00000002;

  LINETONEMODE_CUSTOM                     = $00000001;
  LINETONEMODE_RINGBACK                   = $00000002;
  LINETONEMODE_BUSY                       = $00000004;
  LINETONEMODE_BEEP                       = $00000008;
  LINETONEMODE_BILLING                    = $00000010;

  LINETRANSFERMODE_TRANSFER               = $00000001;
  LINETRANSFERMODE_CONFERENCE             = $00000002;

  LINETRANSLATEOPTION_CARDOVERRIDE        = $00000001;
  LINETRANSLATEOPTION_CANCELCALLWAITING   = $00000002;      { TAPI v1.4 }
  LINETRANSLATEOPTION_FORCELOCAL          = $00000004;      { TAPI v1.4 }
  LINETRANSLATEOPTION_FORCELD             = $00000008;      { TAPI v1.4 }

  LINETRANSLATERESULT_CANONICAL           = $00000001;
  LINETRANSLATERESULT_INTERNATIONAL       = $00000002;
  LINETRANSLATERESULT_LONGDISTANCE        = $00000004;
  LINETRANSLATERESULT_LOCAL               = $00000008;
  LINETRANSLATERESULT_INTOLLLIST          = $00000010;
  LINETRANSLATERESULT_NOTINTOLLLIST       = $00000020;
  LINETRANSLATERESULT_DIALBILLING         = $00000040;
  LINETRANSLATERESULT_DIALQUIET           = $00000080;
  LINETRANSLATERESULT_DIALDIALTONE        = $00000100;
  LINETRANSLATERESULT_DIALPROMPT          = $00000200;
{$IFDEF TAPI20}
  LINETRANSLATERESULT_VOICEDETECT         = $00000400;      { TAPI v2.0 }
{$ENDIF}

  PHONEBUTTONFUNCTION_UNKNOWN             = $00000000;
  PHONEBUTTONFUNCTION_CONFERENCE          = $00000001;
  PHONEBUTTONFUNCTION_TRANSFER            = $00000002;
  PHONEBUTTONFUNCTION_DROP                = $00000003;
  PHONEBUTTONFUNCTION_HOLD                = $00000004;
  PHONEBUTTONFUNCTION_RECALL              = $00000005;
  PHONEBUTTONFUNCTION_DISCONNECT          = $00000006;
  PHONEBUTTONFUNCTION_CONNECT             = $00000007;
  PHONEBUTTONFUNCTION_MSGWAITON           = $00000008;
  PHONEBUTTONFUNCTION_MSGWAITOFF          = $00000009;
  PHONEBUTTONFUNCTION_SELECTRING          = $0000000A;
  PHONEBUTTONFUNCTION_ABBREVDIAL          = $0000000B;
  PHONEBUTTONFUNCTION_FORWARD             = $0000000C;
  PHONEBUTTONFUNCTION_PICKUP              = $0000000D;
  PHONEBUTTONFUNCTION_RINGAGAIN           = $0000000E;
  PHONEBUTTONFUNCTION_PARK                = $0000000F;
  PHONEBUTTONFUNCTION_REJECT              = $00000010;
  PHONEBUTTONFUNCTION_REDIRECT            = $00000011;
  PHONEBUTTONFUNCTION_MUTE                = $00000012;
  PHONEBUTTONFUNCTION_VOLUMEUP            = $00000013;
  PHONEBUTTONFUNCTION_VOLUMEDOWN          = $00000014;
  PHONEBUTTONFUNCTION_SPEAKERON           = $00000015;
  PHONEBUTTONFUNCTION_SPEAKEROFF          = $00000016;
  PHONEBUTTONFUNCTION_FLASH               = $00000017;
  PHONEBUTTONFUNCTION_DATAON              = $00000018;
  PHONEBUTTONFUNCTION_DATAOFF             = $00000019;
  PHONEBUTTONFUNCTION_DONOTDISTURB        = $0000001A;
  PHONEBUTTONFUNCTION_INTERCOM            = $0000001B;
  PHONEBUTTONFUNCTION_BRIDGEDAPP          = $0000001C;
  PHONEBUTTONFUNCTION_BUSY                = $0000001D;
  PHONEBUTTONFUNCTION_CALLAPP             = $0000001E;
  PHONEBUTTONFUNCTION_DATETIME            = $0000001F;
  PHONEBUTTONFUNCTION_DIRECTORY           = $00000020;
  PHONEBUTTONFUNCTION_COVER               = $00000021;
  PHONEBUTTONFUNCTION_CALLID              = $00000022;
  PHONEBUTTONFUNCTION_LASTNUM             = $00000023;
  PHONEBUTTONFUNCTION_NIGHTSRV            = $00000024;
  PHONEBUTTONFUNCTION_SENDCALLS           = $00000025;
  PHONEBUTTONFUNCTION_MSGINDICATOR        = $00000026;
  PHONEBUTTONFUNCTION_REPDIAL             = $00000027;
  PHONEBUTTONFUNCTION_SETREPDIAL          = $00000028;
  PHONEBUTTONFUNCTION_SYSTEMSPEED         = $00000029;
  PHONEBUTTONFUNCTION_STATIONSPEED        = $0000002A;
  PHONEBUTTONFUNCTION_CAMPON              = $0000002B;
  PHONEBUTTONFUNCTION_SAVEREPEAT          = $0000002C;
  PHONEBUTTONFUNCTION_QUEUECALL           = $0000002D;
  PHONEBUTTONFUNCTION_NONE                = $0000002E;

  PHONEBUTTONMODE_DUMMY                   = $00000001;
  PHONEBUTTONMODE_CALL                    = $00000002;
  PHONEBUTTONMODE_FEATURE                 = $00000004;
  PHONEBUTTONMODE_KEYPAD                  = $00000008;
  PHONEBUTTONMODE_LOCAL                   = $00000010;
  PHONEBUTTONMODE_DISPLAY                 = $00000020;

  PHONEBUTTONSTATE_UP                     = $00000001;
  PHONEBUTTONSTATE_DOWN                   = $00000002;
  PHONEBUTTONSTATE_UNKNOWN                = $00000004;      { TAPI v1.4 }
  PHONEBUTTONSTATE_UNAVAIL                = $00000008;      { TAPI v1.4 }

  PHONEERR_ALLOCATED                      = $90000001;
  PHONEERR_BADDEVICEID                    = $90000002;
  PHONEERR_INCOMPATIBLEAPIVERSION         = $90000003;
  PHONEERR_INCOMPATIBLEEXTVERSION         = $90000004;
  PHONEERR_INIFILECORRUPT                 = $90000005;
  PHONEERR_INUSE                          = $90000006;
  PHONEERR_INVALAPPHANDLE                 = $90000007;
  PHONEERR_INVALAPPNAME                   = $90000008;
  PHONEERR_INVALBUTTONLAMPID              = $90000009;
  PHONEERR_INVALBUTTONMODE                = $9000000A;
  PHONEERR_INVALBUTTONSTATE               = $9000000B;
  PHONEERR_INVALDATAID                    = $9000000C;
  PHONEERR_INVALDEVICECLASS               = $9000000D;
  PHONEERR_INVALEXTVERSION                = $9000000E;
  PHONEERR_INVALHOOKSWITCHDEV             = $9000000F;
  PHONEERR_INVALHOOKSWITCHMODE            = $90000010;
  PHONEERR_INVALLAMPMODE                  = $90000011;
  PHONEERR_INVALPARAM                     = $90000012;
  PHONEERR_INVALPHONEHANDLE               = $90000013;
  PHONEERR_INVALPHONESTATE                = $90000014;
  PHONEERR_INVALPOINTER                   = $90000015;
  PHONEERR_INVALPRIVILEGE                 = $90000016;
  PHONEERR_INVALRINGMODE                  = $90000017;
  PHONEERR_NODEVICE                       = $90000018;
  PHONEERR_NODRIVER                       = $90000019;
  PHONEERR_NOMEM                          = $9000001A;
  PHONEERR_NOTOWNER                       = $9000001B;
  PHONEERR_OPERATIONFAILED                = $9000001C;
  PHONEERR_OPERATIONUNAVAIL               = $9000001D;
  PHONEERR_RESOURCEUNAVAIL                = $9000001F;
  PHONEERR_REQUESTOVERRUN                 = $90000020;
  PHONEERR_STRUCTURETOOSMALL              = $90000021;
  PHONEERR_UNINITIALIZED                  = $90000022;
  PHONEERR_REINIT                         = $90000023;


{$IFDEF TAPI20}
  PHONEFEATURE_GETBUTTONINFO              = $00000001;      { TAPI v2.0 }
  PHONEFEATURE_GETDATA                    = $00000002;      { TAPI v2.0 }
  PHONEFEATURE_GETDISPLAY                 = $00000004;      { TAPI v2.0 }
  PHONEFEATURE_GETGAINHANDSET             = $00000008;      { TAPI v2.0 }
  PHONEFEATURE_GETGAINSPEAKER             = $00000010;      { TAPI v2.0 }
  PHONEFEATURE_GETGAINHEADSET             = $00000020;      { TAPI v2.0 }
  PHONEFEATURE_GETHOOKSWITCHHANDSET       = $00000040;      { TAPI v2.0 }
  PHONEFEATURE_GETHOOKSWITCHSPEAKER       = $00000080;      { TAPI v2.0 }
  PHONEFEATURE_GETHOOKSWITCHHEADSET       = $00000100;      { TAPI v2.0 }
  PHONEFEATURE_GETLAMP                    = $00000200;      { TAPI v2.0 }
  PHONEFEATURE_GETRING                    = $00000400;      { TAPI v2.0 }
  PHONEFEATURE_GETVOLUMEHANDSET           = $00000800;      { TAPI v2.0 }
  PHONEFEATURE_GETVOLUMESPEAKER           = $00001000;      { TAPI v2.0 }
  PHONEFEATURE_GETVOLUMEHEADSET           = $00002000;      { TAPI v2.0 }
  PHONEFEATURE_SETBUTTONINFO              = $00004000;      { TAPI v2.0 }
  PHONEFEATURE_SETDATA                    = $00008000;      { TAPI v2.0 }
  PHONEFEATURE_SETDISPLAY                 = $00010000;      { TAPI v2.0 }
  PHONEFEATURE_SETGAINHANDSET             = $00020000;      { TAPI v2.0 }
  PHONEFEATURE_SETGAINSPEAKER             = $00040000;      { TAPI v2.0 }
  PHONEFEATURE_SETGAINHEADSET             = $00080000;      { TAPI v2.0 }
  PHONEFEATURE_SETHOOKSWITCHHANDSET       = $00100000;      { TAPI v2.0 }
  PHONEFEATURE_SETHOOKSWITCHSPEAKER       = $00200000;      { TAPI v2.0 }
  PHONEFEATURE_SETHOOKSWITCHHEADSET       = $00400000;      { TAPI v2.0 }
  PHONEFEATURE_SETLAMP                    = $00800000;      { TAPI v2.0 }
  PHONEFEATURE_SETRING                    = $01000000;      { TAPI v2.0 }
  PHONEFEATURE_SETVOLUMEHANDSET           = $02000000;      { TAPI v2.0 }
  PHONEFEATURE_SETVOLUMESPEAKER           = $04000000;      { TAPI v2.0 }
  PHONEFEATURE_SETVOLUMEHEADSET           = $08000000;      { TAPI v2.0 }
{$ENDIF}

  PHONEHOOKSWITCHDEV_HANDSET              = $00000001;
  PHONEHOOKSWITCHDEV_SPEAKER              = $00000002;
  PHONEHOOKSWITCHDEV_HEADSET              = $00000004;

  PHONEHOOKSWITCHMODE_ONHOOK              = $00000001;
  PHONEHOOKSWITCHMODE_MIC                 = $00000002;
  PHONEHOOKSWITCHMODE_SPEAKER             = $00000004;
  PHONEHOOKSWITCHMODE_MICSPEAKER          = $00000008;
  PHONEHOOKSWITCHMODE_UNKNOWN             = $00000010;

{$IFDEF TAPI20}
  PHONEINITIALIZEEXOPTION_USEHIDDENWINDOW     = $00000001;  { TAPI v2.0 }
  PHONEINITIALIZEEXOPTION_USEEVENT            = $00000002;  { TAPI v2.0 }
  PHONEINITIALIZEEXOPTION_USECOMPLETIONPORT   = $00000003;  { TAPI v2.0 }
{$ENDIF}

  PHONELAMPMODE_DUMMY                     = $00000001;
  PHONELAMPMODE_OFF                       = $00000002;
  PHONELAMPMODE_STEADY                    = $00000004;
  PHONELAMPMODE_WINK                      = $00000008;
  PHONELAMPMODE_FLASH                     = $00000010;
  PHONELAMPMODE_FLUTTER                   = $00000020;
  PHONELAMPMODE_BROKENFLUTTER             = $00000040;
  PHONELAMPMODE_UNKNOWN                   = $00000080;

  PHONEPRIVILEGE_MONITOR                  = $00000001;
  PHONEPRIVILEGE_OWNER                    = $00000002;

  PHONESTATE_OTHER                        = $00000001;
  PHONESTATE_CONNECTED                    = $00000002;
  PHONESTATE_DISCONNECTED                 = $00000004;
  PHONESTATE_OWNER                        = $00000008;
  PHONESTATE_MONITORS                     = $00000010;
  PHONESTATE_DISPLAY                      = $00000020;
  PHONESTATE_LAMP                         = $00000040;
  PHONESTATE_RINGMODE                     = $00000080;
  PHONESTATE_RINGVOLUME                   = $00000100;
  PHONESTATE_HANDSETHOOKSWITCH            = $00000200;
  PHONESTATE_HANDSETVOLUME                = $00000400;
  PHONESTATE_HANDSETGAIN                  = $00000800;
  PHONESTATE_SPEAKERHOOKSWITCH            = $00001000;
  PHONESTATE_SPEAKERVOLUME                = $00002000;
  PHONESTATE_SPEAKERGAIN                  = $00004000;
  PHONESTATE_HEADSETHOOKSWITCH            = $00008000;
  PHONESTATE_HEADSETVOLUME                = $00010000;
  PHONESTATE_HEADSETGAIN                  = $00020000;
  PHONESTATE_SUSPEND                      = $00040000;
  PHONESTATE_RESUME                       = $00080000;
  PHONESTATE_DEVSPECIFIC                  = $00100000;
  PHONESTATE_REINIT                       = $00200000;
  PHONESTATE_CAPSCHANGE                   = $00400000;      { TAPI v1.4 }
  PHONESTATE_REMOVED                      = $00800000;      { TAPI v1.4 }

  PHONESTATUSFLAGS_CONNECTED              = $00000001;
  PHONESTATUSFLAGS_SUSPENDED              = $00000002;

  STRINGFORMAT_ASCII                      = $00000001;
  STRINGFORMAT_DBCS                       = $00000002;
  STRINGFORMAT_UNICODE                    = $00000003;
  STRINGFORMAT_BINARY                     = $00000004;

  TAPI_REPLY                              = WM_USER + 99;

  TAPIERR_CONNECTED                       = 0;
  TAPIERR_DROPPED                         = -1;
  TAPIERR_NOREQUESTRECIPIENT              = -2;
  TAPIERR_REQUESTQUEUEFULL                = -3;
  TAPIERR_INVALDESTADDRESS                = -4;
  TAPIERR_INVALWINDOWHANDLE               = -5;
  TAPIERR_INVALDEVICECLASS                = -6;
  TAPIERR_INVALDEVICEID                   = -7;
  TAPIERR_DEVICECLASSUNAVAIL              = -8;
  TAPIERR_DEVICEIDUNAVAIL                 = -9;
  TAPIERR_DEVICEINUSE                     = -10;
  TAPIERR_DESTBUSY                        = -11;
  TAPIERR_DESTNOANSWER                    = -12;
  TAPIERR_DESTUNAVAIL                     = -13;
  TAPIERR_UNKNOWNWINHANDLE                = -14;
  TAPIERR_UNKNOWNREQUESTID                = -15;
  TAPIERR_REQUESTFAILED                   = -16;
  TAPIERR_REQUESTCANCELLED                = -17;
  TAPIERR_INVALPOINTER                    = -18;


  TAPIMAXDESTADDRESSSIZE                  = 80;
  TAPIMAXAPPNAMESIZE                      = 40;
  TAPIMAXCALLEDPARTYSIZE                  = 40;
  TAPIMAXCOMMENTSIZE                      = 80;
  TAPIMAXDEVICECLASSSIZE                  = 40;
  TAPIMAXDEVICEIDSIZE                     = 40;



type
  LPLineAddressCaps = ^TLineAddressCaps;
  TLineAddressCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwLineDeviceID,
    dwAddressSize,
    dwAddressOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset,
    dwAddressSharing,
    dwAddressStates,
    dwCallInfoStates,
    dwCallerIDFlags,
    dwCalledIDFlags,
    dwConnectedIDFlags,
    dwRedirectionIDFlags,
    dwRedirectingIDFlags,
    dwCallStates,
    dwDialToneModes,
    dwBusyModes,
    dwSpecialInfo,
    dwDisconnectModes,
    dwMaxNumActiveCalls,
    dwMaxNumOnHoldCalls,
    dwMaxNumOnHoldPendingCalls,
    dwMaxNumConference,
    dwMaxNumTransConf,
    dwAddrCapFlags,
    dwCallFeatures,
    dwRemoveFromConfCaps,
    dwRemoveFromConfState,
    dwTransferModes,
    dwParkModes,
    dwForwardModes,
    dwMaxForwardEntries,
    dwMaxSpecificEntries,
    dwMinFwdNumRings,
    dwMaxFwdNumRings,
    dwMaxCallCompletions,
    dwCallCompletionConds,
    dwCallCompletionModes,
    dwNumCompletionMessages,
    dwCompletionMsgTextEntrySize,
    dwCompletionMsgTextSize,
    dwCompletionMsgTextOffset,

    dwAddressFeatures: Longint;                     { TAPI v1.4 }

{$IFDEF TAPI20}
    dwPredictiveAutoTransferStates,                 { TAPI v2.0 }
    dwNumCallTreatments,                            { TAPI v2.0 }
    dwCallTreatmentListSize,                        { TAPI v2.0 }
    dwCallTreatmentListOffset,                      { TAPI v2.0 }
    dwDeviceClassesSize,                            { TAPI v2.0 }
    dwDeviceClassesOffset,                          { TAPI v2.0 }
    dwMaxCallDataSize,                              { TAPI v2.0 }
    dwCallFeatures2,                                { TAPI v2.0 }
    dwMaxNoAnswerTimeout,                           { TAPI v2.0 }
    dwConnectedModes,                               { TAPI v2.0 }
    dwOfferingModes,                                { TAPI v2.0 }
    dwAvailableMediaModes: Longint;                 { TAPI v2.0 }
{$ENDIF}
  end;

  LPLineAddressStatus = ^TLineAddressStatus;
  TLineAddressStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumInUse,
    dwNumActiveCalls,
    dwNumOnHoldCalls,
    dwNumOnHoldPendCalls,
    dwAddressFeatures,
    dwNumRingsNoAnswer,
    dwForwardNumEntries,
    dwForwardSize,
    dwForwardOffset,
    dwTerminalModesSize,
    dwTerminalModesOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;
  end;

{$IFDEF TAPI20}
  LPLineAgentActivityEntry = ^TLineAgentActivityEntry;
  TLineAgentActivityEntry = record
    dwID,                                           { TAPI v2.0 }
    dwNameSize,                                     { TAPI v2.0 }
    dwNameOffset: Longint;                          { TAPI v2.0 }
  end;

  LPLineAgentActivityList = ^TLineAgentActivityList;
  TLineAgentActivityList = record
    dwTotalSize,                                    { TAPI v2.0 }
    dwNeededSize,                                   { TAPI v2.0 }
    dwUsedSize,                                     { TAPI v2.0 }
    dwNumEntries,                                   { TAPI v2.0 }
    dwListSize,                                     { TAPI v2.0 }
    dwListOffset: Longint;                          { TAPI v2.0 }
  end;

  LPLineAgentCaps = ^TLineAgentCaps;
  TLineAgentCaps = record
    dwTotalSize,                                    { TAPI v2.0 }
    dwNeededSize,                                   { TAPI v2.0 }
    dwUsedSize,                                     { TAPI v2.0 }
    dwAgentHandlerInfoSize,                         { TAPI v2.0 }
    dwAgentHandlerInfoOffset,                       { TAPI v2.0 }
    dwCapsVersion,                                  { TAPI v2.0 }
    dwFeatures,                                     { TAPI v2.0 }
    dwStates,                                       { TAPI v2.0 }
    dwNextStates,                                   { TAPI v2.0 }
    dwMaxNumGroupEntries,                           { TAPI v2.0 }
    dwAgentStatusMessages,                          { TAPI v2.0 }
    dwNumAgentExtensionIDs,                         { TAPI v2.0 }
    dwAgentExtensionIDListSize,                     { TAPI v2.0 }
    dwAgentExtensionIDListOffset: Longint;          { TAPI v2.0 }
  end;

  LPLineAgentGroupEntry = ^TLineAgentGroupEntry;
  TLineAgentGroupEntry = record
    GroupID: record
      dwGroupID1,                                   { TAPI v2.0 }
      dwGroupID2,                                   { TAPI v2.0 }
      dwGroupID3,                                   { TAPI v2.0 }
      dwGroupID4: Longint;                          { TAPI v2.0 }
    end;
    dwNameSize,                                     { TAPI v2.0 }
    dwNameOffset: Longint;                          { TAPI v2.0 }
  end;

  LPLineAgentGroupList = ^TLineAgentGroupList;
  TLineAgentGroupList = record
    dwTotalSize,                                    { TAPI v2.0 }
    dwNeededSize,                                   { TAPI v2.0 }
    dwUsedSize,                                     { TAPI v2.0 }
    dwNumEntries,                                   { TAPI v2.0 }
    dwListSize,                                     { TAPI v2.0 }
    dwListOffset: Longint;                          { TAPI v2.0 }
  end;

  LPLineAgentStatus = ^TLineAgentStatus;
  TLineAgentStatus = record
    dwTotalSize,                                    { TAPI v2.0 }
    dwNeededSize,                                   { TAPI v2.0 }
    dwUsedSize,                                     { TAPI v2.0 }
    dwNumEntries,                                   { TAPI v2.0 }
    dwGroupListSize,                                { TAPI v2.0 }
    dwGroupListOffset,                              { TAPI v2.0 }
    dwState,                                        { TAPI v2.0 }
    dwNextState,                                    { TAPI v2.0 }
    dwActivityID,                                   { TAPI v2.0 }
    dwActivitySize,                                 { TAPI v2.0 }
    dwActivityOffset,                               { TAPI v2.0 }
    dwAgentFeatures,                                { TAPI v2.0 }
    dwValidStates,                                  { TAPI v2.0 }
    dwValidNextStates: Longint;                     { TAPI v2.0 }
  end;

  LPLineAppInfo = ^TLineAppInfo;
  TLineAppInfo = record
    dwMachineNameSize,                              { TAPI v2.0 }
    dwMachineNameOffset,                            { TAPI v2.0 }
    dwUserNameSize,                                 { TAPI v2.0 }
    dwUserNameOffset,                               { TAPI v2.0 }
    dwModuleFilenameSize,                           { TAPI v2.0 }
    dwModuleFilenameOffset,                         { TAPI v2.0 }
    dwFriendlyNameSize,                             { TAPI v2.0 }
    dwFriendlyNameOffset,                           { TAPI v2.0 }
    dwMediaModes,                                   { TAPI v2.0 }
    dwAddressID: Longint;                           { TAPI v2.0 }
  end;
{$ENDIF}

  LPLineDialParams = ^TLineDialParams;
  TLineDialParams = record
    dwDialPause,
    dwDialSpeed,
    dwDigitDuration,
    dwWaitForDialtone: Longint;
  end;

  LPLineCallInfo = ^TLineCallInfo;
  TLineCallInfo = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize: Longint;
    hLine: THLine;
    dwLineDeviceID,
    dwAddressID,
    dwBearerMode,
    dwRate,
    dwMediaMode,
    dwAppSpecific,
    dwCallID,
    dwRelatedCallID,
    dwCallParamFlags,
    dwCallStates,
    dwMonitorDigitModes,
    dwMonitorMediaModes: Longint;
    DialParams: TLineDialParams;
    dwOrigin,
    dwReason,
    dwCompletionID,
    dwNumOwners,
    dwNumMonitors,
    dwCountryCode,
    dwTrunk,
    dwCallerIDFlags,
    dwCallerIDSize,
    dwCallerIDOffset,
    dwCallerIDNameSize,
    dwCallerIDNameOffset,
    dwCalledIDFlags,
    dwCalledIDSize,
    dwCalledIDOffset,
    dwCalledIDNameSize,
    dwCalledIDNameOffset,
    dwConnectedIDFlags,
    dwConnectedIDSize,
    dwConnectedIDOffset,
    dwConnectedIDNameSize,
    dwConnectedIDNameOffset,
    dwRedirectionIDFlags,
    dwRedirectionIDSize,
    dwRedirectionIDOffset,
    dwRedirectionIDNameSize,
    dwRedirectionIDNameOffset,
    dwRedirectingIDFlags,
    dwRedirectingIDSize,
    dwRedirectingIDOffset,
    dwRedirectingIDNameSize,
    dwRedirectingIDNameOffset,
    dwAppNameSize,
    dwAppNameOffset,
    dwDisplayableAddressSize,
    dwDisplayableAddressOffset,
    dwCalledPartySize,
    dwCalledPartyOffset,
    dwCommentSize,
    dwCommentOffset,
    dwDisplaySize,
    dwDisplayOffset,
    dwUserUserInfoSize,
    dwUserUserInfoOffset,
    dwHighLevelCompSize,
    dwHighLevelCompOffset,
    dwLowLevelCompSize,
    dwLowLevelCompOffset,
    dwChargingInfoSize,
    dwChargingInfoOffset,
    dwTerminalModesSize,
    dwTerminalModesOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;

{$IFDEF TAPI20}
    dwCallTreatment,                                { TAPI v2.0 }
    dwCallDataSize,                                 { TAPI v2.0 }
    dwCallDataOffset,                               { TAPI v2.0 }
    dwSendingFlowspecSize,                          { TAPI v2.0 }
    dwSendingFlowspecOffset,                        { TAPI v2.0 }
    dwReceivingFlowspecSize,                        { TAPI v2.0 }
    dwReceivingFlowspecOffset: Longint;             { TAPI v2.0 }
{$ENDIF}
  end;

  LPLineCallList = ^TLineCallList;
  TLineCallList = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwCallsNumEntries,
    dwCallsSize,
    dwCallsOffset: Longint;
  end;

  LPLineCallParams = ^TLineCallParams;
  TLineCallParams = record            { Defaults:        }
    dwTotalSize,                    { ---------        }
    dwBearerMode,                   { voice            }
    dwMinRate,                      { (3.1kHz)         }
    dwMaxRate,                      { (3.1kHz)         }
    dwMediaMode,                    { interactiveVoice }
    dwCallParamFlags,               { 0                }
    dwAddressMode,                  { addressID        }
    dwAddressID: Longint;           { (any available)  }
    DialParams: TLineDialParams;    { (0, 0, 0, 0)     }
    dwOrigAddressSize,              { 0                }
    dwOrigAddressOffset,
    dwDisplayableAddressSize,
    dwDisplayableAddressOffset,
    dwCalledPartySize,              { 0                }
    dwCalledPartyOffset,
    dwCommentSize,                  { 0                }
    dwCommentOffset,
    dwUserUserInfoSize,             { 0                }
    dwUserUserInfoOffset,
    dwHighLevelCompSize,            { 0                }
    dwHighLevelCompOffset,
    dwLowLevelCompSize,             { 0                }
    dwLowLevelCompOffset,
    dwDevSpecificSize,              { 0                }
    dwDevSpecificOffset: Longint;

{$IFDEF TAPI20}
    dwPredictiveAutoTransferStates,                 { TAPI v2.0 }
    dwTargetAddressSize,                            { TAPI v2.0 }
    dwTargetAddressOffset,                          { TAPI v2.0 }
    dwSendingFlowspecSize,                          { TAPI v2.0 }
    dwSendingFlowspecOffset,                        { TAPI v2.0 }
    dwReceivingFlowspecSize,                        { TAPI v2.0 }
    dwReceivingFlowspecOffset,                      { TAPI v2.0 }
    dwDeviceClassSize,                              { TAPI v2.0 }
    dwDeviceClassOffset,                            { TAPI v2.0 }
    dwDeviceConfigSize,                             { TAPI v2.0 }
    dwDeviceConfigOffset,                           { TAPI v2.0 }
    dwCallDataSize,                                 { TAPI v2.0 }
    dwCallDataOffset,                               { TAPI v2.0 }
    dwNoAnswerTimeout,                              { TAPI v2.0 }
    dwCallingPartyIDSize,                           { TAPI v2.0 }
    dwCallingPartyIDOffset: Longint;                { TAPI v2.0 }
{$ENDIF}
  end;

  LPLineCallStatus = ^TLineCallStatus;
  TLineCallStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwCallState,
    dwCallStateMode,
    dwCallPrivilege,
    dwCallFeatures,
    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;

{$IFDEF TAPI20}
    dwCallFeatures2: Longint;                       { TAPI v2.0 }
  {$IFDEF WIN32}
    tStateEntryTime: TSystemTime;                   { TAPI v2.0 }
  {$ELSE}
    tStateEntryTime: array[0..7] of Word;           { TAPI v2.0 }
  {$ENDIF}
{$ENDIF}
  end;


{$IFDEF TAPI20}
  LPLineCallTreatmentEntry = ^TLineCallTreatmentEntry;
  TLineCallTreatmentEntry = record
    dwCallTreatmentID,                              { TAPI v2.0 }
    dwCallTreatmentNameSize,                        { TAPI v2.0 }
    dwCallTreatmentNameOffset: Longint;             { TAPI v2.0 }
  end;
{$ENDIF}


  LPLineCardEntry = ^TLineCardEntry;
  TLineCardEntry = record
    dwPermanentCardID,
    dwCardNameSize,
    dwCardNameOffset,
    dwCardNumberDigits,                             { TAPI v1.4 }
    dwSameAreaRuleSize,                             { TAPI v1.4 }
    dwSameAreaRuleOffset,                           { TAPI v1.4 }
    dwLongDistanceRuleSize,                         { TAPI v1.4 }
    dwLongDistanceRuleOffset,                       { TAPI v1.4 }
    dwInternationalRuleSize,                        { TAPI v1.4 }
    dwInternationalRuleOffset,                      { TAPI v1.4 }
    dwOptions: Longint;                             { TAPI v1.4 }
  end;

  LPLineCountryEntry = ^TLineCountryEntry;
  TLineCountryEntry = record
    dwCountryID,                                    { TAPI v1.4 }
    dwCountryCode,                                  { TAPI v1.4 }
    dwNextCountryID,                                { TAPI v1.4 }
    dwCountryNameSize,                              { TAPI v1.4 }
    dwCountryNameOffset,                            { TAPI v1.4 }
    dwSameAreaRuleSize,                             { TAPI v1.4 }
    dwSameAreaRuleOffset,                           { TAPI v1.4 }
    dwLongDistanceRuleSize,                         { TAPI v1.4 }
    dwLongDistanceRuleOffset,                       { TAPI v1.4 }
    dwInternationalRuleSize,                        { TAPI v1.4 }
    dwInternationalRuleOffset: Longint;             { TAPI v1.4 }
  end;

  LPLineCountryList = ^TLineCountryList;
  TLineCountryList = record
    dwTotalSize,                                    { TAPI v1.4 }
    dwNeededSize,                                   { TAPI v1.4 }
    dwUsedSize,                                     { TAPI v1.4 }
    dwNumCountries,                                 { TAPI v1.4 }
    dwCountryListSize,                              { TAPI v1.4 }
    dwCountryListOffset: Longint;                   { TAPI v1.4 }
  end;

  LPLineDevCaps = ^TLineDevCaps;
  TLineDevCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwProviderInfoSize,
    dwProviderInfoOffset,
    dwSwitchInfoSize,
    dwSwitchInfoOffset,
    dwPermanenTLineID,
    dwLineNameSize,
    dwLineNameOffset,
    dwStringFormat,
    dwAddressModes,
    dwNumAddresses,
    dwBearerModes,
    dwMaxRate,
    dwMediaModes,
    dwGenerateToneModes,
    dwGenerateToneMaxNumFreq,
    dwGenerateDigitModes,
    dwMonitorToneMaxNumFreq,
    dwMonitorToneMaxNumEntries,
    dwMonitorDigitModes,
    dwGatherDigitsMinTimeout,
    dwGatherDigitsMaxTimeout,
    dwMedCtlDigitMaxListSize,
    dwMedCtlMediaMaxListSize,
    dwMedCtlToneMaxListSize,
    dwMedCtlCallStateMaxListSize,
    dwDevCapFlags,
    dwMaxNumActiveCalls,
    dwAnswerMode,
    dwRingModes,
    dwLineStates,
    dwUUIAcceptSize,
    dwUUIAnswerSize,
    dwUUIMakeCallSize,
    dwUUIDropSize,
    dwUUISendUserUserInfoSize,
    dwUUICallInfoSize: Longint;
    MinDialParams,
    MaxDialParams,
    DefaultDialParams: TLineDialParams;
    dwNumTerminals,
    dwTerminalCapsSize,
    dwTerminalCapsOffset,
    dwTerminalTextEntrySize,
    dwTerminalTextSize,
    dwTerminalTextOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset,

    dwLineFeatures: Longint;                        { TAPI v1.4 }

{$IFDEF TAPI20}
    dwSettableDevStatus,                            { TAPI v2.0 }
    dwDeviceClassesSize,                            { TAPI v2.0 }
    dwDeviceClassesOffset: Longint;                 { TAPI v2.0 }
{$ENDIF}
  end;

  LPLineDevStatus = ^TLineDevStatus;
  TLineDevStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumOpens,
    dwOpenMediaModes,
    dwNumActiveCalls,
    dwNumOnHoldCalls,
    dwNumOnHoldPendCalls,
    dwLineFeatures,
    dwNumCallCompletions,
    dwRingMode,
    dwSignalLevel,
    dwBatteryLevel,
    dwRoamMode,
    dwDevStatusFlags,
    dwTerminalModesSize,
    dwTerminalModesOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;

{$IFDEF TAPI20}
    dwAvailableMediaModes,                          { TAPI v2.0 }
    dwAppInfoSize,                                  { TAPI v2.0 }
    dwAppInfoOffset: Longint;                       { TAPI v2.0 }
{$ENDIF}
  end;

  LPLineExtensionID = ^TLineExtensionID;
  TLineExtensionID = record
    dwExtensionID0,
    dwExtensionID1,
    dwExtensionID2,
    dwExtensionID3: Longint;
  end;

  LPLineForward = ^TLineForward;
  TLineForward = record
    dwForwardMode,
    dwCallerAddressSize,
    dwCallerAddressOffset,
    dwDestCountryCode,
    dwDestAddressSize,
    dwDestAddressOffset: Longint;
  end;

  LPLineForwardList = ^TLineForwardList;
  TLineForwardList = record
    dwTotalSize,
    dwNumEntries: Longint;
  end;

  LPLineGenerateTone = ^TLineGenerateTone;
  PLINEGENERATETONE = ^TLineGENERATETONE;
  TLineGenerateTone = record
    dwFrequency,
    dwCadenceOn,
    dwCadenceOff,
    dwVolume: Longint;
  end;

{$IFDEF TAPI20}
  THandleUnion = record
    case Integer of
      0: (hEvent: THandle);
      1: (hCompletionPort: THandle);
  end;

  LPLineInitializeExParams = ^TLineInitializeExParams;
  TLineInitializeExParams = record
    dwTotalSize,                                    { TAPI v2.0 }
    dwNeededSize,                                   { TAPI v2.0 }
    dwUsedSize,                                     { TAPI v2.0 }
    dwOptions: Longint;                             { TAPI v2.0 }

    Handles: THandleUnion;

    dwCompletionKey: Longint;                       { TAPI v2.0 }
  end;
{$ENDIF}

  LPLineLocationEntry = ^TLineLocationEntry;
  TLineLocationEntry = record
    dwPermanentLocationID,
    dwLocationNameSize,
    dwLocationNameOffset,
    dwCountryCode,
    dwCityCodeSize,
    dwCityCodeOffset,
    dwPreferredCardID,

    dwLocalAccessCodeSize,                          { TAPI v1.4 }
    dwLocalAccessCodeOffset,                        { TAPI v1.4 }
    dwLongDistanceAccessCodeSize,                   { TAPI v1.4 }
    dwLongDistanceAccessCodeOffset,                 { TAPI v1.4 }
    dwTollPrefixListSize,                           { TAPI v1.4 }
    dwTollPrefixListOffset,                         { TAPI v1.4 }
    dwCountryID,                                    { TAPI v1.4 }
    dwOptions,                                      { TAPI v1.4 }
    dwCancelCallWaitingSize,                        { TAPI v1.4 }
    dwCancelCallWaitingOffset: Longint;             { TAPI v1.4 }
  end;

  LPLineMediaControlCallState = ^TLineMediaControlCallState;
  TLineMediaControlCallState = record
    dwCallStates,
    dwMediaControl: Longint;
  end;

  LPLineMediaControlDigit = ^TLineMediaControlDigit;
  TLineMediaControlDigit = record
    dwDigit,
    dwDigitModes,
    dwMediaControl: Longint;
  end;

  LPLineMediaControlMedia = ^TLineMediaControlMedia;
  TLineMediaControlMedia = record
    dwMediaModes,
    dwDuration,
    dwMediaControl: Longint;
  end;

  LPLineMediaControlTone = ^TLineMediaControlTone;
  TLineMediaControlTone = record
    dwAppSpecific,
    dwDuration,
    dwFrequency1,
    dwFrequency2,
    dwFrequency3,
    dwMediaControl: Longint;
  end;

{$IFDEF TAPI20}
  LPLineMessage = ^TLineMessage;
  TLineMessage = record
    hDevice,                                        { TAPI v2.0 }
    dwMessageID,                                    { TAPI v2.0 }
    dwCallbackInstance,                             { TAPI v2.0 }
    dwParam1,                                       { TAPI v2.0 }
    dwParam2,                                       { TAPI v2.0 }
    dwParam3: Longint;                              { TAPI v2.0 }
  end;
{$ENDIF}

  LPLineMonitorTone = ^TLineMonitorTone;
  TLineMonitorTone = record
    dwAppSpecific,
    dwDuration,
    dwFrequency1,
    dwFrequency2,
    dwFrequency3: Longint;
  end;

  LPLineProviderEntry = ^TLineProviderEntry;
  TLineProviderEntry = record
    dwPermanentProviderID,                          { TAPI v1.4 }
    dwProviderFilenameSize,                         { TAPI v1.4 }
    dwProviderFilenameOffset: Longint;              { TAPI v1.4 }
  end;

  LPLineProviderList = ^TLineProviderList;
  TLineProviderList = record
    dwTotalSize,                                    { TAPI v1.4 }
    dwNeededSize,                                   { TAPI v1.4 }
    dwUsedSize,                                     { TAPI v1.4 }
    dwNumProviders,                                 { TAPI v1.4 }
    dwProviderListSize,                             { TAPI v1.4 }
    dwProviderListOffset: Longint;                  { TAPI v1.4 }
  end;

{$IFDEF TAPI20}
  LPLineProxyRequest = ^TLineProxyRequest;
  TLineProxyRequest = record
    dwSize,                                         { TAPI v2.0 }
    dwClientMachineNameSize,                        { TAPI v2.0 }
    dwClientMachineNameOffset,                      { TAPI v2.0 }
    dwClientUserNameSize,                           { TAPI v2.0 }
    dwClientUserNameOffset,                         { TAPI v2.0 }
    dwClientAppAPIVersion,                          { TAPI v2.0 }
    dwRequestType: Longint;                         { TAPI v2.0 }

    case Integer of
      0: (
        SetAgentGroup: record
          dwAddressID: Longint;                     { TAPI v2.0 }
          GroupList: TLineAgentGroupList;           { TAPI v2.0 }
        end;
        );
      1: (
        SetAgentState: record
          dwAddressID,                              { TAPI v2.0 }
          dwAgentState,                             { TAPI v2.0 }
          dwNextAgentState: Longint;                { TAPI v2.0 }
        end;
        );
      2: (
        SetAgentActivity: record
          dwAddressID: Longint;                     { TAPI v2.0 }
          dwActivityID: Longint;                    { TAPI v2.0 }
        end;
        );
      3: (
        GetAgentCaps: record
          dwAddressID: Longint;                     { TAPI v2.0 }
          AgentCaps: TLineAgentCaps;                { TAPI v2.0 }
        end;
        );
      4: (
        GetAgentStatus: record
          dwAddressID: Longint;                     { TAPI v2.0 }
          AgentStatus: TLineAgentStatus;            { TAPI v2.0 }
        end;
        );
      5: (
        AgentSpecific: record
          dwAddressID,                              { TAPI v2.0 }
          dwAgentExtensionIDIndex,                  { TAPI v2.0 }
          dwSize: Longint;                          { TAPI v2.0 }
          Params: array[0..0] of Byte;              { TAPI v2.0 }
        end;
        );
      6: (
        GetAgentActivityList: record
          dwAddressID: Longint;                     { TAPI v2.0 }
          ActivityList: TLineAgentActivityList;     { TAPI v2.0 }
        end;
        );
      7: (
        GetAgentGroupList: record
          dwAddressID: Longint;                     { TAPI v2.0 }
          GroupList: TLineAgentGroupList;          { TAPI v2.0 }
        end;
        );
  end;
{$ENDIF}


  LPLineReqMakeCall = ^TLineReqMakeCall;
  TLineReqMakeCall = record
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of Char;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of Char;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of Char;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of Char;
  end;

{$IFDEF TAPI20}
  LPLineReqMakeCallW = ^TLineReqMakeCallW;
  TLineReqMakeCallW = record
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of WideChar;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of WideChar;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of WideChar;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of WideChar;
  end;
{$ENDIF}


  LPLineReqMediaCall = ^TLineReqMediaCall;
  TLineReqMediaCall = record
    HWnd: HWnd;
		wRequestID: WPARAM;
    szDeviceClass: array[0..TAPIMAXDEVICECLASSSIZE - 1] of Char;
    ucDeviceID: array[0..TAPIMAXDEVICEIDSIZE - 1] of Byte;
    dwSize,
    dwSecure: Longint;
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE] of Char;
    szAppName: array[0..TAPIMAXAPPNAMESIZE] of Char;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE] of Char;
    szComment: array[0..TAPIMAXCOMMENTSIZE] of Char;
  end;

{$IFDEF TAPI20}
  LPLineReqMediaCallW = ^TLineReqMediaCallW;
  TLineReqMediaCallW = record
    HWnd: HWnd;
    wRequestID: WPARAM;
    szDeviceClass: array[0..TAPIMAXDEVICECLASSSIZE - 1] of WideChar;
    ucDeviceID: array[0..TAPIMAXDEVICEIDSIZE - 1] of Byte;
    dwSize,
    dwSecure: Longint;
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE] of WideChar;
    szAppName: array[0..TAPIMAXAPPNAMESIZE] of WideChar;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE] of WideChar;
    szComment: array[0..TAPIMAXCOMMENTSIZE] of WideChar;
  end;
{$ENDIF}


  LPLineTermCaps = ^TLineTermCaps;
  TLineTermCaps = record
    dwTermDev,
    dwTermModes,
    dwTermSharing: Longint;
  end;

  LPLineTranslateCaps = ^TLineTranslateCaps;
  TLineTranslateCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumLocations,
    dwLocationListSize,
    dwLocationListOffset,
    dwCurrentLocationID,
    dwNumCards,
    dwCardListSize,
    dwCardListOffset,
    dwCurrentPreferredCardID: Longint;
  end;

  LPLineTranslateOutput = ^TLineTranslateOutput;
  TLineTranslateOutput = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwDialableStringSize,
    dwDialableStringOffset,
    dwDisplayableStringSize,
    dwDisplayableStringOffset,
    dwCurrentCountry,
    dwDestCountry,
    dwTranslateResults: Longint;
  end;

  LPPhoneButtonInfo = ^TPhoneButtonInfo;
  TPhoneButtonInfo = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwButtonMode,
    dwButtonFunction,
    dwButtonTextSize,
    dwButtonTextOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset,

    dwButtonState: Longint;                         { TAPI v1.4 }
  end;

  LPPhoneCaps = ^TPhoneCaps;
  TPhoneCaps = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwProviderInfoSize,
    dwProviderInfoOffset,
    dwPhoneInfoSize,
    dwPhoneInfoOffset,
    dwPermanenTPhoneID,
    dwPhoneNameSize,
    dwPhoneNameOffset,
    dwStringFormat,
    dwPhoneStates,
    dwHookSwitchDevs,
    dwHandsetHookSwitchModes,
    dwSpeakerHookSwitchModes,
    dwHeadsetHookSwitchModes,
    dwVolumeFlags,
    dwGainFlags,
    dwDisplayNumRows,
    dwDisplayNumColumns,
    dwNumRingModes,
    dwNumButtonLamps,
    dwButtonModesSize,
    dwButtonModesOffset,
    dwButtonFunctionsSize,
    dwButtonFunctionsOffset,
    dwLampModesSize,
    dwLampModesOffset,
    dwNumSetData,
    dwSetDataSize,
    dwSetDataOffset,
    dwNumGetData,
    dwGetDataSize,
    dwGetDataOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;

{$IFDEF TAPI20}
    dwDeviceClassesSize,                            { TAPI v2.0 }
    dwDeviceClassesOffset,                          { TAPI v2.0 }
    dwPhoneFeatures,                                { TAPI v2.0 }
    dwSettableHandsetHookSwitchModes,               { TAPI v2.0 }
    dwSettableSpeakerHookSwitchModes,               { TAPI v2.0 }
    dwSettableHeadsetHookSwitchModes,               { TAPI v2.0 }
    dwMonitoredHandsetHookSwitchModes,              { TAPI v2.0 }
    dwMonitoredSpeakerHookSwitchModes,              { TAPI v2.0 }
    dwMonitoredHeadsetHookSwitchModes: Longint;     { TAPI v2.0 }
{$ENDIF}
  end;

  LPPhoneExtensionId = ^TPhoneExtensionId;
  TPhoneExtensionId = record
    dwExtensionID0,
    dwExtensionID1,
    dwExtensionID2,
    dwExtensionID3: Longint;
  end;

{$IFDEF TAPI20}
  LPPhoneInitializeExParams = ^TPhoneInitializeExParams;
  TPhoneInitializeExParams = record
    dwTotalSize,                                    { TAPI v2.0 }
    dwNeededSize,                                   { TAPI v2.0 }
    dwUsedSize,                                     { TAPI v2.0 }
    dwOptions: Longint;                             { TAPI v2.0 }

    Handles: THandleUnion;

    dwCompletionKey: Longint;                       { TAPI v2.0 }
  end;

  LPPhoneMessage = ^TPhoneMessage;
  TPhoneMessage = record
    hDevice,                                        { TAPI v2.0 }
    dwMessageID,                                    { TAPI v2.0 }
    dwCallbackInstance,                             { TAPI v2.0 }
    dwParam1,                                       { TAPI v2.0 }
    dwParam2,                                       { TAPI v2.0 }
    dwParam3: Longint;                              { TAPI v2.0 }
  end;
{$ENDIF}

  LPPhoneStatus = ^TPhoneStatus;
  TPhoneStatus = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwStatusFlags,
    dwNumOwners,
    dwNumMonitors,
    dwRingMode,
    dwRingVolume,
    dwHandsetHookSwitchMode,
    dwHandsetVolume,
    dwHandsetGain,
    dwSpeakerHookSwitchMode,
    dwSpeakerVolume,
    dwSpeakerGain,
    dwHeadsetHookSwitchMode,
    dwHeadsetVolume,
    dwHeadsetGain,
    dwDisplaySize,
    dwDisplayOffset,
    dwLampModesSize,
    dwLampModesOffset,
    dwOwnerNameSize,
    dwOwnerNameOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: Longint;

{$IFDEF TAPI20}
    dwPhoneFeatures: Longint;                       { TAPI v2.0 }
{$ENDIF}
  end;

  LPVarString = ^TVarString;
  TVarString = record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwStringFormat,
    dwStringSize,
    dwStringOffset: Longint;
  end;


function lineAccept(
  hCall: THCall;
  lpsUserUserInfo: PChar;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineAddProvider(                           { TAPI v1.4 }
  lpszProviderFilename: PChar;
  hwndOwner: HWnd;
  var lpdwPermanentProviderID: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineAddProviderA(                          { TAPI v1.4 }
  lpszProviderFilename: PChar;
  hwndOwner: HWnd;
  var lpdwPermanentProviderID: Longint): Longint; stdcall;

function lineAddProviderW(
  lpszProviderFilename: PWideChar;
  hwndOwner: HWnd;
  var lpdwPermanentProviderID: Longint): Longint; stdcall;
{$ENDIF}

function lineAddToConference(
    hConfCall: THCall;
    hConsultCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineAgentSpecific(                         { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  dwAgentExtensionIDIndex: Longint;
  lpParams: Pointer;
  dwSize: Longint): Longint; stdcall;
{$ENDIF}

function lineAnswer(
  hCall: THCall;
  lpsUserUserInfo: PChar;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineBlindTransfer(
  hCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineBlindTransferA(
  hCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint): Longint; stdcall;

function lineBlindTransferW(
  hCall: THCall;
  lpszDestAddress: PWideChar;
  dwCountryCode: Longint): Longint; stdcall;
{$ENDIF}

function lineClose(
  hLine: THLine): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineCompleteCall(
  hCall: THCall;
  var lpdwCompletionID: Longint;
  dwCompletionMode: Longint;
  dwMessageID: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineCompleteTransfer(
  hCall: THCall;
  hConsultCall: THCall;
  var lphConfCall: THCall;
  dwTransferMode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineConfigDialog(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineConfigDialogA(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PChar): Longint; stdcall;

function lineConfigDialogW(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$ENDIF}

function lineConfigDialogEdit(                      { TAPI v1.4 }
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PChar;
  lpDeviceConfigIn: Pointer;
  dwSize: Longint;
  var lpDeviceConfigOut: TVarString): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineConfigDialogEditA(                     { TAPI v1.4 }
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PChar;
  lpDeviceConfigIn: Pointer;
  dwSize: Longint;
  var lpDeviceConfigOut: TVarString): Longint; stdcall;

function lineConfigDialogEditW(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PWideChar;
  lpDeviceConfigIn: Pointer;
  dwSize: Longint;
  var lpDeviceConfigOut: TVarString): Longint; stdcall;
{$ENDIF}

function lineConfigProvider(                        { TAPI v1.4 }
  hwndOwner: HWnd;
  dwPermanentProviderID: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineDeallocateCall(
    hCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineDevSpecific(
  hLine: THLine;
  dwAddressID: Longint;
  hCall: THCall;
  lpParams: Pointer;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineDevSpecificFeature(
  hLine: THLine;
  dwFeature: Longint;
  lpParams: Pointer;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineDial(
  hCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineDialA(
  hCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint): Longint; stdcall;

function lineDialW(
  hCall: THCall;
  lpszDestAddress: PWideChar;
  dwCountryCode: Longint): Longint; stdcall;
{$ENDIF}

function lineDrop(
  hCall: THCall;
  lpsUserUserInfo: PChar;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineForward(
  hLine: THLine;
  bAllAddresses: Longint;
  dwAddressID: Longint;
  var lpForwardList: TLineForwardList;
  dwNumRingsNoAnswer: Longint;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineForwardA(
  hLine: THLine;
  bAllAddresses: Longint;
  dwAddressID: Longint;
  var lpForwardList: TLineForwardList;
  dwNumRingsNoAnswer: Longint;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint; stdcall;

function lineForwardW(
  hLine: THLine;
  bAllAddresses: Longint;
  dwAddressID: Longint;
  var lpForwardList: TLineForwardList;
  dwNumRingsNoAnswer: Longint;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint; stdcall;
{$ENDIF}

function lineGatherDigits(
  hCall: THCall;
  dwDigitModes: Longint;
  lpsDigits: PChar;
  dwNumDigits: Longint;
  lpszTerminationDigits: PChar;
  dwFirstDigitTimeout: Longint;
  dwInterDigitTimeout: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGatherDigitsA(
  hCall: THCall;
  dwDigitModes: Longint;
  lpsDigits: PChar;
  dwNumDigits: Longint;
  lpszTerminationDigits: PChar;
  dwFirstDigitTimeout: Longint;
  dwInterDigitTimeout: Longint): Longint; stdcall;

function lineGatherDigitsW(
  hCall: THCall;
  dwDigitModes: Longint;
  lpsDigits: PWideChar;
  dwNumDigits: Longint;
  lpszTerminationDigits: PWideChar;
  dwFirstDigitTimeout: Longint;
  dwInterDigitTimeout: Longint): Longint; stdcall;
{$ENDIF}

function lineGenerateDigits(
  hCall: THCall;
  dwDigitMode: Longint;
  lpszDigits: PChar;
  dwDuration: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGenerateDigitsA(
  hCall: THCall;
  dwDigitMode: Longint;
  lpszDigits: PChar;
  dwDuration: Longint): Longint; stdcall;

function lineGenerateDigitsW(
  hCall: THCall;
  dwDigitMode: Longint;
  lpszDigits: PWideChar;
  dwDuration: Longint): Longint; stdcall;
{$ENDIF}

function lineGenerateTone(
  hCall: THCall;
  dwToneMode: Longint;
  dwDuration: Longint;
  dwNumTones: Longint;
  lpTones: LPLineGenerateTone): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineGetAddressCaps(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAddressID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpAddressCaps: TLineAddressCaps): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetAddressCapsA(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAddressID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpAddressCaps: TLineAddressCaps): Longint; stdcall;

function lineGetAddressCapsW(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAddressID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpAddressCaps: TLineAddressCaps): Longint; stdcall;
{$ENDIF}

function lineGetAddressID(
  hLine: THLine;
  var lpdwAddressID: Longint;
  dwAddressMode: Longint;
  lpsAddress: PChar;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetAddressIDA(
  hLine: THLine;
  var lpdwAddressID: Longint;
  dwAddressMode: Longint;
  lpsAddress: PChar;
  dwSize: Longint): Longint; stdcall;

function lineGetAddressIDW(
  hLine: THLine;
  var lpdwAddressID: Longint;
  dwAddressMode: Longint;
  lpsAddress: PWideChar;
  dwSize: Longint): Longint; stdcall;
{$ENDIF}

function lineGetAddressStatus(
  hLine: THLine;
  dwAddressID: Longint;
  var lpAddressStatus: TLineAddressStatus): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetAddressStatusA(
  hLine: THLine;
  dwAddressID: Longint;
  var lpAddressStatus: TLineAddressStatus): Longint; stdcall;

function lineGetAddressStatusW(
  hLine: THLine;
  dwAddressID: Longint;
  var lpAddressStatus: TLineAddressStatus): Longint; stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineGetAgentActivityList(                  { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentActivityList: TLineAgentActivityList): Longint; stdcall;

function lineGetAgentActivityListA(                 { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentActivityList: TLineAgentActivityList): Longint; stdcall;

function lineGetAgentActivityListW(                 { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentActivityList: TLineAgentActivityList): Longint; stdcall;

function lineGetAgentCaps(                          { TAPI v2.0 }
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAddressID: Longint;
  dwAppAPIVersion: Longint;
  var lpAgentCaps: TLineAgentCaps): Longint; stdcall;

function lineGetAgentCapsA(                         { TAPI v2.0 }
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAddressID: Longint;
  dwAppAPIVersion: Longint;
  var lpAgentCaps: TLineAgentCaps): Longint; stdcall;

function lineGetAgentCapsW(                         { TAPI v2.0 }
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAddressID: Longint;
  dwAppAPIVersion: Longint;
  var lpAgentCaps: TLineAgentCaps): Longint; stdcall;

function lineGetAgentGroupList(                     { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentGroupList: TLineAgentGroupList): Longint; stdcall;

function lineGetAgentGroupListA(                    { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentGroupList: TLineAgentGroupList): Longint; stdcall;

function lineGetAgentGroupListW(                    { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentGroupList: TLineAgentGroupList): Longint; stdcall;

function lineGetAgentStatus(                        { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentStatus: TLineAgentStatus): Longint; stdcall;

function lineGetAgentStatusA(                       { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentStatus: TLineAgentStatus): Longint; stdcall;

function lineGetAgentStatusW(                       { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentStatus: TLineAgentStatus): Longint; stdcall;
{$ENDIF}

function lineGetAppPriority(                        { TAPI v1.4 }
  lpszAppFilename: PChar;
  dwMediaMode: Longint;
  lpExtensionID: LPLineExtensionID;
  dwRequestMode: Longint;
  lpExtensionName: LPVarString;
  var lpdwPriority: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetAppPriorityA(                       { TAPI v1.4 }
  lpszAppFilename: PChar;
  dwMediaMode: Longint;
  lpExtensionID: LPLineExtensionID;
  dwRequestMode: Longint;
  lpExtensionName: LPVarString;
  var lpdwPriority: Longint): Longint; stdcall;

function lineGetAppPriorityW(                       { TAPI v1.4 }
  lpszAppFilename: PWideChar;
  dwMediaMode: Longint;
  lpExtensionID: LPLineExtensionID;
  dwRequestMode: Longint;
  lpExtensionName: LPVarString;
  var lpdwPriority: Longint): Longint; stdcall;
{$ENDIF}

function lineGetCallInfo(
  hCall: THCall;
  var lpCallInfo: TLineCallInfo): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetCallInfoA(
  hCall: THCall;
  var lpCallInfo: TLineCallInfo): Longint; stdcall;

function lineGetCallInfoW(
  hCall: THCall;
  var lpCallInfo: TLineCallInfo): Longint; stdcall;
{$ENDIF}

function lineGetCallStatus(
  hCall: THCall;
  var lpCallStatus: TLineCallStatus): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineGetConfRelatedCalls(
  hCall: THCall;
  var lpCallList: TLineCallList): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineGetCountry(                            { TAPI v1.4 }
  dwCountryID: Longint;
  dwAPIVersion: Longint;
  var lpLineCountryList: TLineCountryList): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetCountryA(                           { TAPI v1.4 }
  dwCountryID: Longint;
  dwAPIVersion: Longint;
  var lpLineCountryList: TLineCountryList): Longint; stdcall;

function lineGetCountryW(                           { TAPI v1.4 }
  dwCountryID: Longint;
  dwAPIVersion: Longint;
  var lpLineCountryList: TLineCountryList): Longint; stdcall;
{$ENDIF}

function lineGetDevCaps(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpLineDevCaps: TLineDevCaps): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetDevCapsA(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpLineDevCaps: TLineDevCaps): Longint; stdcall;

function lineGetDevCapsW(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpLineDevCaps: TLineDevCaps): Longint; stdcall;
{$ENDIF}

function lineGetDevConfig(
  dwDeviceID: Longint;
  var lpDeviceConfig: TVarString;
  lpszDeviceClass: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetDevConfigA(
  dwDeviceID: Longint;
  var lpDeviceConfig: TVarString;
  lpszDeviceClass: PChar): Longint; stdcall;

function lineGetDevConfigW(
  dwDeviceID: Longint;
  var lpDeviceConfig: TVarString;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$ENDIF}

function lineGetNewCalls(
  hLine: THLine;
  dwAddressID: Longint;
  dwSelect: Longint;
  var lpCallList: TLineCallList): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineGetIcon(
  dwDeviceID: Longint;
  lpszDeviceClass: PChar;
  var lphIcon: HIcon): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetIconA(
  dwDeviceID: Longint;
  lpszDeviceClass: PChar;
  var lphIcon: HIcon): Longint; stdcall;

function lineGetIconW(
  dwDeviceID: Longint;
  lpszDeviceClass: PWideChar;
  var lphIcon: HIcon): Longint; stdcall;
{$ENDIF}

function lineGetID(
  hLine: THLine;
  dwAddressID: Longint;
  hCall: THCall;
  dwSelect: Longint;
  var lpDeviceID: TVarString;
  lpszDeviceClass: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetIDA(
  hLine: THLine;
  dwAddressID: Longint;
  hCall: THCall;
  dwSelect: Longint;
  var lpDeviceID: TVarString;
  lpszDeviceClass: PChar): Longint; stdcall;

function lineGetIDW(
  hLine: THLine;
  dwAddressID: Longint;
  hCall: THCall;
  dwSelect: Longint;
  var lpDeviceID: TVarString;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$ENDIF}

function lineGetLineDevStatus(
  hLine: THLine;
  var lpLineDevStatus: TLineDevStatus): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetLineDevStatusA(
  hLine: THLine;
  var lpLineDevStatus: TLineDevStatus): Longint; stdcall;

function lineGetLineDevStatusW(
  hLine: THLine;
  var lpLineDevStatus: TLineDevStatus): Longint; stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineGetMessage(                            { TAPI v2.0 }
  hLineApp: THLineApp;
  var lpMessage: TLineMessage;
  dwTimeout: Longint): Longint; stdcall;
{$ENDIF}

function lineGetNumRings(
  hLine: THLine;
  dwAddressID: Longint;
  var lpdwNumRings: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineGetProviderList(                       { TAPI v1.4 }
  dwAPIVersion: Longint;
  var lpProviderList: TLineProviderList): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetProviderListA(
  dwAPIVersion: Longint;
  var lpProviderList: TLineProviderList): Longint; stdcall;

function lineGetProviderListW(
  dwAPIVersion: Longint;
  var lpProviderList: TLineProviderList): Longint; stdcall;
{$ENDIF}

function lineGetRequest(
  hLineApp: THLineApp;
  dwRequestMode: Longint;
  lpRequestBuffer: Pointer): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetRequestA(
  hLineApp: THLineApp;
  dwRequestMode: Longint;
  lpRequestBuffer: Pointer): Longint; stdcall;

function lineGetRequestW(
  hLineApp: THLineApp;
  dwRequestMode: Longint;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$ENDIF}

function lineGetStatusMessages(
  hLine: THLine;
  var lpdwLineStates: Longint;
  var lpdwAddressStates: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineGetTranslateCaps(
  hLineApp: THLineApp;
  dwAPIVersion: Longint;
  var lpTranslateCaps: TLineTranslateCaps): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineGetTranslateCapsA(
  hLineApp: THLineApp;
  dwAPIVersion: Longint;
  var lpTranslateCaps: TLineTranslateCaps): Longint; stdcall;

function lineGetTranslateCapsW(
  hLineApp: THLineApp;
  dwAPIVersion: Longint;
  var lpTranslateCaps: TLineTranslateCaps): Longint; stdcall;
{$ENDIF}

function lineHandoff(
  hCall: THCall;
  lpszFileName: PChar;
  dwMediaMode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineHandoffA(
  hCall: THCall;
  lpszFileName: PChar;
  dwMediaMode: Longint): Longint; stdcall;

function lineHandoffW(
  hCall: THCall;
  lpszFileName: PWideChar;
  dwMediaMode: Longint): Longint; stdcall;
{$ENDIF}

function lineHold(
	hCall: THCall): Longint;
{$IFDEF WIN32}
	stdcall;
{$ENDIF}

function lineInitialize(
	var lphLineApp: THLineApp;
	hInstance: HInst;
	lpfnCallback: TLineCallback;
	lpszAppName: PChar;
	var lpdwNumDevs: Longint): Longint;
{$IFDEF WIN32}
	stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineInitializeEx(                          { TAPI v2.0 }
	var lphLineApp: THLineApp;
	hInstance: HInst;
	lpfnCallback: TLineCallback;
	lpszFriendlyAppName: PChar;
	var lpdwNumDevs: Longint;
	var lpdwAPIVersion: Longint;
	var lpLineInitializeExParams: TLineInitializeExParams): Longint; stdcall;

function lineInitializeExA(                         { TAPI v2.0 }
	var lphLineApp: THLineApp;
	hInstance: HInst;
	lpfnCallback: TLineCallback;
	lpszFriendlyAppName: PChar;
	var lpdwNumDevs: Longint;
  var lpdwAPIVersion: Longint;
  var lpLineInitializeExParams: TLineInitializeExParams): Longint; stdcall;

function lineInitializeExW(                         { TAPI v2.0 }
  var lphLineApp: THLineApp;
  hInstance: HInst;
  lpfnCallback: TLineCallback;
  lpszFriendlyAppName: PWideChar;
  var lpdwNumDevs: Longint;
  var lpdwAPIVersion: Longint;
  var lpLineInitializeExParams: TLineInitializeExParams): Longint; stdcall;
{$ENDIF}

function lineMakeCall(
  hLine: THLine;
  var lphCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint;
  lpCallParams: LPLineCallParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineMakeCallA(
  hLine: THLine;
  var lphCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint;
  lpCallParams: LPLineCallParams): Longint; stdcall;

function lineMakeCallW(
  hLine: THLine;
  var lphCall: THCall;
  lpszDestAddress: PWideChar;
  dwCountryCode: Longint;
  lpCallParams: LPLineCallParams): Longint; stdcall;
{$ENDIF}

function lineMonitorDigits(
  hCall: THCall;
  dwDigitModes: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineMonitorMedia(
  hCall: THCall;
  dwMediaModes: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineMonitorTones(
  hCall: THCall;
  lpToneList: LPLineMonitorTone;
  dwNumEntries: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineNegotiateAPIVersion(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPILowVersion: Longint;
  dwAPIHighVersion: Longint;
  var lpdwAPIVersion: Longint;
  var lpExtensionID: TLineExtensionID): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineNegotiateExtVersion(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtLowVersion: Longint;
  dwExtHighVersion: Longint;
  var lpdwExtVersion: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineOpen(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  var lphLine: THLine;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  dwCallbackInstance: Longint;
  dwPrivileges: Longint;
  dwMediaModes: Longint;
  lpCallParams: LPLineCallParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineOpenA(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  var lphLine: THLine;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  dwCallbackInstance: Longint;
  dwPrivileges: Longint;
  dwMediaModes: Longint;
  lpCallParams: LPLineCallParams): Longint; stdcall;

function lineOpenW(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  var lphLine: THLine;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  dwCallbackInstance: Longint;
  dwPrivileges: Longint;
  dwMediaModes: Longint;
  lpCallParams: LPLineCallParams): Longint; stdcall;
{$ENDIF}

function linePark(
  hCall: THCall;
  dwParkMode: Longint;
  lpszDirAddress: PChar;
  lpNonDirAddress: LPVarString): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineParkA(
  hCall: THCall;
  dwParkMode: Longint;
  lpszDirAddress: PChar;
  lpNonDirAddress: LPVarString): Longint; stdcall;

function lineParkW(
  hCall: THCall;
  dwParkMode: Longint;
  lpszDirAddress: PWideChar;
  lpNonDirAddress: LPVarString): Longint; stdcall;
{$ENDIF}

function linePickup(
  hLine: THLine;
  dwAddressID: Longint;
  var lphCall: THCall;
  lpszDestAddress: PChar;
  lpszGroupID: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function linePickupA(
  hLine: THLine;
  dwAddressID: Longint;
  var lphCall: THCall;
  lpszDestAddress: PChar;
  lpszGroupID: PChar): Longint; stdcall;

function linePickupW(
  hLine: THLine;
  dwAddressID: Longint;
  var lphCall: THCall;
  lpszDestAddress: PWideChar;
  lpszGroupID: PWideChar): Longint; stdcall;
{$ENDIF}

function linePrepareAddToConference(
  hConfCall: THCall;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function linePrepareAddToConferenceA(
  hConfCall: THCall;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint; stdcall;

function linePrepareAddToConferenceW(
  hConfCall: THCall;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint; stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineProxyMessage(                          { TAPI v2.0 }
  hLine: THLine;
  hCall: THCall;
  dwMsg: Longint;
  dwParam1: Longint;
  dwParam2: Longint;
  dwParam3: Longint): Longint; stdcall;

function lineProxyResponse(                         { TAPI v2.0 }
  hLine: THLine;
  var lpProxyRequest: TLineProxyRequest;
  dwResult: Longint): Longint; stdcall;
{$ENDIF}

function lineRedirect(
  hCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineRedirectA(
  hCall: THCall;
  lpszDestAddress: PChar;
  dwCountryCode: Longint): Longint; stdcall;

function lineRedirectW(
  hCall: THCall;
  lpszDestAddress: PWideChar;
  dwCountryCode: Longint): Longint; stdcall;
{$ENDIF}

function lineRegisterRequestRecipient(
  hLineApp: THLineApp;
  dwRegistrationInstance: Longint;
  dwRequestMode: Longint;
  bEnable: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineReleaseUserUserInfo(                   { TAPI v1.4 }
  hCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineRemoveFromConference(
    hCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineRemoveProvider(                        { TAPI v1.4 }
    dwPermanentProviderID: Longint;
    hwndOwner: HWnd): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSecureCall(
    hCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSendUserUserInfo(
    hCall: THCall;
    lpsUserUserInfo: PChar;
    dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineSetAgentActivity(                      { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  dwActivityID: Longint): Longint; stdcall;

function lineSetAgentGroup(                         { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  var lpAgentGroupList: TLineAgentGroupList): Longint; stdcall;

function lineSetAgentState(                         { TAPI v2.0 }
  hLine: THLine;
  dwAddressID: Longint;
  dwAgentState: Longint;
  dwNextAgentState: Longint): Longint; stdcall;
{$ENDIF}

function lineSetAppPriority(                        { TAPI v1.4 }
  lpszAppFilename: PChar;
  dwMediaMode: Longint;
  lpExtensionID: LPLineExtensionID;
  dwRequestMode: Longint;
  lpszExtensionName: PChar;
  dwPriority: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineSetAppPriorityA(                       { TAPI v1.4 }
  lpszAppFilename: PChar;
  dwMediaMode: Longint;
  lpExtensionID: LPLineExtensionID;
  dwRequestMode: Longint;
  lpszExtensionName: PChar;
  dwPriority: Longint): Longint; stdcall;

function lineSetAppPriorityW(                       { TAPI v1.4 }
  lpszAppFilename: PWideChar;
  dwMediaMode: Longint;
  lpExtensionID: LPLineExtensionID;
  dwRequestMode: Longint;
  lpszExtensionName: PWideChar;
  dwPriority: Longint): Longint; stdcall;
{$ENDIF}

function lineSetAppSpecific(
  hCall: THCall;
  dwAppSpecific: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineSetCallData(                           { TAPI v2.0 }
  hCall: THCall;
  lpCallData: Pointer;
  dwSize: Longint): Longint; stdcall;
{$ENDIF}

function lineSetCallParams(
  hCall: THCall;
  dwBearerMode: Longint;
  dwMinRate: Longint;
  dwMaxRate: Longint;
  lpDialParams: LPLineDialParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetCallPrivilege(
  hCall: THCall;
  dwCallPrivilege: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineSetCallQualityOfService(               { TAPI v2.0 }
  hCall: THCall;
  lpSendingFlowspec: Pointer;
  dwSendingFlowspecSize: Longint;
  lpReceivingFlowspec: Pointer;
  dwReceivingFlowspecSize: Longint): Longint; stdcall;

function lineSetCallTreatment(                      { TAPI v2.0 }
  hCall: THCall;
  dwTreatment: Longint): Longint; stdcall;
{$ENDIF}

function lineSetCurrentLocation(
  hLineApp: THLineApp;
  dwLocation: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetDevConfig(
  dwDeviceID: Longint;
  lpDeviceConfig: Pointer;
  dwSize: Longint;
  lpszDeviceClass: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineSetDevConfigA(
  dwDeviceID: Longint;
  lpDeviceConfig: Pointer;
  dwSize: Longint;
  lpszDeviceClass: PChar): Longint; stdcall;

function lineSetDevConfigW(
  dwDeviceID: Longint;
  lpDeviceConfig: Pointer;
  dwSize: Longint;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function lineSetLineDevStatus(                      { TAPI v2.0 }
  hLine: THLine;
  dwStatusToChange: Longint;
  fStatus: Longint): Longint; stdcall;
{$ENDIF}

function lineSetMediaControl(
    hLine: THLine;
    dwAddressID: Longint;
    hCall: THCall;
    dwSelect: Longint;
    var lpDigitList: TLineMediaControlDigit;
    dwDigitNumEntries: Longint;
    var lpMediaList: TLineMediaControlMedia;
    dwMediaNumEntries: Longint;
    var lpToneList: TLineMediaControlTone;
    dwToneNumEntries: Longint;
    var lpCallStateList: TLineMediaControlCallState;
    dwCallStateNumEntries: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetMediaMode(
  hCall: THCall;
  dwMediaModes: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetNumRings(
  hLine: THLine;
  dwAddressID: Longint;
  dwNumRings: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetStatusMessages(
  hLine: THLine;
  dwLineStates: Longint;
  dwAddressStates: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetTerminal(
  hLine: THLine;
  dwAddressID: Longint;
  hCall: THCall;
  dwSelect: Longint;
  dwTerminalModes: Longint;
  dwTerminalID: Longint;
  bEnable: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSetTollList(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  lpszAddressIn: PChar;
  dwTollListOption: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineSetTollListA(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  lpszAddressIn: PChar;
  dwTollListOption: Longint): Longint; stdcall;

function lineSetTollListW(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  lpszAddressInW: PWideChar;
  dwTollListOption: Longint): Longint; stdcall;
{$ENDIF}

function lineSetupConference(
  hCall: THCall;
  hLine: THLine;
  var lphConfCall: THCall;
  var lphConsultCall: THCall;
  dwNumParties: Longint;
  lpCallParams: LPLineCallParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineSetupConferenceA(
  hCall: THCall;
  hLine: THLine;
  var lphConfCall: THCall;
  var lphConsultCall: THCall;
  dwNumParties: Longint;
  lpCallParams: LPLineCallParams): Longint; stdcall;

function lineSetupConferenceW(
  hCall: THCall;
  hLine: THLine;
  var lphConfCall: THCall;
  var lphConsultCall: THCall;
  dwNumParties: Longint;
  lpCallParams: LPLineCallParams): Longint; stdcall;
{$ENDIF}

function lineSetupTransfer(
  hCall: THCall;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineSetupTransferA(
  hCall: THCall;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint; stdcall;

function lineSetupTransferW(
  hCall: THCall;
  var lphConsultCall: THCall;
  lpCallParams: LPLineCallParams): Longint; stdcall;
{$ENDIF}

function lineShutdown(
  hLineApp: THLineApp): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineSwapHold(
  hActiveCall: THCall;
  hHeldCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineTranslateAddress(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  lpszAddressIn: PChar;
  dwCard: Longint;
  dwTranslateOptions: Longint;
  var lpTranslateOutput: TLineTranslateOutput): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineTranslateAddressA(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  lpszAddressIn: PChar;
  dwCard: Longint;
  dwTranslateOptions: Longint;
  var lpTranslateOutput: TLineTranslateOutput): Longint; stdcall;

function lineTranslateAddressW(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  lpszAddressIn: PWideChar;
  dwCard: Longint;
  dwTranslateOptions: Longint;
  var lpTranslateOutput: TLineTranslateOutput): Longint; stdcall;
{$ENDIF}

function lineTranslateDialog(                       { TAPI v1.4 }
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  hwndOwner: HWnd;
  lpszAddressIn: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineTranslateDialogA(                      { TAPI v1.4 }
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  hwndOwner: HWnd;
  lpszAddressIn: PChar): Longint; stdcall;

function lineTranslateDialogW(
  hLineApp: THLineApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  hwndOwner: HWnd;
  lpszAddressIn: PWideChar): Longint; stdcall;
{$ENDIF}

function lineUncompleteCall(
  hLine: THLine;
  dwCompletionID: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineUnhold(
  hCall: THCall): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function lineUnpark(
  hLine: THLine;
  dwAddressID: Longint;
  var lphCall: THCall;
  lpszDestAddress: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function lineUnparkA(
  hLine: THLine;
  dwAddressID: Longint;
  var lphCall: THCall;
  lpszDestAddress: PChar): Longint; stdcall;

function lineUnparkW(
  hLine: THLine;
  dwAddressID: Longint;
  var lphCall: THCall;
  lpszDestAddress: PWideChar): Longint; stdcall;
{$ENDIF}

function phoneClose(
  hPhone: THPhone): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneConfigDialog(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneConfigDialogA(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PChar): Longint; stdcall;

function phoneConfigDialogW(
  dwDeviceID: Longint;
  hwndOwner: HWnd;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$ENDIF}

function phoneDevSpecific(
  hPhone: THPhone;
  lpParams: Pointer;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetButtonInfo(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpButtonInfo: TPhoneButtonInfo): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneGetButtonInfoA(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpButtonInfo: TPhoneButtonInfo): Longint; stdcall;

function phoneGetButtonInfoW(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpButtonInfo: TPhoneButtonInfo): Longint; stdcall;
{$ENDIF}

function phoneGetData(
  hPhone: THPhone;
  dwDataID: Longint;
  lpData: Pointer;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetDevCaps(
  hPhoneApp: THPhoneApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpPhoneCaps: TPhoneCaps): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneGetDevCapsA(
  hPhoneApp: THPhoneApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpPhoneCaps: TPhoneCaps): Longint; stdcall;

function phoneGetDevCapsW(
  hPhoneApp: THPhoneApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  var lpPhoneCaps: TPhoneCaps): Longint; stdcall;
{$ENDIF}

function phoneGetDisplay(
  hPhone: THPhone;
  var lpDisplay: TVarString): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetGain(
  hPhone: THPhone;
  dwHookSwitchDev: Longint;
  var lpdwGain: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetHookSwitch(
  hPhone: THPhone;
  lpdwHookSwitchDevs: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetIcon(
  dwDeviceID: Longint;
  lpszDeviceClass: PChar;
  var lphIcon: HIcon): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneGetIconA(
  dwDeviceID: Longint;
  lpszDeviceClass: PChar;
  var lphIcon: HIcon): Longint; stdcall;

function phoneGetIconW(
  dwDeviceID: Longint;
  lpszDeviceClass: PWideChar;
  var lphIcon: HIcon): Longint; stdcall;
{$ENDIF}

function phoneGetID(
  hPhone: THPhone;
  var lpDeviceID: TVarString;
  lpszDeviceClass: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneGetIDA(
  hPhone: THPhone;
  var lpDeviceID: TVarString;
  lpszDeviceClass: PChar): Longint; stdcall;

function phoneGetIDW(
  hPhone: THPhone;
  var lpDeviceID: TVarString;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$ENDIF}

function phoneGetLamp(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpdwLampMode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function phoneGetMessage(                           { TAPI v2.0 }
  hPhoneApp: THPhoneApp;
  var lpMessage: TPhoneMessage;
  dwTimeout: Longint): Longint; stdcall;
{$ENDIF}

function phoneGetRing(
  hPhone: THPhone;
  var lpdwRingMode: Longint;
  var lpdwVolume: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetStatus(
  hPhone: THPhone;
  var lpPhoneStatus: TPhoneStatus): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneGetStatusA(
  hPhone: THPhone;
  var lpPhoneStatus: TPhoneStatus): Longint; stdcall;

function phoneGetStatusW(
  hPhone: THPhone;
  var lpPhoneStatus: TPhoneStatus): Longint; stdcall;
{$ENDIF}

function phoneGetStatusMessages(
  hPhone: THPhone;
  var lpdwPhoneStates: Longint;
  var lpdwButtonModes: Longint;
  var lpdwButtonStates: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneGetVolume(
  hPhone: THPhone;
  dwHookSwitchDev: Longint;
  var lpdwVolume: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneInitialize(
  var lphPhoneApp: THPhoneApp;
  hInstance: HInst;
  lpfnCallback: TPhoneCallback;
  lpszAppName: PChar;
  var lpdwNumDevs: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF TAPI20}
function phoneInitializeEx(                         { TAPI v2.0 }
  var lphPhoneApp: THPhoneApp;
  hInstance: HInst;
  lpfnCallback: TPhoneCallback;
  lpszFriendlyAppName: PChar;
  var lpdwNumDevs: Longint;
  var lpdwAPIVersion: Longint;
  var lpPhoneInitializeExParams: TPhoneInitializeExParams): Longint; stdcall;

function phoneInitializeExA(                        { TAPI v2.0 }
  var lphPhoneApp: THPhoneApp;
  hInstance: HInst;
  lpfnCallback: TPhoneCallback;
  lpszFriendlyAppName: PChar;
  var lpdwNumDevs: Longint;
  var lpdwAPIVersion: Longint;
  var lpPhoneInitializeExParams: TPhoneInitializeExParams): Longint; stdcall;

function phoneInitializeExW(                        { TAPI v2.0 }
  var lphPhoneApp: THPhoneApp;
  hInstance: HInst;
  lpfnCallback: TPhoneCallback;
  lpszFriendlyAppName: PWideChar;
  var lpdwNumDevs: Longint;
  var lpdwAPIVersion: Longint;
  var lpPhoneInitializeExParams: TPhoneInitializeExParams): Longint; stdcall;
{$ENDIF}

function phoneNegotiateAPIVersion(
  hPhoneApp: THPhoneApp;
  dwDeviceID: Longint;
  dwAPILowVersion: Longint;
  dwAPIHighVersion: Longint;
  var lpdwAPIVersion: Longint;
  var lpExtensionID: TPhoneExtensionID): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneNegotiateExtVersion(
  hPhoneApp: THPhoneApp;
  dwDeviceID: Longint;
  dwAPIVersion: Longint;
  dwExtLowVersion: Longint;
  dwExtHighVersion: Longint;
  var lpdwExtVersion: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneOpen(
  hPhoneApp: THPhoneApp;
  dwDeviceID: Longint;
  var lphPhone: THPhone;
  dwAPIVersion: Longint;
  dwExtVersion: Longint;
  dwCallbackInstance: Longint;
  dwPrivilege: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetButtonInfo(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpButtonInfo: TPhoneButtonInfo): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function phoneSetButtonInfoA(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpButtonInfo: TPhoneButtonInfo): Longint; stdcall;

function phoneSetButtonInfoW(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  var lpButtonInfo: TPhoneButtonInfo): Longint; stdcall;
{$ENDIF}

function phoneSetData(
  hPhone: THPhone;
  dwDataID: Longint;
  lpData: Pointer;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetDisplay(
  hPhone: THPhone;
  dwRow: Longint;
  dwColumn: Longint;
  lpsDisplay: PChar;
  dwSize: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetGain(
  hPhone: THPhone;
  dwHookSwitchDev: Longint;
  dwGain: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetHookSwitch(
  hPhone: THPhone;
  dwHookSwitchDevs: Longint;
  dwHookSwitchMode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetLamp(
  hPhone: THPhone;
  dwButtonLampID: Longint;
  dwLampMode: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetRing(
  hPhone: THPhone;
  dwRingMode: Longint;
  dwVolume: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetStatusMessages(
  hPhone: THPhone;
  dwPhoneStates: Longint;
  dwButtonModes: Longint;
  dwButtonStates: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneSetVolume(
  hPhone: THPhone;
  dwHookSwitchDev: Longint;
  dwVolume: Longint): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function phoneShutdown(
  hPhoneApp: THPhoneApp): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function tapiGetLocationInfo(
  lpszCountryCode: PChar;
  lpszCityCode: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function tapiGetLocationInfoA(
  lpszCountryCode: PChar;
  lpszCityCode: PChar): Longint; stdcall;

function tapiGetLocationInfoW(
    lpszCountryCodeW: PWideChar;
    lpszCityCodeW: PWideChar): Longint; stdcall;
{$ENDIF}

function tapiRequestDrop(
  hwnd: HWnd;
  wRequestID: WParam): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

function tapiRequestMakeCall(
  lpszDestAddress: PChar;
  lpszAppName: PChar;
  lpszCalledParty: PChar;
  lpszComment: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function tapiRequestMakeCallA(
  lpszDestAddress: PChar;
  lpszAppName: PChar;
  lpszCalledParty: PChar;
  lpszComment: PChar): Longint; stdcall;

function tapiRequestMakeCallW(
  lpszDestAddress: PWideChar;
  lpszAppName: PWideChar;
  lpszCalledParty: PWideChar;
  lpszComment: PWideChar): Longint; stdcall;
{$ENDIF}

function tapiRequestMediaCall(
  hwnd: HWnd;
  wRequestID: WParam;
  lpszDeviceClass: PChar;
  lpDeviceID: PChar;
  dwSize: Longint;
  dwSecure: Longint;
  lpszDestAddress: PChar;
  lpszAppName: PChar;
  lpszCalledParty: PChar;
  lpszComment: PChar): Longint;
{$IFDEF WIN32}
  stdcall;
{$ENDIF}

{$IFDEF WIN32}
function tapiRequestMediaCallA(
  hwnd: HWnd;
  wRequestID: WParam;
  lpszDeviceClass: PChar;
  lpDeviceID: PChar;
  dwSize: Longint;
  dwSecure: Longint;
  lpszDestAddress: PChar;
  lpszAppName: PChar;
  lpszCalledParty: PChar;
  lpszComment: PChar): Longint; stdcall;

function tapiRequestMediaCallW(
  hwnd: HWnd;
  wRequestID: WParam;
  lpszDeviceClass: PWideChar;
  lpDeviceID: PWideChar;
  dwSize: Longint;
  dwSecure: Longint;
  lpszDestAddress: PWideChar;
  lpszAppName: PWideChar;
  lpszCalledParty: PWideChar): Longint; stdcall;
{$ENDIF}

(*

TAPIERROR_FORMATMESSAGE - macro to convert a TAPI error constant
    into a constant that FormatMessage will accept

        TAPIERR : Negative numbers and 0
            Map to : strip off high WORD
            Example: 0xFFFFFFFF (-1) becomes 0x0000FFFF
        LINEERR : Start at 0x80000000
            Map to : strip off 0x80000000 and add 0xE000
            Example: 0x80000004 becomes 0x0000E004
        PHONEERR: Start at 0x90000000
            Map to : strip off 0x90000000 and add 0xF000
            Example: 0x9000000A becomes 0x0000F00A

        pseudocode:

        if (__ErrCode__ is a TAPIERR)
            strip off high word

            else if (__ErrCode__ is a PHONEERR)
                strip off 0x90000000
                add 0xE000

                else
                    strip off 0x80000000
                    add 0xF000

*)

function TAPIERROR_FORMATMESSAGE (ErrCode: Longint): Longint;

implementation

{$IFDEF WIN32}

function lineAccept; external 'Tapi32.dll' name 'lineAccept';
function lineAddProvider; external 'Tapi32.dll' name 'lineAddProvider';
function lineAddProviderA; external 'Tapi32.dll' name 'lineAddProvider';
function lineAddProviderW; external 'Tapi32.dll' name 'lineAddProviderW';
function lineAddToConference; external 'Tapi32.dll' name 'lineAddToConference';
{$IFDEF TAPI20}
function lineAgentSpecific; external 'Tapi32.dll' name 'lineAgentSpecific';
{$ENDIF}
function lineAnswer; external 'Tapi32.dll' name 'lineAnswer';
function lineBlindTransfer; external 'Tapi32.dll' name 'lineBlindTransfer';
function lineBlindTransferA; external 'Tapi32.dll' name 'lineBlindTransfer';
function lineBlindTransferW; external 'Tapi32.dll' name 'lineBlindTransferW';
function lineClose; external 'Tapi32.dll' name 'lineClose';
function lineCompleteCall; external 'Tapi32.dll' name 'lineCompleteCall';
function lineCompleteTransfer; external 'Tapi32.dll' name 'lineCompleteTransfer';
function lineConfigDialog; external 'Tapi32.dll' name 'lineConfigDialog';
function lineConfigDialogA; external 'Tapi32.dll' name 'lineConfigDialog';
function lineConfigDialogW; external 'Tapi32.dll' name 'lineConfigDialogW';
function lineConfigDialogEdit; external 'Tapi32.dll' name 'lineConfigDialogEdit';
function lineConfigDialogEditA; external 'Tapi32.dll' name 'lineConfigDialogEdit';
function lineConfigDialogEditW; external 'Tapi32.dll' name 'lineConfigDialogEditW';
function lineConfigProvider; external 'Tapi32.dll' name 'lineConfigProvider';
function lineDeallocateCall; external 'Tapi32.dll' name 'lineDeallocateCall';
function lineDevSpecific; external 'Tapi32.dll' name 'lineDevSpecific';
function lineDevSpecificFeature; external 'Tapi32.dll' name 'lineDevSpecificFeature';
function lineDial; external 'Tapi32.dll' name 'lineDial';
function lineDialA; external 'Tapi32.dll' name 'lineDial';
function lineDialW; external 'Tapi32.dll' name 'lineDialW';
function lineDrop; external 'Tapi32.dll' name 'lineDrop';
function lineForward; external 'Tapi32.dll' name 'lineForward';
function lineForwardA; external 'Tapi32.dll' name 'lineForward';
function lineForwardW; external 'Tapi32.dll' name 'lineForwardW';
function lineGatherDigits; external 'Tapi32.dll' name 'lineGatherDigits';
function lineGatherDigitsA; external 'Tapi32.dll' name 'lineGatherDigits';
function lineGatherDigitsW; external 'Tapi32.dll' name 'lineGatherDigitsW';
function lineGenerateDigits; external 'Tapi32.dll' name 'lineGenerateDigits';
function lineGenerateDigitsA; external 'Tapi32.dll' name 'lineGenerateDigits';
function lineGenerateDigitsW; external 'Tapi32.dll' name 'lineGenerateDigitsW';
function lineGenerateTone; external 'Tapi32.dll' name 'lineGenerateTone';
function lineGetAddressCaps; external 'Tapi32.dll' name 'lineGetAddressCaps';
function lineGetAddressCapsA; external 'Tapi32.dll' name 'lineGetAddressCaps';
function lineGetAddressCapsW; external 'Tapi32.dll' name 'lineGetAddressCapsW';
function lineGetAddressID; external 'Tapi32.dll' name 'lineGetAddressID';
function lineGetAddressIDA; external 'Tapi32.dll' name 'lineGetAddressID';
function lineGetAddressIDW; external 'Tapi32.dll' name 'lineGetAddressIDW';
function lineGetAddressStatus; external 'Tapi32.dll' name 'lineGetAddressStatus';
function lineGetAddressStatusA; external 'Tapi32.dll' name 'lineGetAddressStatus';
function lineGetAddressStatusW; external 'Tapi32.dll' name 'lineGetAddressStatusW';
{$IFDEF TAPI20}
function lineGetAgentStatus; external 'Tapi32.dll' name 'lineGetAgentStatus';
function lineGetAgentStatusA; external 'Tapi32.dll' name 'lineGetAgentStatus';
function lineGetAgentStatusW; external 'Tapi32.dll' name 'lineGetAgentStatusW';
function lineGetAgentGroupList; external 'Tapi32.dll' name 'lineGetAgentGroupList';
function lineGetAgentGroupListA; external 'Tapi32.dll' name 'lineGetAgentGroupList';
function lineGetAgentGroupListW; external 'Tapi32.dll' name 'lineGetAgentGroupListW';
function lineGetAgentCaps; external 'Tapi32.dll' name 'lineGetAgentCaps';
function lineGetAgentCapsA; external 'Tapi32.dll' name 'lineGetAgentCaps';
function lineGetAgentCapsW; external 'Tapi32.dll' name 'lineGetAgentCapsW';
function lineGetAgentActivityList; external 'Tapi32.dll' name 'lineGetAgentActivityList';
function lineGetAgentActivityListA; external 'Tapi32.dll' name 'lineGetAgentActivityList';
function lineGetAgentActivityListW; external 'Tapi32.dll' name 'lineGetAgentActivityListW';
{$ENDIF}
function lineGetAppPriority; external 'Tapi32.dll' name 'lineGetAppPriority';
function lineGetAppPriorityA; external 'Tapi32.dll' name 'lineGetAppPriority';
function lineGetAppPriorityW; external 'Tapi32.dll' name 'lineGetAppPriorityW';
function lineGetCallInfo; external 'Tapi32.dll' name 'lineGetCallInfo';
function lineGetCallInfoA; external 'Tapi32.dll' name 'lineGetCallInfo';
function lineGetCallInfoW; external 'Tapi32.dll' name 'lineGetCallInfoW';
function lineGetCallStatus; external 'Tapi32.dll' name 'lineGetCallStatus';
function lineGetConfRelatedCalls; external 'Tapi32.dll' name 'lineGetConfRelatedCalls';
function lineGetCountry; external 'Tapi32.dll' name 'lineGetCountry';
function lineGetCountryA; external 'Tapi32.dll' name 'lineGetCountry';
function lineGetCountryW; external 'Tapi32.dll' name 'lineGetCountryW';
function lineGetDevCaps; external 'Tapi32.dll' name 'lineGetDevCaps';
function lineGetDevCapsA; external 'Tapi32.dll' name 'lineGetDevCaps';
function lineGetDevCapsW; external 'Tapi32.dll' name 'lineGetDevCapsW';
function lineGetDevConfig; external 'Tapi32.dll' name 'lineGetDevConfig';
function lineGetDevConfigA; external 'Tapi32.dll' name 'lineGetDevConfig';
function lineGetDevConfigW; external 'Tapi32.dll' name 'lineGetDevConfigW';
function lineGetNewCalls; external 'Tapi32.dll' name 'lineGetNewCalls';
function lineGetIcon; external 'Tapi32.dll' name 'lineGetIcon';
function lineGetIconA; external 'Tapi32.dll' name 'lineGetIcon';
function lineGetIconW; external 'Tapi32.dll' name 'lineGetIconW';
function lineGetID; external 'Tapi32.dll' name 'lineGetID';
function lineGetIDA; external 'Tapi32.dll' name 'lineGetID';
function lineGetIDW; external 'Tapi32.dll' name 'lineGetIDW';
function lineGetLineDevStatus; external 'Tapi32.dll' name 'lineGetLineDevStatus';
function lineGetLineDevStatusA; external 'Tapi32.dll' name 'lineGetLineDevStatus';
function lineGetLineDevStatusW; external 'Tapi32.dll' name 'lineGetLineDevStatusW';
{$IFDEF TAPI20}
function lineGetMessage; external 'Tapi32.dll' name 'lineGetMessage';
{$ENDIF}
function lineGetNumRings; external 'Tapi32.dll' name 'lineGetNumRings';
function lineGetProviderList; external 'Tapi32.dll' name 'lineGetProviderList';
function lineGetProviderListA; external 'Tapi32.dll' name 'lineGetProviderList';
function lineGetProviderListW; external 'Tapi32.dll' name 'lineGetProviderListW';
function lineGetRequest; external 'Tapi32.dll' name 'lineGetRequest';
function lineGetRequestA; external 'Tapi32.dll' name 'lineGetRequest';
function lineGetRequestW; external 'Tapi32.dll' name 'lineGetRequestW';
function lineGetStatusMessages; external 'Tapi32.dll' name 'lineGetStatusMessages';
function lineGetTranslateCaps; external 'Tapi32.dll' name 'lineGetTranslateCaps';
function lineGetTranslateCapsA; external 'Tapi32.dll' name 'lineGetTranslateCaps';
function lineGetTranslateCapsW; external 'Tapi32.dll' name 'lineGetTranslateCapsW';
function lineHandoff; external 'Tapi32.dll' name 'lineHandoff';
function lineHandoffA; external 'Tapi32.dll' name 'lineHandoff';
function lineHandoffW; external 'Tapi32.dll' name 'lineHandoffW';
function lineHold; external 'Tapi32.dll' name 'lineHold';
function lineInitialize; external 'Tapi32.dll' name 'lineInitialize';
{$IFDEF TAPI20}
function lineInitializeEx; external 'Tapi32.dll' name 'lineInitializeEx';
function lineInitializeExA; external 'Tapi32.dll' name 'lineInitializeEx';
function lineInitializeExW; external 'Tapi32.dll' name 'lineInitializeExW';
{$ENDIF}
function lineMakeCall; external 'Tapi32.dll' name 'lineMakeCall';
function lineMakeCallA; external 'Tapi32.dll' name 'lineMakeCall';
function lineMakeCallW; external 'Tapi32.dll' name 'lineMakeCallW';
function lineMonitorDigits; external 'Tapi32.dll' name 'lineMonitorDigits';
function lineMonitorMedia; external 'Tapi32.dll' name 'lineMonitorMedia';
function lineMonitorTones; external 'Tapi32.dll' name 'lineMonitorTones';
function lineNegotiateAPIVersion; external 'Tapi32.dll' name 'lineNegotiateAPIVersion';
function lineNegotiateExtVersion; external 'Tapi32.dll' name 'lineNegotiateExtVersion';
function lineOpen; external 'Tapi32.dll' name 'lineOpen';
function lineOpenA; external 'Tapi32.dll' name 'lineOpen';
function lineOpenW; external 'Tapi32.dll' name 'lineOpenW';
function linePark; external 'Tapi32.dll' name 'linePark';
function lineParkA; external 'Tapi32.dll' name 'linePark';
function lineParkW; external 'Tapi32.dll' name 'lineParkW';
function linePickup; external 'Tapi32.dll' name 'linePickup';
function linePickupA; external 'Tapi32.dll' name 'linePickup';
function linePickupW; external 'Tapi32.dll' name 'linePickupW';
function linePrepareAddToConference; external 'Tapi32.dll' name 'linePrepareAddToConference';
function linePrepareAddToConferenceA; external 'Tapi32.dll' name 'linePrepareAddToConference';
function linePrepareAddToConferenceW; external 'Tapi32.dll' name 'linePrepareAddToConferenceW';
{$IFDEF TAPI20}
function lineProxyMessage; external 'Tapi32.dll' name 'lineProxyMessage';
function lineProxyResponse; external 'Tapi32.dll' name 'lineProxyResponse';
{$ENDIF}
function lineRedirect; external 'Tapi32.dll' name 'lineRedirect';
function lineRedirectA; external 'Tapi32.dll' name 'lineRedirect';
function lineRedirectW; external 'Tapi32.dll' name 'lineRedirectW';
function lineRegisterRequestRecipient; external 'Tapi32.dll' name 'lineRegisterRequestRecipient';
function lineReleaseUserUserInfo; external 'Tapi32.dll' name 'lineReleaseUserUserInfo';
function lineRemoveFromConference; external 'Tapi32.dll' name 'lineRemoveFromConference';
function lineRemoveProvider; external 'Tapi32.dll' name 'lineRemoveProvider';
function lineSecureCall; external 'Tapi32.dll' name 'lineSecureCall';
function lineSendUserUserInfo; external 'Tapi32.dll' name 'lineSendUserUserInfo';
{$IFDEF TAPI20}
function lineSetAgentActivity; external 'Tapi32.dll' name 'lineSetAgentActivity';
function lineSetAgentGroup; external 'Tapi32.dll' name 'lineSetAgentGroup';
function lineSetAgentState; external 'Tapi32.dll' name 'lineSetAgentState';
{$ENDIF}
function lineSetAppPriority; external 'Tapi32.dll' name 'lineSetAppPriority';
function lineSetAppPriorityA; external 'Tapi32.dll' name 'lineSetAppPriority';
function lineSetAppPriorityW; external 'Tapi32.dll' name 'lineSetAppPriorityW';
function lineSetAppSpecific; external 'Tapi32.dll' name 'lineSetAppSpecific';
{$IFDEF TAPI20}
function lineSetCallData; external 'Tapi32.dll' name 'lineSetCallData';
{$ENDIF}
function lineSetCallParams; external 'Tapi32.dll' name 'lineSetCallParams';
function lineSetCallPrivilege; external 'Tapi32.dll' name 'lineSetCallPrivilege';
{$IFDEF TAPI20}
function lineSetCallQualityOfService; external 'Tapi32.dll' name 'lineSetCallQualityOfService';
function lineSetCallTreatment; external 'Tapi32.dll' name 'lineSetCallTreatment';
{$ENDIF}
function lineSetCurrentLocation; external 'Tapi32.dll' name 'lineSetCurrentLocation';
function lineSetDevConfig; external 'Tapi32.dll' name 'lineSetDevConfig';
function lineSetDevConfigA; external 'Tapi32.dll' name 'lineSetDevConfig';
function lineSetDevConfigW; external 'Tapi32.dll' name 'lineSetDevConfigW';
{$IFDEF TAPI20}
function lineSetLineDevStatus; external 'Tapi32.dll' name 'lineSetLineDevStatus';
{$ENDIF}
function lineSetMediaControl; external 'Tapi32.dll' name 'lineSetMediaControl';
function lineSetMediaMode; external 'Tapi32.dll' name 'lineSetMediaMode';
function lineSetNumRings; external 'Tapi32.dll' name 'lineSetNumRings';
function lineSetStatusMessages; external 'Tapi32.dll' name 'lineSetStatusMessages';
function lineSetTerminal; external 'Tapi32.dll' name 'lineSetTerminal';
function lineSetTollList; external 'Tapi32.dll' name 'lineSetTollList';
function lineSetTollListA; external 'Tapi32.dll' name 'lineSetTollList';
function lineSetTollListW; external 'Tapi32.dll' name 'lineSetTollListW';
function lineSetupConference; external 'Tapi32.dll' name 'lineSetupConference';
function lineSetupConferenceA; external 'Tapi32.dll' name 'lineSetupConference';
function lineSetupConferenceW; external 'Tapi32.dll' name 'lineSetupConferenceW';
function lineSetupTransfer; external 'Tapi32.dll' name 'lineSetupTransfer';
function lineSetupTransferA; external 'Tapi32.dll' name 'lineSetupTransfer';
function lineSetupTransferW; external 'Tapi32.dll' name 'lineSetupTransferW';
function lineShutdown; external 'Tapi32.dll' name 'lineShutdown';
function lineSwapHold; external 'Tapi32.dll' name 'lineSwapHold';
function lineTranslateAddress; external 'Tapi32.dll' name 'lineTranslateAddress';
function lineTranslateAddressA; external 'Tapi32.dll' name 'lineTranslateAddress';
function lineTranslateAddressW; external 'Tapi32.dll' name 'lineTranslateAddressW';
function lineTranslateDialog; external 'Tapi32.dll' name 'lineTranslateDialog';
function lineTranslateDialogA; external 'Tapi32.dll' name 'lineTranslateDialog';
function lineTranslateDialogW; external 'Tapi32.dll' name 'lineTranslateDialogW';
function lineUncompleteCall; external 'Tapi32.dll' name 'lineUncompleteCall';
function lineUnhold; external 'Tapi32.dll' name 'lineUnhold';
function lineUnpark; external 'Tapi32.dll' name 'lineUnpark';
function lineUnparkA; external 'Tapi32.dll' name 'lineUnpark';
function lineUnparkW; external 'Tapi32.dll' name 'lineUnparkW';
function phoneClose; external 'Tapi32.dll' name 'phoneClose';
function phoneConfigDialog; external 'Tapi32.dll' name 'phoneConfigDialog';
function phoneConfigDialogA; external 'Tapi32.dll' name 'phoneConfigDialog';
function phoneConfigDialogW; external 'Tapi32.dll' name 'phoneConfigDialogW';
function phoneDevSpecific; external 'Tapi32.dll' name 'phoneDevSpecific';
function phoneGetButtonInfo; external 'Tapi32.dll' name 'phoneGetButtonInfo';
function phoneGetButtonInfoA; external 'Tapi32.dll' name 'phoneGetButtonInfo';
function phoneGetButtonInfoW; external 'Tapi32.dll' name 'phoneGetButtonInfoW';
function phoneGetData; external 'Tapi32.dll' name 'phoneGetData';
function phoneGetDevCaps; external 'Tapi32.dll' name 'phoneGetDevCaps';
function phoneGetDevCapsA; external 'Tapi32.dll' name 'phoneGetDevCaps';
function phoneGetDevCapsW; external 'Tapi32.dll' name 'phoneGetDevCapsW';
function phoneGetDisplay; external 'Tapi32.dll' name 'phoneGetDisplay';
function phoneGetGain; external 'Tapi32.dll' name 'phoneGetGain';
function phoneGetHookSwitch; external 'Tapi32.dll' name 'phoneGetHookSwitch';
function phoneGetIcon; external 'Tapi32.dll' name 'phoneGetIcon';
function phoneGetIconA; external 'Tapi32.dll' name 'phoneGetIcon';
function phoneGetIconW; external 'Tapi32.dll' name 'phoneGetIconW';
function phoneGetID; external 'Tapi32.dll' name 'phoneGetID';
function phoneGetIDA; external 'Tapi32.dll' name 'phoneGetID';
function phoneGetIDW; external 'Tapi32.dll' name 'phoneGetIDW';
function phoneGetLamp; external 'Tapi32.dll' name 'phoneGetLamp';
{$IFDEF TAPI20}
function phoneGetMessage; external 'Tapi32.dll' name 'phoneGetMessage';
{$ENDIF}
function phoneGetRing; external 'Tapi32.dll' name 'phoneGetRing';
function phoneGetStatus; external 'Tapi32.dll' name 'phoneGetStatus';
function phoneGetStatusA; external 'Tapi32.dll' name 'phoneGetStatus';
function phoneGetStatusW; external 'Tapi32.dll' name 'phoneGetStatusW';
function phoneGetStatusMessages; external 'Tapi32.dll' name 'phoneGetStatusMessages';
function phoneGetVolume; external 'Tapi32.dll' name 'phoneGetVolume';
function phoneInitialize; external 'Tapi32.dll' name 'phoneInitialize';
{$IFDEF TAPI20}
function phoneInitializeEx; external 'Tapi32.dll' name 'phoneInitializeEx';
function phoneInitializeExA; external 'Tapi32.dll' name 'phoneInitializeEx';
function phoneInitializeExW; external 'Tapi32.dll' name 'phoneInitializeExW';
{$ENDIF}
function phoneNegotiateAPIVersion; external 'Tapi32.dll' name 'phoneNegotiateAPIVersion';
function phoneNegotiateExtVersion; external 'Tapi32.dll' name 'phoneNegotiateExtVersion';
function phoneOpen; external 'Tapi32.dll' name 'phoneOpen';
function phoneSetButtonInfo; external 'Tapi32.dll' name 'phoneSetButtonInfo';
function phoneSetButtonInfoA; external 'Tapi32.dll' name 'phoneSetButtonInfo';
function phoneSetButtonInfoW; external 'Tapi32.dll' name 'phoneSetButtonInfoW';
function phoneSetData; external 'Tapi32.dll' name 'phoneSetData';
function phoneSetDisplay; external 'Tapi32.dll' name 'phoneSetDisplay';
function phoneSetGain; external 'Tapi32.dll' name 'phoneSetGain';
function phoneSetHookSwitch; external 'Tapi32.dll' name 'phoneSetHookSwitch';
function phoneSetLamp; external 'Tapi32.dll' name 'phoneSetLamp';
function phoneSetRing; external 'Tapi32.dll' name 'phoneSetRing';
function phoneSetStatusMessages; external 'Tapi32.dll' name 'phoneSetStatusMessages';
function phoneSetVolume; external 'Tapi32.dll' name 'phoneSetVolume';
function phoneShutdown; external 'Tapi32.dll' name 'phoneShutdown';
function tapiGetLocationInfo; external 'Tapi32.dll' name 'tapiGetLocationInfo';
function tapiGetLocationInfoA; external 'Tapi32.dll' name 'tapiGetLocationInfo';
function tapiGetLocationInfoW; external 'Tapi32.dll' name 'tapiGetLocationInfoW';
function tapiRequestDrop; external 'Tapi32.dll' name 'tapiRequestDrop';
function tapiRequestMakeCall; external 'Tapi32.dll' name 'tapiRequestMakeCall';
function tapiRequestMakeCallA; external 'Tapi32.dll' name 'tapiRequestMakeCall';
function tapiRequestMakeCallW; external 'Tapi32.dll' name 'tapiRequestMakeCallW';
function tapiRequestMediaCall; external 'Tapi32.dll' name 'tapiRequestMediaCall';
function tapiRequestMediaCallA; external 'Tapi32.dll' name 'tapiRequestMediaCall';
function tapiRequestMediaCallW; external 'Tapi32.dll' name 'tapiRequestMediaCallW';

{$ELSE}

function tapiRequestMakeCall; external 'TAPI' index 28;
function tapiRequestMediaCall; external 'TAPI' index 101;
function tapiRequestDrop; external 'TAPI' index 112;
function lineRegisterRequestRecipient; external 'TAPI' index 10;
function tapiGetLocationInfo; external 'TAPI' index 85;
function lineSetCurrentLocation; external 'TAPI' index 81;
function lineSetTollList; external 'TAPI' index 3;
function lineTranslateAddress; external 'TAPI' index 19;
function lineGetTranslateCaps; external 'TAPI' index 100;
function lineAccept; external 'TAPI' index 82;
function lineAddToConference; external 'TAPI' index 47;
function lineAnswer; external 'TAPI' index 103;
function lineBlindTransfer; external 'TAPI' index 25;
function lineClose; external 'TAPI' index 78;
function lineCompleteCall; external 'TAPI' index 76;
function lineCompleteTransfer; external 'TAPI' index 73;
function lineConfigDialog; external 'TAPI' index 12;
function lineConfigDialogEdit; external 'TAPI' index 135;
function lineDeallocateCall; external 'TAPI' index 111;
function lineDevSpecific; external 'TAPI' index 21;
function lineDevSpecificFeature; external 'TAPI' index 22;
function lineDial; external 'TAPI' index 29;
function lineDrop; external 'TAPI' index 23;
function lineForward; external 'TAPI' index 87;
function lineGatherDigits; external 'TAPI' index 52;
function lineGenerateDigits; external 'TAPI' index 105;
function lineGenerateTone; external 'TAPI' index 80;
function lineGetAddressCaps; external 'TAPI' index 71;
function lineGetAddressID; external 'TAPI' index 104;
function lineGetAddressStatus; external 'TAPI' index 60;
function lineGetCallInfo; external 'TAPI' index 97;
function lineGetCallStatus; external 'TAPI' index 94;
function lineGetConfRelatedCalls; external 'TAPI' index 72;
function lineGetDevCaps; external 'TAPI' index 116;
function lineGetDevConfig; external 'TAPI' index 79;
function lineGetNewCalls; external 'TAPI' index 34;
function lineGetIcon; external 'TAPI' index 53;
function lineGetID; external 'TAPI' index 40;
function lineGetLineDevStatus; external 'TAPI' index 49;
function lineGetNumRings; external 'TAPI' index 62;
function lineGetRequest; external 'TAPI' index 86;
function lineGetStatusMessages; external 'TAPI' index 45;
function lineHandoff; external 'TAPI' index 11;
function lineHold; external 'TAPI' index 6;
function lineInitialize; external 'TAPI' index 33;
function lineMakeCall; external 'TAPI' index 32;
function lineMonitorDigits; external 'TAPI' index 24;
function lineMonitorMedia; external 'TAPI' index 15;
function lineMonitorTones; external 'TAPI' index 31;
function lineNegotiateAPIVersion; external 'TAPI' index 64;
function lineNegotiateExtVersion; external 'TAPI' index 17;
function lineOpen; external 'TAPI' index 46;
function linePark; external 'TAPI' index 5;
function linePickup; external 'TAPI' index 102;
function linePrepareAddToConference; external 'TAPI' index 50;
function lineRedirect; external 'TAPI' index 38;
function lineRemoveFromConference; external 'TAPI' index 43;
function lineSecureCall; external 'TAPI' index 57;
function lineSendUserUserInfo; external 'TAPI' index 63;
function lineSetAppSpecific; external 'TAPI' index 88;
function lineSetCallParams; external 'TAPI' index 2;
function lineSetCallPrivilege; external 'TAPI' index 95;
function lineSetDevConfig; external 'TAPI' index 107;
function lineSetMediaControl; external 'TAPI' index 37;
function lineSetMediaMode; external 'TAPI' index 115;
function lineSetNumRings; external 'TAPI' index 61;
function lineSetStatusMessages; external 'TAPI' index 44;
function lineSetTerminal; external 'TAPI' index 108;
function lineSetupConference; external 'TAPI' index 48;
function lineSetupTransfer; external 'TAPI' index 65;
function lineShutdown; external 'TAPI' index 8;
function lineSwapHold; external 'TAPI' index 109;
function lineUncompleteCall; external 'TAPI' index 41;
function lineUnhold; external 'TAPI' index 113;
function lineUnpark; external 'TAPI' index 77;
function lineReleaseUserUserInfo; external 'TAPI' index 139;
function phoneClose; external 'TAPI' index 119;
function phoneConfigDialog; external 'TAPI' index 16;
function phoneDevSpecific; external 'TAPI' index 9;
function phoneGetButtonInfo; external 'TAPI' index 4;
function phoneGetData; external 'TAPI' index 93;
function phoneGetDevCaps; external 'TAPI' index 114;
function phoneGetDisplay; external 'TAPI' index 83;
function phoneGetGain; external 'TAPI' index 68;
function phoneGetHookSwitch; external 'TAPI' index 27;
function phoneGetIcon; external 'TAPI' index 74;
function phoneGetID; external 'TAPI' index 106;
function phoneGetLamp; external 'TAPI' index 117;
function phoneGetRing; external 'TAPI' index 70;
function phoneGetStatus; external 'TAPI' index 39;
function phoneGetStatusMessages; external 'TAPI' index 55;
function phoneGetVolume; external 'TAPI' index 59;
function phoneInitialize; external 'TAPI' index 35;
function phoneNegotiateAPIVersion; external 'TAPI' index 7;
function phoneNegotiateExtVersion; external 'TAPI' index 14;
function phoneOpen; external 'TAPI' index 89;
function phoneSetButtonInfo; external 'TAPI' index 42;
function phoneSetData; external 'TAPI' index 92;
function phoneSetDisplay; external 'TAPI' index 98;
function phoneSetGain; external 'TAPI' index 67;
function phoneSetHookSwitch; external 'TAPI' index 51;
function phoneSetLamp; external 'TAPI' index 118;
function phoneSetRing; external 'TAPI' index 69;
function phoneSetStatusMessages; external 'TAPI' index 56;
function phoneSetVolume; external 'TAPI' index 54;
function phoneShutdown; external 'TAPI' index 26;
function lineTranslateDialog; external 'TAPI' index 13;
function lineGetCountry; external 'TAPI' index 143;
function lineGetAppPriority; external 'TAPI' index 58;
function lineSetAppPriority; external 'TAPI' index 66;
function lineAddProvider; external 'TAPI' index 141;
function lineConfigProvider; external 'TAPI' index 75;
function lineRemoveProvider; external 'TAPI' index 142;
function lineGetProviderList; external 'TAPI' index 129;

{$ENDIF}

function TAPIERROR_FORMATMESSAGE (ErrCode: Longint): Longint;
  begin
  if ErrCode > $FFFF0000 then
    Result := ErrCode and $FFFF
  else if ErrCode and $10000000 <> 0 then
    Result := ErrCode - $90000000 + $F000
  else
    Result := ErrCode - $80000000 + $F000;
  end;

end.

