unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dgcspts, DGCILib, DGC, DGCStar, DGCSnd, dgcslib, Dgcfxlib, hiscore,
  ExtCtrls;

type
  TForm1 = class(TForm)
    DGCScreen1: TDGCScreen;
    DGCImageLib1: TDGCImageLib;
    DGCSpriteMgr1: TDGCSpriteMgr;
    DGCAudio1: TDGCAudio;
    DGCSoundLib1: TDGCSoundLib;
    DGCStarField1: TDGCStarField;
    DGCIntroLib1: TDGCIntroLib;
    DGCHiScore1: TDGCHiScore;
    Timer1: TTimer;
    procedure DGCScreen1Initialize(Sender: TObject);
    procedure DGCScreen1Flip(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure DGCSpriteMgr1SpriteStopped(Sprite: TDGCSprite;
      LimitsSide: TLimitsSide);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CurrentLevel:Integer;
    Lives:Integer;
    Score:Longint;
    BulletCount:Integer;
    LastFireTickCount:longint;
    FirstDonut:Integer;
    FirstMidDonut:Integer;
    FirstSmallDonut:Integer;
    FirstBullet:integer;
    numofdonuts:Integer;
    AlienShip:Integer;
    Donutsleft:Integer;
    AlienFireTime:Integer;
    APaused:Boolean;
    HyperSpaceTickCount:Longint;
    HyperSpaceWait:Integer;
    SaucerTickCount:LongInt;
    AWaiting:Boolean;
    GameEnd:boolean;
    ShipAppearCount:Longint;
    ShowHiscore:Boolean;
    FirstAlienBullet:Integer;
    ShowingHiscore:Boolean;
    Procedure SetUpSprites;
    Procedure SetUpAnimations;
    Procedure NextLevel;
    Procedure CheckKeys;
    Procedure CheckCollisions;
    Procedure CreateAliens;
    Procedure ShowFourMidSizedDonuts(NewX,NewY:Integer);
    Procedure ShowFourSmallSizedDonuts(NewX,NewY:Integer);
    Procedure DrawScore;
    Procedure DrawLives;
    Procedure EndOfLevel;
    Procedure GameOver;
    Procedure FindFirstAvailableBullet(NewX,NewY,Adirection:Integer);
    Procedure AlienFire;
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}
Procedure Tform1.SetUpAnimations;
begin
     //Add the Our animation
     DGCSpriteMgr1.Animations.Add('OurShip', True);
     with DGCSpriteMgr1.Animations[0] do
     begin
          SetFrames(0, 1, [170]);
          SetFrames(2, 1, [167]);
          SetFrames(4, 1, [165]);
          SetFrames(6, 1, [162]);
          SetFrames(8, 1, [160]);
          SetFrames(10, 1, [157]);
          SetFrames(12, 1, [155]);
          SetFrames(14, 1, [152]);
          SetFrames(16, 1, [150]);
          SetFrames(18, 1, [187]);
          SetFrames(20, 1, [185]);
          SetFrames(22, 1, [182]);
          SetFrames(24, 1, [180]);
          SetFrames(26, 1, [177]);
          SetFrames(28, 1, [175]);
          SetFrames(30, 1, [172]);
     end;
     // Add Bullet Animation
     DGCSpriteMgr1.Animations.Add('Bullet',false);
     With DGCSpriteMgr1.Animations[1] do
          Setalldirections(50,[190]);
     //Add the Donut animation
     DGCSpriteMgr1.Animations.Add('LargeDonut', True);
     with DGCSpriteMgr1.Animations[2] do
          Setalldirections(50,[0,2,4,6,8,10,12,14,16,18,20,22,24,26,28]);
     //Add the Medium Donut animation
     DGCSpriteMgr1.Animations.Add('MidDonut', True);
     with DGCSpriteMgr1.Animations[3] do
          Setalldirections(50,[30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68]);
     //Add the Medium Donut animation
     DGCSpriteMgr1.Animations.Add('SmallDonut', True);
     with DGCSpriteMgr1.Animations[4] do
          Setalldirections(50,[70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108]);
     //Add the Saucer animation
     DGCSpriteMgr1.Animations.Add('Saucer', True);
     with DGCSpriteMgr1.Animations[5] do
          Setalldirections(150,[201,202,203,202]);
end;

Procedure Tform1.DrawScore;
var
   ScoreStr:String;
   i:Integer;
begin
     ScoreStr:=Format('%.8d',[Score]);
     for i:=1 to 8 do
          DGCScreen1.Back.Draw(((DGCSCreen1.Back.Width div 2)- ((8*17)div 2))+(i*17),0,DGCScreen1.Images[191+(ord(Scorestr[i])-48)],True);
end;

Procedure TForm1.SetUpSprites;
begin
     ShipappearCount:=GetTickCount;
     DGCSpriteMgr1.Sprites.AddThruster(0, 320, 240, 0, 6, 0);
     with DGCSpriteMgr1.Sprites[0] as TDGCThruster do
     begin
          Acceleration := 0.1;  //Try making this a smaller value
          Decceleration := 0.05; //Try making this a smaller value
          Handling:=30;
          Hide;
     end;
end;

Procedure Tform1.DrawLives;
var
   i:integer;
begin
     With DGCScreen1.Back do
     begin
          for i:= 1 to Lives-1 do
               StretchDraw(rect(i*DGCScreen1.Images[170].Width div 2,height - DGCScreen1.Images[170].height,
                                i*DGCScreen1.Images[170].Width div 2 + (DGCScreen1.Images[170].width div 2),
                                height - DGCScreen1.Images[170].height + (DGCScreen1.Images[170].Height div 2)),
                                DGCScreen1.Images[170],true);
     end;
end;

procedure TForm1.DGCScreen1Initialize(Sender: TObject);
var
   n: Integer;
   temp:integer;
begin
     DGCIntroLib1.Filename:=Extractfilepath(Application.ExeName)+'\delphoid.crl';
     DGCIntrolib1.Play;
     ShipAppearCount:=GetTickCount;
     SetupAnimations;
     CurrentLevel:=0;
     AWaiting:=true;
     GameEnd:=False;
     HyperSpaceTickCount:=0;
     APaused:=False;
     Lives:=3;
     Score:=0;
     SaucerTickCount:=GetTickCount;
     AlienFireTime:=250;
     DGCScreen1.Flip;
end;

Procedure TForm1.CreateAliens;
var
   n,i:integer;
begin
     firstDonut:=DGCSpriteMgr1.Sprites.Count;
     for n:=1 to NumOfDonuts do
     begin
          i:=DGCSpriteMgr1.Sprites.AddBouncer(0, Random(DGCScreen1.Back.Width),Random(DGCScreen1.Back.Height), Random(32), 1+Random(3), 2);
          with DGCSpriteMgr1.Sprites[i] as TDGCBouncer do
               Allactions:=Lawrap;
     end;
     FirstMidDonut:=DGCSpriteMgr1.Sprites.Count;
     for n:=1 to NumOfDonuts*4 do
     begin
          i:=DGCSpriteMgr1.Sprites.AddBouncer(0, Random(DGCScreen1.Back.Width),Random(DGCScreen1.Back.Height), Random(32), 1+Random(3), 3);
          with DGCSpriteMgr1.Sprites[i] as TDGCBouncer do
          begin
               Allactions:=Lawrap;
               Hide;
               Disable;
          end;
     end;
     firstSmallDonut:=DGCSpriteMgr1.Sprites.Count;
     Donutsleft:=Numofdonuts*16;
     for n:=1 to NumOfDonuts*16 do
     begin
          i:=DGCSpriteMgr1.Sprites.AddBouncer(100, Random(DGCScreen1.Back.Width),Random(DGCScreen1.Back.Height), Random(32), 1+Random(4), 4);
          with DGCSpriteMgr1.Sprites[i] as TDGCBouncer do
          begin
               Allactions:=Lawrap;
               Hide;
               Disable;
          end;
     end;
     Alienship:=DGCSpriteMgr1.Sprites.AddBouncer(400,640,0,8,3,5);
     with DGCSpriteMgr1.Sprites[Alienship] as TDGCBouncer do
     begin
          //  will be hidden default
          Hide;
          Enable;
          Allactions:=LaWrap;
     end;
     FirstBullet:=DGCSpriteMgr1.Sprites.Count;
     for n:=1 to 20 do
     begin
          i:=DGCSpriteMgr1.Sprites.AddBouncer(300, Random(DGCScreen1.Back.Width),Random(DGCScreen1.Back.Height), Random(32), 4, 1);
          with DGCSpriteMgr1.Sprites[i] as TDGCBouncer do
          begin
               Allactions:=LaStopOutside;
               Hide;
               Disable;
          end;
     end;
     FirstAlienBullet:=DGCSpriteMgr1.Sprites.AddBouncer(200, 0,0, 0, 6, 1);
     with DGCSpriteMgr1.Sprites[FirstAlienBullet] as TDGCBouncer do
     begin
          Allactions:=LaStopOutside;
          Hide;
     end;
end;

Procedure TForm1.NextLevel;
var
   n,i:Integer;
begin
     DGCStarfield1.Generate;
     ShowingHiscore:=false;
     while DGCSpriteMgr1.Sprites.Count > 0 do
         DGCSPriteMgr1.Sprites.Delete(0);
     SetUpSprites;
     BulletCount:=21;
     Randomize;
     inc(currentlevel);
     Numofdonuts:=Currentlevel;
     If Numofdonuts > 6 then
        NumofDonuts:=6;
     CreateAliens;
     showhiscore:=true;
     Timer1.Enabled:=False;
     DGCScreen1.FlippingEnabled:=True;
end;

Procedure TForm1.EndofLevel;
var
   MsgString:string;
   i:integer;
begin
     For i:=0 to DGCSpriteMgr1.Sprites.Count - 1 do
         DGCSpriteMgr1.Sprites[i].Hide;
     DGCScreen1.FlippingEnabled:=False;
     DGCScreen1.Back.EraseRect(DGCScreen1.Back.clientrect, 0);
     with DGCScreen1.Back.Canvas do
     begin
          msgstring:=Format('LEVEL %0.2d ',[Currentlevel+1]);
          Brush.Style:=BsClear;
          Font.Size := 30;
          Font.Name:='Times New Roman';
          Font.Color := rgb(0,128,0);
          TextOut(DGCScreen1.Back.Width div 2 - TextWidth(msgstring) div 2,(DGCScreen1.Back.height div 2)-100 , msgstring);
          Font.Color := rgb(0,255,0);
          TextOut((DGCScreen1.Back.Width div 2- TextWidth(msgstring)div 2)+2,(DGCScreen1.back.height div 2)-99 , msgstring);
          msgstring:='Press Fire To Continue - Esc To Exit';
          Font.Color := rgb(128,128,128);
          TextOut(DGCScreen1.Back.Width div 2 - TextWidth(msgstring) div 2,DGCScreen1.Back.height -100 , msgstring);
          Font.Color := rgb(255,255,255);
          TextOut((DGCScreen1.Back.Width div 2- TextWidth(msgstring)div 2)+2,DGCScreen1.back.height -99 , msgstring);
          Release;
     end;
     AWaiting:=true;
end;

Procedure TForm1.GameOver;
var
   MsgString:string;
   i:integer;
begin
     For i:=0 to DGCSpriteMgr1.Sprites.Count - 1 do
         DGCSpriteMgr1.Sprites[i].Hide;
     DGCScreen1.FlippingEnabled:=False;
     DGCScreen1.Back.EraseRect(DGCScreen1.Back.clientrect, 0);
     with DGCScreen1.Back.Canvas do
     begin
          msgstring:='GameOver';
          Brush.Style:=BsClear;
          Font.Size := 24;
          Font.Name:='Times New Roman';
          Font.Color := rgb(0,128,0);
          TextOut(DGCScreen1.Back.Width div 2 - TextWidth(msgstring) div 2,(DGCScreen1.Back.height div 2)-100 , msgstring);
          Font.Color := rgb(0,255,0);
          TextOut((DGCScreen1.Back.Width div 2- TextWidth(msgstring)div 2)+2,(DGCScreen1.back.height div 2)-99 , msgstring);
          msgstring:='Press Fire For New Game - Esc To Exit';
          Font.Color := rgb(128,128,128);
          TextOut(DGCScreen1.Back.Width div 2 - TextWidth(msgstring) div 2,DGCScreen1.Back.height -100 , msgstring);
          Font.Color := rgb(255,255,255);
          TextOut((DGCScreen1.Back.Width div 2- TextWidth(msgstring)div 2)+2,DGCScreen1.back.height -99 , msgstring);
          Release;
     end;
     GameEnd:=true;
end;

procedure TForm1.DGCScreen1Flip(Sender: TObject);
begin
     DGCScreen1.Back.Erase(0);
     if DonutsLeft <=0 then
        Awaiting:=true;
     if Lives < 1 then
     begin
        If DGCAudio1.Sound[0].Playing then
           DGCAudio1.Sound[0].stop;
        if DGCHiScore1.CheckHiScore(Score,Currentlevel) then
           DGCHiScore1.Execute(Score,Currentlevel);
        showinghiscore:=true;
        Gameover;
        timer1.enabled:=true;
        exit;
     end;
     If (Awaiting) then
        EndOfLevel
     else
     begin
          DGCStarField1.Update;
          if (GetTickCount - SaucerTickCount >=  30000) and (Not DGCSpriteMgr1.Sprites[alienship].Visible) then
          begin
               SaucerTickCount :=GettickCount;
               with DGCSpriteMgr1.Sprites[AlienShip] do
               begin
                    // should give 0 or screen width
                    If Not DGCAudio1.Sound[0].Playing then
                         DGCAudio1.Sound[0].PlayLoop;
                    X:=random(1)*600;
                    Y:=random(1)*400;
                    LookAt(DGCSpriteMgr1.Sprites[0].X,DGCSpriteMgr1.Sprites[0].Y);
                    Show;
                    Resume;
               end;
          end;
          AlienFire;
          DrawLives;
          DrawScore;
          CheckKeys;
          CheckCollisions;
          If HyperSpaceTickcount <> 0 then
          begin
               // Disable Fire While In HyperSpace
               BulletCount := 21;
               if (GetTickcount - HyperSpaceTickCount) >= (HyperSpaceWait*100) then
               begin
                    HyperSpaceTickCount:=0;
                    With DGCSpriteMgr1.Sprites[0] do
                    begin
                         X:=Random(DGCScreen1.Back.Width - width);
                         Y:=Random(DGCScreen1.Back.Height - Height);
                         Show;
                    end;
                    // Reenable Fire
                    BulletCount:=0;
               end;
          end
          else
          begin
              DGCStarField1.Velocity:=1;
              if (GetTickCount - ShipappearCount >= 3000)and (Not DGCSpriteMgr1.Sprites[0].Visible) then
              begin
                   DGCSpriteMgr1.Sprites[0].Show;
                   DGCSpriteMgr1.Sprites[0].Enable;
                   Bulletcount:=0;
              end;
          end;
     end;
     DGCSpriteMgr1.Update;
     DGCSpriteMgr1.Draw;
end;

Procedure TForm1.FindFirstAvailableBullet(NewX,NewY,Adirection:Integer);
var
   i:integer;
begin
     For i:= FirstBullet to FirstBullet + 20 do
     begin
          if Not DGCSpriteMgr1.Sprites[i].Enabled then
          begin
               with DGCSpriteMgr1.Sprites[i] do
               begin
                    X:=NewX;
                    Y:=NewY;
                    Direction:=Adirection;
                    Show;
                    Enable;
                    Resume;
               end;
               inc(BulletCount);
               Break;
          end;
     end;
end;

Procedure TForm1.ShowFourMidsizedDonuts(NewX,NewY:integer);
var
   showcount,i:Integer;
begin
     ShowCount:=0;
     For i:= FirstMidDonut to FirstMidDonut +(NumOfDonuts*4) do
     begin
          if Not DGCSpriteMgr1.Sprites[i].Enabled then
          begin
               with DGCSpriteMgr1.Sprites[i] do
               begin
                    X:=NewX;
                    Y:=NewY;
                    Direction:=Random(32);
                    Show;
                    Enable;
               end;
               inc(ShowCount);
          end;
          if ShowCount > 3 then Break;
     end;
end;

Procedure TForm1.ShowFourSmallsizedDonuts(NewX,NewY:integer);
var
   showcount,i:Integer;
begin
     ShowCount:=0;
     For i:= FirstSmallDonut to FirstSmallDonut +(NumOfDonuts*16) do
     begin
          if Not DGCSpriteMgr1.Sprites[i].Enabled then
          begin
               with DGCSpriteMgr1.Sprites[i] do
               begin
                    X:=NewX;
                    Y:=NewY;
                    Direction:=Random(32);
                    Show;
                    Enable;
               end;
               inc(ShowCount);
          end;
          if ShowCount > 3 then Break;
     end;
end;

Procedure TForm1.CheckCollisions;
var
   i,j:integer;
begin
     // any bullet and a donut
     for i:=FirstBullet to DGCSpriteMgr1.Sprites.Count-1 do
     begin
          if DGCSpriteMgr1.Sprites[i].Id = 300 then
          begin
               for j:= FirstDonut to Firstdonut + NumofDonuts -1  do
               begin
                    if DGCSpriteMgr1.Sprites.Collision(i,j) then
                    begin
                       inc(score,100);
                       With DGCSpriteMgr1.Sprites[j] do
                       begin
                            Disable;
                            Hide;
                            ShowFourMidSizedDonuts(X+(width div 2),Y+(Height div 2));
                       end;
                       With DGCSpriteMgr1.Sprites[i] do
                       begin
                            Dec(bulletcount);
                            Disable;
                            Stop;
                            Hide;
                       end;
                       If not DGCAudio1.Sound[1].Playing then
                       begin
                            DGCAudio1.Sound[1].Position:=0;
                            DGCAudio1.Sound[1].Play;
                       end;
                    end;
                    if DGCSpriteMgr1.Sprites.Collision(0,j) then
                    begin
                         Dec(Lives);
                         With DGCSpriteMgr1.Sprites[j] do
                         begin
                              Hide;
                              ShowFourMidSizedDonuts(X+(width div 2),Y+(Height div 2));
                              Disable;
                         end;
                         If not DGCAudio1.Sound[1].Playing then
                         begin
                            DGCAudio1.Sound[1].Position:=0;
                            DGCAudio1.Sound[1].Play;
                         end;
                         DGCSpriteMgr1.Sprites[0].Hide;
                         DGCSpriteMgr1.Sprites[0].Disable;
                         ShipAppearCount:=GetTickCount;
                         Break;
                    end;
               end;
               for j:= FirstMidDonut to (FirstMiddonut + NumofDonuts*4) -1  do
               begin
                    if DGCSpriteMgr1.Sprites.Collision(i,j) then
                    begin
                       inc(score,200);
                       With DGCSpriteMgr1.Sprites[j] do
                       begin
                            Disable;
                            Hide;
                            ShowFourSmallSizedDonuts(X+(width div 2),Y+(Height div 2));
                       end;
                       With DGCSpriteMgr1.Sprites[i] do
                       begin
                            Dec(bulletcount);
                            Disable;
                            Stop;
                            Hide;
                       end;
                       If not DGCAudio1.Sound[1].Playing then
                       begin
                            DGCAudio1.Sound[1].Position:=0;
                            DGCAudio1.Sound[1].Play;
                       end;
                    end;
                    if DGCSpriteMgr1.Sprites.Collision(0,j) then
                    begin
                         Dec(Lives);
                         With DGCSpriteMgr1.Sprites[j] do
                         begin
                              Hide;
                              ShowFourSmallSizedDonuts(X+(width div 2),Y+(Height div 2));
                              Disable;
                         end;
                         If not DGCAudio1.Sound[1].Playing then
                         begin
                            DGCAudio1.Sound[1].Position:=0;
                            DGCAudio1.Sound[1].Play;
                         end;
                         DGCSpriteMgr1.Sprites[0].Hide;
                         DGCSpriteMgr1.Sprites[0].Disable;
                         ShipAppearCount:=GetTickCount;
                         Break;
                    end;
               end;
               for j:= FirstsmallDonut to (Firstsmalldonut + NumofDonuts*16) -1  do
               begin
                    if DGCSpriteMgr1.Sprites.Collision(i,j) then
                    begin
                       inc(score,300);
                       Dec(DonutsLeft);
                       With DGCSpriteMgr1.Sprites[j] do
                       begin
                            Disable;
                            Hide;
                       end;
                       With DGCSpriteMgr1.Sprites[i] do
                       begin
                            Dec(bulletcount);
                            Disable;
                            Stop;
                            Hide;
                       end;
                       If not DGCAudio1.Sound[1].Playing then
                       begin
                            DGCAudio1.Sound[1].Position:=0;
                            DGCAudio1.Sound[1].Play;
                       end;
                    end;
                    if DGCSpriteMgr1.Sprites.Collision(0,j) then
                    begin
                         Dec(Lives);
                         Dec(DonutsLeft);
                         With DGCSpriteMgr1.Sprites[j] do
                         begin
                              Hide;
                              Disable;
                         end;
                         If not DGCAudio1.Sound[1].Playing then
                         begin
                            DGCAudio1.Sound[1].Position:=0;
                            DGCAudio1.Sound[1].Play;
                         end;
                         DGCSpriteMgr1.Sprites[0].Hide;
                         DGCSpriteMgr1.Sprites[0].Disable;
                         ShipAppearCount:=GetTickCount;
                         break;
                    end;
               end;
          end;
          if (DGCSpriteMgr1.Sprites[i].id <> 200) and (DGCSpriteMgr1.Sprites[i].Visible) and (DGCSpriteMgr1.Sprites.Collision(i,AlienShip)) then
          begin
                DGCAudio1.Sound[0].Stop;
                With DGCSpriteMgr1.Sprites[AlienShip] do
                begin
                     Hide;
                     SaucerTickCount:=GetTickCount;
                     Inc(Score,1000);
                end;
                With DGCSpriteMgr1.Sprites[i] do
                begin
                     Dec(bulletcount);
                     Disable;
                     Stop;
                     Hide;
                end;
           end;
     end;
     if DGCSpriteMgr1.Sprites.Collision(0,Firstalienbullet) then
     begin
          Dec(Lives);
          With DGCSpriteMgr1.Sprites[FirstAlienBullet] do
          begin
               Hide;
               Disable;
          end;
          If not DGCAudio1.Sound[1].Playing then
          begin
               DGCAudio1.Sound[1].Position:=0;
               DGCAudio1.Sound[1].Play;
          end;
          DGCSpriteMgr1.Sprites[0].Hide;
          DGCSpriteMgr1.Sprites[0].Disable;
          ShipAppearCount:=GetTickCount;
     end;
end;

Procedure TForm1.CheckKeys;
var
   i:integer;
begin
     if (DGCScreen1.KeyDown(Vk_Space)) and (not awaiting) and (not gameend) then
     begin
          if (bulletcount < 20) and (Gettickcount - LastFireTickCount >= 50) and (DGCSpriteMgr1.Sprites[0].Visible) then
          begin
               FindFirstAvailablebullet(DGCSPriteMgr1.Sprites[0].X + (DGCSpriteMgr1.Sprites[0].Width div 2),
                                        DGCSpriteMgr1.Sprites[0].Y+(DGCSpriteMgr1.Sprites[0].height div 2),
                                        (DGCSpriteMgr1.Sprites[0] as TDGCThruster).CurrentDirection);
               LastFireTickCount:=GetTickCount;
               If not DGCAudio1.Sound[2].Playing then
               begin
                    DGCAudio1.Sound[2].Position:=0;
                    DGCAudio1.Sound[2].Play;
               end;
          end;
     end;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
     if key = #27 then
        close;
     if (Upcase(key) = 'P') then
     begin
          Apaused := not Apaused;
          if Apaused then
          begin
               DGCScreen1.FlippingEnabled:=false;
               with DGCScreen1.Front.Canvas do
               begin
                    Font.Size := 18;
                    Brush.Style:=Bsclear;
                    Font.Color := clwhite;
                    TextOut((DGCScreen1.Front.Width div 2) - (TextWidth('Game Paused') div 2),200 , 'Game Paused');
                    Release;
               end;
          end
          else
              DGCScreen1.FlippingEnabled:=true;
     end;
     if (UpCase(Key)='H') then
     begin
          DGCStarField1.Velocity:=20;
          DGCSpriteMgr1.Sprites[0].Hide;
          HyperSpaceTickCount:=GetTickCount;
          HyperSpaceWait:=10+Random(20);
     end;
     if (key = #32) and (Awaiting) then
     begin
          timer1.enabled:=false;
          DGCAudio1.Sound[3].PlayLoop;
          NextLevel;
          AWaiting:=False;
     end;
     If (key = #32) and (Gameend) then
     begin
          ShipAppearCount:=GetTickCount;
          CurrentLevel:=0;
          AWaiting:=true;
          GameEnd:=False;
          HyperSpaceTickCount:=0;
          APaused:=False;
          Lives:=3;
          Score:=0;
     end;
end;


Procedure Tform1.AlienFire;
var
   SpriteNum,i:Integer;
begin
     if (not DGCSpriteMgr1.Sprites[Firstalienbullet].Visible) and (DGCSpriteMgr1.Sprites[0].Visible) then
     begin
          if DGCSpriteMgr1.Sprites[Alienship].Visible then
          begin
               With DGCSpriteMgr1.Sprites[Firstalienbullet] do
               begin
                    X:=DGCSpriteMgr1.Sprites[alienship].X + (DGCSpriteMgr1.Sprites[alienship].Width div 2);
                    Y:=DGCSpriteMgr1.Sprites[alienship].Y + (DGCSpriteMgr1.Sprites[alienship].Height div 2);
                    Lookat(DGCSpriteMgr1.Sprites[0].X ,DGCSpriteMgr1.Sprites[0].y) ;
                    Speed:=8;
                    Limits:=rect(X-200,Y-200,X+200,Y+200);
                    Allactions:=Lastopoutside;
                    Show;
                    Resume;
                    If not DGCAudio1.Sound[2].Playing then
                    begin
                         DGCAudio1.Sound[2].Position:=0;
                         DGCAudio1.Sound[2].Play;
                    end;
               end;
          end;
     end;
end;

procedure TForm1.DGCSpriteMgr1SpriteStopped(Sprite: TDGCSprite;
  LimitsSide: TLimitsSide);
begin
    if Sprite.Id = 300 then
    begin
         Sprite.Disable;
         Sprite.Hide;
         Dec(BulletCount);
    end;
    if Sprite.Id = 200 then
         Sprite.Hide;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
     DGCSCreen1.Flippingenabled:=false;
     if ShowHiscore then
     begin
        DGCHIScore1.ShowScores;
        ShowHiScore:=False;
     end
     else
     begin
          GameOver;
          DGCScreen1.Flip;
          ShowingHiscore:=false;
          ShowHiscore:=true;
     end;
end;

end.
