unit Test;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls ;

type
  TForm1 = class(TForm)
    TestButton: TButton;
    GroupBox1: TGroupBox;
    Width: TEdit;
    Label1: TLabel;
    Height: TEdit;
    Label2: TLabel;
    Depth: TEdit;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Count: TEdit;
    Size: TEdit;
    procedure TestButtonClick(Sender: TObject);
    procedure Test ( Sender: TObject; var Done: Boolean);
  private
    { Private declarations }
    procedure Finish ;
    procedure PlayBeat ;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses DirectDraw, DirectSound, DDraw ;

var
  Screen: TDDScreen ;
  ScreenWidth, ScreenHeight, ScreenDepth: Integer ;
  ObjectCount, ObjectSize: Integer ;
  DeepSound, BoingSound, LoopSound: TDSSound ;
  Blocks: Array [ 0..4999 ] of record X, Y, Xv, Yv, Color, Size: Integer end ;
  Frames: Integer ;
  Beat, Bar: Integer ;

{$R *.DFM}

procedure TForm1.TestButtonClick(Sender: TObject);
var
  Index: Integer ;
  Done: Boolean ;
  LastNoise, StartTime: TDateTime ;
begin
  ScreenWidth := StrToInt ( Width.Text ) ;
  ScreenHeight := StrToInt ( Height.Text ) ;
  ScreenDepth := StrToInt ( Depth.Text ) ;
  ObjectCount := StrToInt ( Count.Text ) ;
  ObjectSize := StrToInt ( Size.Text ) ;
  if ObjectCount > 5000 then
    raise Exception.Create ( 'No more than 5000 objects!' ) ;
  if ObjectSize > 200 then
    raise Exception.Create ( 'No larger than 200 pixels!' ) ;

  BoingSound := TDSPolySound.Create ( 5 ) ;
  DeepSound := TDSPolySound.Create ( 50 ) ;
  LoopSound := TDSLoopedSound.Create ( 70.18732998373 ) ;

  Screen := TDDScreen.Create ( ScreenWidth, ScreenHeight, ScreenDepth ) ;
  LoopSound.Play ;

  for Index := 0 to ObjectCount-1 do
  with Blocks [ Index ] do
  begin
    X := Random ( ScreenWidth - 100 ) + 50 ;
    Y := Random ( ScreenHeight - 100 ) + 50 ;
    Xv := Random ( 5 ) - 2 ;
    Yv := Random ( 5 ) - 2 ;
    Color := Random ( 255 ) ;
    Size := Random ( ObjectSize ) ;
  end ;

  Frames := 0 ;
  Beat := 0 ;
  Bar := 0 ;
  StartTime := Now ;
  LastNoise := StartTime ;
  while True do
  begin
    Test ( self, Done ) ;
    if Now >= StartTime + ( 1 / 24 / 60 / 6 ) then
      Break ;
    if Now >= LastNoise + ( 1 / 24 / 60 / 600 ) then
    begin
      LastNoise := Now ;
      PlayBeat ;
    end ;
  end ;
  Finish ;
end;

procedure TForm1.Test(Sender: TObject; var Done: Boolean);
var
  TestRect: TRect ;
  TestBltEx: DDBLTFX ;
  BlockRect: TRect ;
  Index: Integer ;
begin
  Done := False ;
  Frames := Frames + 1 ;

  TestRect.Left := 0 ;
  TestRect.Top := 0 ;
  TestRect.Right := ScreenWidth ;
  TestRect.Bottom := ScreenHeight ;

  ZeroMemory ( @TestBltEx, sizeof ( TestBltEx ) ) ;
  TestBltEx.dwSize := sizeof ( TestBltEx ) ;
  TestBltEx.dwFillColor := 0 ;
  Screen.BackSurface.Blt ( TestRect, nil, TestRect, DDBLT_COLORFILL + DDBLT_WAIT, TestBltEx ) ;

  for Index := 0 to ObjectCount do
  with Blocks [ Index ] do
  begin
    BlockRect.Left := X ;
    BlockRect.Top := Y ;
    BlockRect.Right := X + Size ;
    BlockRect.Bottom := Y + Size ;

    if ( X + Xv + Size > ScreenWidth ) or ( X + Xv < 0 ) then
    begin
      Xv := - Xv ;
    end ;
    X := X + Xv ;
    if ( Y + Yv + Size > ScreenHeight ) or ( Y + Yv < 0 ) then
    begin
      Yv := - Yv ;
    end ;
    Y := Y + Yv ;

    TestBltEx.dwFillColor := Color ;
    Screen.BackSurface.Blt ( BlockRect, nil, TestRect,
        DDBLT_COLORFILL + DDBLT_WAIT, TestBltEx ) ;
  end ;

  Screen.Flip ;
end ;

procedure TForm1.Finish ;
begin
  DeepSound.Free ;
  DeepSound := nil ;
  BoingSound.Free ;
  BoingSound := nil ;
  LoopSound.Free ;
  LoopSound := nil ;
  Screen.Free ;
  Screen := nil ;
  ShowMessage ( Format ( 'Frames per second: %n', [ Frames / 10 ] ) ) ;
end;

procedure TForm1.PlayBeat ;
begin
  if Beat = 0 then
  begin
    DeepSound.Stop ;
    DeepSound.Play ;
  end ;

  if Bar mod 2 = 0 then
  begin
    if Beat = 0 then
    begin
      BoingSound.Stop ;
      BoingSound.Play ;
    end ;
  end else
    if Beat = 4 then
    begin
      BoingSound.Stop ;
      BoingSound.Play ;
    end ;

  Beat := Beat + 1 ;
  if Beat = 8 then
  begin
    Beat := 0 ;
    Bar := Bar + 1 ;
  end ;
end;

end.

