unit d3d ;

interface

uses OLE2, Windows, d3dtypes, d3dcaps, DDraw ;

(*==========================================================================;
 *
 *  Copyright (C) 1995,1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       d3d.h
 *  Content:    Direct3D include file
 *
 *  DirectX 3 Delphi adaptation by Blake Stone
 *
 *    EMail:     bstone@dkw.com
 *    Home Page: http://www.dkw.com/bstone
 *
 ***************************************************************************)

{$Z4}
{$A+}

(*
 * Interface IID's
 *)

const
  IID_IDirect3D: TGUID = (D1:$3BBA0080;D2:$2421;D3:$11CF;D4:($A3,$1A,$00,$AA,$00,$B9,$33,$56));
  IID_IDirect3DTexture: TGUID = (D1:$2CDCD9E0;D2:$25A0;D3:$11CF;D4:($A3,$1A,$00,$AA,$00,$B9,$33,$56));
  IID_IDirect3DLight: TGUID = (D1:$4417C142;D2:$33AD;D3:$11CF;D4:($81,$6F,$00,$00,$C0,$20,$15,$6E));
  IID_IDirect3DMaterial: TGUID = (D1:$4417C144;D2:$33AD;D3:$11CF;D4:($81,$6F,$00,$00,$C0,$20,$15,$6E));
  IID_IDirect3DExecuteBuffer: TGUID = (D1:$4417C145;D2:$33AD;D3:$11CF;D4:($81,$6F,$00,$00,$C0,$20,$15,$6E));
  IID_IDirect3DViewport: TGUID = (D1:$4417C146;D2:$33AD;D3:$11CF;D4:($81,$6F,$00,$00,$C0,$20,$15,$6E));

(*
 * Flags for execute buffer calls
 *)

  D3DNEXT_NEXT    = $00000001 ;
  D3DNEXT_HEAD    = $00000002 ;
  D3DNEXT_TAIL    = $00000004 ;

(*
 * Data structures
 *)

type
  IDirect3D = class ;
  IDirect3DDevice = class ;
  IDirect3DExecuteBuffer = class ;
  IDirect3DLight = class ;
  IDirect3DMaterial = class ;
  IDirect3DTexture = class ;
  IDirect3DViewport = class ;

(*
 * IDirect3D
 *)

  IDirect3D = class ( IUnknown )
    (*** IDirect3D methods ***)
    function Initialize ( lpREFIID: {REFIID} PGUID ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function EnumDevices ( lpEnumDevicesCallback: LPD3DENUMDEVICESCALLBACK ;
        lpUserArg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
    function CreateLight ( var lplpDirect3Dlight: IDirect3DLight ;
        pUnkOuter: IUnknown ): HRESULT ; virtual ; stdcall ; abstract ;
    function CreateMaterial ( var lplpDirect3DMaterial: IDirect3DMaterial ;
        pUnkOuter: IUnknown ): HRESULT ; virtual ; stdcall ; abstract ;
    function CreateViewport ( var lplpD3DViewport: IDirect3DViewport ;
        pUnkOuter: IUnknown ): HRESULT ; virtual ; stdcall ; abstract ;
    function FindDevice ( const lpD3DFDS: D3DFINDDEVICESEARCH ;
        var lpD3DFDR: D3DFINDDEVICERESULT ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

(*
 * IDirect3DDevice
 *)

  IDirect3DDevice = class ( IUnknown )
    (*** IDirect3DDevice methods ***)
    function Initialize ( lpd3d: IDirect3D ; lpGUID: PGUID ;
        const lpd3ddvdesc: D3DDEVICEDESC ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetCaps ( var lpD3DHWDevDesc: D3DDEVICEDESC ;
        var lpD3DHELDevDesc: D3DDEVICEDESC ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SwapTextureHandles ( lpD3DTex1: IDirect3DTexture ;
        lpD3DTex2: IDirect3DTexture ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function CreateExecuteBuffer ( const lpDesc: D3DEXECUTEBUFFERDESC  ;
        var lplpDirect3DExecuteBuffer: IDirect3DExecuteBuffer ;
        pUnkOuter: IUnknown ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetStats ( var lpD3DStats: D3DSTATS ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Execute ( lpDirect3DExecuteBuffer: IDirect3DExecuteBuffer ;
        lpDirect3DViewport: IDirect3DViewport ; dwFlags: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function AddViewport ( lpDirect3DViewport: IDirect3DViewport ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function DeleteViewport ( lpDirect3DViewport: IDirect3DViewport ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function NextViewport ( lpDirect3DViewport: IDirect3DViewport ;
        var lplpDirect3DViewport: IDirect3DViewport ; dwFlags: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function Pick ( lpDirect3DExecuteBuffer: IDirect3DExecuteBuffer ;
        lpDirect3DViewport: IDirect3DViewport ; dwFlags: DWORD ;
        const lpRect: D3DRECT ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetPickRecords ( var lpCount: DWORD ;
        var lpD3DPickRec: D3DPICKRECORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function EnumTextureFormats (
        lpd3dEnumTextureProc: LPD3DENUMTEXTUREFORMATSCALLBACK ; lpArg: Pointer):
        HRESULT ; virtual ; stdcall ; abstract ;
    function CreateMatrix ( var lpD3DMatHandle: D3DMATRIXHANDLE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetMatrix ( d3dMatHandle: D3DMATRIXHANDLE ;
        const lpD3DMatrix: D3DMATRIX ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetMatrix ( const lpD3DMatHandle: D3DMATRIXHANDLE ;
        var lpD3DMatrix: D3DMATRIX ): HRESULT ; virtual ; stdcall ; abstract ;
    function DeleteMatrix ( d3dMatHandle: D3DMATRIXHANDLE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function BeginScene: HRESULT ; virtual ; stdcall ; abstract ;
    function EndScene: HRESULT ; virtual ; stdcall ; abstract ;
    function GetDirect3D ( var lpD3D: IDirect3D ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

(*
 * IDirect3DExecuteBuffer
 *)

  IDirect3DExecuteBuffer = class ( IUnknown )
    (*** IDirect3DExecuteBuffer methods ***)
    function Initialize ( lpDirect3DDevice: IDirect3DDevice ;
        const lpDesc: D3DEXECUTEBUFFERDESC ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Lock ( const lpDesc: D3DEXECUTEBUFFERDESC ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Unlock: HRESULT ; virtual ; stdcall ; abstract ;
    function SetExecuteData ( const lpData: D3DEXECUTEDATA ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetExecuteData ( var lpData: D3DEXECUTEDATA ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Validate ( var lpdwOffset: DWORD ; lpFunc: LPD3DVALIDATECALLBACK ;
        lpUserArg: Pointer ; dwReserved: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    (*** Warning!  Optimize is defined differently in the header files
         and the online documentation ***)
    function Optimize ( dwFlags: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

(*
 * IDirect3DLight
 *)

  IDirect3DLight = class ( IUnknown )
    (*** IDirect3DLight methods ***)
    function Initialize ( lpDirect3D: IDirect3D ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetLight ( const lpLight: D3DLIGHT ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetLight ( var lpLight: D3DLIGHT ): HRESULT ; virtual ;
        stdcall ; abstract ;
  end ;

(*
 * IDirect3DMaterial
 *)

  IDirect3DMaterial = class ( IUnknown )
    (*** IDirect3DMaterial methods ***)
    function Initialize ( lpDirect3D: IDirect3D): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetMaterial ( const lpMat: D3DMATERIAL ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetMaterial ( var lpMat: D3DMATERIAL ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetHandle ( lpDirect3DDevice: IDirect3DDevice ;
        var lpHandle: D3DMATERIALHANDLE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Reserve: HRESULT ; virtual ; stdcall ; abstract ;
    function Unreserve: HRESULT ; virtual ; stdcall ; abstract ;
  end ;

(*
 * IDirect3DTexture
 *)

  IDirect3DTexture = class ( IUnknown )
    (*** IDirect3DTexture methods ***)
    function Initialize ( lpD3DDevice: IDirect3DDevice ;
        lpDDSurface: IDirectDrawSurface ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetHandle ( lpDirect3DDevice: IDirect3DDevice ;
        var lpHandle: D3DTEXTUREHANDLE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function PaletteChanged ( dwStart: DWORD ; dwCount: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Load ( lpD3DTexture: IDirect3DTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Unload: HRESULT ; virtual ; stdcall ; abstract ;
  end ;

(*
 * IDirect3DViewport
 *)

  IDirect3DViewport = class ( IUnknown )
    (*** IDirect3DViewport methods ***)
    function Initialize ( lpDirect3D: IDirect3D ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetViewport ( var lpData: D3DVIEWPORT ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetViewport ( const lpData: D3DVIEWPORT ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function TransformVertices ( dwVertexCount: DWORD ;
        var lpData: D3DTRANSFORMDATA ; dwFlags: DWORD ;
        var lpOffscreen: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function LightElements ( dwElementCount: DWORD ;
        var lpData: D3DLIGHTDATA ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetBackground ( hMat: D3DMATERIALHANDLE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetBackground ( hMat: D3DMATERIALHANDLE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetBackgroundDepth ( lpDDSurface: IDirectDrawSurface ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function GetBackgroundDepth ( var lplpDDSurface: IDirectDrawSurface ;
        var lpValid: BOOL ): HRESULT ; virtual ; stdcall ; abstract ;
    function Clear ( dwCount: DWORD ; const lpRects: D3DRECT ; dwFlags: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function AddLight ( lpDirect3DLight: IDirect3DLight ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function DeleteLight ( lpDirect3DLight: IDirect3DLight ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function NextLight ( lpDirect3DLight: IDirect3DLight ;
        var lplpDirect3DLight: IDirect3DLight ; dwFlags: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
  end ;

(*
 * Direct3D Errors
 * DirectDraw error codes are used when errors not specified here.
 *)

const
  D3D_OK                          = DD_OK ;
  D3DERR_BADMAJORVERSION          = $88760000 + 700 ;
  D3DERR_BADMINORVERSION          = $88760000 + 701 ;

  D3DERR_EXECUTE_CREATE_FAILED    = $88760000 + 710 ;
  D3DERR_EXECUTE_DESTROY_FAILED   = $88760000 + 711 ;
  D3DERR_EXECUTE_LOCK_FAILED      = $88760000 + 712 ;
  D3DERR_EXECUTE_UNLOCK_FAILED    = $88760000 + 713 ;
  D3DERR_EXECUTE_LOCKED           = $88760000 + 714 ;
  D3DERR_EXECUTE_NOT_LOCKED       = $88760000 + 715 ;

  D3DERR_EXECUTE_FAILED           = $88760000 + 716 ;
  D3DERR_EXECUTE_CLIPPED_FAILED   = $88760000 + 717 ;

  D3DERR_TEXTURE_NO_SUPPORT       = $88760000 + 720 ;
  D3DERR_TEXTURE_CREATE_FAILED    = $88760000 + 721 ;
  D3DERR_TEXTURE_DESTROY_FAILED   = $88760000 + 722 ;
  D3DERR_TEXTURE_LOCK_FAILED      = $88760000 + 723 ;
  D3DERR_TEXTURE_UNLOCK_FAILED    = $88760000 + 724 ;
  D3DERR_TEXTURE_LOAD_FAILED      = $88760000 + 725 ;
  D3DERR_TEXTURE_SWAP_FAILED      = $88760000 + 726 ;
  D3DERR_TEXTURE_LOCKED           = $88760000 + 727 ;
  D3DERR_TEXTURE_NOT_LOCKED       = $88760000 + 728 ;
  D3DERR_TEXTURE_GETSURF_FAILED   = $88760000 + 729 ;

  D3DERR_MATRIX_CREATE_FAILED     = $88760000 + 730 ;
  D3DERR_MATRIX_DESTROY_FAILED    = $88760000 + 731 ;
  D3DERR_MATRIX_SETDATA_FAILED    = $88760000 + 732 ;
  D3DERR_MATRIX_GETDATA_FAILED    = $88760000 + 733 ;
  D3DERR_SETVIEWPORTDATA_FAILED   = $88760000 + 734 ;

  D3DERR_MATERIAL_CREATE_FAILED   = $88760000 + 740 ;
  D3DERR_MATERIAL_DESTROY_FAILED  = $88760000 + 741 ;
  D3DERR_MATERIAL_SETDATA_FAILED  = $88760000 + 742 ;
  D3DERR_MATERIAL_GETDATA_FAILED  = $88760000 + 743 ;

  D3DERR_LIGHT_SET_FAILED         = $88760000 + 750 ;

  D3DERR_SCENE_IN_SCENE           = $88760000 + 760 ;
  D3DERR_SCENE_NOT_IN_SCENE       = $88760000 + 761 ;
  D3DERR_SCENE_BEGIN_FAILED       = $88760000 + 762 ;
  D3DERR_SCENE_END_FAILED         = $88760000 + 763 ;

procedure DisableFPUExceptions ;
procedure EnableFPUExceptions ;

implementation

procedure DisableFPUExceptions ;
var
  FPUControlWord: WORD ;
asm
  FSTCW   FPUControlWord ;
  OR      FPUControlWord, $4 + $1 ; { Divide by zero + invalid operation }
  FLDCW   FPUControlWord ;
end ;

procedure EnableFPUExceptions ;
var
  FPUControlWord: WORD ;
asm
  FSTCW   FPUControlWord ;
  AND     FPUControlWord, $FFFF - $4 - $1 ; { Divide by zero + invalid operation }
  FLDCW   FPUControlWord ;
end ;

initialization
  DisableFPUExceptions ;
end.
