unit d3drm ;

interface

uses OLE2, Windows, D3DRMObj, D3DTypes, D3DRMDef, DDraw, D3D ;

(*==========================================================================;
 *
 *  Copyright (C) 1995-1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       d3drm.h
 *  Content:    Direct3DRM include file
 *
 *  DirectX 3 Delphi adaptation by Blake Stone
 *
 *    EMail:     bstone@dkw.com
 *    Home Page: http://www.dkw.com/bstone
 *
 ***************************************************************************)

{$Z4}
{$A+}

type
  D3DRMDEVICEPALETTECALLBACK = procedure ( lpDirect3DRMDev: IDirect3DRMDevice ;
      lpArg: Pointer ; dwIndex: DWORD ; red, green, blue: LongInt ) ; stdcall ;

const
  IID_IDirect3DRM: TGUID = ( D1:$2bc49361;D2:$8327;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
// WIN_TYPES(IDirect3DRM, DIRECT3DRM);

type
  IDirect3DRM = class ( IUnknown )
  public
    function CreateObject ( rclsid: TGUID ; pUnkOuter: IUnknown ;
        riid: TGUID ; var ppv: Pointer ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function CreateFrame ( lpD3DRMFrame: IDirect3DRMFrame ;
        var lplpD3DRMFrame: IDirect3DRMFrame ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function CreateMesh ( var lplpD3DRMMesh: IDirect3DRMMesh ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function CreateMeshBuilder ( var lplpD3DRMMeshBuilder:
        IDirect3DRMMeshBuilder ): HRESULT ; virtual ; stdcall ; abstract ;
    function CreateFace ( var lplpd3drmFace: IDirect3DRMFace ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function CreateAnimation ( var lplpD3DRMAnimation: IDirect3DRMAnimation ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function CreateAnimationSet ( var lplpD3DRMAnimationSet:
        IDirect3DRMAnimationSet ): HRESULT ; virtual ; stdcall ; abstract ;
    function CreateTexture ( const lpImage: D3DRMIMAGE ;
        var lplpD3DRMTexture: IDirect3DRMTexture ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function CreateLight ( d3drmltLightType: D3DRMLIGHTTYPE ;
        cColor: D3DCOLOR ; var lplpD3DRMLight: IDirect3DRMLight ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function CreateLightRGB ( ltLightType: D3DRMLIGHTTYPE ; vRed,
        vGreen, vBlue: D3DVALUE ; var lplpD3DRMLight: IDirect3DRMLight ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function CreateMaterial ( vPower: D3DVALUE ; var lplpD3DRMMaterial:
        IDirect3DRMMaterial ): HRESULT ; virtual ; stdcall ; abstract ;
    function CreateDevice ( dwWidth, dwHeight: DWORD ; var lplpD3DRMDevice:
        IDirect3DRMDevice ): HRESULT ; virtual ; stdcall ; abstract ;

    (* Create a Windows Device using DirectDraw surfaces *)
    function CreateDeviceFromSurface ( lpGUID: PGUID ; lpDD: IDirectDraw ;
        lpDDSBack: IDirectDrawSurface ; var lplpD3DRMDevice: IDirect3DRMDevice ):
        HRESULT ; virtual ; stdcall ; abstract ;

      (* Create a Windows Device using D3D objects *)
    function CreateDeviceFromD3D ( lpD3D: IDirect3D ; lpD3DDev: IDirect3DDevice ;
        var lplpD3DRMDevice: IDirect3DRMDevice ): HRESULT ; virtual ; stdcall ;
        abstract ;

    function CreateDeviceFromClipper ( lpDDClipper: IDirectDrawClipper ;
        lpGUID: PGUID ; width, height: Integer ; var lplpD3DRMDevice:
        IDirect3DRMDevice ): HRESULT ; virtual ; stdcall ; abstract ;

    function CreateTextureFromSurface (  lpDDS: IDirectDrawSurface ;
        lplpD3DRMTexture: IDirect3DRMTexture ): HRESULT ; virtual ; stdcall ;
        abstract ;

    function CreateShadow ( lpVisual: IDirect3DRMVisual ;
        lpLight: IDirect3DRMLight ; px, py, pz, nx, ny, nz: D3DVALUE ;
        var lplpShadow: IDirect3DRMVisual ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function CreateViewport ( lpDev: IDirect3DRMDevice ;
        lpCamera: IDirect3DRMFrame ; dwXPos, dwYPos, dwWidth, dwHeight: DWORD ;
        var lplpD3DRMViewport: IDirect3DRMViewport ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function CreateWrap ( wraptype: D3DRMWRAPTYPE ; lpRef: IDirect3DRMFrame ;
        ox, oy, oz, dx, dy, dz, ux, uy, uz, ou, ov, su, sv: D3DVALUE ;
        var lplpD3DRMWrap: IDirect3DRMWrap ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function CreateUserVisual ( fn: D3DRMUSERVISUALCALLBACK ; lpArg: Pointer ;
        var lplpD3DRMUV: IDirect3DRMUserVisual ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function LoadTexture ( lpFileName: LPSTR ; var lplpD3DRMTexture:
        IDirect3DRMTexture ): HRESULT ; virtual ; stdcall ; abstract ;
    function LoadTextureFromResource ( rs: HRSRC ; var lplpD3DRMTexture:
        IDirect3DRMTexture ): HRESULT ; virtual ; stdcall ; abstract ;

    function SetSearchPath ( lpPath: LPSTR ): HRESULT ; virtual ; stdcall ; abstract ;
    function AddSearchPath ( lpPath: LPSTR ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetSearchPath ( var lpdwSize: DWORD ; lpszPath: LPSTR ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetDefaultTextureColors ( dwColors: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetDefaultTextureShades ( dwShades: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;

    function GetDevices ( var lplpDevArray: IDirect3DRMDeviceArray ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetNamedObject ( lpName: LPSTR ; var lplpD3DRMObject:
        IDirect3DRMObject ): HRESULT ; virtual ; stdcall ; abstract ;

    function EnumerateObjects ( func: D3DRMOBJECTCALLBACK ; lpArg: Pointer ):
        HRESULT ; virtual ; stdcall ; abstract ;

    function Load ( lpvObjSource, lpvObjID: Pointer ; var lplpGUIDs: PGUID ;
        dwcGUIDs: DWORD ; d3drmLOFlags: D3DRMLOADOPTIONS ; d3drmLoadProc:
        D3DRMLOADCALLBACK ; lpArgLP: Pointer ; d3drmLoadTextureProc:
        D3DRMLOADTEXTURECALLBACK ; lpArgLTP: Pointer ; lpParentFrame:
        IDirect3DRMFrame ): HRESULT ; virtual ; stdcall ; abstract ;
    function Tick ( d3dvalTick: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

const
  D3DRM_OK                        = DD_OK ;
  D3DRMERR_BADOBJECT              = $88760000 + 781 ;
  D3DRMERR_BADTYPE                = $88760000 + 782 ;
  D3DRMERR_BADALLOC               = $88760000 + 783 ;
  D3DRMERR_FACEUSED               = $88760000 + 784 ;
  D3DRMERR_NOTFOUND               = $88760000 + 785 ;
  D3DRMERR_NOTDONEYET             = $88760000 + 786 ;
  D3DRMERR_FILENOTFOUND           = $88760000 + 787 ;
  D3DRMERR_BADFILE                = $88760000 + 788 ;
  D3DRMERR_BADDEVICE              = $88760000 + 789 ;
  D3DRMERR_BADVALUE               = $88760000 + 790 ;
  D3DRMERR_BADMAJORVERSION        = $88760000 + 791 ;
  D3DRMERR_BADMINORVERSION        = $88760000 + 792 ;
  D3DRMERR_UNABLETOEXECUTE        = $88760000 + 793 ;

(* Create a Direct3DRM API *)
function Direct3DRMCreate ( var lplpDirect3DRM: IDirect3DRM ): HRESULT ; stdcall ;

implementation

function Direct3DRMCreate ; external 'D3DRM.DLL' ;

end.

