unit d3drmdef ;

interface

uses OLE2, Windows, D3DTypes ;

(*==========================================================================;
 *
 *  Copyright (C) 1995-1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       d3drm.h
 *  Content:    Direct3DRM include file
 *
 *  DirectX 3 Delphi adaptation by Blake Stone
 *
 *    EMail:     bstone@dkw.com
 *    Home Page: http://www.dkw.com/bstone
 *
 ***************************************************************************)

{$Z4}
{$A+}

type
  D3DRMVECTOR4D = record
    x, y, z, w: D3DVALUE ;
  end ;
//  LPD3DRMVECTOR4D = ^D3DRMVECTOR4D ;

  D3DRMMATRIX4D = Array [0..4, 0..4] of D3DVALUE ;

  D3DRMQUATERNION = record
    s: D3DVALUE ;
    v: D3DVECTOR ;
  end ;
  LPD3DRMQUATERNION = ^D3DRMQUATERNION ;

  D3DRMBOX = record
    min, max: D3DVECTOR ;
  end ;
//  LPD3DRMBOX = ^D3DRMBOX ;

  D3DRMWRAPCALLBACK = procedure ( var lpD3DVector: D3DVECTOR ;
      var lpU, lpV: Integer ; var lpD3DRMVA, lpD3DRMVB: D3DVECTOR ; lpArg:
      Pointer ) ; stdcall ;

  D3DRMLIGHTTYPE = ( D3DRMLIGHT_AMBIENT, D3DRMLIGHT_POINT, D3DRMLIGHT_SPOT,
      D3DRMLIGHT_DIRECTIONAL, D3DRMLIGHT_PARALLELPOINT ) ;
//  LPD3DRMLIGHTTYPE = ^D3DRMLIGHTTYPE ;

// << Test these 'enumerated' types >>
  D3DRMSHADEMODE = WORD ;

const
  D3DRMSHADE_FLAT = 0 ;
  D3DRMSHADE_GOURAUD = 1 ;
  D3DRMSHADE_PHONG = 2 ;
  D3DRMSHADE_MASK = 7 ;
  D3DRMSHADE_MAX = 8 ;
//  LPD3DRMSHADEMODE = ^D3DRMSHADEMODE ;

type
  D3DRMLIGHTMODE = WORD ;
//  LPD3DRMLIGHTMOD = ^D3DRMLIGHTMODE ;

const
  D3DRMLIGHT_OFF  = 0 * D3DRMSHADE_MAX ;
  D3DRMLIGHT_ON   = 1 * D3DRMSHADE_MAX ;
  D3DRMLIGHT_MASK = 7 * D3DRMSHADE_MAX ;
  D3DRMLIGHT_MAX  = 8 * D3DRMSHADE_MAX ;

type
  D3DRMFILLMODE = WORD ;
//  LPD3DRMFILLMODE = ^D3DRMFILLMODE ;

const
  D3DRMFILL_POINTS    = 0 * D3DRMLIGHT_MAX ;
  D3DRMFILL_WIREFRAME = 1 * D3DRMLIGHT_MAX ;
  D3DRMFILL_SOLID     = 2 * D3DRMLIGHT_MAX ;
  D3DRMFILL_MASK      = 7 * D3DRMLIGHT_MAX ;
  D3DRMFILL_MAX       = 8 * D3DRMLIGHT_MAX ;

type
  D3DRMRENDERQUALITY = DWORD ;
//  LPD3DRMRENDERQUALITY = ^D3DRMRENDERQUALITY ;

const
  D3DRMRENDER_WIREFRAME   = ( D3DRMSHADE_FLAT + D3DRMLIGHT_OFF + D3DRMFILL_WIREFRAME ) ;
  D3DRMRENDER_UNLITFLAT   = ( D3DRMSHADE_FLAT + D3DRMLIGHT_OFF + D3DRMFILL_SOLID ) ;
  D3DRMRENDER_FLAT        = ( D3DRMSHADE_FLAT + D3DRMLIGHT_ON + D3DRMFILL_SOLID ) ;
  D3DRMRENDER_GOURAUD     = ( D3DRMSHADE_GOURAUD + D3DRMLIGHT_ON + D3DRMFILL_SOLID ) ;
  D3DRMRENDER_PHONG       = ( D3DRMSHADE_PHONG + D3DRMLIGHT_ON + D3DRMFILL_SOLID ) ;

type
  D3DRMTEXTUREQUALITY = (
    D3DRMTEXTURE_NEAREST,               (* choose nearest texel *)
    D3DRMTEXTURE_LINEAR,                (* interpolate 4 texels *)
    D3DRMTEXTURE_MIPNEAREST,            (* nearest texel in nearest mipmap  *)
    D3DRMTEXTURE_MIPLINEAR,             (* interpolate 2 texels from 2 mipmaps *)
    D3DRMTEXTURE_LINEARMIPNEAREST,      (* interpolate 4 texels in nearest mipmap *)
    D3DRMTEXTURE_LINEARMIPLINEAR        (* interpolate 8 texels from 2 mipmaps *)
  ) ;
//  LPD3DRMTEXTUREQUALITY = ^D3DRMTEXTUREQUALITY ;

  D3DRMCOMBINETYPE = ( D3DRMCOMBINE_REPLACE, D3DRMCOMBINE_BEFORE, D3DRMCOMBINE_AFTER ) ;
//  LPD3DRMCOMBINETYPE = ^D3DRMCOMBINETYPE ;

  D3DRMCOLORMODEL = D3DCOLORMODEL ;
  LPD3DRMCOLORMODEL = ^D3DRMCOLORMODEL ;

  D3DRMPALETTEFLAGS = (
    D3DRMPALETTE_FREE,                  (* renderer may use this entry freely *)
    D3DRMPALETTE_READONLY,              (* fixed but may be used by renderer *)
    D3DRMPALETTE_RESERVED               (* may not be used by renderer *)
  ) ;
//  LPD3DRMPALETTEFLAGS = ^D3DRMPALETTEFLAGS ;

  D3DRMPALETTEENTRY = record
    red: Byte ;          (* 0 .. 255 *)
    green: Byte ;        (* 0 .. 255 *)
    blue: Byte ;         (* 0 .. 255 *)
    flags: Byte ;        (* one of D3DRMPALETTEFLAGS *)
  end ;
//  LPD3DRMPALETTEENTRY = ^D3DRMPALETTEENTRY ;

  D3DRMIMAGE = record
    width, height: Integer ;    (* width and height in pixels *)
    aspectx, aspecty: Integer ; (* aspect ratio for non-square pixels *)
    depth: Integer ;            (* bits per pixel *)
    rgb: Integer ;              (* if false, pixels are indices into a
                                   palette otherwise, pixels encode
                                   RGB values. *)
    bytes_per_line: Integer ;   (* number of bytes of memory for a
                                   scanline. This must be a multiple
                                   of 4. *)
    buffer1: Pointer ;          (* memory to render into (first buffer). *)
    buffer2: Pointer ;          (* second rendering buffer for double
                                   buffering, set to NULL for single
                                   buffering. *)
    red_mask: Longint ;
    green_mask: Longint ;
    blue_mask: Longint ;
    alpha_mask: Longint ;       (* if rgb is true, these are masks for
                                   the red, green and blue parts of a
                                   pixel.  Otherwise, these are masks
                                   for the significant bits of the
                                   red, green and blue elements in the
                                   palette.  For instance, most SVGA
                                   displays use 64 intensities of red,
                                   green and blue, so the masks should
                                   all be set to 0xfc. *)
    palette_size: Integer ;     (* number of entries in palette *)
    palette: ^D3DRMPALETTEENTRY ; (* description of the palette (only if
                                   rgb is false).  Must be (1<<depth)
                                   elements. *)
  end ;
  LPD3DRMIMAGE = ^D3DRMIMAGE ;

  D3DRMWRAPTYPE = ( D3DRMWRAP_FLAT, D3DRMWRAP_CYLINDER, D3DRMWRAP_SPHERE, D3DRMWRAP_CHROME ) ;
//  LPD3DRMWRAPTYPE = ^D3DRMWRAPTYPE ;

const
  D3DRMWIREFRAME_CULL             = 1 ; (* cull backfaces *)
  D3DRMWIREFRAME_HIDDENLINE       = 2 ; (* lines are obscured by closer objects *)

type
  D3DRMPROJECTIONTYPE = ( D3DRMPROJECT_PERSPECTIVE, D3DRMPROJECT_ORTHOGRAPHIC ) ;
//  LPD3DRMPROJECTIONTYPE = ^D3DRMPROJECTIONTYPE ;

  D3DRMXOFFORMAT = ( D3DRMXOF_BINARY, D3DRMXOF_COMPRESSED, D3DRMXOF_TEXT ) ;
//  LPD3DRMXOFFORMAT = ^D3DRMXOFFORMAT ;

  D3DRMSAVEOPTIONS = DWORD ;

const
  D3DRMXOFSAVE_NORMALS = 1 ;
  D3DRMXOFSAVE_TEXTURECOORDINATES = 2 ;
  D3DRMXOFSAVE_MATERIALS = 4 ;
  D3DRMXOFSAVE_TEXTURENAMES = 8 ;
  D3DRMXOFSAVE_ALL = 15 ;
  D3DRMXOFSAVE_TEMPLATES = 16 ;

type
  D3DRMCOLORSOURCE = ( D3DRMCOLOR_FROMFACE, D3DRMCOLOR_FROMVERTEX ) ;
//  LPD3DRMCOLORSOURCE = ^D3DRMCOLORSOURCE ;

  D3DRMFRAMECONSTRAINT = (
    D3DRMCONSTRAIN_Z,           (* use only X and Y rotations *)
    D3DRMCONSTRAIN_Y,           (* use only X and Z rotations *)
    D3DRMCONSTRAIN_X            (* use only Y and Z rotations *)
  ) ;
//  LPD3DRMFRAMECONSTRAINT = ^D3DRMFRAMECONSTRAINT ;

  D3DRMMATERIALMODE = ( D3DRMMATERIAL_FROMMESH, D3DRMMATERIAL_FROMPARENT,
      D3DRMMATERIAL_FROMFRAME ) ;
//  LPD3DRMMATERIALMODE = ^D3DRMMATERIALMODE ;

  D3DRMFOGMODE = (
    D3DRMFOG_LINEAR,            (* linear between start and end *)
    D3DRMFOG_EXPONENTIAL,       (* density * exp(-distance) *)
    D3DRMFOG_EXPONENTIALSQUARED (* density * exp(-distance*distance) *)
  ) ;
//  LPD3DRMFOGMODE = ^D3DRMFOGMODE ;

  D3DRMZBUFFERMODE = (
    D3DRMZBUFFER_FROMPARENT,    (* default *)
    D3DRMZBUFFER_ENABLE,        (* enable zbuffering *)
    D3DRMZBUFFER_DISABLE        (* disable zbuffering *)
  ) ;
//  LPD3DRMZBUFFERMODE = ^D3DRMZBUFFERMODE ;

  D3DRMSORTMODE = (
    D3DRMSORT_FROMPARENT,       (* default *)
    D3DRMSORT_NONE,             (* don't sort child frames *)
    D3DRMSORT_FRONTTOBACK,      (* sort child frames front-to-back *)
    D3DRMSORT_BACKTOFRONT       (* sort child frames back-to-front *)
  ) ;
//  LPD3DRMSORTMODE = ^D3DRMSORTMODE ;

  D3DRMANIMATIONOPTIONS = DWORD ;

const
  D3DRMANIMATION_OPEN = $01 ;
  D3DRMANIMATION_CLOSED = $02 ;
  D3DRMANIMATION_LINEARPOSITION = $04 ;
  D3DRMANIMATION_SPLINEPOSITION = $08 ;
  D3DRMANIMATION_SCALEANDROTATION = $00000010 ;
  D3DRMANIMATION_POSITION = $00000020 ;

type
  D3DRMLOADOPTIONS = DWORD ;

const
  D3DRMLOAD_FROMFILE  = $00 ;
  D3DRMLOAD_FROMRESOURCE = $01 ;
  D3DRMLOAD_FROMMEMORY = $02 ;
  D3DRMLOAD_FROMSTREAM = $04 ;

  D3DRMLOAD_BYNAME = $10 ;
  D3DRMLOAD_BYPOSITION = $20 ;
  D3DRMLOAD_BYGUID = $40 ;
  D3DRMLOAD_FIRST = $80 ;

  D3DRMLOAD_INSTANCEBYREFERENCE = $100 ;
  D3DRMLOAD_INSTANCEBYCOPYING = $200 ;

type
  D3DRMLOADRESOURCE = record
    hModule: HMODULE ;
    lpName: PChar ;
    lpType: PChar ;
  end ;
//  LPD3DRMLOADRESOURCE = ^D3DRMLOADRESOURCE ;

  D3DRMLOADMEMORY = record
    lpMemory: Pointer ;
    dSize: DWORD ;
  end ;
//  LPD3DRMLOADMEMORY = ^D3DRMLOADMEMORY ;

  D3DRMUSERVISUALREASON = ( D3DRMUSERVISUAL_CANSEE, D3DRMUSERVISUAL_RENDER ) ;
//  LPD3DRMUSERVISUALREASON = ^D3DRMUSERVISUALREASON ;

  D3DRMMAPPING = DWORD ;
  D3DRMMAPPINGFLAG = DWORD ;
  LPD3DRMMAPPING = ^DWORD ;

const
  D3DRMMAP_WRAPU = 1 ;
  D3DRMMAP_WRAPV = 2 ;
  D3DRMMAP_PERSPCORRECT = 4 ;

type
  D3DRMVERTEX = record
    position: D3DVECTOR ;
    normal: D3DVECTOR ;
    tu, tv: D3DVALUE ;
    color: D3DCOLOR ;
  end ;
//  LPD3DRMVERTEX = ^D3DRMVERTEX ;

  D3DRMGROUPINDEX = Longint ; (* group indexes begin a 0 *)

const
  D3DRMGROUP_ALLGROUPS = -1 ;

(*
 * Create a color from three components in the range 0-1 inclusive.
 *)
function D3DRMCreateColorRGB ( red, green, blue: D3DVALUE ): D3DCOLOR ; stdcall ;

(*
 * Create a color from four components in the range 0-1 inclusive.
 *)
function D3DRMCreateColorRGBA ( red, green, blue, alpha: D3DVALUE ): D3DCOLOR ; stdcall ;

(*
 * Get the red component of a color.
 *)
function D3DRMColorGetRed ( d3drmc: D3DCOLOR ): D3DVALUE ;

(*
 * Get the green component of a color.
 *)
function D3DRMColorGetGreen ( d3drmc: D3DCOLOR ): D3DVALUE ;

(*
 * Get the blue component of a color.
 *)
function D3DRMColorGetBlue ( d3drmc: D3DCOLOR ): D3DVALUE ;

(*
 * Get the alpha component of a color.
 *)
function D3DRMColorGetAlpha ( d3drmc: D3DCOLOR ): D3DVALUE ;

(*
 * Add two vectors.  Returns its first argument.
 *)
function D3DRMVectorAdd ( var d, s1, s2: D3DVECTOR ): LPD3DVECTOR ; stdcall ;

(*
 * Subtract two vectors.  Returns its first argument.
 *)
function D3DRMVectorSubtract ( var d, s1, s2: D3DVECTOR ): LPD3DVECTOR ; stdcall ;

(*
 * Reflect a ray about a given normal.  Returns its first argument.
 *)
function D3DRMVectorReflect ( var d, ray, norm: D3DVECTOR ): LPD3DVECTOR ; stdcall ;

(*
 * Calculate the vector cross product.  Returns its first argument.
 *)
function D3DRMVectorCrossProduct ( var d, s1, s2: D3DVECTOR ): LPD3DVECTOR ; stdcall ;

(*
 * Return the vector dot product.
 *)
function D3DRMVectorDotProduct ( var s1, s2: D3DVECTOR ): D3DVALUE ; stdcall ;

(*
 * Scale a vector so that its modulus is 1.  Returns its argument or
 * NULL if there was an error (e.g. a zero vector was passed).
 *)
function D3DRMVectorNormalize ( var lpv: D3DVECTOR ): LPD3DVECTOR ; stdcall ;
function D3DRMVectorNormalise ( var lpv: D3DVECTOR ): LPD3DVECTOR ; stdcall ;

(*
 * Return the length of a vector (e.g. sqrt(x*x + y*y + z*z)).
 *)
function D3DRMVectorModulus ( var v: D3DVECTOR ): D3DVALUE ; stdcall ;

(*
 * Set the rotation part of a matrix to be a rotation of theta radians
 * around the given axis.
 *)
function D3DRMVectorRotate ( var r, v, axis: D3DVECTOR ; theta: D3DVALUE ):
    LPD3DVECTOR ; stdcall ;

(*
 * Scale a vector uniformly in all three axes
 *)
function D3DRMVectorScale( var d, s: D3DVECTOR ; factor: D3DVALUE ):
    LPD3DVECTOR ; stdcall ;

(*
 * Return a random unit vector
 *)
function D3DRMVectorRandom ( var d: D3DVECTOR ): LPD3DVECTOR ; stdcall ;

(*
 * Returns a unit quaternion that represents a rotation of theta radians
 * around the given axis.
 *)

function D3DRMQuaternionFromRotation ( var quat: LPD3DRMQUATERNION ;
    var v: LPD3DVECTOR ; theta: D3DVALUE ): LPD3DRMQUATERNION ; stdcall ;

(*
 * Calculate the product of two quaternions
 *)
function D3DRMQuaternionMultiply ( var q, a, b: D3DRMQUATERNION ):
    LPD3DRMQUATERNION ; stdcall ;

(*
 * Interpolate between two quaternions
 *)
function D3DRMQuaternionSlerp( var q, a, b: D3DRMQUATERNION ; alpha: D3DVALUE ):
    LPD3DRMQUATERNION ; stdcall ;

(*
 * Calculate the matrix for the rotation that a unit quaternion represents
 *)
procedure D3DRMMatrixFromQuaternion ( dmMat: D3DRMMATRIX4D ; var lpDqQuat:
    D3DRMQUATERNION );

implementation

function D3DRMCreateColorRGB ; external 'D3DRM.DLL' ;
function D3DRMCreateColorRGBA ; external 'D3DRM.DLL' ;
function D3DRMColorGetRed ; external 'D3DRM.DLL' ;
function D3DRMColorGetGreen ; external 'D3DRM.DLL' ;
function D3DRMColorGetBlue ; external 'D3DRM.DLL' ;
function D3DRMColorGetAlpha ; external 'D3DRM.DLL' ;
function D3DRMVectorAdd ; external 'D3DRM.DLL' ;
function D3DRMVectorSubtract ; external 'D3DRM.DLL' ;
function D3DRMVectorReflect ; external 'D3DRM.DLL' ;
function D3DRMVectorCrossProduct ; external 'D3DRM.DLL' ;
function D3DRMVectorDotProduct ; external 'D3DRM.DLL' ;
function D3DRMVectorNormalize ; external 'D3DRM.DLL' ;
function D3DRMVectorNormalise ; external 'D3DRM.DLL' name 'D3DRMVectorNormalize' ;
function D3DRMVectorModulus ; external 'D3DRM.DLL' ;
function D3DRMVectorRotate ; external 'D3DRM.DLL' ;
function D3DRMVectorScale ; external 'D3DRM.DLL' ;
function D3DRMVectorRandom ; external 'D3DRM.DLL' ;
function D3DRMQuaternionFromRotation ; external 'D3DRM.DLL' ;
function D3DRMQuaternionMultiply ; external 'D3DRM.DLL' ;
function D3DRMQuaternionSlerp ; external 'D3DRM.DLL' ;
procedure D3DRMMatrixFromQuaternion ; external 'D3DRM.DLL' ;

end.

