unit d3drmobj ;

interface

uses OLE2, Windows, D3DRmDef, D3D, D3DTypes, DDraw ;

(*==========================================================================;
 *
 *  Copyright (C) 1995-1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       d3drm.h
 *  Content:    Direct3DRM include file
 *
 *  DirectX 3 Delphi adaptation by Blake Stone
 *
 *    EMail:     bstone@dkw.com
 *    Home Page: http://www.dkw.com/bstone
 *
 ***************************************************************************)

{$Z4}
{$A+}

(*
 * Direct3DRM Object classes
 *)

const
  CLSID_CDirect3DRMDevice: TGUID = ( D1:$4fa3568e;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMViewport: TGUID = ( D1:$4fa3568f;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMFrame: TGUID = ( D1:$4fa35690;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMMesh: TGUID = ( D1:$4fa35691;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMMeshBuilder: TGUID = ( D1:$4fa35692;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMFace: TGUID = ( D1:$4fa35693;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMLight: TGUID = ( D1:$4fa35694;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMTexture: TGUID = ( D1:$4fa35695;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMWrap: TGUID = ( D1:$4fa35696;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMMaterial: TGUID = ( D1:$4fa35697;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMAnimation: TGUID = ( D1:$4fa35698;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMAnimationSet: TGUID = ( D1:$4fa35699;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMUserVisual: TGUID = ( D1:$4fa3569a;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  CLSID_CDirect3DRMShadow: TGUID = ( D1:$4fa3569b;D2:$623f;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));

(*
 * Direct3DRM Object interfaces
 *)

  IID_IDirect3DRMObject: TGUID = ( D1:$eb16cb00;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMDevice: TGUID = ( D1:$e9e19280;D2:$6e05;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMViewport: TGUID = ( D1:$eb16cb02;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMFrame: TGUID = ( D1:$eb16cb03;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMVisual: TGUID = ( D1:$eb16cb04;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMMesh: TGUID = ( D1:$a3a80d01;D2:$6e12;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMMeshBuilder: TGUID = ( D1:$a3a80d02;D2:$6e12;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMFace: TGUID = ( D1:$eb16cb07;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMLight: TGUID = ( D1:$eb16cb08;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMTexture: TGUID = ( D1:$eb16cb09;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMWrap: TGUID = ( D1:$eb16cb0a;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMMaterial: TGUID = ( D1:$eb16cb0b;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMAnimation: TGUID = ( D1:$eb16cb0d;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMAnimationSet: TGUID = ( D1:$eb16cb0e;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMDeviceArray: TGUID = ( D1:$eb16cb10;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMViewportArray: TGUID = ( D1:$eb16cb11;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMFrameArray: TGUID = ( D1:$eb16cb12;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMVisualArray: TGUID = ( D1:$eb16cb13;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMLightArray: TGUID = ( D1:$eb16cb14;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMPickedArray: TGUID = ( D1:$eb16cb16;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMFaceArray: TGUID = ( D1:$eb16cb17;D2:$d271;D3:$11ce;D4:($ac,$48,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMUserVisual: TGUID = ( D1:$59163de0;D2:$6d43;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  IID_IDirect3DRMShadow: TGUID = ( D1:$af359780;D2:$6ba3;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));

type
  IDirect3DRMObject = class;
  IDirect3DRMDevice = class;
  IDirect3DRMViewport = class;
  IDirect3DRMFrame = class;
  IDirect3DRMVisual = class;
  IDirect3DRMMesh = class;
  IDirect3DRMMeshBuilder = class;
  IDirect3DRMFace = class;
  IDirect3DRMLight = class;
  IDirect3DRMTexture = class;
  IDirect3DRMWrap = class;
  IDirect3DRMMaterial = class;
  IDirect3DRMAnimation = class;
  IDirect3DRMAnimationSet = class;
  IDirect3DRMUserVisual = class;
  IDirect3DRMShadow = class;
  IDirect3DRMArray = class;
  IDirect3DRMDeviceArray = class;
  IDirect3DRMFaceArray = class;
  IDirect3DRMViewportArray = class;
  IDirect3DRMFrameArray = class;
  IDirect3DRMVisualArray = class;
  IDirect3DRMPickedArray = class;
  IDirect3DRMLightArray = class;

  D3DRMOBJECTCALLBACK = procedure ( lpD3DRMobj: IDirect3DRMObject ;
      lpArg: Pointer ) ;
  D3DRMFRAMEMOVECALLBACK = procedure ( lpD3DRMFrame: IDirect3DRMFrame ;
      lpArg: Pointer ; delta: D3DVALUE ) ;
  D3DRMUPDATECALLBACK = procedure ( lpobj: IDirect3DRMDevice ; lpArg: Pointer ;
      iRectCount: Integer ; d3dRectUpdate: LPD3DRECT ) ;
  D3DRMUSERVISUALCALLBACK = function ( lpD3DRMUV: IDirect3DRMUserVisual ;
      lpArg: Pointer ; lpD3DRMUVreason: D3DRMUSERVISUALREASON ;
      lpD3DRMDev: IDirect3DRMDevice ;
      lpD3DRMview: IDirect3DRMViewport ): Integer ;
  D3DRMLOADTEXTURECALLBACK = function ( tex_name: PChar ; lpArg: Pointer ;
      lpD3DRMTex: IDirect3DRMTexture ): HRESULT ;
  D3DRMLOADCALLBACK = procedure ( lpObject: IDirect3DRMObject ;
      ObjectGuid: TGUID ; lpArg: Pointer ) ;

  D3DRMPICKDESC = record
    ulFaceIdx: LongInt ;
    lGroupIdx: LongInt ;
    vPosition: D3DVECTOR ;
  end ;
//  LPD3DRMPICKDESC = ^D3DRMPICKDESC ;

(*
 * Base class
 *)
  IDirect3DRMObject = class ( IUnknown )
    (*
     * The methods for IDirect3DRMObject
     *)
     function Clone ( pUnkOuter: IUnknown ; riid: TGUID ;
        var ppvObj: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
     function AddDestroyCallback ( lpCallback: D3DRMOBJECTCALLBACK ;
        lpArg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
     function DeleteDestroyCallback ( d3drmObjProc: D3DRMOBJECTCALLBACK ;
        lpArg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
     function SetAppData ( ulData: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
     function GetAppData: DWORD ; virtual ; stdcall ; abstract ;
     function SetName ( lpName: PChar ): HRESULT ; virtual ; stdcall ; abstract ;
     function GetName ( var lpdwSize: DWORD ; lpName: PChar ): HRESULT ;
        virtual ; stdcall ; abstract ;
     function GetClassName ( var lpdwSize: DWORD ; lpName: PChar ): HRESULT ;
        virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMVisual = class ( IDirect3DRMObject ) ;

  IDirect3DRMDevice = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMDevice methods
     *)
    function Init ( width: LongInt ; height: LongInt ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function InitFromD3D ( lpD3D: IDirect3D ; lpD3DIMDev: IDirect3DDevice ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function InitFromClipper ( lpDDClipper: IDirectDrawClipper ; lpGUID: PGUID ;
        width: Integer ; height: Integer ): HRESULT ; virtual ; stdcall ;
        abstract ;

    function Update: HRESULT ; virtual ; stdcall ; abstract ;
    function AddUpdateCallback ( d3drmUpdateProc: D3DRMUPDATECALLBACK ;
        arg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
    function DeleteUpdateCallback ( d3drmUpdateProc: D3DRMUPDATECALLBACK ;
        arg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetBufferCount ( dwCount: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetBufferCount: DWORD ; virtual ; stdcall ; abstract ;

    function SetDither ( bDither: BOOL ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetShades ( ulShades: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetQuality ( rqQuality: D3DRMRENDERQUALITY ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetTextureQuality ( tqTextureQuality: D3DRMTEXTUREQUALITY ):
        HRESULT ; virtual ; stdcall ; abstract ;

    function GetViewports ( var lplpViewports: IDirect3DRMViewportArray ):
        HRESULT ; virtual ; stdcall ; abstract ;

    function GetDither: BOOL ; virtual ; stdcall ; abstract ;
    function GetShades: DWORD ; virtual ; stdcall ; abstract ;
    function GetHeight: DWORD ; virtual ; stdcall ; abstract ;
    function GetWidth: DWORD ; virtual ; stdcall ; abstract ;
    function GetTrianglesDrawn: DWORD ; virtual ; stdcall ; abstract ;
    function GetWireframeOptions: DWORD ; virtual ; stdcall ; abstract ;
    function GetQuality: D3DRMRENDERQUALITY ; virtual ; stdcall ; abstract ;
    function GetColorModel: D3DCOLORMODEL ; virtual ; stdcall ; abstract ;
    function GetTextureQuality: D3DRMTEXTUREQUALITY ; virtual ; stdcall ;
        abstract ;
    function GetDirect3DDevice ( var lplpD3DDevice: IDirect3DDevice ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMViewport = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMViewport methods
     *)
    function Init ( lpD3DRMDevice: IDirect3DRMDevice ;
        lpD3DRMFrameCamera: IDirect3DRMFrame ; xpos, ypos,
        width, height: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function Clear: HRESULT ; virtual ; stdcall ; abstract ;
    function Render ( lpD3DRMFrame: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;

    function SetFront ( rvFront: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetBack ( rvBack: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetField ( rvField: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetUniformScaling ( bScale: BOOL ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetCamera ( lpCamera: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetProjection ( rptType: D3DRMPROJECTIONTYPE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Transform ( var lprvDst: D3DRMVECTOR4D ; var lprvSrc: D3DVECTOR ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function InverseTransform ( var lprvDst: D3DVECTOR ;
        var lprvSrc: D3DRMVECTOR4D ): HRESULT ; virtual ; stdcall ; abstract ;
    function Configure ( lX, lY: LongInt ; dwWidth, dwHeight: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function ForceUpdate ( dwX1, dwY1, dwX2, dwY2: DWORD ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetPlane ( rvLeft, rvRight, rvBottom, rvTop: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;

    function GetCamera ( var lpCamera: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetDevice ( lpD3DRMDevice: IDirect3DRMDevice ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetPlane ( var lpd3dvLeft, lpd3dvRight, lpd3dvBottom, lpd3dvTop:
        D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function Pick ( lX, lY: LongInt ; var lplpVisuals: IDirect3DRMPickedArray ):
        HRESULT ; virtual ; stdcall ; abstract ;

    function GetUniformScaling: BOOL ; virtual ; stdcall ; abstract ;
    function GetX: LongInt; virtual ; stdcall ; abstract ;
    function GetY: LongInt; virtual ; stdcall ; abstract ;
    function GetWidth: DWORD ; virtual ; stdcall ; abstract ;
    function GetHeight: DWORD ; virtual ; stdcall ; abstract ;
    function GetField: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetBack: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetFront: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetProjection: D3DRMPROJECTIONTYPE ; virtual ; stdcall ; abstract ;
    function GetDirect3DViewport ( var lplpD3DViewport: IDirect3DViewport ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMFrame = class ( IDirect3DRMVisual )
    (*
     * IDirect3DRMFrame methods
     *)
    function AddChild ( lpD3DRMFrameChild: IDirect3DRMFrame ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function AddLight ( lpD3DRMLight: IDirect3DRMLight ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function AddMoveCallback ( d3drmFMC: D3DRMFRAMEMOVECALLBACK ;
        lpArg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
    function AddTransform ( rctCombine: D3DRMCOMBINETYPE ;
        rmMatrix: D3DRMMATRIX4D ): HRESULT ; virtual ; stdcall ; abstract ;
    function AddTranslation ( rctCombine: D3DRMCOMBINETYPE ; rvX, rvY, rvZ:
        D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function AddScale ( rctCombine: D3DRMCOMBINETYPE ; rvX, rvY, rvZ: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function AddRotation ( rctCombine: D3DRMCOMBINETYPE ; rvX, rvY, rvZ,
        rvTheta: D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function AddVisual ( lpD3DRMVisual: IDirect3DRMVisual ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetChildren ( var lplpChildren: IDirect3DRMFrameArray ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetColor: D3DCOLOR ; virtual ; stdcall ; abstract ;
    function GetLights ( var lplpLights: IDirect3DRMLightArray ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetMaterialMode: D3DRMMATERIALMODE ; virtual ; stdcall ; abstract ;
    function GetParent ( var lplpParent: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetPosition ( lpRef: IDirect3DRMFrame ; var lprvPos: D3DVECTOR ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function GetRotation ( lpRef: IDirect3DRMFrame ; var lprvAxis: D3DVECTOR ;
        var lprvTheta: D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetScene ( var lplpRoot: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetSortMode: D3DRMSORTMODE ; virtual ; stdcall ; abstract ;
    function GetTexture ( var lplpTexture: IDirect3DRMTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetTransform ( rmMatrix: D3DRMMATRIX4D ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetVelocity ( lpRef: IDirect3DRMFrame ; var lprvVel: D3DVECTOR ;
        fRotVel: BOOL ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetOrientation ( lpRef: IDirect3DRMFrame ; var lprvDir: D3DVECTOR ;
        var lprvUp: D3DVECTOR ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetVisuals ( var lplpVisuals: IDirect3DRMVisualArray ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetTextureTopology ( var lpU, lpV: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function InverseTransform ( var lprvDst, lprvSrc: D3DVECTOR ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Load ( lpvObjSource: Pointer ; lpvObjID: Pointer ;
        d3drmLOFlags: D3DRMLOADOPTIONS ; d3drmLoadTextureProc:
        D3DRMLOADTEXTURECALLBACK ; lpArgLTP: Pointer ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function LookAt ( lpTarget, lpRef: IDirect3DRMFrame ;
        rfcConstraint: D3DRMFRAMECONSTRAINT  ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Move ( delta: D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function DeleteChild ( lpChild: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function DeleteLight ( lpD3DRMLight: IDirect3DRMLight ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function DeleteMoveCallback ( d3drmFMC: D3DRMFRAMEMOVECALLBACK ;
        lpArg: Pointer): HRESULT ; virtual ; stdcall ; abstract ;
    function DeleteVisual ( lpD3DRMVisual: IDirect3DRMVisual ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetSceneBackground: D3DCOLOR ; virtual ; stdcall ; abstract ;
    function GetSceneBackgroundDepth ( var lplpDDSurface: IDirectDrawSurface ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function GetSceneFogColor: D3DCOLOR ; virtual ; stdcall ; abstract ;
    function GetSceneFogEnable: BOOL ; virtual ; stdcall ; abstract ;
    function GetSceneFogMode: D3DRMFOGMODE ; virtual ; stdcall ; abstract ;
    function GetSceneFogParams ( var lprvStart, lprvEnd, lprvDensity: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function SetSceneBackground ( rcColor: D3DCOLOR): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetSceneBackgroundRGB ( rvRed, rvGreen, rvBlue: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function SetSceneBackgroundDepth ( lpImage: IDirectDrawSurface ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetSceneBackgroundImage ( lpTexture: IDirect3DRMTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetSceneFogEnable ( bEnable: BOOL ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetSceneFogColor ( rcColor: D3DCOLOR ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetSceneFogMode ( rfMode: D3DRMFOGMODE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetSceneFogParams ( rvStart, rvEnd, rvDensity: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetColor ( rcColor: D3DCOLOR): HRESULT ; virtual ; stdcall ; abstract ;
    function SetColorRGB ( rvRed, rvGreen, rvBlue: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetZbufferMode: D3DRMZBUFFERMODE ; virtual ; stdcall ; abstract ;
    function SetMaterialMode ( rmmMode: D3DRMMATERIALMODE): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetOrientation ( lpRef: IDirect3DRMFrame ; rvDx, rvDy, rvDz, rvUx,
        rvUy, rvUz: D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetPosition ( lpRef: IDirect3DRMFrame ; rvX, rvY, rvZ: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function SetRotation ( lpRef: IDirect3DRMFrame ; rvX, rvY, rvZ,
        rvTheta: D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetSortMode ( d3drmSM: D3DRMSORTMODE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetTexture ( lpD3DRMTexture: IDirect3DRMTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetTextureTopology ( cylU, cylV: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetVelocity ( lpRef: IDirect3DRMFrame ; rvX, rvY, rvZ: D3DVALUE ;
        fRotVel: BOOL ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetZbufferMode ( d3drmZBM: D3DRMZBUFFERMODE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Transform ( var lpd3dVDst, lpd3dVSrc: D3DVECTOR ): HRESULT ;
        virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMMesh = class ( IDirect3DRMVisual )
    (*
     * IDirect3DRMMesh methods
     *)
    function Scale ( sx, sy, sz: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Translate ( tx, ty, tz: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetBox ( var lpD3DRMBox: D3DRMBOX ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function AddGroup ( vCount, fCount, vPerFace: DWORD ; var fData: DWORD ;
        var returnId: D3DRMGROUPINDEX ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetVertices ( id: D3DRMGROUPINDEX ; index, count: DWORD ;
        var values: D3DRMVERTEX ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetGroupColor ( id: D3DRMGROUPINDEX ; value: D3DCOLOR ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetGroupColorRGB ( id: D3DRMGROUPINDEX ; red, green,
        blue: D3DVALUE ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetGroupMapping ( id: D3DRMGROUPINDEX ;
        value: D3DRMMAPPING ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetGroupQuality ( id: D3DRMGROUPINDEX ;
        value: D3DRMRENDERQUALITY ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetGroupMaterial ( id: D3DRMGROUPINDEX ; value:
        IDirect3DRMMaterial ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetGroupTexture ( id: D3DRMGROUPINDEX ; value: IDirect3DRMTexture ):
        HRESULT ; virtual ; stdcall ; abstract ;

    function GetGroupCount: DWORD ; virtual ; stdcall ; abstract ;
    function GetGroup ( id: D3DRMGROUPINDEX ; var vCount, fCount, vPerFace,
        fDataSize, fData: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetVertices ( var lpdwVertexCount: DWORD ;
        var lpPosition: D3DVECTOR ; var lpNormal: D3DVECTOR ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetGroupColor ( id: D3DRMGROUPINDEX ): D3DCOLOR ; virtual ; stdcall ; abstract ;
    function GetGroupMapping ( id: D3DRMGROUPINDEX ): D3DRMMAPPING ; virtual ; stdcall ; abstract ;
    function GetGroupQuality ( id: D3DRMGROUPINDEX ): D3DRMRENDERQUALITY ; virtual ; stdcall ; abstract ;
    function GetGroupMaterial ( id: D3DRMGROUPINDEX ;
        var returnPtr: IDirect3DRMMaterial ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetGroupTexture ( id: D3DRMGROUPINDEX ;
        var returnPtr: IDirect3DRMTexture ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

  IDirect3DRMShadow = class ( IDirect3DRMVisual )
    (*
     * IDirect3DRMShadow methods
     *)
    function Init ( lpD3DRMVisual: IDirect3DRMVisual ;
        lpD3DRMLight: IDirect3DRMLight ; px, py, pz, nx, ny, nz: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMFace = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMFace methods
     *)
     function AddVertex ( x, y, z: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
     function AddVertexAndNormalIndexed ( vertex: DWORD ; normal: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
     function SetColorRGB ( red, green, blue: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
     function SetColor ( color: D3DCOLOR ): HRESULT ; virtual ; stdcall ;
        abstract ;
     function SetTexture ( lpD3DRMTexture: IDirect3DRMTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
     function SetTextureCoordinates ( vertex: DWORD ; u, v: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
     function SetMaterial ( lpMat: IDirect3DRMMaterial ): HRESULT ; virtual ;
        stdcall ; abstract ;
     function SetTextureTopology ( cylU, cylV: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;

     function GetVertex ( index: DWORD ; var lpPosition: D3DVECTOR ;
        var lpNormal: D3DVECTOR ): HRESULT ; virtual ; stdcall ; abstract ;
     function GetVertices ( var lpdwVertexCount: DWORD ;
        var lpPosition, lpNormal: D3DVECTOR ): HRESULT ; virtual ; stdcall ;
        abstract ;
     function GetTextureCoordinates ( index: DWORD ; var lpU, lpV: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
     function GetTextureTopology ( var lpU, lpV: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;
     function GetNormal ( var lpNormal: D3DVECTOR ): HRESULT ; virtual ;
        stdcall ; abstract ;
     function GetTexture ( var lplpTexture: IDirect3DRMTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
     function GetMaterial ( lpMat: IDirect3DRMMaterial ): HRESULT ; virtual ;
        stdcall ; abstract ;

     function GetVertexCount: Integer ; virtual ; stdcall ; abstract ;
     function GetVertexIndex ( dwIndex: DWORD ): Integer ; virtual ; stdcall ; abstract ;
     function GetTextureCoordinateIndex ( dwIndex: DWORD ): Integer ; virtual ; stdcall ; abstract ;
     function GetColor: D3DCOLOR ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMMeshBuilder = class ( IDirect3DRMVisual )
    (*
     * IDirect3DRMMeshBuilder methods
     *)
    function Load ( lpvObjSource, lpvObjID: Pointer ; d3drmLOFlags:
        D3DRMLOADOPTIONS ; d3drmLoadTextureProc: D3DRMLOADTEXTURECALLBACK ;
        lpvArg: Pointer ): HRESULT ; virtual ; stdcall ; abstract ;
    function Save ( lpFilename: PChar ; d3drmXOFFormat: D3DRMXOFFORMAT ;
        d3drmSOContents: D3DRMSAVEOPTIONS ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Scale ( sx, sy, sz: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Translate ( tx, ty, tz: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetColorSource ( source: D3DRMCOLORSOURCE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetBox ( var lpD3DRMBox: D3DRMBOX ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GenerateNormals: HRESULT ; virtual ; stdcall ; abstract ;
    function GetColorSource: D3DRMCOLORSOURCE ; virtual ; stdcall ; abstract ;

    function AddMesh ( lpD3DRMMesh: IDirect3DRMMesh ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function AddMeshBuilder ( lpD3DRMMeshBuild: IDirect3DRMMeshBuilder ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function AddFrame ( lpD3DRMFrame: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function AddFace ( lpD3DRMFace: IDirect3DRMFace ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function AddFaces ( dwVertexCount: DWORD ; var lpD3DVertices: D3DVECTOR ;
        normalCount: DWORD ; var lpNormals: D3DVECTOR ; var lpFaceData: DWORD ;
        var lplpD3DRMFaceArray: IDirect3DRMFaceArray ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function ReserveSpace ( vertexCount, normalCount, faceCount: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function SetColorRGB ( red, green, blue: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetColor ( color: D3DCOLOR ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetTexture ( lpD3DRMTexture: IDirect3DRMTexture ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetMaterial ( lpIDirect3DRMmaterial: IDirect3DRMMaterial ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function SetTextureTopology ( cylU, cylV: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetQuality ( quality: D3DRMRENDERQUALITY): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetPerspective ( perspective: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetVertex ( index: DWORD ; x, y, z: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetNormal ( index: DWORD ; x, y, z: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetTextureCoordinates ( index: DWORD ; u, v: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetVertexColor ( index: DWORD ; color: D3DCOLOR ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetVertexColorRGB ( index: DWORD ; red, green, blue: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;

    function GetFaces ( var lplpD3DRMFaceArray: IDirect3DRMFaceArray ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetVertices ( var lpdwVertexCount: DWORD ; var lpPosition,
        lpNormal: D3DVECTOR ): HRESULT ; virtual ; stdcall ; abstract ;

    function AddVertex ( x, y, z: D3DVALUE ): Integer ; virtual ; stdcall ;
        abstract ;
    function AddNormal ( x, y, z: D3DVALUE ): Integer ; virtual ; stdcall ;
        abstract ;
    function CreateFace ( var lplpd3drmFace: IDirect3DRMFace ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetQuality: D3DRMRENDERQUALITY ; virtual ; stdcall ; abstract ;
    function GetPerspective: BOOL ; virtual ; stdcall ; abstract ;
    function GetFaceCount: Integer ; virtual ; stdcall ; abstract ;
    function GetVertexCount: Integer ; virtual ; stdcall ; abstract ;
    function GetVertexColor ( index: DWORD ): D3DCOLOR ; virtual ; stdcall ; abstract ;

    function CreateMesh ( var lplpD3DRMMesh: IDirect3DRMMesh ): HRESULT ;
        virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMLight = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMLight methods
     *)
    function SetType ( d3drmtType: D3DRMLIGHTTYPE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetColor ( rcColor: D3DCOLOR ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetColorRGB ( rvRed, rvGreen, rvBlue: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function SetRange ( rvRange: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetUmbra ( rvAngle: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetPenumbra ( rvAngle: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetConstantAttenuation ( rvAtt: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetLinearAttenuation ( rvAtt: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetQuadraticAttenuation ( rvAtt: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;

    function GetRange: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetUmbra: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetPenumbra: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetConstantAttenuation: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetLinearAttenuation: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetQuadraticAttenuation: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetColor: D3DCOLOR ; virtual ; stdcall ; abstract ;
    function GetType: D3DRMLIGHTTYPE ; virtual ; stdcall ; abstract ;

    function SetEnableFrame ( lpEnableFrame: IDirect3DRMFrame ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetEnableFrame ( var lplpEnableFrame: IDirect3DRMFrame ): HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMTexture = class ( IDirect3DRMVisual )
    (*
     * IDirect3DRMTexture methods
     *)
    function InitFromFile ( filename: PChar ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function InitFromSurface ( lpDDS: IDirectDrawSurface ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function InitFromResource ( rs: HRSRC ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Changed ( bPixels, bPalette: BOOL ): HRESULT ; virtual ; stdcall ;
        abstract ;

    function SetColors ( ulColors: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetShades ( ulShades: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetDecalSize ( rvWidth, rvHeight: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetDecalOrigin ( lX, lY: LongInt ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetDecalScale ( dwScale: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetDecalTransparency ( bTransp: BOOL ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetDecalTransparentColor ( rcTransp: D3DCOLOR ): HRESULT ;
        virtual ; stdcall ; abstract ;

    function GetDecalSize ( var lprvWidth, lprvHeight: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetDecalOrigin ( var lplX, lplY: LongInt ): HRESULT ; virtual ;
        stdcall ; abstract ;

    function GetImage: LPD3DRMIMAGE ; virtual ; stdcall ; abstract ;
    function GetShades: DWORD ; virtual ; stdcall ; abstract ;
    function GetColors: DWORD ; virtual ; stdcall ; abstract ;
    function GetDecalScale: DWORD ; virtual ; stdcall ; abstract ;
    function GetDecalTransparency: BOOL ; virtual ; stdcall ; abstract ;
    function GetDecalTransparentColor: D3DCOLOR ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMWrap = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMWrap methods
     *)
    function Init ( d3drmwt: D3DRMWRAPTYPE ; lpd3drmfRef: IDirect3DRMFrame ;
        ox, oy, oz, dx, dy, dz, ux, uy, uz, ou, ov, su, sv: D3DVALUE ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function Apply ( lpObject: IDirect3DRMObject ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function ApplyRelative ( frame: IDirect3DRMFrame ; mesh: IDirect3DRMObject ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMMaterial = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMMaterial methods
     *)
    function SetPower ( rvPower: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetSpecular ( r, g, b: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetEmissive ( r, g, b: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;

    function GetPower: D3DVALUE ; virtual ; stdcall ; abstract ;
    function GetSpecular ( var lpr, lpg, lpb: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetEmissive ( var lpr, lpg, lpb: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
  end ;

  IDirect3DRMAnimation = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMAnimation methods
     *)
    function SetOptions ( d3drmanimFlags: D3DRMANIMATIONOPTIONS ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function AddRotateKey ( rvTime: D3DVALUE ; var rqQuat: D3DRMQUATERNION ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function AddPositionKey ( rvTime, rvX, rvY, rvZ: D3DVALUE ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function AddScaleKey ( time, x, y, z: D3DVALUE ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function DeleteKey ( time: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetFrame ( lpD3DRMFrame: IDirect3DRMFrame ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function SetTime ( rvTime: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;

    function GetOptions: D3DRMANIMATIONOPTIONS ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMAnimationSet = class ( IDirect3DRMObject )
    (*
     * IDirect3DRMAnimationSet methods
     *)
    function AddAnimation ( lpD3DRMAnimation: IDirect3DRMAnimation ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Load ( lpvObjSource, lpvObjID: Pointer ;
        d3drmLOFlags: D3DRMLOADOPTIONS ;
        d3drmLoadTextureProc: D3DRMLOADTEXTURECALLBACK ; lpArgLTP: Pointer ;
        lpParentFrame: IDirect3DRMFrame ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function DeleteAnimation ( lpD3DRMAnimation: IDirect3DRMAnimation ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function SetTime ( rvTime: D3DVALUE ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

  IDirect3DRMUserVisual = class ( IDirect3DRMVisual )
    (*
     * IDirect3DRMUserVisual methods
     *)
    function Init ( d3drmUVProc: D3DRMUSERVISUALCALLBACK ; lpArg: Pointer ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMArray = class ( IUnknown )
    function GetSize: DWORD ; virtual ; stdcall ; abstract ;
    (* No GetElement method as it would get overloaded
     * in derived classes, and overloading is
     * a no-no in COM
     *)
  end ;

  IDirect3DRMDeviceArray = class ( IDirect3DRMArray )
    function GetElement ( index: DWORD ; var lplpD3DRMDevice:
        IDirect3DRMDevice ): HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMFrameArray = class ( IDirect3DRMArray )
    function GetElement ( index: DWORD ; var lplpD3DRMFrame: IDirect3DRMFrame ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMViewportArray = class ( IDirect3DRMArray )
    function GetElement ( index: DWORD ; var lplpD3DRMViewport:
        IDirect3DRMViewport): HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMVisualArray = class ( IDirect3DRMArray )
    function GetElement ( index: DWORD ; var lplpD3DRMVisual:
        IDirect3DRMVisual ): HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMPickedArray = class ( IDirect3DRMArray )
    function GetPick ( index: DWORD ; var lplpVisual: IDirect3DRMVisual ;
        var lplpFrameArray: IDirect3DRMFrameArray ;
        var lpD3DRMPickDesc: D3DRMPICKDESC ): HRESULT ; virtual ; stdcall ;
        abstract ;
  end ;

  IDirect3DRMLightArray = class ( IDirect3DRMArray )
    function GetElement ( index: DWORD ; var lplpD3DRMLight: IDirect3DRMLight ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

  IDirect3DRMFaceArray = class ( IDirect3DRMArray )
    function GetElement ( index: DWORD ; var lplpD3DRMFace: IDirect3DRMFace ):
        HRESULT ; virtual ; stdcall ; abstract ;
  end ;

implementation

end.

