unit d3dtypes ;

interface

uses OLE2, Windows, DDraw ;

(*==========================================================================;
 *
 *  Copyright (C) 1995 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       d3dtypes.h
 *  Content:    Direct3D types include file
 *
 *  DirectX 3 Delphi adaptation by Blake Stone
 *
 *    EMail:     bstone@dkw.com
 *    Home Page: http://www.dkw.com/bstone
 *
 ***************************************************************************)

{$Z4}
{$A+}

(* D3DVALUE is the fundamental Direct3D fractional data type *)

type
  D3DVALUE = single ;
  D3DFIXED = LongInt ;
// typedef float D3DVALUE, *LPD3DVALUE;
// typedef LONG D3DFIXED;

// #define D3DVALP(val, prec) ((float)(val))
// #define D3DVAL(val) ((float)(val))
// #define D3DDivide(a, b)    (float)((double) (a) / (double) (b))
// #define D3DMultiply(a, b)    ((a) * (b))

(*
 * Format of CI colors is
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |    alpha      |         color index           |   fraction    |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *)

// #define CI_GETALPHA(ci)    ((ci) >> 24)
// #define CI_GETINDEX(ci)    (((ci) >> 8) & 0xffff)
// #define CI_GETFRACTION(ci) ((ci) & 0xff)
// #define CI_ROUNDINDEX(ci)  CI_GETINDEX((ci) + 0x80)
// #define CI_MASKALPHA(ci)   ((ci) & 0xffffff)
// #define CI_MAKE(a, i, f)    (((a) << 24) | ((i) << 8) | (f))

(*
 * Format of RGBA colors is
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |    alpha      |      red      |     green     |     blue      |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *)

// #define RGBA_GETALPHA(rgb)      ((rgb) >> 24)
// #define RGBA_GETRED(rgb)        (((rgb) >> 16) & 0xff)
// #define RGBA_GETGREEN(rgb)      (((rgb) >> 8) & 0xff)
// #define RGBA_GETBLUE(rgb)       ((rgb) & 0xff)
// #define RGBA_MAKE(r, g, b, a)   ((D3DCOLOR) (((a) << 24) | ((r) << 16) | ((g) << 8) | (b)))

(* D3DRGB and D3DRGBA may be used as initialisers for D3DCOLORs
 * The float values must be in the range 0..1
 *)

// #define D3DRGB(r, g, b) \
//     (0xff000000L | ( ((long)((r) * 255)) << 16) | (((long)((g) * 255)) << 8) | (long)((b) * 255))
// #define D3DRGBA(r, g, b, a) \
//     (   (((long)((a) * 255)) << 24) | (((long)((r) * 255)) << 16) \
//     |   (((long)((g) * 255)) << 8) | (long)((b) * 255) \
//     )

(*
 * Format of RGB colors is
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |    ignored    |      red      |     green     |     blue      |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *)

// #define RGB_GETRED(rgb)         (((rgb) >> 16) & 0xff)
// #define RGB_GETGREEN(rgb)       (((rgb) >> 8) & 0xff)
// #define RGB_GETBLUE(rgb)        ((rgb) & 0xff)
// #define RGBA_SETALPHA(rgba, x) (((x) << 24) | ((rgba) & 0x00ffffff))
// #define RGB_MAKE(r, g, b)       ((D3DCOLOR) (((r) << 16) | ((g) << 8) | (b)))
// #define RGBA_TORGB(rgba)       ((D3DCOLOR) ((rgba) & 0xffffff))
// #define RGB_TORGBA(rgb)        ((D3DCOLOR) ((rgb) | 0xff000000))

(*
 * Flags for Enumerate functions
 *)

(*
 * Stop the enumeration
 *)

const
  D3DENUMRET_CANCEL                        = DDENUMRET_CANCEL ;

(*
 * Continue the enumeration
 *)

  D3DENUMRET_OK                            = DDENUMRET_OK ;

type
  LPD3DVALIDATECALLBACK = function ( lpUserArg: Pointer ;
      dwOffset: DWORD ): HRESULT ; stdcall ;
  LPD3DENUMTEXTUREFORMATSCALLBACK = function ( const lpDdsd: DDSURFACEDESC ;
      lpUserArg: Pointer ): HRESULT ; stdcall ;
// typedef HRESULT (WINAPI* LPD3DVALIDATECALLBACK)(LPVOID lpUserArg, DWORD dwOffset);
// typedef HRESULT (WINAPI* LPD3DENUMTEXTUREFORMATSCALLBACK)(LPDDSURFACEDESC lpDdsd, LPVOID lpContext);

  D3DCOLOR = DWORD ;
  D3DMATERIALHANDLE = DWORD ;
  D3DTEXTUREHANDLE = DWORD ;
  D3DMATRIXHANDLE = DWORD ;
//  LPD3DCOLOR = ^D3DCOLOR ;
//  LPD3DMATERIALHANDLE = ^D3DMATERIALHANDLE ;
//  LPD3DTEXTUREHANDLE = ^D3DTEXTUREHANDLE ;
//  LPD3DMATRIXHANDLE = ^D3DMATRIXHANDLE ;

  D3DCOLORVALUE = record
    case Integer of
    0: (
      r: D3DVALUE ;
      g: D3DVALUE ;
      b: D3DVALUE ;
      a: D3DVALUE ;
      ) ;
    1: (
      dvR: D3DVALUE ;
      dvG: D3DVALUE ;
      dvB: D3DVALUE ;
      dvA: D3DVALUE ;
      ) ;
  end ;

  D3DRECT = record
    case Integer of
    0: (
      x1: LongInt;
      y1: LongInt;
      x2: LongInt;
      y2: LongInt;
      ) ;
    1: (
      lX1: LongInt;
      lY1: LongInt;
      lX2: LongInt;
      lY2: LongInt;
      ) ;
  end ;
  LPD3DRECT = ^D3DRECT ;

  D3DVECTOR = record
    case Integer of
    0: (
      x: D3DVALUE ;
      y: D3DVALUE ;
      z: D3DVALUE ;
      ) ;
    1: (
      dvX: D3DVALUE ;
      dvY: D3DVALUE ;
      dvZ: D3DVALUE ;
      ) ;
  end ;
  LPD3DVECTOR = ^D3DVECTOR ;


(*
 * Vertex data types supported in an ExecuteBuffer.
 *)

(*
 * Homogeneous vertices
 *)

  D3DHVERTEX = record
    dwFlags: DWORD ;        (* Homogeneous clipping flags *)
    case Integer of
    0: (
      hx: D3DVALUE ;
      hy: D3DVALUE ;
      hz: D3DVALUE ;
      ) ;
    1: (
      dvHX: D3DVALUE ;
      dvHY: D3DVALUE ;
      dvHZ: D3DVALUE ;
      ) ;
  end ;

(*
 * Transformed/lit vertices
 *)

  D3DTLVERTEX = record
    case Integer of
    0: (
      sx: D3DVALUE ;             (* Screen coordinates *)
      sy: D3DVALUE ;
      sz: D3DVALUE ;
      rhw: D3DVALUE ;            (* Reciprocal of homogeneous w *)
      color: D3DCOLOR ;          (* Vertex color *)
      specular: D3DCOLOR ;       (* Specular component of vertex *)
      tu: D3DVALUE ;             (* Texture coordinates *)
      tv: D3DVALUE ;
      ) ;
    1: (
      dvSX: D3DVALUE ;
      dvSY: D3DVALUE ;
      dvSZ: D3DVALUE ;
      dvRHW: D3DVALUE ;
      dcColor: D3DCOLOR ;
      dcSpecular: D3DCOLOR ;
      dvTU: D3DVALUE ;
      dvTV: D3DVALUE ;
      ) ;
  end ;

(*
 * Untransformed/lit vertices
 *)

  D3DLVERTEX = record
    case Integer of
    0: (
      x: D3DVALUE ;             (* Homogeneous coordinates *)
      y: D3DVALUE ;
      z: D3DVALUE ;
      dwReserved: DWORD ;
      color: D3DCOLOR ;         (* Vertex color *)
      specular: D3DCOLOR ;      (* Specular component of vertex *)
      tu: D3DVALUE ;            (* Texture coordinates *)
      tv: D3DVALUE ;
      ) ;
    1: (
      dvX: D3DVALUE ;
      dvY: D3DVALUE ;
      dvZ: D3DVALUE ;
      UNIONFILLER1d: DWORD ;
      dcColor: D3DCOLOR ;
      dcSpecular: D3DCOLOR ;
      dvTU: D3DVALUE ;
      dvTV: D3DVALUE ;
      ) ;
  end ;

(*
 * Untransformed/unlit vertices
 *)

  D3DVERTEX = record
    case Integer of
    0: (
      x: D3DVALUE ;             (* Homogeneous coordinates *)
      y: D3DVALUE ;
      z: D3DVALUE ;
      nx: D3DVALUE ;            (* Normal *)
      ny: D3DVALUE ;
      nz: D3DVALUE ;
      tu: D3DVALUE ;            (* Texture coordinates *)
      tv: D3DVALUE ;
      ) ;
    1: (
      dvX: D3DVALUE ;
      dvY: D3DVALUE ;
      dvZ: D3DVALUE ;
      dvNX: D3DVALUE ;
      dvNY: D3DVALUE ;
      dvNZ: D3DVALUE ;
      dvTU: D3DVALUE ;
      dvTV: D3DVALUE ;
      ) ;
  end ;

(*
 * Matrix, viewport, and tranformation structures and definitions.
 *)

  D3DMATRIX = record
    _11, _12, _13, _14: D3DVALUE ;
    _21, _22, _23, _24: D3DVALUE ;
    _31, _32, _33, _34: D3DVALUE ;
    _41, _42, _43, _44: D3DVALUE ;
  end ;

  D3DVIEWPORT = record
    dwSize: DWORD ;
    dwX: DWORD ;
    dwY: DWORD ;               (* Top left *)
    dwWidth: DWORD ;
    dwHeight: DWORD ;          (* Dimensions *)
    dvScaleX: D3DVALUE ;       (* Scale homogeneous to screen *)
    dvScaleY: D3DVALUE ;       (* Scale homogeneous to screen *)
    dvMaxX: D3DVALUE ;         (* Min/max homogeneous x coord *)
    dvMaxY: D3DVALUE ;         (* Min/max homogeneous y coord *)
    dvMinZ: D3DVALUE ;
    dvMaxZ: D3DVALUE ;         (* Min/max homogeneous z coord *)
  end ;

(*
 * Values for clip fields.
 *)

const
  D3DCLIP_LEFT                            = $00000001 ;
  D3DCLIP_RIGHT                           = $00000002 ;
  D3DCLIP_TOP                             = $00000004 ;
  D3DCLIP_BOTTOM                          = $00000008 ;
  D3DCLIP_FRONT                           = $00000010 ;
  D3DCLIP_BACK                            = $00000020 ;
  D3DCLIP_GEN0                            = $00000040 ;
  D3DCLIP_GEN1                            = $00000080 ;
  D3DCLIP_GEN2                            = $00000100 ;
  D3DCLIP_GEN3                            = $00000200 ;
  D3DCLIP_GEN4                            = $00000400 ;
  D3DCLIP_GEN5                            = $00000800 ;

(*
 * Values for d3d status.
 *)

  D3DSTATUS_CLIPUNIONLEFT                 = D3DCLIP_LEFT ;
  D3DSTATUS_CLIPUNIONRIGHT                = D3DCLIP_RIGHT ;
  D3DSTATUS_CLIPUNIONTOP                  = D3DCLIP_TOP ;
  D3DSTATUS_CLIPUNIONBOTTOM               = D3DCLIP_BOTTOM ;
  D3DSTATUS_CLIPUNIONFRONT                = D3DCLIP_FRONT ;
  D3DSTATUS_CLIPUNIONBACK                 = D3DCLIP_BACK ;
  D3DSTATUS_CLIPUNIONGEN0                 = D3DCLIP_GEN0 ;
  D3DSTATUS_CLIPUNIONGEN1                 = D3DCLIP_GEN1 ;
  D3DSTATUS_CLIPUNIONGEN2                 = D3DCLIP_GEN2 ;
  D3DSTATUS_CLIPUNIONGEN3                 = D3DCLIP_GEN3 ;
  D3DSTATUS_CLIPUNIONGEN4                 = D3DCLIP_GEN4 ;
  D3DSTATUS_CLIPUNIONGEN5                 = D3DCLIP_GEN5 ;

  D3DSTATUS_CLIPINTERSECTIONLEFT          = $00001000 ;
  D3DSTATUS_CLIPINTERSECTIONRIGHT         = $00002000 ;
  D3DSTATUS_CLIPINTERSECTIONTOP           = $00004000 ;
  D3DSTATUS_CLIPINTERSECTIONBOTTOM        = $00008000 ;
  D3DSTATUS_CLIPINTERSECTIONFRONT         = $00010000 ;
  D3DSTATUS_CLIPINTERSECTIONBACK          = $00020000 ;
  D3DSTATUS_CLIPINTERSECTIONGEN0          = $00040000 ;
  D3DSTATUS_CLIPINTERSECTIONGEN1          = $00080000 ;
  D3DSTATUS_CLIPINTERSECTIONGEN2          = $00100000 ;
  D3DSTATUS_CLIPINTERSECTIONGEN3          = $00200000 ;
  D3DSTATUS_CLIPINTERSECTIONGEN4          = $00400000 ;
  D3DSTATUS_CLIPINTERSECTIONGEN5          = $00800000 ;
  D3DSTATUS_ZNOTVISIBLE                   = $01000000 ;

  D3DSTATUS_CLIPUNIONALL = (
            D3DSTATUS_CLIPUNIONLEFT or
            D3DSTATUS_CLIPUNIONRIGHT or
            D3DSTATUS_CLIPUNIONTOP or
            D3DSTATUS_CLIPUNIONBOTTOM or
            D3DSTATUS_CLIPUNIONFRONT or
            D3DSTATUS_CLIPUNIONBACK or
            D3DSTATUS_CLIPUNIONGEN0 or
            D3DSTATUS_CLIPUNIONGEN1 or
            D3DSTATUS_CLIPUNIONGEN2 or
            D3DSTATUS_CLIPUNIONGEN3 or
            D3DSTATUS_CLIPUNIONGEN4 or
            D3DSTATUS_CLIPUNIONGEN5 ) ;

  D3DSTATUS_CLIPINTERSECTIONALL = (
            D3DSTATUS_CLIPINTERSECTIONLEFT or
            D3DSTATUS_CLIPINTERSECTIONRIGHT or
            D3DSTATUS_CLIPINTERSECTIONTOP or
            D3DSTATUS_CLIPINTERSECTIONBOTTOM or
            D3DSTATUS_CLIPINTERSECTIONFRONT or
            D3DSTATUS_CLIPINTERSECTIONBACK or
            D3DSTATUS_CLIPINTERSECTIONGEN0 or
            D3DSTATUS_CLIPINTERSECTIONGEN1 or
            D3DSTATUS_CLIPINTERSECTIONGEN2 or
            D3DSTATUS_CLIPINTERSECTIONGEN3 or
            D3DSTATUS_CLIPINTERSECTIONGEN4 or
            D3DSTATUS_CLIPINTERSECTIONGEN5 ) ;

  D3DSTATUS_DEFAULT = (
            D3DSTATUS_CLIPINTERSECTIONALL or
            D3DSTATUS_ZNOTVISIBLE ) ;

(*
 * Options for direct transform calls
 *)

  D3DTRANSFORM_CLIPPED       = $00000001 ;
  D3DTRANSFORM_UNCLIPPED     = $00000002 ;

type
  D3DTRANSFORMDATA = record
    dwSize: DWORD ;
    lpIn: Pointer ;             (* Input vertices *)
    dwInSize: DWORD ;           (* Stride of input vertices *)
    lpOut: Pointer ;            (* Output vertices *)
    dwOutSize: DWORD ;          (* Stride of output vertices *)
    lpHOut: ^D3DHVERTEX ;       (* Output homogeneous vertices *)
    dwClip: DWORD ;             (* Clipping hint *)
    dwClipIntersection: DWORD ;
    dwClipUnion: DWORD ;        (* Union of all clip flags *)
    drExtent: D3DRECT ;         (* Extent of transformed vertices *)
  end ;

(*
 * Structure defining position and direction properties for lighting.
 *)

  D3DLIGHTINGELEMENT = record
    dvPosition: D3DVECTOR ;           (* Lightable point in model space *)
    dvNormal: D3DVECTOR ;             (* Normalised unit vector *)
  end ;

(*
 * Structure defining material properties for lighting.
 *)

  D3DMATERIAL = record
    dwSize: DWORD ;
    case Integer of
    0: (
      diffuse: D3DCOLORVALUE ;        (* Diffuse color RGBA *)
      ambient: D3DCOLORVALUE ;        (* Ambient color RGB *)
      specular: D3DCOLORVALUE ;       (* Specular 'shininess' *)
      emissive: D3DCOLORVALUE ;       (* Emissive color RGB *)
      power: D3DVALUE ;               (* Sharpness if specular highlight *)
      hTexture: D3DTEXTUREHANDLE ;    (* Handle to texture map *)
      dwRampSize: DWORD ;
      ) ;
    1: (
      dcvDiffuse: D3DCOLORVALUE ;
      dcvAmbient: D3DCOLORVALUE ;
      dcvSpecular: D3DCOLORVALUE ;
      dcvEmissive: D3DCOLORVALUE ;
      dvPower: D3DVALUE ;
      ) ;
  end ;

  D3DLIGHTTYPE = (
    D3DLIGHT_INVALID_0,
    D3DLIGHT_POINT,
    D3DLIGHT_SPOT,
    D3DLIGHT_DIRECTIONAL,
    D3DLIGHT_PARALLELPOINT,
    D3DLIGHT_GLSPOT ) ;

(*
 * Structure defining a light source and its properties.
 *)

  D3DLIGHT = record
    dwSize: DWORD ;
    dltType: D3DLIGHTTYPE ;     (* Type of light source *)
    dcvColor: D3DCOLORVALUE ;   (* Color of light *)
    dvPosition: D3DVECTOR ;     (* Position in world space *)
    dvDirection: D3DVECTOR ;    (* Direction in world space *)
    dvRange: D3DVALUE ;         (* Cutoff range *)
    dvFalloff: D3DVALUE ;       (* Falloff *)
    dvAttenuation0: D3DVALUE ;  (* Constant attenuation *)
    dvAttenuation1: D3DVALUE ;  (* Linear attenuation *)
    dvAttenuation2: D3DVALUE ;  (* Quadratic attenuation *)
    dvTheta: D3DVALUE ;         (* Inner angle of spotlight cone *)
    dvPhi: D3DVALUE ;           (* Outer angle of spotlight cone *)
  end ;

  D3DLIGHTDATA = record
    dwSize: DWORD ;
    lpIn: ^D3DLIGHTINGELEMENT ;   (* Input positions and normals *)
    dwInSize: DWORD ;             (* Stride of input elements *)
    lpOut: ^D3DTLVERTEX ;         (* Output colors *)
    dwOutSize: DWORD ;            (* Stride of output colors *)
  end ;

  D3DCOLORMODEL = (
    D3DCOLOR_INVALID_0,
    D3DCOLOR_MONO,
    D3DCOLOR_RGB ) ;

(*
 * Options for clearing
 *)

const
  D3DCLEAR_TARGET            = $00000001 ; (* Clear target surface *)
  D3DCLEAR_ZBUFFER           = $00000002 ; (* Clear target z buffer *)

(*
 * Execute buffers are allocated via Direct3D.  These buffers may then
 * be filled by the application with instructions to execute along with
 * vertex data.
 *)

(*
 * Supported op codes for execute instructions.
 *)

type
  D3DOPCODE = (
    D3DOP_INVALID_0,
    D3DOP_POINT,
    D3DOP_LINE,
    D3DOP_TRIANGLE,
    D3DOP_MATRIXLOAD,
    D3DOP_MATRIXMULTIPLY,
    D3DOP_STATETRANSFORM,
    D3DOP_STATELIGHT,
    D3DOP_STATERENDER,
    D3DOP_PROCESSVERTICES,
    D3DOP_TEXTURELOAD,
    D3DOP_EXIT,
    D3DOP_BRANCHFORWARD,
    D3DOP_SPAN,
    D3DOP_SETSTATUS ) ;

  D3DINSTRUCTION = record
    bOpcode: BYTE ;   (* Instruction opcode *)
    bSize: BYTE ;     (* Size of each instruction data unit *)
    wCount: WORD ;    (* Count of instruction data units to follow *)
  end ;

(*
 * Structure for texture loads
 *)

  D3DTEXTURELOAD = record
    hDestTexture: D3DTEXTUREHANDLE ;
    hSrcTexture: D3DTEXTUREHANDLE ;
  end ;

(*
 * Structure for picking
 *)

  D3DPICKRECORD = record
    bOpcode: BYTE ;
    bPad: BYTE ;
    dwOffset: DWORD ;
    dvZ: D3DVALUE ;
  end ;

(*
 * The following defines the rendering states which can be set in the
 * execute buffer.
 *)

  D3DSHADEMODE = (
    D3DSHADE_INVALID_0,
    D3DSHADE_FLAT,
    D3DSHADE_GOURAUD,
    D3DSHADE_PHONG ) ;

  D3DFILLMODE = (
    D3DFILL_INVALID_0,
    D3DFILL_POINT,
    D3DFILL_WIREFRAME,
    D3DFILL_SOLID ) ;

  D3DLINEPATTERN = record
    wRepeatFactor: WORD ;
    wLinePattern: WORD ;
  end ;

  D3DTEXTUREFILTER = (
    D3DFILTER_INVALID_0,
    D3DFILTER_NEAREST,
    D3DFILTER_LINEAR,
    D3DFILTER_MIPNEAREST,
    D3DFILTER_MIPLINEAR,
    D3DFILTER_LINEARMIPNEAREST,
    D3DFILTER_LINEARMIPLINEAR ) ;

  D3DBLEND = (
    D3DBLEND_INVALID_0,
    D3DBLEND_ZERO,
    D3DBLEND_ONE,
    D3DBLEND_SRCCOLOR,
    D3DBLEND_INVSRCCOLOR,
    D3DBLEND_SRCALPHA,
    D3DBLEND_INVSRCALPHA,
    D3DBLEND_DESTALPHA,
    D3DBLEND_INVDESTALPHA,
    D3DBLEND_DESTCOLOR,
    D3DBLEND_INVDESTCOLOR,
    D3DBLEND_SRCALPHASAT,
    D3DBLEND_BOTHSRCALPHA,
    D3DBLEND_BOTHINVSRCALPHA ) ;

  D3DTEXTUREBLEND = (
    D3DTBLEND_INVALID_0,
    D3DTBLEND_DECAL,
    D3DTBLEND_MODULATE,
    D3DTBLEND_DECALALPHA,
    D3DTBLEND_MODULATEALPHA,
    D3DTBLEND_DECALMASK,
    D3DTBLEND_MODULATEMASK,
    D3DTBLEND_COPY ) ;

  D3DTEXTUREADDRESS = (
    D3DTADDRESS_INVALID_0,
    D3DTADDRESS_WRAP,
    D3DTADDRESS_MIRROR,
    D3DTADDRESS_CLAMP ) ;

  D3DCULL = (
    D3DCULL_INVALID_0,
    D3DCULL_NONE,
    D3DCULL_CW,
    D3DCULL_CCW ) ;

  D3DCMPFUNC = (
    D3DCMP_INVALID_0,
    D3DCMP_NEVER,
    D3DCMP_LESS,
    D3DCMP_EQUAL,
    D3DCMP_LESSEQUAL,
    D3DCMP_GREATER,
    D3DCMP_NOTEQUAL,
    D3DCMP_GREATEREQUAL,
    D3DCMP_ALWAYS ) ;

  D3DFOGMODE = (
    D3DFOG_NONE,
    D3DFOG_EXP,
    D3DFOG_EXP2,
    D3DFOG_LINEAR ) ;

(*
 * Amount to add to a state to generate the override for that state.
 *)

const
  D3DSTATE_OVERRIDE_BIAS          = 256 ;

(*
 * A state which sets the override flag for the specified state type.
 *)

// #define D3DSTATE_OVERRIDE(type) ((DWORD) (type) + D3DSTATE_OVERRIDE_BIAS)

type
  D3DTRANSFORMSTATETYPE = (
    D3DTRANSFORMSTATE_INVALID_0,
    D3DTRANSFORMSTATE_WORLD,
    D3DTRANSFORMSTATE_VIEW,
    D3DTRANSFORMSTATE_PROJECTION ) ;

  D3DLIGHTSTATETYPE = (
    D3DLIGHTSTATE_INVALID_0,
    D3DLIGHTSTATE_MATERIAL,
    D3DLIGHTSTATE_AMBIENT,
    D3DLIGHTSTATE_COLORMODEL,
    D3DLIGHTSTATE_FOGMODE,
    D3DLIGHTSTATE_FOGSTART,
    D3DLIGHTSTATE_FOGEND,
    D3DLIGHTSTATE_FOGDENSITY ) ;

  D3DRENDERSTATETYPE = (
    D3DRENDERSTATE_INVALID_0,
    D3DRENDERSTATE_TEXTUREHANDLE,       (* Texture handle *)
    D3DRENDERSTATE_ANTIALIAS,           (* Antialiasing prim edges *)
    D3DRENDERSTATE_TEXTUREADDRESS,      (* D3DTEXTUREADDRESS      *)
    D3DRENDERSTATE_TEXTUREPERSPECTIVE,  (* TRUE for perspective correction *)
    D3DRENDERSTATE_WRAPU,               (* TRUE for wrapping in u *)
    D3DRENDERSTATE_WRAPV,               (* TRUE for wrapping in v *)
    D3DRENDERSTATE_ZENABLE,             (* TRUE to enable z test *)
    D3DRENDERSTATE_FILLMODE,            (* D3DFILL_MODE            *)
    D3DRENDERSTATE_SHADEMODE,           (* D3DSHADEMODE *)
    D3DRENDERSTATE_LINEPATTERN,         (* D3DLINEPATTERN *)
    D3DRENDERSTATE_MONOENABLE,          (* TRUE to enable mono rasterization *)
    D3DRENDERSTATE_ROP2,                (* ROP2 *)
    D3DRENDERSTATE_PLANEMASK,           (* DWORD physical plane mask *)
    D3DRENDERSTATE_ZWRITEENABLE,        (* TRUE to enable z writes *)
    D3DRENDERSTATE_ALPHATESTENABLE,     (* TRUE to enable alpha tests *)
    D3DRENDERSTATE_LASTPIXEL,           (* TRUE for last-pixel on lines *)
    D3DRENDERSTATE_TEXTUREMAG,          (* D3DTEXTUREFILTER *)
    D3DRENDERSTATE_TEXTUREMIN,          (* D3DTEXTUREFILTER *)
    D3DRENDERSTATE_SRCBLEND,            (* D3DBLEND *)
    D3DRENDERSTATE_DESTBLEND,           (* D3DBLEND *)
    D3DRENDERSTATE_TEXTUREMAPBLEND,     (* D3DTEXTUREBLEND *)
    D3DRENDERSTATE_CULLMODE,            (* D3DCULL *)
    D3DRENDERSTATE_ZFUNC,               (* D3DCMPFUNC *)
    D3DRENDERSTATE_ALPHAREF,            (* D3DFIXED *)
    D3DRENDERSTATE_ALPHAFUNC,           (* D3DCMPFUNC *)
    D3DRENDERSTATE_DITHERENABLE,        (* TRUE to enable dithering *)
    D3DRENDERSTATE_BLENDENABLE,         (* TRUE to enable alpha blending *)
    D3DRENDERSTATE_FOGENABLE,           (* TRUE to enable fog *)
    D3DRENDERSTATE_SPECULARENABLE,      (* TRUE to enable specular *)
    D3DRENDERSTATE_ZVISIBLE,            (* TRUE to enable z checking *)
    D3DRENDERSTATE_SUBPIXEL,            (* TRUE to enable subpixel correction *)
    D3DRENDERSTATE_SUBPIXELX,           (* TRUE to enable correction in X only *)
    D3DRENDERSTATE_STIPPLEDALPHA,       (* TRUE to enable stippled alpha *)
    D3DRENDERSTATE_FOGCOLOR,            (* D3DCOLOR *)
    D3DRENDERSTATE_FOGTABLEMODE,        (* D3DFOGMODE *)
    D3DRENDERSTATE_FOGTABLESTART,       (* Fog table start        *)
    D3DRENDERSTATE_FOGTABLEEND,         (* Fog table end          *)
    D3DRENDERSTATE_FOGTABLEDENSITY,     (* Fog table density      *)
    D3DRENDERSTATE_STIPPLEENABLE,       (* TRUE to enable stippling *)
    D3DRENDERSTATE_INVALID_40,
    D3DRENDERSTATE_INVALID_41,
    D3DRENDERSTATE_INVALID_42,
    D3DRENDERSTATE_INVALID_43,
    D3DRENDERSTATE_INVALID_44,
    D3DRENDERSTATE_INVALID_45,
    D3DRENDERSTATE_INVALID_46,
    D3DRENDERSTATE_INVALID_47,
    D3DRENDERSTATE_INVALID_48,
    D3DRENDERSTATE_INVALID_49,
    D3DRENDERSTATE_INVALID_50,
    D3DRENDERSTATE_INVALID_51,
    D3DRENDERSTATE_INVALID_52,
    D3DRENDERSTATE_INVALID_53,
    D3DRENDERSTATE_INVALID_54,
    D3DRENDERSTATE_INVALID_55,
    D3DRENDERSTATE_INVALID_56,
    D3DRENDERSTATE_INVALID_57,
    D3DRENDERSTATE_INVALID_58,
    D3DRENDERSTATE_INVALID_59,
    D3DRENDERSTATE_INVALID_60,
    D3DRENDERSTATE_INVALID_61,
    D3DRENDERSTATE_INVALID_62,
    D3DRENDERSTATE_INVALID_63,
    D3DRENDERSTATE_STIPPLEPATTERN00,   (* Stipple pattern 01...  *)
    D3DRENDERSTATE_STIPPLEPATTERN01,
    D3DRENDERSTATE_STIPPLEPATTERN02,
    D3DRENDERSTATE_STIPPLEPATTERN03,
    D3DRENDERSTATE_STIPPLEPATTERN04,
    D3DRENDERSTATE_STIPPLEPATTERN05,
    D3DRENDERSTATE_STIPPLEPATTERN06,
    D3DRENDERSTATE_STIPPLEPATTERN07,
    D3DRENDERSTATE_STIPPLEPATTERN08,
    D3DRENDERSTATE_STIPPLEPATTERN09,
    D3DRENDERSTATE_STIPPLEPATTERN10,
    D3DRENDERSTATE_STIPPLEPATTERN11,
    D3DRENDERSTATE_STIPPLEPATTERN12,
    D3DRENDERSTATE_STIPPLEPATTERN13,
    D3DRENDERSTATE_STIPPLEPATTERN14,
    D3DRENDERSTATE_STIPPLEPATTERN15,
    D3DRENDERSTATE_STIPPLEPATTERN16,
    D3DRENDERSTATE_STIPPLEPATTERN17,
    D3DRENDERSTATE_STIPPLEPATTERN18,
    D3DRENDERSTATE_STIPPLEPATTERN19,
    D3DRENDERSTATE_STIPPLEPATTERN20,
    D3DRENDERSTATE_STIPPLEPATTERN21,
    D3DRENDERSTATE_STIPPLEPATTERN22,
    D3DRENDERSTATE_STIPPLEPATTERN23,
    D3DRENDERSTATE_STIPPLEPATTERN24,
    D3DRENDERSTATE_STIPPLEPATTERN25,
    D3DRENDERSTATE_STIPPLEPATTERN26,
    D3DRENDERSTATE_STIPPLEPATTERN27,
    D3DRENDERSTATE_STIPPLEPATTERN28,
    D3DRENDERSTATE_STIPPLEPATTERN29,
    D3DRENDERSTATE_STIPPLEPATTERN30,
    D3DRENDERSTATE_STIPPLEPATTERN31 ) ;

// #define D3DRENDERSTATE_STIPPLEPATTERN(y) (D3DRENDERSTATE_STIPPLEPATTERN00 + (y))

  D3DSTATE = record
    case Integer of
    0: (
      dtstTransformStateType: D3DTRANSFORMSTATETYPE ;
      dwArg: Array [ 0..0 ] of DWORD ;
      ) ;
    1: (
      dlstLightStateType: D3DLIGHTSTATETYPE ;
      dvArg: Array [ 0..0 ] of D3DVALUE ;
      ) ;
    2: (
      drstRenderStateType: D3DRENDERSTATETYPE ;
      ) ;
  end ;

(*
 * Operation used to load matrices
 * hDstMat = hSrcMat
 *)

  D3DMATRIXLOAD = record
    hDestMatrix: D3DMATRIXHANDLE ;   (* Destination matrix *)
    hSrcMatrix: D3DMATRIXHANDLE ;    (* Source matrix *)
  end ;

(*
 * Operation used to multiply matrices
 * hDstMat = hSrcMat1 * hSrcMat2
 *)

  D3DMATRIXMULTIPLY = record
    hDestMatrix: D3DMATRIXHANDLE ;   (* Destination matrix *)
    hSrcMatrix1: D3DMATRIXHANDLE ;   (* First source matrix *)
    hSrcMatrix2: D3DMATRIXHANDLE ;   (* Second source matrix *)
  end ;

(*
 * Operation used to transform and light vertices.
 *)

  D3DPROCESSVERTICES = record
  dwFlags: DWORD ;           (* Do we transform or light or just copy? *)
  wStart: WORD ;             (* Index to first vertex in source *)
  wDest: WORD ;              (* Index to first vertex in local buffer *)
  dwCount: DWORD ;           (* Number of vertices to be processed *)
  dwReserved: DWORD ;        (* Must be zero *)
  end ;

const
  D3DPROCESSVERTICES_TRANSFORMLIGHT       = $00000000 ;
  D3DPROCESSVERTICES_TRANSFORM            = $00000001 ;
  D3DPROCESSVERTICES_COPY                 = $00000002 ;
  D3DPROCESSVERTICES_OPMASK               = $00000007 ;

  D3DPROCESSVERTICES_UPDATEEXTENTS        = $00000008 ;
  D3DPROCESSVERTICES_NOCOLOR              = $00000010 ;

(*
 * Triangle flags
 *)

(*
 * Tri strip and fan flags.
 * START loads all three vertices
 * EVEN and ODD load just v3 with even or odd culling
 * START_FLAT contains a count from 0 to 29 that allows the
 * whole strip or fan to be culled in one hit.
 * e.g. for a quad len = 1
 *)

  D3DTRIFLAG_START                        = $00000000 ;
// #define D3DTRIFLAG_STARTFLAT(len) (len)         (* 0 < len < 30 *)
  D3DTRIFLAG_ODD                          = $0000001e ;
  D3DTRIFLAG_EVEN                         = $0000001f ;

(*
 * Triangle edge flags
 * enable edges for wireframe or antialiasing
 *)

  D3DTRIFLAG_EDGEENABLE1                  = $00000100 ; (* v0-v1 edge *)
  D3DTRIFLAG_EDGEENABLE2                  = $00000200 ; (* v1-v2 edge *)
  D3DTRIFLAG_EDGEENABLE3                  = $00000400 ; (* v2-v0 edge *)
  D3DTRIFLAG_EDGEENABLETRIANGLE = (
      D3DTRIFLAG_EDGEENABLE1 or D3DTRIFLAG_EDGEENABLE2 or D3DTRIFLAG_EDGEENABLE3 ) ;

(*
 * Primitive structures and related defines.  Vertex offsets are to types
 * D3DVERTEX, D3DLVERTEX, or D3DTLVERTEX.
 *)

(*
 * Triangle list primitive structure
 *)

type
  D3DTRIANGLE = record
    case Integer of
    0: (
      v1: WORD ;            (* Vertex indices *)
      v2: WORD ;
      v3: WORD ;
      wFlags: WORD ;        (* Edge (and other) flags *)
      ) ;
    1: (
      wV1: WORD ;
      wV2: WORD ;
      wV3: WORD ;
      ) ;
  end ;

(*
 * Line strip structure.
 * The instruction count - 1 defines the number of line segments.
 *)

  D3DLINE = record
    case Integer of
    0: (
      v1: WORD ;            (* Vertex indices *)
      v2: WORD ;
      ) ;
    1: (
      wV1: WORD ;
      wV2: WORD ;
      ) ;
  end ;

(*
 * Span structure
 * Spans join a list of points with the same y value.
 * If the y value changes, a new span is started.
 *)

  D3DSPAN = record
    wCount: WORD ;        (* Number of spans *)
    wFirst: WORD ;        (* Index to first vertex *)
  end ;

(*
 * Point structure
 *)

  D3DPOINT = record
    wCount: WORD ;        (* number of points         *)
    wFirst: WORD ;        (* index to first vertex    *)
  end ;

(*
 * Forward branch structure.
 * Mask is logically anded with the driver status mask
 * if the result equals 'value', the branch is taken.
 *)

  D3DBRANCH = record
    dwMask: DWORD ;         (* Bitmask against D3D status *)
    dwValue: DWORD ;
    bNegate: BOOL ;         (* TRUE to negate comparison *)
    dwOffset: DWORD ;       (* How far to branch forward (0 for exit)*)
  end ;

(*
 * Status used for set status instruction.
 * The D3D status is initialised on device creation
 * and is modified by all execute calls.
 *)

  D3DSTATUS = record
    dwFlags: DWORD ;        (* Do we set extents or status *)
    dwStatus: DWORD ;       (* D3D status *)
    drExtent: D3DRECT ;
  end ;

const
  D3DSETSTATUS_STATUS   = $00000001 ;
  D3DSETSTATUS_EXTENTS  = $00000002 ;
  D3DSETSTATUS_ALL      = ( D3DSETSTATUS_STATUS or D3DSETSTATUS_EXTENTS ) ;

(*
 * Statistics structure
 *)

type
  D3DSTATS = record
    dwSize: DWORD ;
    dwTrianglesDrawn: DWORD ;
    dwLinesDrawn: DWORD ;
    dwPointsDrawn: DWORD ;
    dwSpansDrawn: DWORD ;
    dwVerticesProcessed: DWORD ;
  end ;

(*
 * Execute options.
 * When calling using D3DEXECUTE_UNCLIPPED all the primitives
 * inside the buffer must be contained within the viewport.
 *)

const
  D3DEXECUTE_CLIPPED       = $00000001 ;
  D3DEXECUTE_UNCLIPPED     = $00000002 ;

type
  D3DEXECUTEDATA = record
    dwSize: DWORD ;
    dwVertexOffset: DWORD ;
    dwVertexCount: DWORD ;
    dwInstructionOffset: DWORD ;
    dwInstructionLength: DWORD ;
    dwHVertexOffset: DWORD ;
    dsStatus: D3DSTATUS ;       (* Status after execute *)
  end ;

(*
 * Palette flags.
 * This are or'ed with the peFlags in the PALETTEENTRYs passed to DirectDraw.
 *)

const
  D3DPAL_FREE     = $00 ;    (* Renderer may use this entry freely *)
  D3DPAL_READONLY = $40 ;    (* Renderer may not set this entry *)
  D3DPAL_RESERVED = $80 ;    (* Renderer may not use this entry *)

implementation

end.

