unit dplay ;

interface

uses OLE2, Windows, D3DCaps ;

(*==========================================================================;
 *
 *  Copyright (C) 1994-1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dplay.h
 *  Content:    DirectPlay include file
 *
 *  DirectX 3 Delphi adaptation by Blake Stone
 *
 *    EMail:     bstone@dkw.com
 *    Home Page: http://www.dkw.com/bstone
 *
 ***************************************************************************)

{$Z4}
{$A+}

// #define _FACDP  0x877
// #define MAKE_DPHRESULT( code )    MAKE_HRESULT( 1, _FACDP, code )

(*
 * GUIDS used by DirectPlay objects
 *)
const
  IID_IDirectPlay: TGUID = ( D1:$5454e9a0;D2:$db65;D3:$11ce;D4:($92,$1c,$00,$aa,$00,$6c,$49,$72)) ;
  IID_IDirectPlay2: TGUID = ( D1:$2b74f7c0;D2:$9154;D3:$11cf;D4:($a9,$cd,$00,$aa,$00,$68,$86,$e3)) ;
  IID_IDirectPlay2A: TGUID = ( D1:$9d460580;D2:$a822;D3:$11cf;D4:($96,$0c,$00,$80,$c7,$53,$4e,$82)) ;

(*
 * This flag is set on the EnumSessions callback dwFlags parameter when
 * the time out has occurred. There will be no session data for this
 * callback. If *lpdwTimeOut is set to a non-zero value and the
 * EnumSessionsCallback function returns TRUE then EnumSessions will
 * continue waiting until the next timeout occurs. Timeouts are in
 * milliseconds.
 *)

  DPESC_TIMEDOUT          = $00000001 ;

(****************************************************************************
 *
 * DirectPlay Structures
 *
 * Various structures used to invoke DirectPlay.
 *
 ****************************************************************************)

type
  IDirectPlay2 = class ;
//  IDirectPlay2A = class ;

(*
 * DPID
 * DirectPlay player and group ID
 *)

  DPID = DWORD ;
//  LPDPID = ^DPID ;

(*
 * DPCAPS
 * Used to obtain the capabilities of a DirectPlay object
 *)

  DPCAPS = record
    dwSize: DWORD ;             // Size of structure, in bytes
    dwFlags: DWORD ;            // DPCAPS_xxx flags
    dwMaxBufferSize: DWORD ;    // Maximum message size, in bytes,  for this service provider
    dwMaxQueueSize: DWORD ;     // Obsolete.
    dwMaxPlayers: DWORD ;       // Maximum players/groups (local + remote)
    dwHundredBaud: DWORD ;      // Bandwidth in 100 bits per second units;
                                // i.e. 24 is 2400, 96 is 9600, etc.
    dwLatency: DWORD ;          // Estimated latency; 0 = unknown
    dwMaxLocalPlayers: DWORD ;  // Maximum # of locally created players allowed
    dwHeaderLength: DWORD ;     // Maximum header length, in bytes, on messages
                                // added by the service provider
    dwTimeout: DWORD ;          // Service provider's suggested timeout value
                                // This is how long DirectPlay will wait for
                                // responses to system messages
  end ;
//  LPDPCAPS = ^DPCAPS ;

(*
 * DPSESSIONDESC2
 * Used to describe the properties of a DirectPlay
 * session instance
 *)
  DPSESSIONDESC2 = record
    dwSize: DWORD ;             // Size of structure
    dwFlags: DWORD ;            // DPSESSION_xxx flags
    guidInstance: TGUID ;       // ID for the session instance
    guidApplication: TGUID ;    // GUID of the DirectPlay application.
                                // GUID_NULL for all applications.
    dwMaxPlayers: DWORD ;       // Maximum # players allowed in session
    dwCurrentPlayers: DWORD ;   // Current # players in session (read only)
    lpszSessionNameA: PChar ;   // Name of the session
    lpszPasswordA: PChar ;      // Password of the session (optional)
    dwReserved1: DWORD ;        // Reserved for future MS use.
    dwReserved2: DWORD ;
    dwUser1: DWORD ;            // For use by the application
    dwUser2: DWORD ;
    dwUser3: DWORD ;
    dwUser4: DWORD ;
  end ;
//  LPDPSESSIONDESC2 = ^DPSESSIONDESC2 ;

(*
 * LPCDPSESSIONDESC2
 * A constant pointer to DPSESSIONDESC2
 *)
// typedef const DPSESSIONDESC2 FAR *LPCDPSESSIONDESC2;

(*
 * DPNAME
 * Used to hold the name of a DirectPlay entity
 * like a player or a group
 *)

  DPNAME = record
    dwSize: DWORD ;             // Size of structure
    dwFlags: DWORD ;            // Not used. Must be zero.
    lpszShortName: LPSTR ;      // The short or friendly name
    lpszLongName: LPSTR ;       // The long or formal name
  end ;
//  LPDPNAME = ^DPNAME ;

(*
 * LPCDPNAME
 * A constant pointer to DPNAME
 *)
// typedef const DPNAME FAR *LPCDPNAME;


(****************************************************************************
 *
 * Prototypes for DirectPlay callback functions
 *
 ****************************************************************************)

(*
 * Callback for IDirectPlay2::EnumSessions
 *)
  LPDPENUMSESSIONSCALLBACK2 = function ( const lpThisSD: DPSESSIONDESC2 ;
      var lpdwTimeOut: DWORD ; dwFlags: DWORD ; lpContext: Pointer ): BOOL ;
      stdcall ;


(*
 * Callback for IDirectPlay2::EnumPlayers
 *              IDirectPlay2::EnumGroups
 *              IDirectPlay2::EnumGroupPlayers
 *)

  LPDPENUMPLAYERSCALLBACK2 = function ( dpId: DPID ; dwPlayerType: DWORD ;
      const lpName: DPNAME ; dwFlags: DWORD ; lpContext: Pointer ): BOOL ;
      stdcall ;

(*
 * Unicode callback for DirectPlayEnumerate
 * This callback prototype will be used if compiling
 * for Unicode strings
 *
 * BWS: Unicode version dropped during conversion
 *)
//  LPDPENUMDPCALLBACK = function ( var lpguidSP: GUID ; lpSPName: LPWSTR ;
//      dwMajorVersion, dwMinorVersion: DWORD ; lpContext: Pointer ): BOOL ;
//      stdcall ;

(*
 * ANSI callback for DirectPlayEnumerate
 * This callback prototype will be used if compiling
 * for ANSI strings
 *)
  LPDPENUMDPCALLBACK = function ( var lpguidSP: TGUID ; lpSPName: LPSTR ;
      dwMajorVersion, dwMinorVersion: DWORD ; lpContext: Pointer ): BOOL ;
      stdcall ;

(****************************************************************************
 *
 * IDirectPlay2 (and IDirectPlay2A) Interface
 *
 ****************************************************************************)

  IDirectPlay2 = class ( IUnknown )
    (*** IDirectPlay2 methods ***)
    function AddPlayerToGroup ( idGroup: DPID ; idPlayer: DPID ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Close: HRESULT ; virtual ; stdcall ; abstract ;
    function CreateGroup ( var lpidGroup: DPID ; var lpGroupName: DPNAME ;
        lpData: Pointer ; dwDataSize, dwFlags: DWORD ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function CreatePlayer ( var  lpidPlayer: DPID ; var lpPlayerName: DPNAME ;
        hEvent: THANDLE ; lpData: Pointer ; dwDataSize, dwFlags: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function DeletePlayerFromGroup ( idGroup: DPID ; idPlayer: DPID): HRESULT ;
        virtual ; stdcall ; abstract ;
    function DestroyGroup ( idGroup: DPID ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function DestroyPlayer ( idPlayer: DPID ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function EnumGroupPlayers ( idGroup: DPID ; lpguidInstance: PGUID ;
        lpEnumPlayersCallback2: LPDPENUMPLAYERSCALLBACK2 ; lpContext: Pointer ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function EnumGroups ( lpguidInstance: PGUID ; lpEnumPlayersCallback2:
        LPDPENUMPLAYERSCALLBACK2 ; lpContext: Pointer ; dwFlags: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function EnumPlayers ( lpguidInstance: PGUID ; lpEnumPlayersCallback2:
        LPDPENUMPLAYERSCALLBACK2 ; lpContext: Pointer ; dwFlags: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function EnumSessions ( var lpsd: DPSESSIONDESC2 ; dwTimeout: DWORD ;
        lpEnumSessionsCallback2: LPDPENUMSESSIONSCALLBACK2 ; lpContext: Pointer ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetCaps ( var lpDPCaps: DPCAPS ; dwFlags: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetGroupData ( idGroup: DPID ; lpData: Pointer ;
        var lpdwDataSize: DWORD ; dwFlags: DWORD ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetGroupName ( idGroup: DPID ; lpData: Pointer ;
        var lpdwDataSize: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetMessageCount ( idPlayer: DPID ; var lpdwCount: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function GetPlayerAddress ( idPlayer: DPID ; lpAddress: Pointer ;
        var lpdwAddressSize: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetPlayerCaps ( idPlayer: DPID ; var lpPlayerCaps: DPCAPS ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetPlayerData ( idPlayer: DPID ; lpData: Pointer ;
        var lpdwDataSize: DWORD ; dwFlags: DWORD ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function GetPlayerName ( idPlayer: DPID ; lpData: Pointer ;
        var lpdwDataSize: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetSessionDesc ( lpData: Pointer ; var lpdwDataSize: DWORD ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function Initialize ( lpGUID: PGUID ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Open ( var lpsd: DPSESSIONDESC2 ; dwFlags: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Receive ( var lpidFrom, lpidTo: DPID ; dwFlags: DWORD ;
        lpData: Pointer ; var lpdwDataSize: DWORD ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Send ( idFrom, idTo: DPID ; dwFlags: DWORD ; lpData: Pointer ;
        dwDataSize: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetGroupData ( idGroup: DPID ; lpData: Pointer ;
        dwDataSize: DWORD ; dwFlags: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetGroupName ( idGroup: DPID ; var lpGroupName: DPNAME ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetPlayerData ( idPlayer: DPID ; lpData: Pointer ; dwDataSize,
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetPlayerName ( idPlayer: DPID ; var lpPlayerName: DPNAME ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function SetSessionDesc ( var lpSessDesc: DPSESSIONDESC2 ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
  end ;

(*
 * DPID that system messages come from
 *)

const
  DPID_SYSMSG         = 0 ;

(*
 * DPID representing all players in the session
 *)

  DPID_ALLPLAYERS     = 0 ;

(*
 * This DirectPlay object is the session host.  If the host exits the
 * session, another application will become the host and receive a
 * DPSYS_HOST system message.
 *)
  DPCAPS_ISHOST               = $00000002 ;

(*
 * The service provider bound to this DirectPlay object can optimize
 * group messaging.
 *)
  DPCAPS_GROUPOPTIMIZED       = $00000008 ;

(*
 * The service provider bound to this DirectPlay object can optimize
 * keep alives (see DPSESSION_KEEPALIVE)
 *)
  DPCAPS_KEEPALIVEOPTIMIZED   = $00000010 ;

(*
 * The service provider bound to this DirectPlay object can optimize
 * guaranteed message delivery.
 *)
  DPCAPS_GUARANTEEDOPTIMIZED  = $00000020 ;

(*
 * This DirectPlay object supports guaranteed message delivery.
 *)
  DPCAPS_GUARANTEEDSUPPORTED  = $00000040 ;

(*
 * Applications cannot create new players in this session.
 *)
  DPSESSION_NEWPLAYERSDISABLED    = $00000001 ;

(*
 * If the DirectPlay object that created the session, the host,
 * quits, then the host will attempt to migrate to another
 * DirectPlay object so that new players can continue to be created
 * and new applications can join the session.
 *)
  DPSESSION_MIGRATEHOST           = $00000004 ;

(*
 * This flag tells DirectPlay not to set the idPlayerTo and idPlayerFrom
 * fields in player messages.  This cuts two DWORD's off the message
 * overhead.
 *)
  DPSESSION_NOMESSAGEID           = $00000008 ;


(*
 * This flag tells DirectPlay to not allow any new applications to
 * join the session.  Applications already in the session can still
 * create new players.
 *)
  DPSESSION_JOINDISABLED          = $00000020 ;

(*
 * This flag tells DirectPlay to detect when remote players
 * exit abnormally (e.g. their computer or modem gets unplugged)
 *)
  DPSESSION_KEEPALIVE             = $00000040 ;

(*
 * This flag tells DirectPlay not to send a message to all players
 *      when a players remote data changes
 *)
  DPSESSION_NODATAMESSAGES        = $00000080 ;

 (****************************************************************************
 *
 * EnumPlayers API flags
 *
 ****************************************************************************)

(*
 * Enumerate all players in the current session
 *)
  DPENUMPLAYERS_ALL           = $00000000 ;

(*
 * Enumerate only local (created by this application) players
 *)
  DPENUMPLAYERS_LOCAL         = $00000008 ;

(*
 * Enumerate only remote (non-local) players
 *)
  DPENUMPLAYERS_REMOTE        = $00000010 ;

(*
 * Enumerate groups along with the players
 *)
  DPENUMPLAYERS_GROUP         = $00000020 ;

(*
 * Enumerate players in another session (must supply lpguidInstance)
 *)
  DPENUMPLAYERS_SESSION       = $00000080 ;


(****************************************************************************
 *
 * EnumSessions API flags
 *
 ****************************************************************************)

(*
 * Enumerate sessions which can be joined
 *)
  DPENUMSESSIONS_AVAILABLE    = $00000001 ;

(*
 * Enumerate all sessions even if they can't be joined.
 *)
  DPENUMSESSIONS_ALL          = $00000002 ;


(****************************************************************************
 *
 * GetCaps and GetPlayerCaps API flags
 *
 ****************************************************************************)

(*
 * The latency returned should be for guaranteed message sending.
 * Default is non-guaranteed messaging.
 *)
  DPGETCAPS_GUARANTEED        = $00000001 ;


(****************************************************************************
 *
 * GetGroupData, GetPlayerData API flags
 * Remote and local Group/Player data is maintained separately.
 * Default is DPGET_REMOTE.
 *
 ****************************************************************************)

(*
 * Get the remote data (set by any DirectPlay object in
 * the session using DPSET_REMOTE)
 *)
  DPGET_REMOTE                = $00000000 ;

(*
 * Get the local data (set by this DirectPlay object
 * using DPSET_LOCAL)
 *)
  DPGET_LOCAL                 = $00000001 ;


(****************************************************************************
 *
 * Open API flags
 *
 ****************************************************************************)

(*
 * Join the session that is described by the DPSESSIONDESC2 structure
 *)
  DPOPEN_JOIN                 = $00000001 ;

(*
 * Create a new session as described by the DPSESSIONDESC2 structure
 *)
  DPOPEN_CREATE               = $00000002 ;

(****************************************************************************
 *
 * Receive API flags
 * Default is DPRECEIVE_ALL
 *
 ****************************************************************************)

(*
 * Get the first message in the queue
 *)
  DPRECEIVE_ALL               = $00000001 ;

(*
 * Get the first message in the queue directed to a specific player
 *)
  DPRECEIVE_TOPLAYER          = $00000002 ;

(*
 * Get the first message in the queue from a specific player
 *)
  DPRECEIVE_FROMPLAYER        = $00000004 ;

(*
 * Get the message but don't remove it from the queue
 *)
  DPRECEIVE_PEEK              = $00000008 ;


(****************************************************************************
 *
 * Send API flags
 *
 ****************************************************************************)

(*
 * Send the message using a guaranteed send method.
 * Default is non-guaranteed.
 *)
  DPSEND_GUARANTEED           = $00000001 ;

(*
 * Send the message high-priority. Move to front of
 * send queue of sender and the receive queue of the
 * receipient
 *)
  DPSEND_HIGHPRIORITY         = $00000002 ;

(*
 * Application will be sending several more guaranteed messages to
 * this player so the service provider may want to optimize for this.
 * Implementation of this flag by a service provider is optional.
 *)
  DPSEND_OPENSTREAM           = $00000008 ;

(*
 * The optimization requested by DPSEND_OPENSTREAM is no longer
 * needed.  Resources allocated for DPSEND_OPENSTREAM may be released.
 *)
  DPSEND_CLOSESTREAM          = $00000010 ;


(****************************************************************************
 *
 * SetGroupData, SetGroupName, SetPlayerData, SetPlayerName,
 * SetSessionDesc API flags.
 * Default is DPSET_REMOTE.
 *
 ****************************************************************************)

(* 
 * Propagate the data to all players in the session
 *)
  DPSET_REMOTE                = $00000000 ;

(*
 * Do not propagate the data to other players
 *)
  DPSET_LOCAL                 = $00000001 ;

(*
 * Used with DPSET_REMOTE, use guaranteed message send to
 * propagate the data
 *)
  DPSET_GUARANTEED            = $00000002 ;


(****************************************************************************
 *
 * DirectPlay system messages and message data structures
 *
 * All system message come 'From' player DPID_SYSMSG.  To determine what type 
 * of message it is, cast the lpData from Receive to DPMSG_GENERIC and check
 * the dwType member against one of the following DPSYS_xxx constants. Once
 * a match is found, cast the lpData to the corresponding of the DPMSG_xxx
 * structures to access the data of the message.
 *
 ****************************************************************************)

(*
 * A new player or group has been created in the session
 * Use DPMSG_CREATEPLAYERORGROUP.  Check dwPlayerType to see if it
 * is a player or a group.
 *)
  DPSYS_CREATEPLAYERORGROUP   = $0003 ;  

(*
 * A player has been deleted from the session
 * Use DPMSG_DESTROYPLAYERORGROUP
 *)
  DPSYS_DESTROYPLAYERORGROUP  = $0005 ;  

(*
 * A player has been added to a group
 * Use DPMSG_ADDPLAYERTOGROUP
 *)
  DPSYS_ADDPLAYERTOGROUP      = $0007 ;  

(*
 * A player has been removed from a group
 * Use DPMSG_DELETEPLAYERFROMGROUP
 *)
  DPSYS_DELETEPLAYERFROMGROUP = $0021 ;  

(*
 * This DirectPlay object lost its connection with all the
 * other players in the session.
 * Use DPMSG_SESSIONLOST.
 *)
  DPSYS_SESSIONLOST           = $0031 ;

(*
 * The current host has left the session.
 * This DirectPlay object is now the host.
 * Use DPMSG_HOST.
 *)
  DPSYS_HOST                  = $0101 ;

(*
 * The remote data associated with a player or
 * group has changed. Check dwPlayerType to see
 * if it is a player or a group
 * Use DPMSG_SETPLAYERORGROUPDATA
 *)
  DPSYS_SETPLAYERORGROUPDATA  = $0102 ;

(*
 * The name of a player or group has changed.
 * Check dwPlayerType to see if it is a player
 * or a group.
 * Use DPMSG_SETPLAYERORGROUPNAME
 *)
  DPSYS_SETPLAYERORGROUPNAME  = $0103 ;

(*
 * Used in the dwPlayerType field to indicate if it applies to a group
 * or a player
 *)
  DPPLAYERTYPE_GROUP          = $00000000 ;
  DPPLAYERTYPE_PLAYER         = $00000001 ;

(*
 * DPMSG_GENERIC
 * Generic message structure used to identify the message type.
 *)
type
  DPMSG_GENERIC = record
    dwType: DWORD ;             // Message type
  end ;
//  LPDPMSG_GENERIC = ^DPMSG_GENERIC ;

(*
 * DPMSG_CREATEPLAYERORGROUP
 * System message generated when a new player or group
 * created in the session with information about it.
 *)
  DPMSG_CREATEPLAYERORGROUP = record
    dwType: DWORD ;             // Message type
    dwPlayerType: DWORD ;       // Is it a player or group
    dpId: DPID ;                // ID of the player or group
    dwCurrentPlayers: DWORD ;   // current # players & groups in session
    lpData: Pointer ;           // pointer to remote data
    dwDataSize: DWORD ;         // size of remote data
    dpnName: DPNAME ;           // structure with name info
  end ;
//  LPDPMSG_CREATEPLAYERORGROUP = ^DPMSG_CREATEPLAYERORGROUP ;

(*
 * DPMSG_DESTROYPLAYERORGROUP
 * System message generated when a player or group is being
 * destroyed in the session with information about it.
 *)
  DPMSG_DESTROYPLAYERORGROUP = record
    dwType: DWORD ;             // Message type
    dwPlayerType: DWORD ;       // Is it a player or group
    dpId: DPID ;                // player ID being deleted
    lpLocalData: Pointer ;      // copy of players local data
    dwLocalDataSize: DWORD ;    // sizeof local data
    lpRemoteData: Pointer ;     // copy of players remote data
    dwRemoteDataSize: DWORD ;   // sizeof remote data
  end ;
//  LPDPMSG_DESTROYPLAYERORGROUP = ^DPMSG_DESTROYPLAYERORGROUP ;

(*
 * DPMSG_ADDPLAYERTOGROUP
 * System message generated when a player is being added
 * to a group.
 *)
  DPMSG_ADDPLAYERTOGROUP = record
    dwType: DWORD ;             // Message type
    dpIdGroup: DPID ;           // group ID being added to
    dpIdPlayer: DPID ;          // player ID being added
  end ;
//  LPDPMSG_ADDPLAYERTOGROUP = ^DPMSG_ADDPLAYERTOGROUP ;

(*
 * DPMSG_DELETEPLAYERFROMGROUP
 * System message generated when a player is being
 * removed from a group
 *)
  DPMSG_DELETEPLAYERFROMGROUP = DPMSG_ADDPLAYERTOGROUP ;
  LPDPMSG_DELETEPLAYERFROMGROUP = ^DPMSG_DELETEPLAYERFROMGROUP ;

(*
 * DPMSG_SETPLAYERORGROUPDATA
 * System message generated when remote data for a player or
 * group has changed.
 *)
  DPMSG_SETPLAYERORGROUPDATA = record
    dwType: DWORD ;             // Message type
    dwPlayerType: DWORD ;       // Is it a player or group
    dpId: DPID ;                // ID of player or group
    lpData: Pointer ;           // pointer to remote data
    dwDataSize: DWORD ;         // size of remote data
  end ;
//  LPDPMSG_SETPLAYERORGROUPDATA = ^DPMSG_SETPLAYERORGROUPDATA ;

(*
 * DPMSG_SETPLAYERORGROUPNAME
 * System message generated when the name of a player or
 * group has changed.
 *)
  DPMSG_SETPLAYERORGROUPNAME = record
    dwType: DWORD ;             // Message type
    dwPlayerType: DWORD ;       // Is it a player or group
    dpId: DPID ;                // ID of player or group
    dpnName: DPNAME ;           // structure with new name info
  end ;
//  LPDPMSG_SETPLAYERORGROUPNAME = ^DPMSG_SETPLAYERORGROUPNAME ;

(*
 * DPMSG_HOST
 * System message generated when the host has migrated to this
 * DirectPlay object.
 *
 *)
  DPMSG_HOST = DPMSG_GENERIC ;
//  LPDPMSG_HOST = ^DPMSG_HOST ;

(*
 * DPMSG_SESSIONLOST
 * System message generated when the connection to the session is lost.
 *
 *)
  DPMSG_SESSIONLOST = DPMSG_GENERIC ;
//  LPDPMSG_SESSIONLOST = ^DPMSG_SESSIONLOST ;

(****************************************************************************
 *
 * DIRECTPLAY ERRORS
 *
 * Errors are represented by negative values and cannot be combined.
 *
 ****************************************************************************)

const
  DP_OK                           = S_OK ;
  DPERR_ALREADYINITIALIZED        = $88770000 + 5 ;
  DPERR_ACCESSDENIED              = $88770000 + 10 ;
  DPERR_ACTIVEPLAYERS             = $88770000 + 20 ;
  DPERR_BUFFERTOOSMALL            = $88770000 + 30 ;
  DPERR_CANTADDPLAYER             = $88770000 + 40 ;
  DPERR_CANTCREATEGROUP           = $88770000 + 50 ;
  DPERR_CANTCREATEPLAYER          = $88770000 + 60 ;
  DPERR_CANTCREATESESSION         = $88770000 + 70 ;
  DPERR_CAPSNOTAVAILABLEYET       = $88770000 + 80 ;
  DPERR_EXCEPTION                 = $88770000 + 90 ;
  DPERR_GENERIC                   = E_FAIL ;
  DPERR_INVALIDFLAGS              = $88770000 + 120 ;
  DPERR_INVALIDOBJECT             = $88770000 + 130 ;
  DPERR_INVALIDPARAM              = E_INVALIDARG ;
  DPERR_INVALIDPARAMS             = DPERR_INVALIDPARAM ;
  DPERR_INVALIDPLAYER             = $88770000 + 150 ;
  DPERR_NOCAPS                    = $88770000 + 160 ;
  DPERR_NOCONNECTION              = $88770000 + 170 ;
  DPERR_NOMEMORY                  = E_OUTOFMEMORY ;
  DPERR_OUTOFMEMORY               = DPERR_NOMEMORY ;
  DPERR_NOMESSAGES                = $88770000 + 190 ;
  DPERR_NONAMESERVERFOUND         = $88770000 + 200 ;
  DPERR_NOPLAYERS                 = $88770000 + 210 ;
  DPERR_NOSESSIONS                = $88770000 + 220 ;
  DPERR_SENDTOOBIG                = $88770000 + 230 ;
  DPERR_TIMEOUT                   = $88770000 + 240 ;
  DPERR_UNAVAILABLE               = $88770000 + 250 ;
  DPERR_UNSUPPORTED               = E_NOTIMPL ;
  DPERR_BUSY                      = $88770000 + 270 ;
  DPERR_USERCANCEL                = $88770000 + 280 ;
  DPERR_NOINTERFACE               = E_NOINTERFACE ;
  DPERR_CANNOTCREATESERVER        = $88770000 + 290 ;
  DPERR_PLAYERLOST                = $88770000 + 300 ;
  DPERR_SESSIONLOST               = $88770000 + 310 ;

  DPERR_BUFFERTOOLARGE            = $88770000 + 1000 ;
  DPERR_CANTCREATEPROCESS         = $88770000 + 1010 ;
  DPERR_APPNOTSTARTED             = $88770000 + 1020 ;
  DPERR_INVALIDINTERFACE          = $88770000 + 1030 ;
  DPERR_NOSERVICEPROVIDER         = $88770000 + 1040 ;
  DPERR_UNKNOWNAPPLICATION        = $88770000 + 1050 ;
  DPERR_NOTLOBBIED                = $88770000 + 1070 ;


(****************************************************************************
 *
 *      dplay 1.0 obsolete structures + interfaces
 *      Included for compatibility only. New apps should
 *      use IDirectPlay2
 *
 ****************************************************************************)

  DPOPEN_OPENSESSION          = DPOPEN_JOIN ;
  DPOPEN_CREATESESSION        = DPOPEN_CREATE ;

  DPENUMSESSIONS_PREVIOUS     = $00000004 ;

  DPENUMPLAYERS_PREVIOUS      = $00000004 ;

  DPSEND_GUARANTEE            = DPSEND_GUARANTEED ;
  DPSEND_TRYONCE              = $00000004 ;

  DPCAPS_NAMESERVICE          = $00000001 ;
  DPCAPS_NAMESERVER           = DPCAPS_ISHOST ;
  DPCAPS_GUARANTEED           = $00000004 ;

  DPLONGNAMELEN               = 52 ;
  DPSHORTNAMELEN              = 20 ;
  DPSESSIONNAMELEN            = 32 ;
  DPPASSWORDLEN               = 16 ;
  DPUSERRESERVED              = 16 ;

  DPSYS_ADDPLAYER             = $0003 ;
  DPSYS_DELETEPLAYER          = $0005 ;

  DPSYS_DELETEGROUP           = $0020 ;
  DPSYS_DELETEPLAYERFROMGRP   = $0021 ;
  DPSYS_CONNECT               = $484b ;

type
  IDirectPlay = class ;

  DPMSG_ADDPLAYER = record
    dwType: DWORD ;
    dwPlayerType: DWORD ;
    dpId: DPID ;
    szLongName: Array [ 0..DPLONGNAMELEN-1 ] of char ;
    szShortName: Array [ 0..DPSHORTNAMELEN-1 ] of char ;
    dwCurrentPlayers: DWORD ;
  end ;
  DPMSG_ADDGROUP = DPMSG_ADDPLAYER ;

  DPMSG_GROUPADD = record
    dwType: DWORD ;
    dpIdGroup: DPID ;
    dpIdPlayer: DPID ;
  end ;
  DPMSG_GROUPDELETE = DPMSG_GROUPADD ;

  DPMSG_DELETEPLAYER = record
    dwType: DWORD ;
    dpId: DPID ;
  end ;

  LPDPENUMPLAYERSCALLBACK = function ( dpId: DPID ; lpFriendlyName: PChar ;
      lpFormalName: PChar ; dwFlags: DWORD ; lpContext: Pointer ): BOOL ;
      stdcall ;

  DPSESSIONDESC = record
    dwSize: DWORD ;
    guidSession: TGUID ;
    dwSession: DWORD ;
    dwMaxPlayers: DWORD ;
    dwCurrentPlayers: DWORD ;
    dwFlags: DWORD ;
    szSessionName: Array [ 0..DPSESSIONNAMELEN-1 ] of char ;
    szUserField: Array [ 0..DPUSERRESERVED-1 ] of char ;
    dwReserved1: DWORD ;
    szPassword: Array [ 0..DPPASSWORDLEN-1 ] of char ;
    dwReserved2: DWORD ;
    dwUser1: DWORD ;
    dwUser2: DWORD ;
    dwUser3: DWORD ;
    dwUser4: DWORD ;
  end ;
//  LPDPSESSIONDESC = ^DPSESSIONDESC ;

  LPDPENUMSESSIONSCALLBACK = function ( var lpDPSessionDesc: DPSESSIONDESC ;
      lpContext: Pointer ; var lpdwTimeOut: DWORD ; dwFlags: DWORD ): BOOL ;
      stdcall ;

(*
 * IDirectPlay
 *)
  IDirectPlay = class ( IUnknown )
    (*** IDirectPlay methods ***)
    function AddPlayerToGroup ( pidGroup: DPID ; pidPlayer: DPID ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function Close: HRESULT ; virtual ; stdcall ; abstract ;
    function CreatePlayer ( var lppidID: DPID ; lpPlayerFriendlyName: LPSTR ;
        lpPlayerFormalName: LPSTR ; lpEvent: PHandle ): HRESULT ; virtual ;
            stdcall ; abstract ;
    function CreateGroup ( var lppidID: DPID ; lpGroupFriendlyName: LPSTR ;
        lpGroupFormalName: LPSTR ): HRESULT ; virtual ; stdcall ; abstract ;
    function DeletePlayerFromGroup ( pidGroup: DPID ; pidPlayer: DPID):
        HRESULT ; virtual ; stdcall ; abstract ;
    function DestroyPlayer ( pidID: DPID ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function DestroyGroup ( pidID: DPID ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function EnableNewPlayers ( bEnable: BOOL ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function EnumGroupPlayers ( pidGroupPID: DPID ;
        lpEnumPlayersCallback: LPDPENUMPLAYERSCALLBACK ;
        lpContext: Pointer ; dwFlags: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function EnumGroups ( dwSessionID: DWORD ;
        lpEnumPlayersCallback: LPDPENUMPLAYERSCALLBACK ; lpContext: Pointer ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function EnumPlayers ( dwSessionId: DWORD ;
        lpEnumPlayersCallback: LPDPENUMPLAYERSCALLBACK ; lpContext: Pointer ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function EnumSessions ( const lpSDesc: DPSESSIONDESC ; dwTimeout: DWORD ;
        lpEnumSessionsCallback: LPDPENUMSESSIONSCALLBACK ; lpContext: Pointer ;
        dwFlags: DWORD ): HRESULT ; virtual ; stdcall ; abstract ;
    function GetCaps ( const lpDPCaps: DPCAPS ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function GetMessageCount ( pidID: DPID ; var lpdwCount: DWORD ): HRESULT ;
        virtual ; stdcall ; abstract ;
    function GetPlayerCaps ( pidID: DPID ; const lpDPPlayerCaps: DPCAPS ):
        HRESULT ; virtual ; stdcall ; abstract ;
    function GetPlayerName ( pidID: DPID ; lpPlayerFriendlyName: LPSTR ;
        var lpdwFriendlyNameLength: DWORD ; lpPlayerFormalName: LPSTR ;
        var lpdwFormalNameLength: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Initialize ( lpGUID: PGUID ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function Open ( const lpSDesc: DPSESSIONDESC ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Receive ( var lppidFrom, lppidTo: DPID ; dwFlags: DWORD ;
        lpvBuffer: Pointer ; var lpdwSize: DWORD ): HRESULT ; virtual ;
        stdcall ; abstract ;
    (*** Warning!  SaveSession is defined differently in the header files
         and the online documentation ***)
    function SaveSession ( lpSessionName: LPSTR ): HRESULT ; virtual ;
        stdcall ; abstract ;
    function Send ( pidFrom: DPID ; pidTo: DPID ; dwFlags: DWORD ;
        lpvBuffer: Pointer ; dwBuffSize: DWORD ): HRESULT ; virtual ; stdcall ;
        abstract ;
    function SetPlayerName ( pidID: DPID ; lpPlayerFriendlyName: LPSTR ;
        lpPlayerFormalName: LPSTR ): HRESULT ; virtual ; stdcall ; abstract ;
  end ;

(*
 * API's
 *)

function DirectPlayEnumerate ( lpEnumDPCallback: LPDPENUMDPCALLBACK ;
    lpContext: Pointer ): HRESULT ; stdcall ;
function DirectPlayCreate ( lpGUID: PGUID ; var lplpDP: IDirectPlay ;
    pUnk: IUnknown ): HRESULT ; stdcall ;

implementation

function DirectPlayEnumerate ; external 'DPLAYX.DLL' name 'DirectPlayEnumerateA' ;
function DirectPlayCreate ; external 'DPLAYX.DLL' ;

end.

