unit Counter;

interface

uses
  Windows, SysUtils, DKWHTTP, HTTPExt, GIFUtils ;

type
{$IFDEF ISAPI}
  TWebCounter = class ( TISAPIExtension )
{$ENDIF}
{$IFDEF CGI}
  TWebCounter = class ( TCGIExtension )
{$ENDIF}
  private
    procedure MakeGIFCounter ( Text: String ) ;
  public
    class function Description: String ; override ;
    procedure Get ; override ;
  end ;


implementation

{ WebCounter description }

class function TWebCounter.Description: String ;
begin
  Result := 'Web Usage Counter is an ISAPI Extension developed ' +
      'using DKW''s Delphi Internet framework' ;
end ;

{ WebCounter 'GET' implementation }

procedure TWebCounter.Get ;
var
  FileHandle: THANDLE ;
  Written, Read: Integer ;
  HTTPHeader: String ;
  szCountFile: Array [ 0..255 ] of Char ;
  Counter: Integer ;
begin

  { Create a filename from the CGI request }

  StrPCopy ( szCountFile, ServerVariable ( 'QUERY_STRING' )  + '.ctr' ) ;

  { Read and update the current counter value }

  FileHandle := CreateFile ( szCountFile, GENERIC_READ or GENERIC_WRITE,
      0, nil, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0 ) ;
  Counter := 0 ;
  if FileHandle <> INVALID_HANDLE_VALUE then
  begin
    ReadFile ( FileHandle, Counter, sizeof ( Counter ), Read, nil ) ;
    Inc ( Counter ) ;
    SetFilePointer ( FileHandle, 0, nil, FILE_BEGIN	) ;
    WriteFile ( FileHandle, Counter, sizeof ( Counter ), Written, nil ) ;
    CloseHandle ( FileHandle ) ;
  end ;

  { Write the CGI header and GIF output }

  HTTPHeader := 'HTTP/1.0 200 OK' + #13 + #10 +
      'Content-Type: image/gif' + #13 + #10 + #13 + #10 ;
  Write ( HTTPHeader [ 1 ], Length ( HTTPHeader ) ) ;
  MakeGIFCounter ( Format ( '%6.6d', [ Counter ] ) ) ;
end ;

{ GIF preparation and output }

procedure TWebCounter.MakeGIFCounter ( Text: String ) ;
var
  Image: TGIFMap ;
  Index, X, Y, Match, Bit: Integer ;

type
  DigitList = Array [ 0..9, 0..19 ] of String ;

const
  BITS_PER_PIXEL = 2 ;
  CHAR_WIDTH = 15 ;
  CHAR_HEIGHT = 20 ;
  CHAR_MAP = '0123456789' ;
  DIGIT_MAP: DigitList =
              ( ( '.......       .',
                  '.             .',
                  '.             .',
                  '.    .++..    .',
                  '.   .*****.   .',
                  '.  .**+.***.  .',
                  '.  +*+   **.  .',
                  '   **.   .*+  .',
                  '   **.   .*+  .',
                  '   **.   .*+  .',
                  '   **.   .*+  .',
                  '   +*.   +*.  .',
                  '   .*+   **   .',
                  '    **+.**    .',
                  '    .*****    .',
                  '      ...     .',
                  '              .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.      .**    .',
                  '.     .+**    .',
                  '.   .+****    .',
                  '.   .*****    .',
                  '       .**    .',
                  '       .**    .',
                  '       .**    .',
                  '       .**    .',
                  '       .**    .',
                  '        ++    .',
                  '        ++    .',
                  '        ++    .',
                  '        ..    .',
                  '              .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.    .++.     .',
                  '.   *****+    .',
                  '.  +**..+**   .',
                  '.  **.  .**.  .',
                  '   ++    **   .',
                  '        +**   .',
                  '       .**+   .',
                  '      .**+    .',
                  '     ++++     .',
                  '    +++.      .',
                  '   +++        .',
                  '   ++++++++   .',
                  '   ++++++++   .',
                  '              .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.             .',
                  '.   .+**+.    .',
                  '.  .******.   .',
                  '.  +*+  **+   .',
                  '   **   .**   .',
                  '        +*+   .',
                  '      .+**    .',
                  '      ***+    .',
                  '       .+++   .',
                  '         ++   .',
                  '   *+    ++   .',
                  '   +++  +++   .',
                  '   .++++++    .',
                  '     .++.     .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.             .',
                  '.      .++.   .',
                  '.      +**.   .',
                  '.     +***.   .',
                  '      *+**.   .',
                  '     +* **.   .',
                  '    .*. **.   .',
                  '    ++  **.   .',
                  '   .+.  **.   .',
                  '   +*+++**+.  .',
                  '   +*******+  .',
                  '        ++.   .',
                  '        ++    .',
                  '        ++    .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.             .',
                  '.   ......    .',
                  '.   ******+   .',
                  '.  .**....    .',
                  '   .*+        .',
                  '   .*.        .',
                  '   .*+***+    .',
                  '   +**++**.   .',
                  '   ..   +**   .',
                  '         **   .',
                  '   ..    **   .',
                  '   ++.  .++   .',
                  '   .++++++.   .',
                  '    .++++.    .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.             .',
                  '.    +***+    .',
                  '.   +*****+   .',
                  '.  .**. +**   .',
                  '   +*+        .',
                  '   +*. +.     .',
                  '   *******.   .',
                  '   ***+.***   .',
                  '   **+   **.  .',
                  '   +*.   **.  .',
                  '   +*+   **   .',
                  '    ++++++.   .',
                  '     .+++.    .',
                  '              .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.             .',
                  '.  ++++++++.  .',
                  '.  ********+  .',
                  '.  ++++++**+  .',
                  '        +*+   .',
                  '       .**    .',
                  '       **.    .',
                  '      .**     .',
                  '      **.     .',
                  '     .**      .',
                  '     +*+      .',
                  '     +*       .',
                  '     **       .',
                  '     **       .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.    +**+     .',
                  '.   ******+   .',
                  '.  +*+  +**   .',
                  '.  +*.   **   .',
                  '   .**  +*+   .',
                  '    +*****+   .',
                  '    +*****.   .',
                  '   +*+  +**   .',
                  '   *+    ++.  .',
                  '   ++    ++.  .',
                  '   +++  .++   .',
                  '    ++++++.   .',
                  '     .+++     .',
                  '              .',
                  '.             .',
                  '.             .',
                  '.....       ...' ),

                ( '.......       .',
                  '.             .',
                  '.             .',
                  '.             .',
                  '.    ++++     .',
                  '.   *****+    .',
                  '.  +*+..**.   .',
                  '   **.  .**   .',
                  '   **    **   .',
                  '   **    **   .',
                  '   +*+  ***   .',
                  '    *******   .',
                  '     .+. **   .',
                  '         ++   .',
                  '   ++.  ++.   .',
                  '   .++++++    .',
                  '    .++++     .',
                  '.             .',
                  '.             .',
                  '.....       ...' ) ) ;
begin

  { Allocate a TGIFImage to hold it }

  Image := TGIFMap.Create ;
  Image.Width := CHAR_WIDTH * Length ( Text ) ;
  Image.Height := CHAR_HEIGHT ;

  { Fill it }

  for Index := 0 to Length ( Text ) - 1 do
  begin
    Match := Pos ( Text [ Index + 1 ], CHAR_MAP ) - 1 ;

    for X := 0 to CHAR_WIDTH-1 do
    begin
      for Y := 0 to CHAR_HEIGHT-1 do
      begin
        Bit := 0 ;
        if Match <> -1 then
        begin
          case ( DIGIT_MAP [ Match, Y ] [ X + 1 ] ) of
            '.': Bit := 1 ;
            '+': Bit := 2 ;
            '*': Bit := 3 ;
          end ;
        end ;
        Image.Pixels [ X + Index * CHAR_WIDTH, Y ] := Bit ;
      end ;
    end ;
  end ;

  Image.Encode ( Write ) ;
  Image.Free ;
end ;

end.

