{
  Generic ISAPI DLL interface

  Written by Blake Stone
  (c) 1996 by DKW Systems Corporation
}

library ISAPI ;

{ NOTE: Put your enhanced TISAPIExtension subclass in a separate unit and
  use it here }

uses
  Windows, SysUtils, HTTPExt, DKWHTTP,
  Counter in 'Counter.pas' ;

{ NOTE: Replace the generic TISAPIExtension with your custom subclass
  here }

const
  ISAPIClass: TISAPIExtensionClass = TWebCounter ;

{ Generic implementation of GetExtensionVersion }

function GetExtensionVersion( var Ver: THSE_VERSION_INFO ): BOOL ; stdcall ; export ;
begin
  Result := True ;

  { Protect DLL calls from throwing exceptions }

  try
    Ver.dwExtensionVersion := MAKELONG ( HSE_VERSION_MINOR, HSE_VERSION_MAJOR ) ;
    StrPCopy ( Ver.lpszExtensionDesc, ISAPIClass.Description ) ;

  { Report failure on exceptions }

  except
    Result := False ;
  end ;
end ;

{ Generic implementation of ISAPIExtensionProc }

function HttpExtensionProc( var ECB: TEXTENSION_CONTROL_BLOCK ): DWORD; stdcall ; export ;
var
  Extension: TISAPIExtension ;
begin
  { Protect DLL calls from throwing exceptions }

  try
    Result := HSE_STATUS_SUCCESS ;
    Extension := nil ;

    { Make sure we free the TISAPIExtension }

    try

      { Create an instance to handle the request, and handle it }

      Extension := ISAPIClass.Create ( ECB ) ;
      if Extension <> nil then Extension.HandleRequest ;
    finally
      if Extension <> nil then Extension.Free ;
    end ;

  { Report error on exceptions }

  except
    Result := HSE_STATUS_ERROR ;
  end ;
end ;

{ Export the two ISAPI routines from the library }

exports GetExtensionVersion, HttpExtensionProc ;

begin
end.

