unit Unit1;

{Direct3D in Delphi demo}
{(c) February 1997 by Luc Cluitmans}
{This source is provided free as an example of using Direct3D in Delphi.
 No guarantees; I am not responsible for nasty things that may happen to you
 or your computer by using this code}
{Sorry for the lack of documentary comments :-)}

{notes: before compiling, install the 'd3drmwnd' component and put the
 Delphi DirectX interface files by Blake Stone somewhere on your libraries'
 search path. (Make sure you got the most recent version)}

interface

uses
  OLE2, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, d3drmwnd, ExtCtrls, dxtools, d3drm, d3drmobj, D3DTypes, D3DRMDef, DDraw,
  D3D, D3DCaps, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Panel1: TPanel;
    Timer1: TTimer;
    Panel2: TPanel;
    pnlFps: TPanel;
    ScrollBar1: TScrollBar;
    Panel3: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    pnl3DBack: TPanel;
    D3D1: TD3DRMWindow;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Open1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    OpenX: TOpenDialog;
    OpenFrame1: TMenuItem;
    SpeedButton5: TSpeedButton;
    DriverMenu: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure D3D1BuildScene(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure D3D1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure D3D1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure D3D1Enter(Sender: TObject);
    procedure D3D1Exit(Sender: TObject);
    procedure D3D1Click(Sender: TObject);
    procedure SpeedButton1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpeedButton1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpeedButton2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure OpenFrame1Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure DriverMenuClick(Sender: TObject);
  private
    { Private declarations }
    oldrotation: D3DVector;
    oldrotspeed: Single;
  protected
    procedure DriverClick(Sender: TObject);
    procedure WMActivate(var Msg: TMessage); message WM_ACTIVATE;
  
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  NewItem: TMenuItem;
  i: Integer;
begin
  Application.OnIdle := D3D1.IdleProc;
  for i := 0 to D3D1.DriverCount-1 do
  begin
    NewItem := TMenuItem.Create(Self);
    NewItem.Caption := D3D1.DriverNames[i];
    NewItem.OnClick := DriverClick;
    DriverMenu.Add(NewItem);
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  {}
end;

procedure TForm1.WMActivate(var Msg: TMessage);
begin
  inherited;
  D3D1.ActivateCallback(Msg);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  frames: Integer;
begin
  frames := D3D1.FrameCount;
  pnlFps.Caption := IntToStr(frames - Timer1.Tag);
  Timer1.Tag := frames;
end;

procedure TForm1.D3D1BuildScene(Sender: TObject);
begin
  D3D1.LoadFile('mything.x');
  ScrollBar1.Position := 1; {start rotating}
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
var
  rot: Single;
begin
  with D3D1 do
  begin
    if Initialized then
    begin
      rot := 0.0025 * ScrollBar1.Position;
      DXCheck(SubScene.SetRotation(Scene, 0.0, -1.0, 0.0, rot));
    end;
  end;
end;

procedure TForm1.D3D1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  dir, up, right, cpos: D3DVECTOR;
  l: Single;
begin
  with D3D1 do
  begin
    if Initialized and not Failed then
    begin
      DXCheck(Camera.GetOrientation(Scene, dir, up));
      DXCheck(Camera.GetPosition(Scene, cpos));
      D3DRMVectorCrossProduct(right, up, dir);
      l := D3DRMVectorModulus(cpos);
      up.x := l * 0.01 * up.x;
      up.y := l * 0.01 * up.y;
      up.z := l * 0.01 * up.z;
      dir.x := l * 0.01 * dir.x;
      dir.y := l * 0.01 * dir.y;
      dir.z := l * 0.01 * dir.z;
      right.x := l * 0.01 * right.x;
      right.y := l * 0.01 * right.y;
      right.z := l * 0.01 * right.z;
      case Key of
        {when you get an error when compiling the following lines, make sure
         you got the correct version of Blake Stone's Delphi port of the DirectX3
         headers. The definition of IDirect3DRMFrame.SetVelocity in d3drmobj.pas
         should be:
          function SetVelocity ( lpRef: IDirect3DRMFrame ; rvX, rvY,
                rvZ: D3DVALUE ; fRotVel: BOOL ): HRESULT ; virtual ; stdcall ; abstract ;
         (A previous version had 'var' in front of 'lpRef'). 
        }
        Ord('T'): DXCheck(Camera.SetVelocity(Scene, dir.x, dir.y, dir.z, False));
        Ord('R'): DXCheck(Camera.SetVelocity(Scene, -dir.x, -dir.y, -dir.z, False));
        VK_UP: DXCheck(Camera.SetVelocity(Scene, up.x, up.y, up.z, False));
        VK_DOWN: DXCheck(Camera.SetVelocity(Scene, -up.x, -up.y, -up.z, False));
        VK_RIGHT: DXCheck(Camera.SetVelocity(Scene, right.x, right.y, right.z, False));
        VK_LEFT: DXCheck(Camera.SetVelocity(Scene, -right.x, -right.y, -right.z, False));
        Ord(' '): CenterScene;
      end;
      if Key in [VK_UP, VK_DOWN, VK_RIGHT, VK_LEFT] then
      begin
        SetCaptureControl(D3D1);
           {otherwise the keyup event for the special key is lost !!!}
      end;
    end;
  end;
end;

procedure TForm1.D3D1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  with D3D1 do
  begin
    if (Key in [VK_UP, VK_DOWN, VK_RIGHT, VK_LEFT]) and (GetCaptureControl = D3D1) then
    begin
      SetCaptureControl(nil); 
    end;
    if Initialized and not Failed then
    begin
      DXCheck(Camera.SetVelocity(Scene, 0.0, 0.0, 0.0, False));
    end;
  end;
end;

procedure TForm1.D3D1Enter(Sender: TObject);
begin
  pnl3DBack.BevelOuter := bvLowered;
  pnl3DBack.Color := clRed;
end;

procedure TForm1.D3D1Exit(Sender: TObject);
begin
  pnl3DBack.BevelOuter := bvRaised;
  pnl3DBack.Color := clBtnFace;
end;

procedure TForm1.D3D1Click(Sender: TObject);
begin
  D3D1.SetFocus;
end;


procedure TForm1.SpeedButton1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  {the trick here is to start rotating when the button is pressed and to stop
   when it is released}
  with D3D1 do
  begin
    if Initialized then
    begin
      DXCheck(SubScene.GetRotation(Scene, oldrotation, oldrotspeed));
      DXCheck(SubScene.SetRotation(Scene, 1.0, 0.0, 0.0, 0.005));
    end;
  end;
end;

procedure TForm1.SpeedButton1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  with D3D1 do
  begin
    if Initialized then
    begin
      DXCheck(SubScene.SetRotation(Scene,
                      oldrotation.x, oldrotation.y, oldrotation.z, oldrotspeed));
    end;
  end;
end;

procedure TForm1.SpeedButton2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with D3D1 do
  begin
    if Initialized then
    begin
      DXCheck(SubScene.GetRotation(Scene, oldrotation, oldrotspeed));
      DXCheck(SubScene.SetRotation(Scene, 1.0, 0.0, 0.0, -0.005));
    end;
  end;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  frmHelp.Visible := True;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  D3D1.CenterScene;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  if OpenX.Execute then
  begin
    try
      D3D1.LoadFile(OpenX.FileName);
    except
      on EDirectX do
      begin
        ShowMessage('Loading the file failed. Maybe it contains a frame instead of a mesh');
        raise
      end;
    end;
    ScrollBar1.Position := 0;
    ScrollBar1.Position := 1; {start rotating}
  end;
end;

procedure TForm1.OpenFrame1Click(Sender: TObject);
begin
  if OpenX.Execute then
  begin
    try
      D3D1.LoadFrameFile(OpenX.FileName);
    except
      on EDirectX do
      begin
        ShowMessage('Loading the file failed. Maybe it contains a mesh instead of a frame');
        raise
      end;
    end;
    ScrollBar1.Position := 0;
    ScrollBar1.Position := 1; {start rotating}
  end;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  ScrollBar1.Position := 0;
end;

procedure TForm1.DriverClick(Sender: TObject);
begin
  with Sender as TMenuItem do
  begin
    D3D1.DriverName := Caption;
  end;
end;


procedure TForm1.DriverMenuClick(Sender: TObject);
var
  i: Integer;
begin
  with DriverMenu do
  begin
    for i := 0 to Count-1 do
    begin
      Items[i].Checked := CompareText(D3D1.DriverName, Items[i].Caption) = 0;
    end;
  end;
end;

end.
 