unit expr;

interface

uses
  WinTypes,WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Parser;

type
  TExprCalc = class(TComponent)
  private
    { Private declarations }
    FExpr : String;
    FValid : Boolean;
    FAnswer : Double;

    procedure RunExpr(AExpr:String);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AComponent:TComponent);override;
    procedure ClearVars;
    function DoExpr(AExpr:String):Double;
  published
    { Published declarations }
    property Expr : String read FExpr write RunExpr;
    property Valid : Boolean read FValid;
    property Answer : Double read FAnswer;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('BFW', [TExprCalc]);
end;
constructor TExprCalc.Create(AComponent:TComponent);
Begin
     inherited Create(AComponent);
     FExpr     := '';
     FValid    := True;
     FAnswer   := 0;
End;

procedure TExprCalc.ClearVars;
Begin
     ClearExprVars;
End;
procedure TExprCalc.RunExpr(AExpr:String);
Begin
     FAnswer := 0;
     FExpr := AExpr;
     FValid := True;
     FAnswer := GetExpr(FExpr,FValid);
End;
function TExprCalc.DoExpr(AExpr:String):Double;
Var
   b : Boolean;
Begin
     RunExpr(AExpr);
     Result := FAnswer;
End;
end.
