{===EZDSLQUE==========================================================

Part of the Delphi Structures Library--the queue and deque.

EZDSLQUE is Copyright (c) 1993, 1996 by  Julian M. Bucknall

VERSION HISTORY
13Mar96 JMB 2.00 release for Delphi 2.0
18Jun95 JMB 1.00 conversion of EZStrucs to Delphi
======================================================================}
{ Copyright (c) 1993, 1996, Julian M. Bucknall. All Rights Reserved   }

unit EZDSLQue;

{$I EZDSLDEF.INC}
{---Place any compiler options you require here-----------------------}


{---------------------------------------------------------------------}
{$I EZDSLOPT.INC}

interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Classes,
  EZDSLCts,
  EZDSLSup,
  EZDSLBse;

type
  TQueue = class(TAbstractContainer)
    {-Queue object}
    private
      Head, Tail : PNode;

    public
      constructor Create(DataOwner : boolean); override;
      constructor Clone(Source : TAbstractContainer;
                        DataOwner : boolean; NewCompare : TCompareFunc); override;

      procedure Append(aData : pointer);
      procedure Empty; override;
      function  Examine : pointer;
      function  Pop : pointer;
  end;

  TDeque = class(TQueue)
    {-Deque object}
    public
      procedure Push(aData : pointer);
  end;

implementation


{=TQueue==============================================================}
constructor TQueue.Create(DataOwner : boolean);
  begin
    NodeSize := 8;
    inherited Create(DataOwner);
    Head := acNewNode(nil);
    Head^.Link := Head;
    Tail := Head;
    FCount := 0;
  end;
{--------}
constructor TQueue.Clone(Source : TAbstractContainer;
                         DataOwner : boolean;
                         NewCompare : TCompareFunc);
  var
    Node     : PNode;
    OldQueue : TQueue absolute Source;
    NewData  : pointer;
  begin
    Create(DataOwner);
    Compare := NewCompare;
    DupData := OldQueue.DupData;
    DisposeData := OldQueue.DisposeData;

    if not (Source is TQueue) then
      RaiseError(escBadSource);

    if OldQueue.IsEmpty then Exit;

    Node := OldQueue.Head^.Link;
    while (Node <> OldQueue.Head) do
      begin
        if DataOwner then
             NewData := DupData(Node^.Data)
        else NewData := Node^.Data;
        try
          Append(NewData);
          Node := Node^.Link;
        except
          DisposeData(NewData);
          raise;
        end;
      end;
  end;
{--------}
procedure TQueue.Append(aData : pointer);
  var
    Node : PNode;
  begin
    Node := acNewNode(aData);
    with Tail^ do
      begin
        Node^.Link := Link;
        Link := Node;
      end;
    Tail := Node;
  end;
{--------}
procedure TQueue.Empty;
  begin
    if IsDataOwner then
      while not IsEmpty do DisposeData(Pop)
    else
      while not IsEmpty do Pop;
    if InDone then
      if Assigned(Head) then
        acDisposeNode(Head);
  end;
{--------}
function  TQueue.Examine : pointer;
  begin
    {$IFDEF DEBUG}
    Assert(not IsEmpty, ascEmptyExamine);
    {$ENDIF}
    Examine := Head^.Link^.Data;
  end;
{--------}
function  TQueue.Pop : pointer;
  var
    Node : PNode;
  begin
    {$IFDEF DEBUG}
    Assert(not IsEmpty, ascEmptyPop);
    {$ENDIF}
    Node := Head^.Link;
    Head^.Link := Node^.Link;
    Pop := Node^.Data;
    acDisposeNode(Node);
    if IsEmpty then Tail := Head;
  end;
{---------------------------------------------------------------------}


{=TDeque==============================================================
A output restricted deque object.

This type of deque allows queue jumpers, ie data objects can also be
pushed into the front of the queue, giving it stack-like behaviour. It
is descended from the basic queue and inherits Pop and Append.
======================================================================}
procedure TDeque.Push(aData : pointer);
  var
    Node : PNode;
  begin
    Node := acNewNode(aData);
    with Head^ do
      begin
        Node^.Link := Link;
        Link := Node;
      end;
    if (Tail = Head) then
      Tail := Node;
  end;
{---------------------------------------------------------------------}


end.
