unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Grids, Outline;

type
  BulkOp_e = (boCreating, boSaving, boReading, boDisposing);

  TForm1 = class(TForm)
    SaveBtn: TButton;
    ReadBtn: TButton;
    ClearBtn: TButton;
    ProgressBar: TProgressBar;
    Label1: TLabel;
    Label2: TLabel;
    LabelCount: TLabel;
    TV: TTreeView;
    LabelOp: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure ReadBtnClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TVKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    function GetRelToPrev(CurrNode : TTreeNode) : ShortInt;
    procedure DisposeTreeViewDataItems;
    procedure BeginBulkOp(Op : BulkOp_e; ProgBarMax : Integer);
    procedure EndBulkOp;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Type
    PRandomData =  ^TRandomData;
    TRandomData = record
        RandomNumbers : array[1..4] of Integer;
        End;

procedure TForm1.FormCreate(Sender: TObject);
var
    CurrOuterLevelNode,
    CurrMiddleLevelNode,
    CurrInnerLevelNode : TTreeNode;
    i,
    j,
    k,
    l : integer;
    RandomDataP : PRandomData;

    function CreateRandomData(I1, I2, I3, I4 : Integer) : PRandomData;
        BEGIN
        New(Result);
        Result.RandomNumbers[1] := I1;
        Result.RandomNumbers[2] := I2;
        Result.RandomNumbers[3] := I3;
        Result.RandomNumbers[4] := I4;
        END;

begin
    { Add some nested strings and data to the tree view }
    BeginBulkOp(boCreating, 9);
    Show;
    Update;
    i := 0;
    j := 0;
    k := 0;
    l := 0;
    for i := 1 to 9 do
        begin
        CurrOuterLevelNode := TV.Items.AddObject(nil, Format('%d,0,0,0', [i,j,k,l]), CreateRandomData(i,0,0,0));
        for j := 1 to 8 do
            begin
            CurrMiddleLevelNode := TV.Items.AddChildObject(CurrOuterLevelNode, Format('%d,%d,0,0', [i,j]), CreateRandomData(i,j,0,0));
            for k := 1 to 7 do
                begin
                CurrInnerLevelNode := TV.Items.AddChildObject(CurrMiddleLevelNode, Format('%d,%d,%d,0', [i,j,k]), CreateRandomData(i,j,k,0));
                for l := 1 to 6 do
                    begin
                    TV.Items.AddChildObject(CurrInnerLevelNode, Format('%d,%d,%d,%d', [i,j,k,l]), CreateRandomData(i,j,k,l));
                    end;
                end;
            end;
        ProgressBar.StepIt;
        end;
    EndBulkOp;
end;

function TForm1.GetRelToPrev(CurrNode : TTreeNode) : ShortInt; // Shortint allows 127 levels of nesting
    { returns -2 if there is no previous node; -1 if CurrNode is a child of the previous node; 0 if
      CurrNode is the first sibling of the previous node; 1 if CurrNode is the first sibling of the
      previous node's parent; 2 if CurrNode is the first sibling of the previous node's grandparent; etc. }
    var
        PrevNode,             // The node preceding CurrNode
        PrevSibling,          // CurrNode's previous sibling
        PrevNodeAncestor : TTreeNode; // One of PrevNode's ancestors
    BEGIN
    PrevNode := CurrNode.GetPrev;
    PrevSibling := CurrNode.GetPrevSibling;
    If PrevNode = nil then
        Result := -2
    Else if PrevNode = CurrNode.Parent then
        Result := -1
    Else if PrevNode = PrevSibling then
        Result := 0
    Else
        begin
        PrevNodeAncestor := PrevNode.Parent;
        Result := 1;
        While PrevNodeAncestor <> PrevSibling do
            BEGIN
            Inc(Result);
            PrevNodeAncestor := PrevNodeAncestor.Parent;
            END;
        end;
    END;

procedure TForm1.SaveBtnClick(Sender: TObject);
var
    S : TFileStream;
    ItemCount : Integer;
    i : Integer;
    CurrStringLength : Integer;
    CurrNode : TTreeNode;
    CurrRelToPrev : Shortint;
    CurrRandomDataP : PRandomData;
begin
    { Store all strings and data to the stream }
    S := TFileStream.Create('.\treeview.stm', fmCreate);
    Try
        ItemCount := TV.Items.Count;
        BeginBulkOp(boSaving, ItemCount);
        S.WriteBuffer(ItemCount, SizeOf(ItemCount));
        for i := 0 to ItemCount - 1 do
            begin
            If i = 0 then
                CurrNode := TV.Items[0]
            Else
                CurrNode := CurrNode.GetNext;
            { Write relational degree }
            CurrRelToPrev := GetRelToPrev(CurrNode);
            S.WriteBuffer(CurrRelToPrev, SizeOf(CurrRelToPrev));
            { Write tree-node string }
            CurrStringLength := Length(CurrNode.Text);
            S.WriteBuffer(CurrStringLength, SizeOf(CurrStringLength));
            S.WriteBuffer(Pointer(CurrNode.Text)^, CurrStringLength);
            { Write tree-node data }
            CurrRandomDataP  := PRandomData(CurrNode.Data);
            S.WriteBuffer(CurrRandomDataP^, SizeOf(TRandomData));
            ProgressBar.StepIt;
            end;
    Finally
        EndBulkOp;
        S.Destroy;
    End;
end;

procedure TForm1.ReadBtnClick(Sender: TObject);
var
    S : TFileStream;
    ItemCount : Integer;
    i : Integer;
    CurrStringLength : Cardinal;
    CurrString : String;
    CurrRandomDataP : PRandomData;
    CurrNode,
    PrevNode,
    PrevNodeAncestor : TTreeNode;
    RelToPrev : Shortint;
    a : ShortInt; // used for looping through ancestor levels
begin
    { Clear tree view, then fill it with the items in the stream }
    DisposeTreeViewDataItems;
    TV.Items.Clear;
    S := TFileStream.Create('.\treeview.stm', fmOpenRead);
    Try
        S.ReadBuffer(ItemCount, SizeOf(ItemCount));
        BeginBulkOp(boReading, ItemCount);
        For i := 1 to ItemCount do
            begin
            { Read relational degree }
            S.ReadBuffer(RelToPrev, SizeOf(RelToPrev));
            { Read tree-node string }
            S.ReadBuffer(CurrStringLength, SizeOf(CurrStringLength));
            SetString(CurrString, PChar(nil), CurrStringLength);
            S.ReadBuffer(Pointer(CurrString)^, CurrStringLength);
            { Read tree-node data }
            New(CurrRandomDataP);
            S.ReadBuffer(CurrRandomDataP^, SizeOf(TRandomData));
            { Insert node at proper point in tree view, based on its relational-degree value }
            Case RelToPrev of
                -2: // the very first object in the stream is always preceded by a RelToPrev value of -2
                    CurrNode := TV.items.AddObject(nil, CurrString, CurrRandomDataP);
                -1:
                    CurrNode := TV.Items.AddChildObject(PrevNode, CurrString, CurrRandomDataP);
                 0:
                    CurrNode := TV.Items.AddObject(PrevNode, CurrString, CurrRandomDataP); // PrevNode = nil for first item in tree, so this works OK
            Else
                begin
                PrevNodeAncestor := PrevNode; // PrevNode variable is invalid during first loop iteration, but valid thereafter
                for a := 1 to RelToPrev do
                    PrevNodeAncestor := PrevNodeAncestor.Parent;
                CurrNode := TV.Items.AddObject(PrevNodeAncestor, CurrString, CurrRandomDataP);
                end;
                End; {Case}
            PrevNode := CurrNode; // prepare for next iteration
            ProgressBar.StepIt;
            end;
    Finally
        EndBulkOp;
        S.Destroy;
    End;
end;

procedure TForm1.DisposeTreeViewDataItems;
var
    ItemCount : Integer;
    i : Integer;
    CurrNode : TTreeNode;
begin
    { Dispose of data at all nodes shown on the list }
    ItemCount := TV.Items.Count;
    BeginBulkOp(boDisposing, ItemCount);
    Try
        for i := 1 to ItemCount do
            begin
            If i = 1 then
                CurrNode := TV.Items[0]
            Else
                CurrNode := CurrNode.GetNext;
            With CurrNode do
                if Data <> nil then
                    Dispose(PRandomData(Data));
            ProgressBar.StepIt;
            end;
    Finally
        EndBulkOp;
    End;
end;

procedure TForm1.ClearBtnClick(Sender: TObject);
begin
    { Destroy tree-view contents and update form display }
    DisposeTreeViewDataItems;
    TV.Items.Clear;
    LabelCount.Caption := IntToStr(TV.Items.Count);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    DisposeTreeViewDataItems;
end;

function IntToMorpheme(I : Integer) : string;
    BEGIN
    Case I of
        0 : Result := 'Zero ';
        1 : Result := 'One ';
        2 : Result := 'Two ';
        3 : Result := 'Three ';
        4 : Result := 'Four ';
        5 : Result := 'Five ';
        6 : Result := 'Six ';
        7 : Result := 'Seven ';
        8 : Result := 'Eight ';
        9 : Result := 'Nine ';
        10 : Result := 'Ten ';
    Else
        Result := 'Too high ';
        End;
    END;

procedure TForm1.TVKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
    RandomDataP : PRandomData;
    Morphs : String;
begin
    { Display data at selected tree node }
    If (Key = VK_RETURN) and (TV.Selected <> nil) then
        begin
        With (Sender as TTreeView) do
            RandomDataP := PRandomData(Selected.Data);
        With RandomDataP^ do
            begin
            Morphs := IntToMorpheme(RandomNumbers[1]) + IntToMorpheme(RandomNumbers[2]) +
                      IntToMorpheme(RandomNumbers[3]) + IntToMorpheme(RandomNumbers[4]);
            ShowMessage(Morphs);
            end;
        end;
end;

procedure TForm1.BeginBulkOp(Op : BulkOp_e; ProgBarMax : Integer);
    BEGIN
    Case Op of
        boCreating : LabelOp .Caption := 'Creating...';
        boSaving : LabelOp .Caption := 'Saving...';
        boReading : LabelOp.Caption := 'Reading...';
        boDisposing : LabelOp.Caption := 'Disposing...';
    Else
        LabelOp.Caption := 'Unknown op';
        End;
    Update;
    ProgressBar.Max := ProgBarMax;
    END;

procedure TForm1.EndBulkOp;
    BEGIN
    LabelOp.Caption := '';
    LabelCount.Caption := IntToStr(TV.Items.Count);
    ProgressBar.Position := 0;
    END;

end.
