unit Icoexamp;

interface
{*
 ** This is an exmaple project using the TICOBMP16a VCL.
 ** This project allows the selection of an ICON then passes it to
 ** the ConvertIcontoBMP function of TICOBMP16a. This conversion is Quick,
 ** Simple, and Easy.  Currently, TICOBMP16 only Supports 32X32X16 Icons.
 ** Anything different may not yield the desired results.
*}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, icobmp16, StdCtrls, Buttons, ExtCtrls, Spin, icobmp;

type
  TForm1 = class(TForm)
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    Image1: TImage;
    Image2: TImage;
    BitBtn1: TBitBtn;
    GroupBox2: TGroupBox;
    BitBtn2: TBitBtn;
    OpenDialog1: TOpenDialog;
    Image3: TImage;
    IcoBmp1: TIcoBmp;
    procedure icobmp161Fail(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.icobmp161Fail(Sender: TObject);
begin
 {*
 ** Something went wrong, let's see what it was...
 *}

     MessageDlg(Icobmp1.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var
   myBitmap: TBitmap;
   mySuccess: BOOLEAN;
begin
 {*
 ** Create the bitmap to receive the converted Icon Image
 *}

     myBitmap:=TBitmap.Create;

 {*
 ** Convert the Icon to a Bitmap
 *}
     mySuccess:=IcoBmp1.ConvertIcontoBitmap(Image1.Picture.Icon,myBitmap);
     if mySuccess=TRUE then
        Image2.Picture.Bitmap:=myBitmap;

     myBitmap.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 {*
 ** Initialize the Transparent Color Map
 *}

     IcoBmp1.TransparentColorMap:=SpinEdit1.Value;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
 {*
 ** The background has been changed, update the Transparent Color Map
 *}

     IcoBmp1.TransparentColorMap:=SpinEdit1.Value;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var
   myBitmap: TBitmap;
   mySuccess: BOOLEAN;

begin
 {*
 ** Find a file and convert it's first icon to a Bitmap
 *}

  if OpenDialog1.Execute then
  begin
     myBitmap:=TBitmap.Create;
     mySuccess:=IcoBmp1.ConvertFileIcontoBitmap(OpenDialog1.FileName,0,myBitmap);
     if mySuccess=TRUE then
       Image3.Picture.Bitmap:=myBitmap;
     myBitmap.Free;
   end;
end;

end.
