{ Copyright 1996 Pierre Valade 
  Principal unit for Calculator program 
  Used to test TMathStr component for Delphi 2.0 }


unit Calcdlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, MathStr;

type
  TMainForm = class(TForm)
    ButtonPanel: TPanel;
    InOutPanel: TPanel;
    Input: TEdit;
    Output: TEdit;
    SB0: TSpeedButton;
    SB1: TSpeedButton;
    SB2: TSpeedButton;
    SB3: TSpeedButton;
    SB4: TSpeedButton;
    SB5: TSpeedButton;
    SB6: TSpeedButton;
    SB7: TSpeedButton;
    SB8: TSpeedButton;
    SB9: TSpeedButton;
    SBPoint: TSpeedButton;
    SBAdd: TSpeedButton;
    SBSub: TSpeedButton;
    SBMult: TSpeedButton;
    SBDiv: TSpeedButton;
    SBe: TSpeedButton;
    SBlog: TSpeedButton;
    SBln: TSpeedButton;
    SBOpenParen: TSpeedButton;
    SBx2: TSpeedButton;
    SBx3: TSpeedButton;
    SBxy: TSpeedButton;
    SBCloseParen: TSpeedButton;
    SBtan: TSpeedButton;
    SBcos: TSpeedButton;
    SBsin: TSpeedButton;
    SBPi: TSpeedButton;
    SBclear: TSpeedButton;
    SBCopy: TSpeedButton;
    SBPaste: TSpeedButton;
    SBDefine: TSpeedButton;
    SBEqual: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SBAbs: TSpeedButton;
    MathStr1: TMathStr;
    Clip: TEdit;
    SBOpenSParen: TSpeedButton;
    SBCloseSParen: TSpeedButton;
    SBRoot: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure EditExpression(Sender: TObject);
    procedure SBEqualClick(Sender: TObject);
    procedure SBClearClick(Sender: TObject);
    procedure SBCopyClick(Sender: TObject);
    procedure SBPasteClick(Sender: TObject);
    procedure SBAboutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Expression: String;
    root:integer;
  end;

var
  MainForm: TMainForm;

implementation

uses AboutDlg;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
   Expression := ''; 
   root := 0;
end;

procedure TMainForm.EditExpression(Sender: TObject);
var 
   ch: string;
begin
   if Sender = SB0 then
      ch := '0'
   else if Sender = SB1 then
      ch := '1'
   else if Sender = SB2 then
      ch := '2'
   else if Sender = SB3 then
      ch := '3'
   else if Sender = SB4 then
      ch := '4'
   else if Sender = SB5 then
      ch := '5'
   else if Sender = SB6 then
      ch := '6'
   else if Sender = SB7 then
      ch := '7'
   else if Sender = SB8 then
      ch := '8'
   else if Sender = SB9 then
      ch := '9'
   else if Sender = SBPoint then
      ch := '.' 
   else if Sender = SBAdd then
      ch := '+'
   else if Sender = SBSub then
      ch := '-'
   else if Sender = SBDiv then
      ch := '/'
   else if Sender = SBMult then
      ch := '*'
   else if Sender = SBAbs then
      ch := '|'
   else if Sender = SBsin then
      ch := 'sin'
   else if Sender = SBcos then
      ch := 'cos'
   else if Sender = SBtan then
      ch := 'tan'
   else if Sender = SBPi then
      ch := 'p'
   else if Sender = SBe then
      ch := 'e'
   else if Sender = SBln then
      ch := 'ln'
   else if Sender = SBlog then
      ch := 'log'
   else if Sender = SBxy then
      ch := '^'
   else if Sender = SBx2 then
      ch := ''
   else if Sender = SB3 then
      ch := ''
   else if Sender = SBRoot then
      begin
      ch := '^(1/';
      root := 1;
      end
   else if Sender = SBOpenSParen then
      ch := '['
   else if Sender = SBCloseSParen then
      ch := ']'
   else if Sender = SBOpenParen then
      ch := '(' 
   else if Sender = SBCloseParen then
      ch := ')';

   Input.SelText := ch;
   end;

procedure TMainForm.SBEqualClick(Sender: TObject);
var
   y: extended;
   ch: String;
begin
   y := MathStr1.Evaluate(MathStr1.Analyse(Input.Text), 0);
   if MathStr1.Status = 0 then
      Output.Text := 'Error'
   else
      Output.Text := FloatToStr(y);
end;

procedure TMainForm.SBClearClick(Sender: TObject);
begin
   Input.SelectAll;
   Input.ClearSelection;
   Output.ReadOnly := False;
   Output.SelectAll;
   Output.ClearSelection;
   Output.ReadOnly := True;
end;

procedure TMainForm.SBCopyClick(Sender: TObject);
var
   tmpstr: String;
begin
   Clip.Text := Input.Text + ' = ' + Output.Text;
   Clip.SelectAll;
   Clip.CopyToClipboard;
end;

procedure TMainForm.SBPasteClick(Sender: TObject);
begin
Input.PasteFromClipboard;
end;

procedure TMainForm.SBAboutClick(Sender: TObject);
begin
 AboutBox.ShowModal;
end;

end.
