unit playlist;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, ComCtrls;

type
  TfPlaylst = class(TForm)
    PageControl1: TPageControl;
    tsPlaylist: TTabSheet;
    btnOK: TButton;
    GroupBox1: TGroupBox;
    sgTracks: TStringGrid;
    GroupBox2: TGroupBox;
    sgPlaylist: TStringGrid;
    bCopyAll: TButton;
    bRemoveAll: TButton;
    bCopy: TButton;
    bRemove: TButton;
    Label1: TLabel;
    Settings: TTabSheet;
    GroupBox3: TGroupBox;
    cbScroll: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure WriteCDFile;
    procedure ReadCDFile(iBuffType : integer);
    procedure OpenCDFile;
    procedure FillUntitled;
    procedure btnOKClick(Sender: TObject);
    procedure sgTracksMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure sgPlaylistDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure sgPlaylistDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure sgTracksDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure sgTracksSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure bCopyAllClick(Sender: TObject);
    procedure bRemoveAllClick(Sender: TObject);
    procedure bCopyClick(Sender: TObject);
    procedure sgPlaylistSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure bRemoveClick(Sender: TObject);
    procedure sgTracksDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure sgPlaylistMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cbScrollClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fPlaylst       : TfPlaylst  ;
  sDraggedTrack  : string[50] ;
  iPLTrack       : integer ;
  sDraggedRow    : string[10] ;
  iPLSelectedRow : integer ;
  iPLSelectedCol : integer ;
  iPLTotalTracks : integer ;


implementation

uses sscd, scroll;

{$R *.DFM}

function PLTracks : integer;
var
iPLTrackCount : integer ;
begin
iPLTrackCount := 0 ;

while fPlaylst.sgPlaylist.Cells[0, iPLTrackCount + 1] <> '' do
   begin
   iPLTrackCount := iPLTrackCount + 1 ;
   end ;

PLTracks := iPLTrackCount ;
end ;


procedure TfPlaylst.FormShow(Sender: TObject);
var
iCount : integer ;
begin
sgTracks.ColWidths[0] := 35;
sgTracks.ColWidths[1] := 160;
sgTracks.Cells[0, 0]  := 'Track';
sgTracks.Cells[1, 0]  := 'Description';

sgPlaylist.ColWidths[0] := 35;
sgPlaylist.ColWidths[1] := 160;
sgPlaylist.Cells[0, 0]  := 'Track';
sgPlaylist.Cells[1, 0]  := 'Description';

sgTracks.RowCount := iTrackCount + 1 ;

for iCount := 1 to iTrackCount  do
   begin
   sgTracks.Cells[0, iCount] := IntToStr(CDTrackInfo[iCount].TrackNo) ;
   sgTracks.Cells[1, iCount] := CDTrackInfo[iCount].Description ;
   end ;

for iCount := 1 to iPLTotalTracks  do
   begin
   sgPlaylist.Cells[0, iCount] := IntToStr(CDPLTrackInfo[iCount].TrackNo) ;
   sgPlaylist.Cells[1, iCount] := CDPLTrackInfo[iCount].Description ;
   end ;

iPLTrack := 1 ;
sDraggedTrack := sgTracks.Cells[1, 1] ;
sDraggedRow   := sgTracks.Cells[0, 1] ;

end;


procedure TfPlaylst.WriteCDFile;
var
iCurrentTrack : integer ;
iActualLen    : integer ;
iPLTrackCount : integer ;
begin

iPLTrackCount := PLTracks;  // call PLTracks function

// write the cd tracks
CDHandle := FileCreate(fCDPlayer.edCDID.Text + '.cdf');

if CDHandle = -1 then
   begin
    MessageDlg('Unable to Create CD File', mtError, [mbOk], 0);
    Exit ;
   end ;

for iCurrentTrack := 1 to iTrackCount do
begin
   CDTrackInfo[iCurrentTrack].TrackNo     := StrToInt(sgTracks.Cells[0, iCurrentTrack]) ;
   CdTrackInfo[iCurrentTrack].Description := sgTracks.Cells[1, iCurrentTrack] ;
   iActualLen := FileWrite(CDHandle, cdTrackInfo[iCurrentTrack], SizeOf(cdTrackInfo[iCurrentTrack]));

   if(iActualLen = -1 ) then
   begin
      MessageDlg('An Error occured writing to disk.', mtError, [mbOk], 0);
      Exit ;
   end ;

end ;

FileClose(CDHandle) ;

// write the cd playlist tracks
CDHandle := FileCreate(fCDPlayer.edCDID.Text + '.cdp');

for iCurrentTrack := 1 to iPLTrackCount do
begin
   CDPLTrackInfo[iCurrentTrack].TrackNo     := StrToInt(sgPlaylist.Cells[0, iCurrentTrack]) ;
   CdPLTrackInfo[iCurrentTrack].Description := sgPlaylist.Cells[1, iCurrentTrack] ;
   iActualLen := FileWrite(CDHandle, cdPLTrackInfo[iCurrentTrack], SizeOf(cdPLTrackInfo[iCurrentTrack]));

   if(iActualLen = -1 ) then
   begin
      MessageDlg('An Error occured writing to disk.', mtError, [mbOk], 0);
      Exit ;
   end ;

end ;

FileClose(CDHandle) ;

end ;

procedure TfPlaylst.ReadCDFile(iBuffType : integer);
var
iActualLen    : integer ;
iCurrentTrack : integer ;
begin

iCurrentTrack := 1 ;
iActualLen := SizeOf(CDTrackRec) ;

while iActualLen > 0 do
   begin

   if iBuffType = 1 then
      iActualLen := FileRead(CDHandle, cdTrackInfo[iCurrentTrack], SizeOf(CDTrackRec))
   else
      iActualLen := FileRead(CDHandle, cdPLTrackInfo[iCurrentTrack], SizeOf(CDTrackRec)) ;

   if iActualLen > 0 then
      begin
      iCurrentTrack := iCurrentTrack + 1 ;
      end ;

   end ;

   if iBuffType = 2 then
      iPLTotalTracks := iCurrentTrack - 1 ;

end;

procedure TfPlaylst.OpenCDFile;
begin

  // read cd tracks
  CDHandle := FileOpen(fCDPlayer.edCDID.Text + '.cdf', fmOpenRead);

  if CDHandle > 0 then
     begin
        ReadCDFile(1);
        FileClose(CDHandle) ;
     end
  else
     begin
        FillUntitled ;
        Exit ;
     end ;

  // read playlist tracks
  CDHandle := FileOpen(fCDPlayer.edCDID.Text + '.cdp', fmOpenRead);
  ReadCDFile(2);
  FileClose(CDHandle) ;

end ;


procedure TfPlaylst.FillUntitled;
var
iCount : integer ;
begin
//sgTracks.RowCount := iTrackCount + 1 ;  uncommenting this will give an access violation

for iCount := 1 to iTrackCount  do
   begin
   CDTrackInfo[iCount].TrackNo := iCount ;
   CdTrackInfo[iCount].Description := 'Untitled '+ IntToStr(iCount) ;

   end ;

end;

procedure TfPlaylst.btnOKClick(Sender: TObject);
begin
WriteCDFile ;
end;

procedure TfPlaylst.sgTracksMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin

    if Button = mbLeft then	{ only drag if left button pressed }
    with Sender as TStringGrid do	{ treat Sender as TFileListBox }
    begin
 //     if ItemAtPos(Point(X, Y), True) >= 0 then	{ is there an item here? }
        BeginDrag(False);	{ if so, drag it }
    end;

  end;

procedure TfPlaylst.sgPlaylistDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  if Source is TStringGrid then
    Accept := True;

end;

procedure TfPlaylst.sgPlaylistDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
iPLTrackCount : integer ;

begin
iPLTrackCount := PLTracks;  // call PLTracks function
iPLTrackCount := iPLTrackCount + 1 ;

   if Sender is TStringGrid then
      begin
      sgPlayList.Cells[1, iPLTrackCount] := sDraggedTrack ;
      sgPlayList.Cells[0, iPLTrackCount] := sDraggedRow ;
      iPLTrack := iPLTrack + 1 ;
      end ;

end;

procedure TfPlaylst.sgTracksDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  if Source is TStringGrid then
    Accept := True;

end;

procedure TfPlaylst.sgTracksSelectCell(Sender: TObject; Col, Row: Longint;
  var CanSelect: Boolean);

begin
sDraggedTrack := sgTracks.Cells[1, Row] ;
sDraggedRow   := sgTracks.Cells[0, Row] ;

end;

procedure TfPlaylst.bCopyAllClick(Sender: TObject);
var
iPLTrackCount : integer ;
iCurrentTrack : integer ;
begin

iPLTrackCount := PLTracks;  // call PLTracks function

if iPLTrackCount >= 50 then
   begin
    MessageDlg('Maximum Playlist reached (50 tracks)', mtError, [mbOk], 0);
   end ;

if iPLTrackCount < 50 then
   begin
      for iCurrentTrack := 1 to iTrackCount do
         begin
         sgPlayList.Cells[1, iCurrentTrack + iPLTrackCount] := sgTracks.Cells[1, iCurrentTrack] ;
         sgPlayList.Cells[0, iCurrentTrack + iPLTrackCount] := sgTracks.Cells[0, iCurrentTrack] ;
         end ;
   end ;
end;

procedure TfPlaylst.bRemoveAllClick(Sender: TObject);
var
iCurrentTrack : integer ;
begin
   for iCurrentTrack := 1 to 50 do
      begin
         sgPlayList.Cells[1, iCurrentTrack] := '' ;
         sgPlayList.Cells[0, iCurrentTrack] := '' ;
      end ;

end;

procedure TfPlaylst.bCopyClick(Sender: TObject);
var
iPLTrackCount : integer ;
begin
iPLTrackCount := PLTracks;  // call PLTracks function

    sgPlayList.Cells[1, iPLTrackCount + 1] := sDraggedTrack ;
    sgPlayList.Cells[0, iPLTrackCount + 1] := sDraggedRow ;
end;

procedure TfPlaylst.sgPlaylistSelectCell(Sender: TObject; Col,
  Row: Longint; var CanSelect: Boolean);
begin
iPLSelectedRow := Row ;
iPLSelectedCol := Col ;

end;

procedure TfPlaylst.bRemoveClick(Sender: TObject);
var
iPLTrackCount : integer ;
iCount : integer ;
begin
iPLTrackCount := PLTracks;  // call PLTracks function

if iPLSelectedRow <= iPLTrackCount then
   begin

   for iCount := iPLSelectedRow to iPLTrackCount - 1 do
      begin
      sgPlayList.Cells[1, iCount] := sgPlayList.Cells[1, iCount + 1] ;
      sgPlayList.Cells[0, iCount] := sgPlayList.Cells[0, iCount + 1] ;
      end ;

   sgPlayList.Cells[0, iPLTrackCount] := '' ;
   sgPlayList.Cells[1, iPLTrackCount] := '' ;

   end ;

end;

procedure TfPlaylst.sgTracksDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
   if Sender is TStringGrid then
      begin
      bRemoveClick(Sender) ;
      end ;
end;

procedure TfPlaylst.sgPlaylistMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    if Button = mbLeft then	{ only drag if left button pressed }
    with Sender as TStringGrid do	{ treat Sender as TFileListBox }
    begin
 //     if ItemAtPos(Point(X, Y), True) >= 0 then	{ is there an item here? }
        BeginDrag(False);	{ if so, drag it }
    end;

end;

procedure TfPlaylst.cbScrollClick(Sender: TObject);
begin

   if(cbScroll.State = cbUnchecked) then
   begin
      fmScroll.timeScroll.Enabled := True ;
   end
   else
   begin
      fmScroll.timeScroll.Enabled := False ;
   end ;

end;

end.
