unit scroll;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, sscd;

type
  TfmScroll = class(TForm)
    timeScroll: TTimer;
    procedure timeScrollTimer(Sender: TObject);
    procedure AddCharacters ;
    procedure FlashLine ;
    procedure ScrollLeft ;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmScroll: TfmScroll;
  iSecCount : integer ;
  iFlashOn : integer = 0 ;

  index : integer = 0 ;
  boolPauseScroll : boolean = False ;
  iPauseCount : integer ;
  iFlashCount : integer = 0 ;

  boolAddCharacters : boolean = False ;
  boolFlash : boolean = False;
  boolFlashAgain : boolean = False;
  boolScrollLeft : boolean = False ;
  boolPauseOn : boolean = False ;
  boolScrollFromRight : boolean = False ;
  
implementation

{$R *.DFM}

{--------------------------------------------------------------}
procedure TfmScroll.AddCharacters;
begin
   fCDPlayer.lblScroll.Caption := Concat(fCDPlayer.lblScroll.Caption, Copy(sScroll, index, 1 ) ) ;

end ;

{--------------------------------------------------------------}
procedure TfmScroll.ScrollLeft;

begin
   fCDPlayer.lblScroll.Caption := Copy(sScroll, index, length(sScroll) - index + 1 )  ;

end ;

{--------------------------------------------------------------}
procedure TfmScroll.FlashLine ;
var
iMaxFlashOn : integer ; // number of flash ons before continuing
iFlashPause : integer ;
begin
   iFlashPause := 2 ;
   iMaxFlashOn := 4 ;

   if (iFlashCount > (iFlashPause )) then
   begin
      if (fCDPlayer.lblScroll.Caption = sScroll) then
      begin
         fCDPlayer.lblScroll.Caption := '' ;
      end
      else
      begin
         iFlashOn := iFlashOn + 1 ;
         fCDPlayer.lblScroll.Caption := sScroll ;
      end ;
      iFlashCount := 0 ;
   end ;

   iFlashCount := iFlashCount + 1 ;

   if (iFlashOn = iMaxFlashOn) then
   begin
      boolFlash := False ;
      iFlashOn := 0 ;
   end ;

end ;


{--------------------------------------------------------------}
procedure TfmScroll.timeScrollTimer(Sender: TObject);
var
iDisplayWait : integer ;
begin
 //  iMaxPause := 8 ;  // two * 150 millisecond pause
   iDisplayWait := 8 ; // show for x cycles

   if (boolAddCharacters = True ) then
   begin
      index := index + 1 ;
      AddCharacters ;
      if( index > length(sScroll ) ) then
      begin
         boolAddCharacters := False ;
         boolFlash := True ;
         index := 0 ;
      end ;

   end ;

   {do the flash if true}
   if (( boolFlash = True)and( boolFlashAgain = False))  then
   begin
      FlashLine ;

      if(boolFlash = False ) then // boolFlash set in FlashLine
      begin
         boolScrollLeft := True ;
         boolPauseOn    := True ;
         iSecCount := 0 ;
      end ;

   end ;  // boolFlash end

    {pause a while here}
    if((boolScrollLeft = True) and (boolPauseOn = True) ) then
    begin
       iSecCount := iSecCount + 1 ;
       if (iSecCount = iDisplayWait) then
          boolPauseOn := False ;

    end ;

   {scroll the text left}
   if((boolScrollLeft = True ) and (boolPauseOn = False )) then
   begin
      index := index + 1 ;
      ScrollLeft ;

      if( index > length(sScroll ) ) then
      begin
         boolScrollLeft := False ;
         boolScrollFromRight := True ;
         index := 0 ;
      end ;
   end ;

   {scroll from right of window}
   if (boolScrollFromRight = True ) then
   begin
      fCDPlayer.lblScroll.Alignment := taRightJustify ;
      index := index + 1 ;
      AddCharacters ;
      if( index > length(sScroll ) ) then
      begin
         boolScrollFromRight := False ;
         boolFlashAgain := True ;
         boolPauseOn := True ;
         iSecCount := 0 ;
         index := 0 ;
      end ;
   end ;

    {pause a while here}
    if((boolFlashAgain = True) and (boolPauseOn = True) ) then
    begin
       iSecCount := iSecCount + 1 ;
       if (iSecCount = iDisplayWait) then
          boolPauseOn := False ;

    end ;

   {do the flash if true}
   if ( (boolFlashAgain = True) and (boolPauseOn = False))  then
   begin
      fCDPlayer.lblScroll.Alignment := taLeftJustify ;
      boolFlash := True ;
      FlashLine ;

      if(boolFlash = False ) then // boolFlash set in FlashLine
      begin
         boolFlashAgain := False ;
         boolPauseOn    := True ;
         iSecCount := 0 ;
      end ;

   end ;  // boolFlash end




   if ((boolAddCharacters = False ) and (boolFlash = False)
     and (boolScrollLeft = False) and (boolFlashAgain = False) and
     (boolScrollFromRight = False)) then
   begin
      fCDPlayer.lblScroll.Caption := '' ;
      index := 0 ;
      boolAddCharacters := True ;
   end ;


end;

{--------------------------------------------------------------}
end.
