unit sscd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MPlayer, StdCtrls, ExtCtrls, Mask, Buttons, cd_about, Menus, ComCtrls;

type
  TfCDPlayer = class(TForm)
    SSMediaPlayer: TMediaPlayer;
    edLenMins: TEdit;
    edLenSecs: TEdit;
    edTrackCount: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edTracks: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    edSecs: TEdit;
    edMins: TEdit;
    Bevel4: TBevel;
    Panel1: TPanel;
    PaintBox1: TPaintBox;
    Label12: TLabel;
    Label11: TLabel;
    Image2: TImage;
    Panel2: TPanel;
    ptboxPosition: TPaintBox;
    Label6: TLabel;
    Label7: TLabel;
    imgColon: TImage;
    panel3: TPanel;
    ptBoxLength: TPaintBox;
    Label19: TLabel;
    Label20: TLabel;
    Image3: TImage;
    Panel4: TPanel;
    ptBoxTrack: TPaintBox;
    Label8: TLabel;
    Panel5: TPanel;
    lbNextTrack: TLabel;
    lbCurrentTrack: TLabel;
    lbPrevTrack: TLabel;
    lbRegular: TLabel;
    lbRandom: TLabel;
    lbPlaylist: TLabel;
    ImageList1: TImageList;
    Panel6: TPanel;
    ptBoxTotTracks: TPaintBox;
    Label10: TLabel;
    Label18: TLabel;
    Timer1: TTimer;
    Bevel1: TBevel;
    Image1: TImage;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Panel7: TPanel;
    Label21: TLabel;
    sbPlay: TSpeedButton;
    sbPause: TSpeedButton;
    sbStop: TSpeedButton;
    sbRewind: TSpeedButton;
    sbFForward: TSpeedButton;
    sbForward: TSpeedButton;
    sbPrevious: TSpeedButton;
    bMode: TButton;
    bPlaylist: TButton;
    edPause: TEdit;
    edCDID: TEdit;
    edLenFrames: TEdit;
    TimerCheckCD: TTimer;
    edErrorBox: TEdit;
    boldPlay: TImage;
    dullPlay: TImage;
    boldPause: TImage;
    lbPaused: TLabel;
    dullPause: TImage;
    Label9: TLabel;
    Label13: TLabel;
    sbEject: TSpeedButton;
    PopupMenu1: TPopupMenu;
    miHelp: TMenuItem;
    miAbout: TMenuItem;
    N2: TMenuItem;
    miExit: TMenuItem;
    Bevel5: TBevel;
    tbTrackBar: TTrackBar;
    Bevel6: TBevel;
    Panel8: TPanel;
    lblScroll: TLabel;
    btnHelp: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PositionDisplay ;
    procedure PositionChange ;
    procedure PositionAdd5 ;
    procedure PositionSub5 ;
    procedure LengthDisplay ;
    procedure MoveToTrack ;
    procedure MoveInToTrack ;
    procedure Timer1Timer(Sender: TObject);
    procedure edTracksChange(Sender: TObject);
    procedure bTrackLenClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure edSecsChange(Sender: TObject);
    procedure edMinsChange(Sender: TObject);
    procedure ptboxPositionPaint(Sender: TObject);
    procedure edLenMinsChange(Sender: TObject);
    procedure edLenSecsChange(Sender: TObject);
    procedure ptBoxLengtPaint(Sender: TObject);
    procedure ptBoxTrackPaint(Sender: TObject);
    procedure edTrackCountChange(Sender: TObject);
    procedure ptBoxTotTracksPaint(Sender: TObject);
    procedure ptBoxLengthPaint(Sender: TObject);
    procedure sbPlayClick(Sender: TObject);
    procedure sbStopClick(Sender: TObject);
    procedure sbForwardClick(Sender: TObject);
    procedure sbPreviousClick(Sender: TObject);
    procedure Panel7Click(Sender: TObject);
    procedure Label21Click(Sender: TObject);
    procedure sbPauseClick(Sender: TObject);
    procedure edPauseChange(Sender: TObject);
    procedure sbFForwardClick(Sender: TObject);
    procedure sbRewindClick(Sender: TObject);
    procedure bPlaylistClick(Sender: TObject);
    procedure ClearTrackArray;
    procedure EnableButtons;
    procedure DisableButtons;
    procedure TimerCheckCDTimer(Sender: TObject);
    procedure BringToLife;
    procedure ShowDescriptions ;
    procedure bModeClick(Sender: TObject);
    procedure CheckRandomise(Sender : TObject) ;
    procedure CheckPlaylist(Sender : TObject) ;
    procedure MoveToSuppliedTrack(Sender: TObject; iNewSuppliedTrack : integer);
    procedure sbEjectClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure miExitClick(Sender: TObject);
    procedure miAboutClick(Sender: TObject);
    procedure tbTrackBarChange(Sender: TObject);
    procedure miHelpClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;


type
  CDTrackRec = record
    CDId        : string[20] ;
    TrackNo     : byte ;
    Description : string[50] ;
  end;

type
  TMSRec = record
    Tracks: byte;
    Minutes: byte;
    Seconds: byte;
    Frames: byte;
  end;

type
  MSRec = record
    Minutes: byte;
    Seconds: byte;
    Frames : byte;
    NotUsed1: byte;
  end;

var
  fCDPlayer     : TfCDPlayer;
  iCurrentTrack : integer ;
  iTrackCount   : integer ;
  bPlaying      : boolean ;
  bShowDisplay  : boolean ;  // false = pause 1 sec before displaying
  CDHandle      : integer ;  // handle of CD file
  CDTrackInfo   : array[1..50] of CDTrackRec ;
  CDPLTrackInfo : array[1..50] of CDTrackRec ;
  CDDeviceOpen  : boolean ;
  iMode         : integer ;
  iPLTrack      : integer ;
  bProgramCall  : boolean ;  // set to true when sbPlayClick called by program (rather than user clicking button)
  sScroll : string = '' ;

implementation


uses playlist;

{$R *.DFM}

{---------------------------------------------------------------------}
function PLTracks : integer;
var
iPLTrackCount : integer ;
begin
iPLTrackCount := 0 ;

while fPlaylst.sgPlaylist.Cells[0, iPLTrackCount + 1] <> '' do
   begin
   iPLTrackCount := iPLTrackCount + 1 ;
   end ;

PLTracks := iPLTrackCount ;
end ;


{---------------------------------------------------------------------}
function OpenCDDevice (SSMediaPlayer : TMediaPlayer) : Boolean;
begin

   try
      SSMediaPlayer.DeviceType := dtCDAudio;
      SSMediaPlayer.Visible := False ;
      SSMediaPlayer.Open;
      SSMediaPlayer.TimeFormat := tfTMSF ;
      OpenCDDevice := True ;
   except
  //    ErrorString := 'ErrorCode: ' + IntToStr(Error) + #13#10;
  //    MessageDlg(ErrorString + SSMediaPlayer.ErrorMessage, mtError, [mbOk], 0);

      OpenCDDevice := False ;

//      Abort ;
   end ;

end ;


{---------------------------------------------------------------------}
procedure TfCDPlayer.MoveInToTrack ;
var
  lNewTrack: LongInt;
begin

   if bPlaying = True then
      SSMediaPlayer.Stop ;

   with TMSRec(lNewTrack) do { Typecast lNewTrack as a HMSRec record }

   begin
     Tracks  := iCurrentTrack;
     //buggerold
     Minutes := StrToInt(edMins.Text) ;
     Seconds := StrToInt(edSecs.Text) ;
     Frames  := 0 ;
   end ;

   SSMediaPlayer.Position := lNewTrack ;

   if (bPlaying = True) then
      SSMediaPlayer.Play ;
end ;


{---------------------------------------------------------------------}
procedure TfCDPlayer.MoveToTrack ;
var
  lNewTrack: LongInt;
begin

   if bPlaying = True then
      SSMediaPlayer.Stop ;

   with TMSRec(lNewTrack) do { Typecast lNewTrack as a HMSRec record }

   begin
     Tracks  := iCurrentTrack;
     Minutes := 0 ;
     Seconds := 0 ;
     Frames  := 0 ;
   end ;

   SSMediaPlayer.Position := lNewTrack ;

   if (bPlaying = True) then
      SSMediaPlayer.Play ;
end ;


{---------------------------------------------------------------------}
procedure TfCDPlayer.LengthDisplay ;
var
  lTrackLen: LongInt;
begin

  if CDDeviceOpen = True then
     lTrackLen := SSMediaPlayer.TrackLength[iCurrentTrack]
  else
     lTrackLen := 0 ;

  with MSRec(lTrackLen) do { Typecast lTrackLen as a HMSRec record }
  begin
    edLenMins.Text   := IntToStr(Minutes);
    edLenSecs.Text   := IntToStr(Seconds);
    edLenFrames.Text := IntToStr(Frames) ;
  end ;
end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.PositionChange ;
begin
    edTracks.Text := IntToStr(iCurrentTrack); // causing infinite loop
    edMins.Text := '0' ;
    edSecs.Text := '0' ;
end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.PositionAdd5 ;
var
iSecs : integer;
iMins : integer;
begin
    edTracks.Text := IntToStr(iCurrentTrack);
    iSecs := StrToInt( edSecs.Text);
    //buggerold
    iSecs := iSecs + 5 ;

    if iSecs > 59 then
       begin
       iSecs := iSecs - 60 ;
       iMins := StrToInt(edMins.Text) ;
       //buggerold
       iMins := iMins + 1 ;
       edMins.Text := IntToStr(iMins) ;
       end ;

edSecs.Text := IntToStr(iSecs) ;
end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.PositionSub5 ;
var
iSecs : integer;
iMins : integer;
begin
    edTracks.Text := IntToStr(iCurrentTrack);
    iSecs := StrToInt( edSecs.Text);
    iSecs := iSecs - 5 ;

    if iSecs < 0 then
       begin
       iSecs := 60 + iSecs ;
       iMins := StrToInt(edMins.Text) ;
       iMins := iMins - 1 ;

       if iMins < 0 then
          begin
          iMins := 0 ;
          iSecs := 0 ;
          end ;

       edMins.Text := IntToStr(iMins) ;
       end ;

edSecs.Text := IntToStr(iSecs) ;
end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.PositionDisplay ;
var
  lPosition: LongInt;
begin

  if CDDeviceOpen = True then
     lPosition := SSMediaPlayer.Position
  else
     lPosition := 0 ;

  with TMSRec(lPosition) do { Typecast lPosition as a HMSRec record }

  begin
    edTracks.Text := IntToStr(Tracks);
    edMins.Text   := IntToStr(Minutes);
    edSecs.Text   := IntToStr(Seconds);

    //    Label4.Caption := IntToStr(Frames);
  end ;
end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.FormCreate(Sender: TObject);
begin

Application.HelpFile := 'MCD.HLP';

iMode := 0 ; // Regular
CDDeviceOpen := OpenCDDevice(SSMediaPlayer) ;
bProgramCall := False ;

if CDDeviceOpen = True then
   begin
   iTrackCount := SSMediaPlayer.Tracks ;
   // some cd devices report device open when no cd is present so:
   // check trackcount for sensible value, if it's over 30 then set to zero

   if iTrackCount > 30 then
      iTrackCount := 0 ;

   BringToLife ;
   end
else
   begin
   iTrackCount   := 0 ;
   edTrackCount.Text := '0' ;
//   BringToLife ;
   DisableButtons ;
   end ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.BringToLife;
begin
iCurrentTrack := 1 ;
bPlaying      := False ;
bShowDisplay  := True ;
edPause.Text  := 'no' ;
edTrackCount.Text := IntToStr(iTrackCount) ;
edTracks.Text := '0' ;  // force edTracks.Text change
edTracks.Text := '1' ;
PositionChange ;
edCDID.Text   := edLenMins.Text + edLenSecs.Text + edLenFrames.Text;

tbTrackBar.Max := iTrackCount ;

ClearTrackArray ;

if CDDeviceOpen = True then  // if this check isn't performed,
   fPlaylst.OpenCDFile ;     // this call will cause an access violation error

ShowDescriptions ;
end ;


{---------------------------------------------------------------------}
procedure TfCDPlayer.Timer1Timer(Sender: TObject);
var
ErrorString      : string ;
begin

    ErrorString := IntToStr(SSMediaPlayer.Error);
    edErrorBox.Text := ErrorString ;

   if (bPlaying = True) and (bShowDisplay = True) and (cdDeviceOpen = True) then
      begin
      PositionDisplay ;

//      if SSMediaPlayer.Error = 266 then // eject during play
      if (ssMediaPlayer.Error = 262) or (ssMediaPlayer.Error = 266) then  // tray opened during stop
         begin
         bPlaying     := False ;
         ssMediaPlayer.Close ;
         cdDeviceOpen := False ;
         end ;



      if iMode = 1 then // random play
         begin
         CheckRandomise(Sender) ;
         end ;

      if iMode = 2 then // playlist
         begin
         CheckPlaylist(Sender) ;
         end ;

      end ;

   if (bPlaying = False) and (CDDeviceOpen = True) then
   begin
      ssMediaPlayer.Tracks ;  // perform i/o to get error

      if (ssMediaPlayer.Error = 262) or (ssMediaPlayer.Error = 266) then  // tray opened during stop
      begin
         ssMediaPlayer.Close ;
         DisableButtons ;
         cdDeviceOpen := False ;
      end ;
   end ;

   bShowDisplay := True ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.CheckPlaylist(Sender : TObject) ;
var
iNewPLTrack  : integer ;
iPLTrackCount : integer ;
begin

   if StrToInt(edMins.Text) = StrToInt(edLenMins.Text) then
      begin
       if(StrToInt(edSecs.Text) = StrToInt(edLenSecs.Text)) or (StrToInt(edSecs.Text) = StrToInt(edLenSecs.Text) - 1) then
         begin
         // move to next playlist track
         sbStopClick(Sender) ;

         iPLTrackCount := PLTracks;  // call PLTracks function
         iPLTrack := iPLTrack + 1 ;

         if (iPLTrack <= iPLTrackCount) and (iPLTrackCount > 0) then
            begin
            iNewPLTrack := StrToInt(fPlaylst.sgPlaylist.Cells[0, iPLTrack])  ;
            MoveToSuppliedTrack(Sender, iNewPLTrack) ;
            bProgramCall := True ;
            sbPlayClick(Sender) ;
            bProgramCall := False ;
            end ;


         end ;
      end ;


// buggerold
end ;


{---------------------------------------------------------------------}
procedure TfCDPlayer.CheckRandomise(Sender : TObject) ;
var
iNewRandomTrack  : integer ;
begin

   if StrToInt(edMins.Text) = StrToInt(edLenMins.Text) then
      begin

      if(StrToInt(edSecs.Text) = StrToInt(edLenSecs.Text)) or (StrToInt(edSecs.Text) = StrToInt(edLenSecs.Text) - 1) then
         begin
         // move to next random track
         iNewRandomTrack := Random(iTrackCount) ;
         bPlaying := False ;
         ssMediaPlayer.Stop ;
         MoveToSuppliedTrack(Sender, iNewRandomTrack) ;
         bProgramCall := True ;
         sbPlayClick(Sender) ;
         bProgramCall := False ;
         end ;

      end ;


//buggerold
end ;


{---------------------------------------------------------------------}

procedure TfCDPlayer.MoveToSuppliedTrack(Sender : TObject; iNewSuppliedTrack : integer);
var
iCount : integer ;
iLocalCurrent : integer ;

begin
   if iNewSuppliedTrack < iCurrentTrack then
      begin
      iLocalCurrent := iCurrentTrack ;

      for iCount := iLocalCurrent downto iNewSuppliedTrack + 1 do
         begin
         sbPreviousClick(Sender) ;
         end ;

      end ;

   if iNewSuppliedTrack > iCurrentTrack then
      begin
      iLocalCurrent := iCurrentTrack ;

      for iCount := iLocalCurrent to iNewSuppliedTrack - 1 do
         begin
         sbForwardClick(Sender) ;
         end ;

      end ;

end ;
//

{---------------------------------------------------------------------}
procedure TfCDPlayer.edTracksChange(Sender: TObject);
var
iLTrack   : integer ;
iRTrack   : integer ;
iTrackVal : integer ;

begin

iCurrentTrack := StrToInt(edTracks.Text) ;
// buggerold
tbTrackBar.Position := iCurrentTrack ;

LengthDisplay ;

iTrackVal := iCurrentTrack ;

if (iTrackVal > 60) or (iTrackVal < 0) then
   begin
   iLTrack := 0 ;
   iRTrack := 0 ;
   end
else
   begin
   iLTrack := iTrackVal div 10 ;
   iRTrack := iTrackVal - (iLTrack * 10) ;
   end ;

ImageList1.Draw(ptBoxTrack.Canvas,  0, 0, iLTrack);
ImageList1.Draw(ptBoxTrack.Canvas, 16, 0, iRTrack);

ShowDescriptions ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.ShowDescriptions;
begin
// change descriptions
if iCurrentTrack - 1 = 0 then
   lbPrevTrack.Caption := ''
else
   lbPrevTrack.Caption := CdTrackInfo[iCurrentTrack - 1].Description ;

lbCurrentTrack.Caption := CdTrackInfo[iCurrentTrack ].Description ;
lblScroll.Caption      := lbCurrentTrack.Caption ;
sScroll := lblScroll.Caption ;

if iCurrentTrack + 1 > iTrackCount then
   lbNextTrack.Caption := ''
else
   lbNextTrack.Caption := CdTrackInfo[iCurrentTrack + 1].Description ;

end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.bTrackLenClick(Sender: TObject);
begin
LengthDisplay ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.Button1Click(Sender: TObject);
begin
edSecs.Text := '1' ;
edSecsChange(Sender);
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.edSecsChange(Sender: TObject);
var
iLSec : integer ;
iRSec : integer ;
iSecVal : integer ;
begin

if CDDeviceOpen = True then
   iSecVal := StrToInt(edSecs.Text)
  // buggerold
else
   iSecVal := 0 ;

if (iSecVal > 60) or (iSecVal < 0) then
   begin
   iLsec := 0 ;
   iRSec := 0 ;
   end
else
   begin
   iLSec := iSecVal div 10 ;
   iRsec := iSecVal - (iLSec * 10) ;
   end ;

ImageList1.Draw(ptBoxPosition.Canvas,38, 0, iLSec);
ImageList1.Draw(ptBoxPosition.Canvas,54, 0, iRSec);

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.edMinsChange(Sender: TObject);
var
iLMin : integer ;
iRMin : integer ;
iMinVal : integer ;
begin

if CDDeviceOpen = True then
   iMinVal := StrToInt(edMins.Text)
// buggerold
else
   iMinVal := 0 ;

if (iMinVal > 60) or (iMinVal < 0) then
   begin
   iLMin := 0 ;
   iRMin := 0 ;
   end
else
   begin
   iLMin := iMinVal div 10 ;
   iRMin := iMinVal - (iLMin * 10) ;
   end ;

ImageList1.Draw(ptBoxPosition.Canvas,0, 0, iLMin);
ImageList1.Draw(ptBoxPosition.Canvas,16, 0, iRMin);

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.ptboxPositionPaint(Sender: TObject);
begin
edMinsChange(Sender) ;
edSecsChange(Sender) ;
end;

procedure TfCDPlayer.edLenMinsChange(Sender: TObject);
var
iLMin : integer ;
iRMin : integer ;
iMinVal : integer ;
begin

iMinVal := StrToInt(edLenMins.Text) ;
//buggerold
if (iMinVal > 60) or (iMinVal < 0) then
   begin
   iLMin := 0 ;
   iRMin := 0 ;
   end
else
   begin
   iLMin := iMinVal div 10 ;
   iRMin := iMinVal - (iLMin * 10) ;
   end ;

ImageList1.Draw(ptBoxLength.Canvas,0, 0, iLMin);
ImageList1.Draw(ptBoxLength.Canvas,16, 0, iRMin);


end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.edLenSecsChange(Sender: TObject);
var
iLSec : integer ;
iRSec : integer ;
iSecVal : integer ;
begin

iSecVal := StrToInt(edLenSecs.Text) ;
// buggerold

if (iSecVal > 60) or (iSecVal < 0) then
   begin
   iLsec := 0 ;
   iRSec := 0 ;
   end
else
   begin
   iLSec := iSecVal div 10 ;
   iRsec := iSecVal - (iLSec * 10) ;
   end ;

ImageList1.Draw(ptBoxLength.Canvas,38, 0, iLSec);
ImageList1.Draw(ptBoxLength.Canvas,54, 0, iRSec);


end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.ptBoxLengtPaint(Sender: TObject);
begin
edLenMinsChange(Sender) ;
edLenSecsChange(Sender) ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.ptBoxTrackPaint(Sender: TObject);
begin
edTracksChange(Sender) ;  // this is ok
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.edTrackCountChange(Sender: TObject);
var
iLTrack : integer ;
iRTrack : integer ;
iTrackVal : integer ;

begin
iTrackVal := StrToInt(edTrackCount.Text) ;
//bugger this one

if (iTrackVal > 60) or (iTrackVal < 0) then
   begin
   iLTrack := 0 ;
   iRTrack := 0 ;
   end
else
   begin
   iLTrack := iTrackVal div 10 ;
   iRTrack := iTrackVal - (iLTrack * 10) ;
   end ;

ImageList1.Draw(ptBoxTotTracks.Canvas,0, 0, iLTrack);
ImageList1.Draw(ptBoxTotTracks.Canvas,16, 0, iRTrack);


end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.ptBoxTotTracksPaint(Sender: TObject);
begin
edTrackCountChange(Sender) ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.ptBoxLengthPaint(Sender: TObject);
begin
edLenMinsChange(Sender) ;
edLenSecsChange(Sender) ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbPlayClick(Sender: TObject);
var
iPLTrackCount : integer ;
iNewPLTrack   : integer ;
bOKtoPlay : boolean ;
begin

   bOKtoPlay := False ;

   if (iMode = 2) and (bProgramCall = False) then // playlist
      begin
      iPLTrack := 1 ;
      iPLTrackCount := PLTracks;  // call PLTracks function

      if iPLTrackCount >= iPLTrack then
         begin
            iNewPLTrack := StrToInt(fPlaylst.sgPlaylist.Cells[0, iPLTrack])  ;
            MoveToSuppliedTrack(Sender, iNewPLTrack) ;
            bOKtoPlay := True ;
         end ;

      end
   else
      begin
      bOKtoPlay := True ;
      end ;


 if bOKtoPlay = True then
    begin

   dullPlay.Visible := False ;
   boldPlay.Visible := True ;
   bShowDisplay  := False ;

      MoveToTrack ;
      SSMediaPlayer.Play ;
      bPlaying := True ;
      edPause.Text := 'no' ;
    end ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbStopClick(Sender: TObject);
begin
   bShowDisplay  := False ;
   SSMediaPlayer.Stop ;
   bPlaying := False ;
   MovetoTrack ;
   PositionChange ;
   SSMediaPlayer.Stop ;
   edPause.Text := 'no' ;
   dullPlay.Visible := True ;
   boldPlay.Visible := False ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbForwardClick(Sender: TObject);
begin
   bShowDisplay  := False ;

   if edPause.Text = 'yes' then
      edPause.Text := 'no' ;

   if (iCurrentTrack + 1) <= iTrackCount then
      begin
      iCurrentTrack := iCurrentTrack + 1 ;
      PositionChange ;
      tbTrackBar.Position := iCurrentTrack ;
      end ;

   if bPlaying = true then
      MoveToTrack ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbPreviousClick(Sender: TObject);
begin
   bShowDisplay  := False ;

   if edPause.Text = 'yes' then
      edPause.Text := 'no' ;

   if (iCurrentTrack - 1) > 0 then
      begin
      iCurrentTrack := iCurrentTrack - 1 ;
      PositionChange ;
      tbTrackBar.Position := iCurrentTrack ;
      end ;

   if bPlaying = true then
      MoveToTrack ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.Panel7Click(Sender: TObject);
var
  NewAboutBox: TAboutBox;
begin

  NewAboutBox := TAboutBox.Create(Self) ;
  NewAboutBox.ShowModal ;

  NewAboutBox.Release ;
end;

procedure TfCDPlayer.Label21Click(Sender: TObject);
var
  NewAboutBox: TAboutBox;
begin

  NewAboutBox := TAboutBox.Create(Self) ;
  NewAboutBox.ShowModal ;

  NewAboutBox.Release ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbPauseClick(Sender: TObject);
begin

if edPause.Text = 'no' then
   begin
   edPause.Text := 'yes' ;
   end
else
   begin
   edPause.Text := 'no' ;
   end ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.edPauseChange(Sender: TObject);
begin

   if edPause.Text = 'yes' then
         begin
         boldPause.Visible := True ;
         dullPause.Visible := False ;
         SSMediaPlayer.Pause ;
         lbPaused.Font.color := clLime ;
         sbPause.Hint := 'Resume Playing' ;
         end
   else
         begin
         boldPause.Visible := False ;
         dullPause.Visible := True ;
         lbPaused.Font.color := clGreen ;
         sbPause.Hint := 'Pause Playing' ;

         if bPlaying = true then
            SSMediaPlayer.Play ;

         end ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbFForwardClick(Sender: TObject);
begin
   bShowDisplay  := False ;

   if edPause.Text = 'yes' then
      edPause.Text := 'no' ;

   PositionAdd5 ;

   if bPlaying = true then
      MoveInToTrack ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbRewindClick(Sender: TObject);
begin
   bShowDisplay  := False ;

   if edPause.Text = 'yes' then
      edPause.Text := 'no' ;

   PositionSub5 ;

   if bPlaying = true then
      MoveInToTrack ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.bPlaylistClick(Sender: TObject);
begin
fPlaylst.Showmodal ;
ShowDescriptions;
end;

procedure TfCDPlayer.ClearTrackArray;
var
iCount : integer ;
begin

for iCount := 1 to 50 do
   begin
   CDTrackInfo[iCount].CDId        := '' ;
   CDTrackInfo[iCount].TrackNo     := 0 ;
   CDTrackInfo[iCount].Description := '' ;
   end ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.DisableButtons;
begin
sbPrevious.Enabled  := False ;
sbForward.Enabled   := False ;
sbRewind.Enabled    := False ;
sbFForward.Enabled  := False ;
sbPause.Enabled     := False ;
sbStop.Enabled      := False ;
sbPlay.Enabled      := False ;
bPlaylist.Enabled   := False ;
tbTrackBar.Enabled  := False ;
end ;

{---------------------------------------------------------------------}
procedure TfCDPlayer.EnableButtons;
begin
sbPrevious.Enabled  := True ;
sbForward.Enabled   := True ;
sbRewind.Enabled    := True ;
sbFForward.Enabled  := True ;
sbPause.Enabled     := True ;
sbStop.Enabled      := True ;
sbPlay.Enabled      := True ;
bPlaylist.Enabled   := True ;
tbTrackBar.Enabled  := True ;

end ;


{---------------------------------------------------------------------}
procedure TfCDPlayer.TimerCheckCDTimer(Sender: TObject);

begin
// 2 second check - is cd in drawer? if yes then bring player to life

if CDDeviceOpen = False then
   begin

   DisableButtons ;

   CDDeviceOpen := OpenCDDevice(SSMediaPlayer) ;


   if CDDeviceOpen = True then
      begin

      ssMediaPlayer.Tracks ;  // perform i/o to get error

      if (ssMediaPlayer.Error = 262) or (ssMediaPlayer.Error = 266) then  // tray opened during stop
         begin
         bPlaying     := False ;
         ssMediaPlayer.Close ;
         cdDeviceOpen := False ;
         end
      else
         begin
         EnableButtons ;
         iTrackCount := SSMediaPlayer.Tracks ;
         BringToLife ;
         end ;

      end ;

   end ;


end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.bModeClick(Sender: TObject);
begin

// iMode = 0 Regular
//       = 1 Random
//       = 2 Playlist

   if iMode = 0 then
      begin
      lbRegular.Font.color  := clGreen ;
      lbRandom.Font.color   := clLime ;
      lbPlaylist.Font.color := clGreen ;
      iMode := 1 ;
      exit ;
      end ;

   if iMode = 1 then
      begin
      lbRegular.Font.color  := clGreen ;
      lbRandom.Font.color   := clGreen ;
      lbPlaylist.Font.color := clLime ;
      iPLTrack := 1 ;
      iMode := 2 ;
      exit ;
      end ;

   if iMode = 2 then
      begin
      lbRegular.Font.color  := clLime ;
      lbRandom.Font.color   := clGreen ;
      lbPlaylist.Font.color := clGreen ;
      iMode := 0 ;
      exit ;
      end ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.sbEjectClick(Sender: TObject);
begin
//   SSMediaPlayer.Stop ;
   SSMediaPlayer.Eject ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if CDDeviceOpen = True then
   begin
      SSMediaPlayer.Stop ;
   end ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.miExitClick(Sender: TObject);
begin
   if CDDeviceOpen = True then
   begin
      SSMediaPlayer.Stop ;
      Application.Terminate ;
   end ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.miAboutClick(Sender: TObject);
var
  NewAboutBox: TAboutBox;
begin

  NewAboutBox := TAboutBox.Create(Self) ;
  NewAboutBox.ShowModal ;

  NewAboutBox.Release ;
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.tbTrackBarChange(Sender: TObject);
begin
   iCurrentTrack := tbTrackBar.Position ;
   bShowDisplay  := False ;
   PositionChange ;

   if bPlaying = true then
      MoveToTrack ;

end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.miHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

{---------------------------------------------------------------------}
procedure TfCDPlayer.FormDestroy(Sender: TObject);
begin
  Application.HelpCommand(HELP_QUIT, 0);

end;

procedure TfCDPlayer.btnHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);

end;

end.
