unit fField;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinGImag, uGlobal, uGame, Dib256, StdCtrls, ExtCtrls, ComCtrls, Mailslot;

type
  TformField = class(TForm)
    labelPause: TLabel;
    WinGField: TWinGImage;
    MailServer: TMailslotServer;
    MailClient: TMailslotClient;
    statusbarGame: TStatusBar;
    Timer1: TTimer;
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
  private
      AppOut: Boolean;
      FCreated: Boolean;

      procedure WindowPosChanged( var Msg: TWMWindowPosChanged );
         message WM_WINDOWPOSCHANGED;
      procedure EndGame( var Msg: TMessage );
         message WM_ENDGAME;
      procedure ApplicationActivate(Sender: TObject);
      procedure ApplicationDeactivate(Sender: TObject);
      procedure TrapMouse( flag: Boolean );
      procedure ThreadPlay( flag: Boolean );
      procedure SetPause( flag: Boolean );
      procedure CalcMouseCenter;
  public
      procedure DrawPads_Ball;
      procedure DrawGoals;
      procedure DrawTimer;
      procedure ReadMessages;
      procedure MailMessage( IdMsg: Byte );
  end;

var
  formField: TformField;
  GameThread: TGameThread;


implementation

{$R *.DFM}


procedure TformField.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   FPM := Quit;

   Action := caFree;
end;


procedure TformField.FormDestroy(Sender: TObject);
begin
   Application.OnActivate := nil;
   Application.OnDeactivate := nil;

   TrapMouse( False );

   GameThread.Resume;
   GameThread.Terminate;
   GameThread := nil;

   DibField.Free;
end;



procedure TformField.ApplicationActivate(Sender: TObject);
begin
   AppOut := False;
   SetPause( False );
end;


procedure TformField.ApplicationDeactivate(Sender: TObject);
begin
   AppOut := True;
   SetPause( True );
end;


procedure TformField.FormActivate(Sender: TObject);
var
   Cnt, Cnt2: Integer;
   fs: TFileStream;
   pS, pD: PChar;
   C, X, Y: Integer;
   t: Longint;
   v: Byte;
begin
   if FCreated = False then
   begin
      AppOut := False;
      FPM := Setup;
      FCreated := True;

      // coloca nome de computador adversrio em MailClient
      if not(OnePlayer) then
         MailClient.ReceiverName := StrPas(OpponentComputerName);

      // inicializa WinGImage
      WinGField.WinG.Width := FIELDWIDTH;
      WinGField.WinG.Height := FIELDHEIGHT;

      // inicializa as posies das raquetes e bola
      if (Ball.Side = 0) then
         Ball.PosX := BALLINITPOSX - (BALLWIDTH div 2)
      else
         Ball.PosX := (FIELDWIDTH-1) - BALLINITPOSX - (BALLWIDTH div 2);
      Ball.PosY := FIELDHEIGHT div 2 - BALLHEIGHT div 2;
      Ball.Vel := 0;
      Ball.Ang := Pi;

      for Cnt := 0 to 1 do
      with Pad[Cnt] do
      begin
         if (Cnt = 0) then
            PosX := PADINITPOSX
         else
            PosX := FIELDWIDTH - PADINITPOSX - PADWIDTH;

         PosY := FIELDHEIGHT/2 - PADHEIGHT/2;

         PosAntX := Trunc(PosX);
         PosAntY := Trunc(PosY);

         Goals := 0;

         IndSprite := 0;   // indice do sprite da raquete

         // Coloca a 0 o array das velocidades da raquete e o indice apontador
         for Cnt2 := 0 to High(VelX) do
         begin
            VelX[ Cnt2 ] := 0;
            VelY[ Cnt2 ] := 0;
         end;
         IndVel := 0;
      end;

      // l imagem do campo
      try
         DibField := TDib256.Create;
         DibField.LoadFromFile( FILEBALLFIELD );
      except
         on E: Exception do
         begin
            MessageDlg('Error: ' + E.Message, mtInformation, [mbOK], 0);
            Close;
            Exit;
         end;
      end;

      // coloca a imagem do campo no WinGImage, e inicializa palete
      WinGField.Palette.ReadFromRGBQuad( PRGBQUAD(DibField.ColorTable), 256 );
      WinGField.Palette.CreateHandle;
      SelectPalette( WinGField.Canvas.Handle, WinGField.Palette.Handle, False );
      RealizePalette( WinGField.Canvas.Handle );
      CopyDIBBits( WinGField.WinG.Pixels, DibField.Pixels, FIELDWIDTH,
         FIELDHEIGHT, WinGField.WinG.WidthBytes, DibField.WidthBytes );

      // l o sprite da bola
      fs := TFileStream.Create( FILEDATABALL, fmOpenRead );
      try
         fs.ReadBuffer( BallSprites[0], sizeof(BallSprites) );
      finally
         fs.Free;
      end;

      // l os sprites das raquetes
      fs := TFileStream.Create( FILEDATAPAD, fmOpenRead );
      try
         fs.ReadBuffer( PadSprites[0], sizeof(PadSprites[0]) );
      finally
         fs.Free;
      end;

      // copia e inverte raquetes para o jogador 2
      pS := @PadSprites[0];
      pD := @PadSprites[1];
      for C := 0 to PADSPRITESNUMBER-1 do
         for X := 0 to PADWIDTH-1 do
            for Y := 0 to PADHEIGHT-1 do
               (pD + C*PADWIDTH + PADWIDTH-1 - X + Y*PADWIDTH*PADSPRITESNUMBER)^
                  := (pS + X + Y*PADWIDTH*PADSPRITESNUMBER + C*PADWIDTH)^;


      // l a matriz de choques
      fs := TFileStream.Create( FILEDATASHOCK, fmOpenRead );
      try
         fs.ReadBuffer( ShockMask[0], sizeof(ShockMask[0]) );
      finally
         fs.Free;
      end;

      // copia e inverte matriz de choques para o jogador 2
      for X := 0 to SMWIDTH-1 do
         for Y := 0 to SMHEIGHT-1 do
         begin
            v := ShockMask[0, X, Y];
            ShockMask[1, SMWIDTH-1 - X, Y] := (v and 128) + ((128 - v) and 127);
         end;

      // cria thread do jogo
      GameThread := TGameThread.Create( False );
      GameThread.Suspend;
      GameThread.FreeOnTerminate := True;

      // instala handlers de activao/desactivao da aplicao
      Application.OnActivate := ApplicationActivate;
      Application.OnDeactivate := ApplicationDeactivate;
      Application.OnActivate( self );

      // calcula posio central do rato
      CalcMouseCenter;

      // init goal panel
      DrawGoals;
      DrawTimer;

      // tenta estabelecer ligao com o adversrio
      if not(OnePlayer) then
      begin
         t := 0;
         repeat
            MailMessage( NBG_CONNECT );
            SleepEx( 50, false );
            Inc( t, 50 );
            ReadMessages;
         until (FPM = Ready) or (FPM = Start) or (t >= CONNECTION_TIMEOUT);
         if (t >= CONNECTION_TIMEOUT) then
         begin
            MessageDlg('Connection time-out.', mtInformation, [mbOk], 0);
            Close;
         end;
      end
      else
         FPM := Start;

      TrapMouse( True );
      ThreadPlay( True );
   end;
end;


procedure TformField.FormKeyPress(Sender: TObject; var Key: Char);
begin
   if (UpCase(Key) = KEY_EXIT) then
   begin
      if not(OnePlayer) then
         MailMessage( NBG_ABORTGAME );
      Close;
   end;

   if (UpCase(Key) = KEY_PAUSE) then
   begin
      if (FPM = Play) then
         SetPause( True )
      else
      if (FPM = Pause) then
         SetPause( False );
   end;
end;


procedure TformField.WindowPosChanged( var Msg: TWMWindowPosChanged );
begin
   inherited;

   CalcMouseCenter;
end;


procedure TformField.EndGame( var Msg: TMessage );
begin
   case Msg.WParam of
      END_OK:
         begin
            MessageDlg('End of Game', mtInformation, [mbOk], 0);
            Close;
         end;

      END_TIMEOUT:
         begin
            MessageDlg('Connection time-out', mtInformation, [mbOk], 0);
            Close;
         end;
   end;
end;


procedure TformField.Timer1Timer(Sender: TObject);
begin
   if not(OnePlayer) then
      ReadMessages;
end;


//***** rotinas ******

procedure TformField.TrapMouse( flag: Boolean );
var
   t: TRect;
   p: TPoint;
begin
   if (flag = True) and (AppOut = False) then
   begin
      p := ClientOrigin;
      t := ClientRect;
      Inc( t.Left, p.X );
      Inc( t.Top, p.Y );
      Inc( t.Right, p.X );
      Inc( t.Bottom, p.Y );
      ClipCursor( @t );
      while ShowCursor( False ) >= 0 do
         ShowCursor( False );

      SetCursorPos( GameThread.MouseCenterX, GameThread.MouseCenterY );
   end
   else
   begin
      // mostra cursor
      while ShowCursor( True ) <= -1 do
         ShowCursor( True );

      ClipCursor( nil );
   end;
end;


procedure TformField.ThreadPlay( flag: Boolean );
begin
   if (flag = True) and (AppOut = False) then
   begin
      while (GameThread.Suspended = True) do
         GameThread.Resume;
      Timer1.Enabled := False;
   end
   else
   begin
      if (GameThread.Suspended = False) then
         GameThread.Suspend;
      Timer1.Enabled := True;
   end;
end;


procedure TformField.SetPause( flag: Boolean );
begin
   if (flag = False) and (AppOut = False) then
   begin
      if (FPM = Pause) then
      begin
         FPM := Play;
         labelPause.Visible := False;
         TrapMouse( True );
         ThreadPlay( True );
      end;
      if (not(OnePlayer)) then
         MailMessage( NBG_RESUMEGAME );
   end
   else
   begin
      if (FPM = Play) then
      begin
         FPM := Pause;
         ThreadPlay( False );
         TrapMouse( False );
         labelPause.Visible := True;
      end;
      if (not(OnePlayer)) then
         MailMessage( NBG_PAUSEGAME );
   end;
end;


procedure TformField.CalcMouseCenter;
var
   p: TPoint;
begin
   if (GameThread <> nil) then
   begin
      p := ClientOrigin;
      GameThread.MouseCenterX := p.X + WinGField.Left + FIELDWIDTH div 2;
      GameThread.MouseCenterY := p.Y + WinGField.Top + FIELDHEIGHT div 2;
   end;
end;

procedure TformField.DrawPads_Ball;
var
   Cnt: Integer;
   a, b, c: TRect;
begin
   // undraw pads
   for Cnt := 0 to 1 do
   with Pad[Cnt] do
   begin
      if ((PosX = PosAntX) and (PosY = PosAntY)) then
         continue;

      // copy background of old position of pad to the GameField
      CopyDIBBits( PChar(WinGField.WinG.Pixels)
         + Trunc(Pad[Cnt].PosAntX + Pad[Cnt].PosAntY*FIELDWIDTH),
         PChar(DibField.Pixels)
         + Trunc(Pad[Cnt].PosAntX + Pad[Cnt].PosAntY*FIELDWIDTH),
         PADWIDTH, PADHEIGHT,
         FIELDWIDTH, FIELDWIDTH );
   end;

   // undraw ball
   CopyDIBBits( PChar(WinGField.WinG.Pixels)
      + Ball.PosAntX + Ball.PosAntY*FIELDWIDTH,
      PChar(DibField.Pixels)
      + Ball.PosAntX + Ball.PosAntY*FIELDWIDTH,
      BALLWIDTH, BALLHEIGHT,
      WinGField.WinG.WidthBytes, DibField.WidthBytes );

   // realize palette
   SelectPalette( WinGField.Canvas.Handle, WinGField.Palette.Handle, False );
   RealizePalette( WinGField.Canvas.Handle );

   // draw pads
   for Cnt := 0 to 1 do
   with Pad[Cnt] do
   begin
      // copy the pad in new position to the GameField
      TransCopyDIBBits( PChar(WinGField.WinG.Pixels)
         + Trunc(Pad[Cnt].PosX) + Trunc(Pad[Cnt].PosY)*FIELDWIDTH,
         @PadSprites[Cnt][Pad[Cnt].IndSprite],
         PADWIDTH, PADHEIGHT, FIELDWIDTH, PADWIDTH, 0 );

      // calc. the rectangle which needs to be updated
      a.Left := Trunc(Pad[Cnt].PosX);
      a.Top := Trunc(Pad[Cnt].PosY);
      a.Right := a.Left + PADWIDTH;
      a.Bottom := a.Top + PADHEIGHT;
      b.Left := Trunc(Pad[Cnt].PosAntX);
      b.Top := Trunc(Pad[Cnt].PosAntY);
      b.Right := b.Left + PADWIDTH;
      b.Bottom := b.Top + PADHEIGHT;
      UnionRect( c, a, b );

      // draw updated rectangle to screen
      WinGField.WinG.BitBlt( WinGField.Canvas.Handle,
         c.Left, c.Top, c.Right - c.Left, c.Bottom - c.Top,
         c.Left, c.Top );

      // set new position as old position
      Pad[Cnt].PosAntX := Trunc(Pad[Cnt].PosX);
      Pad[Cnt].PosAntY := Trunc(Pad[Cnt].PosY);
   end;

   // draw ball
   // copy the ball in new position to the GameField
   TransCopyDIBBits( PChar(WinGField.WinG.Pixels)
      + Trunc(Ball.PosX) + Trunc(Ball.PosY)*FIELDWIDTH, @BallSprites,
      BALLWIDTH, BALLHEIGHT, WinGField.WinG.WidthBytes, BALLWIDTH, 0 );

   // calc. the rectangle which needs to be updated
   a.Left := Trunc(Ball.PosX);
   a.Top := Trunc(Ball.PosY);
   a.Right := a.Left + BALLWIDTH;
   a.Bottom := a.Top + BALLHEIGHT;
   b.Left := Ball.PosAntX;
   b.Top := Ball.PosAntY;
   b.Right := b.Left + BALLWIDTH;
   b.Bottom := b.Top + BALLHEIGHT;
   UnionRect( c, a, b );

   // draw updated rectangle to screen
   WinGField.WinG.BitBlt( WinGField.Canvas.Handle,
      c.Left, c.Top, c.Right - c.Left, c.Bottom - c.Top,
      c.Left, c.Top );

   // set new position as old position
   Ball.PosAntX := Trunc(Ball.PosX);
   Ball.PosAntY := Trunc(Ball.PosY);
end;


procedure TformField.DrawGoals;
var
   Cnt: Integer;
begin
   for Cnt := 0 to 1 do
      statusbarGame.Panels.Items[Cnt].Text := StrPas( Pad[Cnt].PlayerName )
         + '    ' + IntToStr(Pad[Cnt].Goals);
end;


procedure TformField.DrawTimer;
begin
   statusbarGame.Panels.Items[2].Text :=
      format('%d:%.2d', [GameTimer div 60, GameTimer mod 60]);
end;



procedure TformField.ReadMessages;
var
   pRec: Pointer;
begin
   while (MailServer.NumberMessages > 0) do
   begin
      GetMem( pRec, sizeof(Tnbg_padballpos) );  // alloc bigger message structure size
      MailServer.ReadMessage( pRec^, MailServer.MessageSize );

      if (Pnbg_resumegame(pRec)^.SenderID = OpponentID) then
      case PByte(pRec)^ of
         NBG_RESUMEGAME:
         begin
            SetPause( False );
         end;

         NBG_PAUSEGAME:
         begin
            SetPause( True );
         end;

         NBG_ABORTGAME:
         begin
            MessageDlg('Game aborted.', mtInformation, [mbOk], 0);
            Close;
         end;

         NBG_PADPOS:
         with Pnbg_padpos(pRec)^ do
         begin
            if (CycleNum = OpponentCycle) and (OpponentCycle <= SelfCycle) then
            begin
               Pad[1-PlayerSide].PosX := PadX;
               Pad[1-PlayerSide].PosY := PadY;
               Inc( OpponentCycle );
            end;
         end;

         NBG_PADBALLPOS:
         with Pnbg_padballpos(pRec)^ do
         begin
            if (CycleNum = OpponentCycle) and (OpponentCycle <= SelfCycle) then
            begin
               Pad[1-PlayerSide].PosX := PadX;
               Pad[1-PlayerSide].PosY := PadY;
               Ball.PosX := BallX;
               Ball.PosY := BallY;
               if (BallVel <> 0) then
               begin
                  Ball.Side := PlayerSide;
                  Ball.Vel := BallVel;
                  Ball.Ang := BallAng;
               end;
               Inc( OpponentCycle );
            end;
         end;

         NBG_CONNECT:
         begin
            MailMessage( NBG_SYSTEMREADY );
         end;

         NBG_SYSTEMREADY:
         begin
            if (FPM = Setup) then
               FPM := Ready;
         end;

         NBG_STARTGAME:
         begin
            if (FPM = Ready) then
               FPM := Start;
         end;
      end;
   end;

end;



procedure TformField.MailMessage( IdMsg: Byte );
var
   pRec: Pointer;
begin
   case IdMsg of
      NBG_RESUMEGAME:
      begin
         New( Pnbg_resumegame(pRec) );
         with Pnbg_resumegame(pRec)^ do
         begin
            ID := NBG_RESUMEGAME;
            SenderID := SelfID;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_resumegame) );
         Dispose( Pnbg_resumegame(pRec) );
      end;

      NBG_PAUSEGAME:
      begin
         New( Pnbg_pausegame(pRec) );
         with Pnbg_pausegame(pRec)^ do
         begin
            ID := NBG_PAUSEGAME;
            SenderID := SelfID;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_pausegame) );
         Dispose( Pnbg_pausegame(pRec) );
      end;

      NBG_ABORTGAME:
      begin
         New( Pnbg_abortgame(pRec) );
         with Pnbg_abortgame(pRec)^ do
         begin
            ID := NBG_ABORTGAME;
            SenderID := SelfID;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_abortgame) );
         Dispose( Pnbg_abortgame(pRec) );
      end;

      NBG_PADPOS:
      begin
         New( Pnbg_padpos(pRec) );
         with Pnbg_padpos(pRec)^ do
         begin
            ID := NBG_PADPOS;
            SenderID := SelfID;
            CycleNum := SelfCycle;
            PadX := Trunc(Pad[PlayerSide].PosX);
            PadY := Trunc(Pad[PlayerSide].PosY);
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_padpos) );
         Dispose( Pnbg_padpos(pRec) );
         Inc( SelfCycle );
      end;

      NBG_PADBALLPOS:
      begin
         New( Pnbg_padballpos(pRec) );
         with Pnbg_padballpos(pRec)^ do
         begin
            ID := NBG_PADBALLPOS;
            SenderID := SelfID;
            CycleNum := SelfCycle;
            PadX := Trunc(Pad[PlayerSide].PosX);
            PadY := Trunc(Pad[PlayerSide].PosY);
            BallX := Trunc(Ball.PosX);
            BallY := Trunc(Ball.PosY);
            // verifica se a bola j no est neste lado do campo
            if (Ball.Side <> PlayerSide) then
            begin
               BallVel := Ball.Vel;
               BallAng := Ball.Ang;
            end
            else
               BallVel := 0;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_padballpos) );
         Dispose( Pnbg_padballpos(pRec) );
         Inc( SelfCycle );
      end;

      NBG_SYSTEMREADY:
      begin
         New( Pnbg_systemready(pRec) );
         with Pnbg_systemready(pRec)^ do
         begin
            ID := NBG_SYSTEMREADY;
            SenderID := SelfID;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_systemready) );
         Dispose( Pnbg_systemready(pRec) );
      end;

      NBG_STARTGAME:
      begin
         New( Pnbg_startgame(pRec) );
         with Pnbg_startgame(pRec)^ do
         begin
            ID := NBG_STARTGAME;
            SenderID := SelfID;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_startgame) );
         Dispose( Pnbg_startgame(pRec) );
      end;

      NBG_CONNECT:
      begin
         New( Pnbg_connect(pRec) );
         with Pnbg_connect(pRec)^ do
         begin
            ID := NBG_CONNECT;
            SenderID := SelfID;
         end;
         MailClient.WriteMessage( pRec^, sizeof(Tnbg_connect) );
         Dispose( Pnbg_connect(pRec) );
      end;

      else  raise Exception.Create('Unknown message id');
   end;
end;


end.
