unit fNetBall;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, uGlobal, ComCtrls, RegFiles, Mailslot;

const
   CONFIRMJOIN_TIMEOUT  = 3000;
   REG_GAMEDURATION     = 'Duration';
   REG_SHOCKELASTICITY  = 'Shock';
   REG_PLAYERSIDE       = 'Side';
   REG_PLAYERNAME       = 'Name';
   DEF_GAMEDURATION     = 5;
   DEF_SHOCKELASTICITY  = 50;
   DEF_PLAYERSIDE       = 0;
   DEF_PLAYERNAME       = 'Unknown';

type
   TMenuMode = (None, Waiting, Game, Joining);

  TformNetBall = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    bitbtnClose: TBitBtn;
    bitbtnRegister: TBitBtn;
    bitbtnNewGame: TBitBtn;
    bitbtnJoinGame: TBitBtn;
    Label4: TLabel;
    editPlayerName: TEdit;
    bitbtnHelp: TBitBtn;
    listboxGames: TListBox;
    Terminal: TMailslotTerminal;
    Label5: TLabel;
    radiogroupSide: TRadioGroup;
    Panel1: TPanel;
    trackbarDuration: TTrackBar;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Panel2: TPanel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    trackbarShock: TTrackBar;
    regfileConfiguration: TRegFile;
    butttonTeste: TButton;
    procedure bitbtnCloseClick(Sender: TObject);
    procedure bitbtnNewGameClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TerminalNewMessage(Sender: TObject; SenderId: Integer;
      MsgSize: Word);
    procedure bitbtnJoinGameClick(Sender: TObject);
    procedure listboxGamesClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butttonTesteClick(Sender: TObject);
  private
      Mode: TMenuMode;

      procedure MailMessage( IdMsg: Byte );
  public
    { Public declarations }
  end;

var
  formNetBall: TformNetBall;

implementation

uses fWaiting, fField;

{$R *.DFM}


procedure TformNetBall.FormCreate(Sender: TObject);
begin
   Mode := None;

   OnePlayer := False;

   // Load last configuration
   trackbarDuration.Position :=
      regfileConfiguration.ValueDefault[REG_GAMEDURATION, DEF_GAMEDURATION];
   trackbarShock.Position :=
      regfileConfiguration.ValueDefault[REG_SHOCKELASTICITY, DEF_SHOCKELASTICITY];
   radiogroupSide.ItemIndex :=
      regfileConfiguration.ValueDefault[REG_PLAYERSIDE, DEF_PLAYERSIDE];
   editPlayerName.Text :=
      regfileConfiguration.ValueDefault[REG_PLAYERNAME, DEF_PLAYERNAME];
end;

procedure TformNetBall.FormDestroy(Sender: TObject);
begin
   // Save configuration
   regfileConfiguration.Value[REG_GAMEDURATION] := trackbarDuration.Position;
   regfileConfiguration.Value[REG_SHOCKELASTICITY] := trackbarShock.Position;
   regfileConfiguration.Value[REG_PLAYERSIDE] := radiogroupSide.ItemIndex;
   regfileConfiguration.Value[REG_PLAYERNAME] := editPlayerName.Text;
end;

procedure TformNetBall.FormActivate(Sender: TObject);
begin
   MailMessage( NB_QUERYGAMES );
end;


//****** Teclas ******
procedure TformNetBall.bitbtnNewGameClick(Sender: TObject);
begin
   // initialize game parameters
   ShockElasticity := trackbarShock.Position/100;
   GameTimer := DWord(trackbarDuration.Position)*60;
   PlayerSide := radiogroupSide.ItemIndex;
   Ball.Side := PlayerSide;
   StrPCopy( Pad[PlayerSide].PlayerName, editPlayerName.Text );
   SelfID := Terminal.UniqueID;

   MailMessage( NB_GAMEWAITING );
   Mode := Waiting;
   if (formWaiting.ShowModal = mrOk) then
   begin
      MailMessage( NB_NOGAME );
      Application.CreateForm( TformField, formField );
      Hide;
      formField.ShowModal;
      Show;
   end;

   Mode := None;
   MailMessage( NB_NOGAME );

   // actualiza lista de jogos correntes
   listboxGames.Items.Clear;
   MailMessage( NB_QUERYGAMES );
end;


procedure TformNetBall.bitbtnCloseClick(Sender: TObject);
begin
   Close;
end;


procedure TformNetBall.bitbtnJoinGameClick(Sender: TObject);
var
   t: Longint;
begin
   Mode := Joining;
   SelfID := Terminal.UniqueID;
   StrPCopy( Pad[PlayerSide].PlayerName, editPlayerName.Text );
   OpponentID := DWord(listboxGames.Items.Objects[ listboxGames.ItemIndex ]);

   MailMessage( NB_JOINGAME );

   t := GetTickCount;
   while ((GetTickCount-t < CONFIRMJOIN_TIMEOUT) and (Mode = Joining)) do
      Application.ProcessMessages;

   if (Mode = Game) then
   begin
      Application.CreateForm( TformField, formField );
      Hide;
      formField.ShowModal;
      Show;
   end
   else
      MessageDlg('Opponent didnt confirmed connection', mtInformation, [mbOk], 0);

   Mode := None;

   // actualiza lista de jogos correntes
   listboxGames.Items.Clear;
   MailMessage( NB_QUERYGAMES );
end;


// ****** outros eventos *****
procedure TformNetBall.TerminalNewMessage(Sender: TObject;
  SenderId: Integer; MsgSize: Word);
var
   pRec: Pointer;
   Ind: Integer;
   st: string;
   point: TPoint;
begin
   GetMem( pRec, MsgSize );
   Terminal.Message.Read( pRec^, MsgSize );

   case PByte(pRec)^ of
      NB_QUERYGAMES:
      begin
         if (Mode = Waiting) then
            MailMessage( NB_GAMEWAITING );
      end;

      NB_NOGAME:
      with Pnb_nogame(pRec)^ do
      begin
         Ind := listboxGames.Items.IndexOfObject( TObject(SenderID) );
         if (Ind <> -1) then
         begin
            listboxGames.Items.Delete( Ind );
            listboxGames.OnClick( self );
         end;
      end;

      NB_GAMEWAITING:
      with Pnb_gamewaiting(pRec)^ do
      begin
         Ind := listboxGames.Items.IndexOfObject( TObject(SenderID) );
         if (Ind <> -1) then
            listboxGames.Items.Delete( Ind );

         st := StrPas(PlayerName) + ' on ' + StrPas(ComputerName);
         listboxGames.Items.AddObject( st, TObject(SenderID) );
         listboxGames.OnClick( self );
      end;

      NB_JOINGAME:
      with Pnb_joingame(pRec)^ do
      begin
         if (Mode = Waiting) then
         begin
            OpponentID := SenderID;
            StrPCopy( Pad[1-PlayerSide].PlayerName, PlayerName );
            StrCopy( OpponentComputerName, ComputerName );

            Mode := Game;
            formWaiting.ModalResult := mrOk;
            GetCursorPos( point );
            SetCursorPos( point.X, point.Y );
//            SendMessage( formWaiting.Handle, WM_CLOSEMODAL, 0, 0 );
            MailMessage( NB_CONFIRMPLAYER );
         end;
      end;

      NB_CONFIRMPLAYER:
      begin
         with Pnb_confirmplayer(pRec)^ do
         begin
            if (Mode = Joining) and (OpponentID = SenderID) then
            begin
               ShockElasticity := Shock / 100;
               GameTimer := DWord(Duration) * 60;
               PlayerSide := (1 - SenderSide);
               Ball.Side := PlayerSide;
               StrCopy( Pad[SenderSide].PlayerName, PlayerName );
               StrCopy( OpponentComputerName, ComputerName );

               Mode := Game;
            end;
         end;
      end;
   end;

end;


procedure TformNetBall.listboxGamesClick(Sender: TObject);
begin
   if (listboxGames.ItemIndex <> -1) then
      bitbtnJoinGame.Enabled := True
   else
      bitbtnJoinGame.Enabled := False;
end;


//****** rotinas ******
procedure TformNetBall.MailMessage( IdMsg: Byte );
var
   pRec: Pointer;
   lixo: DWord;
begin
   case IdMsg of
      NB_GAMEWAITING:
      begin
         New( Pnb_gamewaiting(pRec) );
         with Pnb_gamewaiting(pRec)^ do
         begin
            ID := NB_GAMEWAITING;
            SenderID := Terminal.UniqueID;
            StrPCopy( PlayerName, editPlayerName.Text );
            lixo := sizeof(ComputerName);
            GetComputerName( @ComputerName, lixo );
         end;
         Terminal.WriteMessage( pRec^, sizeof(Tnb_gamewaiting) );
         Dispose( Pnb_gamewaiting(pRec) );
      end;

      NB_NOGAME:
      begin
         New( Pnb_nogame(pRec) );
         with Pnb_nogame(pRec)^ do
         begin
            ID := NB_NOGAME;
            SenderID := Terminal.UniqueID;
         end;
         Terminal.WriteMessage( pRec^, sizeof(Tnb_nogame) );
         Dispose( Pnb_nogame(pRec) );
      end;

      NB_JOINGAME:
      begin
         New( Pnb_joingame(pRec) );
         with Pnb_joingame(pRec)^ do
         begin
            ID := NB_JOINGAME;
            SenderID := Terminal.UniqueID;
            StrPCopy( PlayerName, editPlayerName.Text );
            GetComputerName( @ComputerName, lixo );
         end;
         Terminal.WriteMessage( pRec^, sizeof(Tnb_joingame) );
         Dispose( Pnb_joingame(pRec) );
      end;

      NB_QUERYGAMES:
      begin
         Terminal.WriteMessage( IdMsg, 1 );
      end;

      NB_CONFIRMPLAYER:
      begin
         New( Pnb_confirmplayer(pRec) );
         with Pnb_confirmplayer(pRec)^ do
         begin
            ID := NB_CONFIRMPLAYER;
            SenderID := Terminal.UniqueID;
            StrPCopy( PlayerName, editPlayerName.Text );
            lixo := sizeof(ComputerName);
            GetComputerName( @ComputerName, lixo );
            Duration := trackbarDuration.Position;
            Shock := trackbarShock.Position;
            SenderSide := PlayerSide;
         end;
         Terminal.WriteMessage( pRec^, sizeof(Tnb_confirmplayer) );
         Dispose( Pnb_confirmplayer(pRec) );
      end;

      else  raise Exception.Create('Unknown message id');
   end;
end;

procedure TformNetBall.butttonTesteClick(Sender: TObject);
begin
   ShockElasticity := trackbarShock.Position/100;
   GameTimer := DWord(trackbarDuration.Position)*60;
   PlayerSide := radiogroupSide.ItemIndex;
   Ball.Side := PlayerSide;
   StrPCopy( Pad[PlayerSide].PlayerName, editPlayerName.Text );

   OnePlayer := True;
   Application.CreateForm( TformField, formField );
   Hide;
   formField.ShowModal;
   Show;
   OnePlayer := False;
end;

end.
