unit uGame;

interface

uses
  Classes, Windows, WinGImag, uGlobal, Dib256, SysUtils;

type
   TGameThread = class(TThread)
   private
      IdMsg: Byte;

      procedure Draw;
      procedure DrawGoals;
      procedure DrawTimer;
      procedure ReadMessages;
      procedure MailMessage;
      procedure PadMove( var dx, dy: Longint );
      function GetCursorMove( var dx, dy: Longint ): Boolean;
      procedure MoveBall( dx, dy: Longint );
   protected
      procedure Execute; override;
   public
      MouseCenterX, MouseCenterY: Longint;
   end;


implementation

uses fField;

{ GameThread }

procedure TGameThread.Execute;
var
   t: Longint;
   dx, dy: Longint;
   CiclosSprite: Byte;
   CiclosTimer: Byte;
begin
   CiclosSprite := 0;
   CiclosTimer := 0;
   SelfCycle := 1;
   OpponentCycle := 1;

   if not(OnePlayer) then
   begin
      // signals game start
      IdMsg := NBG_STARTGAME;
      Synchronize( MailMessage );

      t := 0;
      while (FPM <> Start) and (t < STARTGAME_TIMEOUT) do
      begin
         Synchronize( ReadMessages );
         sleepex( 50, false );
         Inc( t, 50 );
      end;
      if (t >= STARTGAME_TIMEOUT) then
      begin
         PostMessage( formField.Handle, WM_ENDGAME, END_TIMEOUT, 0 );
         while not(Terminated) do
            SleepEx( 100, false );
         exit;
      end;
   end
   else
      FPM := Play;

   repeat
      t := GetTickCount;

      // desenha raquetes e bola
      Synchronize( Draw );

      // calcula novas posies
      PadMove( dx, dy );

      // verifica se tem ou no a bola
      if not(OnePlayer) then
      begin
         if (Ball.Side = PlayerSide) then
         begin
            MoveBall( dx, dy );

            // verifica se a bola passou para o outro campo
            if (PlayerSide = 0) then
            begin
               if (Ball.PosX+BALLWIDTH > FIELDINNERLIMX)
               and (cos(Ball.Ang) > 0) then
                  Ball.Side := 1;
            end
            else
               if (Ball.PosX < (FIELDWIDTH-1) - FIELDINNERLIMX)
               and (cos(Ball.Ang) < 0) then
                  Ball.Side := 0;

            // envia posies da raquete e bola
            IdMsg := NBG_PADBALLPOS;
            Synchronize( MailMessage );
         end
         else
         begin
            // movimenta raquete
            Pad[PlayerSide].PosX := Pad[PlayerSide].PosX + dx;
            Pad[PlayerSide].PosY := Pad[PlayerSide].PosY + dy;

            // envia posio da raquete
            IdMsg := NBG_PADPOS;
            Synchronize( MailMessage );
         end;
      end
      else
         MoveBall( dx, dy );

      // Passa ao prximo sprite da raquete se tiver passado o n de ciclos suf.
      Inc( CiclosSprite );
      if (CiclosSprite = PADCICLESPERSPRITE) then
      with Pad[PlayerSide] do
      begin
         Inc( IndSprite );
         if (IndSprite = PADSPRITESNUMBER) then
            IndSprite := 0;
         CiclosSprite := 0;
      end;

      // espera pelo fim do ciclo
      t := GetTickCount - t;
      if (t < 25) then
         SleepEx( 25-t, false );

      // Passa ao prximo ciclo de relgio
      Inc( CiclosTimer );
      if (CiclosTimer = 1000 div 25) then
      begin
         Dec(GameTimer);
         Synchronize( DrawTimer );
         CiclosTimer := 0;

         // se chegar ao fim do tempo sai do jogo
         if (GameTimer = 0) then
         begin
            PostMessage( formField.Handle, WM_ENDGAME, END_OK, 0 );
            while not(Terminated) do
               SleepEx( 100, false );
         end;
      end;

      // l mensagens
      if not(OnePlayer) then
      begin
         Synchronize( ReadMessages );

         // se for caso disso, tenta vrias vezes para receber a posio
         // adversria
         t := 0;
         while ((OpponentCycle < SelfCycle) and (t < READ_TIMEOUT)) do
         begin
            SleepEx( 25, false );
            Inc( t, 25 );
            Synchronize( ReadMessages );
         end;

         // se passar do tempo limite sai do jogo
         if (t >= READ_TIMEOUT) then
         begin
            PostMessage( formField.Handle, WM_ENDGAME, END_TIMEOUT, 0 );
            while not(Terminated) do
               SleepEx( 100, false );
         end;
      end;
   until Terminated;
end;



procedure TGameThread.Draw;
begin
   if (Terminated = False) then
      formField.DrawPads_Ball;
end;

procedure TGameThread.DrawGoals;
begin
   if (Terminated = False) then
      formField.DrawGoals;
end;

procedure TGameThread.DrawTimer;
begin
   if (Terminated = False) then
      formField.DrawTimer;
end;

procedure TGameThread.ReadMessages;
begin
   if (Terminated = False) then
      formField.ReadMessages;
end;

procedure TGameThread.MailMessage;
begin
   if (Terminated = False) then
      formField.MailMessage( IdMsg );
end;


procedure TGameThread.PadMove( var dx, dy: Longint );
begin
   with Pad[PlayerSide] do
   begin
      if (GetCursorMove( dx, dy ) = True) then
      begin
         // valida a posio horizontal para no sair da grande rea da raquete
         if (PlayerSide = 0) then
         begin
            if (PosX+dx < FIELDOUTTERLIMX) then
               dx := FIELDOUTTERLIMX - Trunc(PosX)
            else
               if (PosX+dx+PADWIDTH > FIELDINNERLIMX) then
                  dx := FIELDINNERLIMX - Trunc(PosX) - PADWIDTH;
         end
         else
         begin
            if (PosX+dx > (FIELDWIDTH-1) - (FIELDOUTTERLIMX+PADWIDTH) ) then
               dx := (FIELDWIDTH-1) - (FIELDOUTTERLIMX+PADWIDTH) - Trunc(PosX)
            else
               if (PosX+dx < (FIELDWIDTH-1) - FIELDINNERLIMX ) then
                  dx := (FIELDWIDTH-1) - FIELDINNERLIMX - Trunc(PosX);
         end;

         // valida a posio vertical
         if (PosY+dy < PADLIMY) then
            dy := PADLIMY - Trunc(PosY)
         else
            if (PosY+dy > FIELDHEIGHT - (PADLIMY+PADHEIGHT) ) then
               dy := FIELDHEIGHT - (PADLIMY+PADHEIGHT) - Trunc(PosY);

         VelX[IndVel] := dx;
         VelY[IndVel] := dy;
      end
      else
      begin
         VelX[IndVel] := 0;
         VelY[IndVel] := 0;
      end;

      // avana indice das velocidades
      if (IndVel = High(VelX)) then
         IndVel := 0
      else
         Inc(IndVel);
   end;
end;


function TGameThread.GetCursorMove( var dx, dy: Longint ): Boolean;
var
   p: TPoint;
begin
   GetCursorPos( p );
   dx := p.X - MouseCenterX;
   dy := p.Y - MouseCenterY;
   if (dx <> 0) or (dy <> 0) then
   begin
      if (dx < -MOUSEDIFLIM_X) then
         dx := -MOUSEDIFLIM_X
      else
         if (dx > MOUSEDIFLIM_X) then
            dx := MOUSEDIFLIM_X;

      if (dy < -MOUSEDIFLIM_Y) then
         dy := -MOUSEDIFLIM_Y
      else
         if (dy > MOUSEDIFLIM_Y) then
            dy := MOUSEDIFLIM_Y;

      SetCursorPos( MouseCenterX, MouseCenterY );
      Result := True;
   end
   else
      Result := False;
end;


procedure TGameThread.MoveBall( dx, dy: Longint );
var
   dPx, dPy, dBx, dBy: Single;
   temp, vBx, vBy: Single;
   Px, Py, Bx, By: Longint;
   mdx, mdy: Longint;
   Cnt, Cnt2: Integer;
   fBallHit, fPadHit: Boolean;
   cosang, sinang: Single;
   ang: Byte;
   vxb1, vyb1, vxr1, vxb2: Single;
begin
   // Aplica atrito  bola
   if (Ball.Vel > BALLMINVEL) then
      Ball.Vel := Ball.Vel - BALLATRITO;

   // calcula deslocamentos
   dPx := dx / NUM_CICLOS;
   dPy := dy / NUM_CICLOS;
   PolarToCartesian( Ball.Vel, Ball.Ang, vBx, vBy );
   dBx := vBx / NUM_CICLOS;
   dBy := vBy / NUM_CICLOS;

   for Cnt := 1 to NUM_CICLOS do
   begin
      // calcula prxima posio da bola e raquete
      // a varivel 'temp'  utilizada para que o resultado da soma seja
      // exactamente igual ao que poder ser atribudo s variveis de forma
      // a manter-se a preciso dos clculos
      temp := Pad[PlayerSide].PosX + dPx;
      Px := Trunc(temp);
      temp := Pad[PlayerSide].PosY + dPy;
      Py := Trunc(temp);
      temp := Ball.PosX + dBx;
      Bx := Trunc(temp);
      temp := Ball.PosY + dBy;
      By := Trunc(temp);

      fBallHit := False;
      fPadHit := False;

      // verifica choque de bola com parede
      if (By < BALLLIMY) or (By > FIELDHEIGHT-BALLHEIGHT-BALLLIMY) then
      begin
         // inverte velocidade vertical e toma a prxima posio da bola como
         // no se tendo alterado em relao  ltima posio para que a bola
         // nunca permanea numa posio de choque
         dBy := -dBy;
         Ball.Ang := -Ball.Ang;
         Bx := Trunc(Ball.PosX);
         By := Trunc(Ball.PosY);
         fBallHit := True;
      end;

      // ***provisoriamente*** reflecte saidas de bola pelos limites horizontais
      if (Bx < 1) or (Bx > FIELDWIDTH-BALLWIDTH-1) then
      begin
         dBx := -dBx;
         Ball.Ang := Pi-Ball.Ang;
         Bx := Trunc(Ball.PosX);
         By := Trunc(Ball.PosY);
         fBallHit := True;
      end;

      // verifica choque de raquete com bola
      if (Bx > Px-BALLWIDTH) and (Bx < Px+PADWIDTH)
      and (By > Py-BALLHEIGHT) and (By < Py+PADHEIGHT) then
      begin
         ang := ShockMask[PlayerSide,
            Bx - Px + BALLWIDTH - 1, By - Py + BALLHEIGHT - 1];

         if ((ang and 128) <> 0) then
         begin
            ang := ang-128;   // ngulo de refleco

            // calcula coseno e seno para o ngulo de refleco
            cosang := Cos(ang*PI/64);
            sinang := Sin(ang*PI/64);

            // calcula a velocidade mdia da raquete utilizando as ltimas
            // velocidades da raquete
            mdx := 0;
            mdy := 0;
            with Pad[PlayerSide] do
            begin
               for Cnt2 := 0 to High(VelX) do
               begin
                  Inc( mdx, VelX[Cnt2] );
                  Inc( mdy, VelY[Cnt2] );
               end;
               mdx := mdx div (High(VelX)+1);
               mdy := mdy div (High(VelX)+1);
            end;

            // converte velocidades para o plano do choque
            vxb1 := - cosang*vBy - sinang*vBx;
            vyb1 := cosang*vBx - sinang*vBy;
            vxr1 := - cosang*mdy - sinang*mdx;

            // verifica se a velocidade da bola  maior do que a raquete, se
            // assim for  porque a bola apanhou a raquete por dentro, o que 
            // uma situao a evitar. Neste caso coloca-se a bola no ponto
            // seguinte apontado pelo ngulo de reflexo.
            if (vxb1 > vxr1) then
            begin
               if (ang < 64) then
                  if (ang < 32) then
                  begin
                     Ball.PosX := Int(Ball.PosX)-0.001;
                     Ball.PosY := Int(Ball.Posy)-0.001;
                  end
                  else
                  begin
                     Ball.PosX := Int(Ball.PosX)-0.001;
                     Ball.PosY := Int(Ball.Posy)+1.001;
                  end
               else
                  if (ang < 96) then
                  begin
                     Ball.PosX := Int(Ball.PosX)+1.001;
                     Ball.PosY := Int(Ball.Posy)+1.001;
                  end
                  else
                  begin
                     Ball.PosX := Int(Ball.PosX)+1.001;
                     Ball.PosY := Int(Ball.Posy)-0.001;
                  end;

               // verifica se a bola passou os limites do campo, se sim
               // desloca a bola e raquete de um ponto para sair dessa situao
               if (Ball.PosY < BALLLIMY) then
               begin
                  Ball.PosY := BALLLIMY;
                  Pad[PlayerSide].PosY := Pad[PlayerSide].PosY + 1;
               end;
               if (Ball.PosY  > FIELDHEIGHT-BALLHEIGHT-BALLLIMY) then
               begin
                  Ball.PosY := FIELDHEIGHT-BALLHEIGHT-BALLLIMY;
                  Pad[PlayerSide].PosY := Pad[PlayerSide].PosY - 1;
               end;

               // ***provisoriamente***
               if (Ball.PosX < 1) then
               begin
                  Ball.PosX := 1;
                  Pad[PlayerSide].PosX := Pad[PlayerSide].PosX + 1;
               end;
               if (Ball.PosX  > FIELDWIDTH-BALLWIDTH-1) then
               begin
                  Ball.PosX := FIELDWIDTH-BALLWIDTH-1;
                  Pad[PlayerSide].PosX := Pad[PlayerSide].PosX - 1;
               end;

               // coloca a zero a velocidade da raquete
               // para deixar de empurrar a bola
               dPx := 0;
               dPy := 0;
               
               fPadHit := True;
               fBallHit := True;
            end
            else
            begin
               // clculo da velocidade da bola depois do choque
               vxb2 := (1+ShockElasticity)*vxr1 - ShockElasticity*vxb1;

               // converte velocidades novamente para o plano do ecran
               vBx := cosang*vyb1 - sinang*vxb2;
               vBy := - cosang*vxb2 - sinang*vyb1;

               CartesianToPolar( vBx, vBy, Ball.Vel, Ball.Ang );
               if (Ball.Vel > BALLMAXVEL) then
                  Ball.Vel := BALLMAXVEL;

               fPadHit := True;
               if (fBallHit = False) then
               begin
                  Px := Trunc(Pad[PlayerSide].PosX);
                  Py := Trunc(Pad[PlayerSide].PosY);
                  if (Bx > Px-BALLWIDTH) and (Bx < Px+PADWIDTH)
                  and (By > Py-BALLHEIGHT) and (By < Py+PADHEIGHT) then
                     if ((ShockMask[PlayerSide, Bx - Px + BALLWIDTH - 1,
                     By - Py + BALLHEIGHT - 1] and 128) <> 0) then
                        fBallHit := True;
               end;
            end;
         end;
      end;

      if not(fBallHit) then
      begin
         Ball.PosX := Ball.PosX + dBx;
         Ball.PosY := Ball.PosY + dBy;
      end;
      if not(fPadHit) then
      begin
         Pad[PlayerSide].PosX := Pad[PlayerSide].PosX + dPx;
         Pad[PlayerSide].PosY := Pad[PlayerSide].PosY + dPy;
      end
      else
         if (Cnt < NUM_CICLOS) then
         begin
            // calcula deslocamentos
            dBx := vBx / NUM_CICLOS;
            dBy := vBy / NUM_CICLOS;
         end;

{      // verifica se est em posio de choque bola e raquete
      Bx := Trunc(Ball.PosX);
      By := Trunc(Ball.PosY);
      Px := Trunc(Pad[PlayerSide].PosX);
      Py := Trunc(Pad[PlayerSide].PosY);
      if (Bx > Px-BALLWIDTH) and (Bx < Px+PADWIDTH)
         and (By > Py-BALLHEIGHT) and (By < Py+PADHEIGHT) then
         if (ShockMask[PlayerSide, Bx - Px + BALLWIDTH - 1,
            By - Py + BALLHEIGHT - 1] and 128) <> 0 then
            dBx := 0;}
   end;
end;


end.

